 /*
  * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
  * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
  */
/*
 * $Id: UserTransactionNegativeBeanBase.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.annotation.resource;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import static com.sun.ts.tests.ejb30.common.annotation.resource.Constants.USER_TRANSACTION_JNDI_NAME;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;


abstract public class UserTransactionNegativeBeanBase implements UserTransactionNegativeIF {
    
    /////////////////////////////////////////////////////////////////////////
    // business methods
    /////////////////////////////////////////////////////////////////////////
    public void testUserTransactionNegativeLookup() throws TestFailedException {
        //See glassfish issue 1538, EJB 3.0 spec page 448
        try {
            Object obj = ServiceLocator.lookup(USER_TRANSACTION_JNDI_NAME);
            if(obj != null) {
                throw new TestFailedException("lookup of UserTransaction must not succeed for CMT beans.  Unexpectedly returned " +
                        obj);
            }
        } catch (Exception e) {
            //should throw NameNotFoundException, but also ok for other exceptions.
        }
    }
    
}