/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * $Id: InterceptorI.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.callback;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.interceptor.InvocationContext;

public class InterceptorI extends InterceptorF {
    public InterceptorI() {
        super();
    }
    
    @Override
    public String getInjectedLocation() {
        return NOT_INJECTED;
    }
    
    @Override
    protected String getShortName() { return "I";}
    
    @Override
    protected void myRemoveInF(InvocationContext inv) throws RuntimeException {
        throw new IllegalStateException("Should not get here.");
    }

    @Override
    protected void myRemoveInE(InvocationContext inv) throws RuntimeException {
        throw new IllegalStateException("Should not get here.");
    }

    @Override
    protected void myRemove(InvocationContext inv) throws RuntimeException {
        throw new IllegalStateException("Should not get here.");
    }

    @Override
    protected void myCreateInF(InvocationContext inv) throws RuntimeException {
        throw new IllegalStateException("Should not get here.");
    }

    @PostConstruct
    @Override
    protected void myCreateInE(InvocationContext inv) throws RuntimeException {
        myCreate0(inv, "I");
    }

    @Override
    @PreDestroy  //re-annotated it as another type of lifecycle
    protected void myCreate(InvocationContext inv) throws RuntimeException {
    }
    
}
