/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ClientBase.java 62595 2011-04-20 20:38:55Z kgrucci $
 */
package com.sun.ts.tests.ejb30.common.invocationcontext;

import java.util.Properties;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import javax.ejb.EJB;

abstract public class ClientBase extends EETest {
    protected Properties props;

    @EJB(beanName = "InvocationContextBean")
    static private InvocationContextIF bean;

    @EJB(beanName = "InvocationContextInterceptorBean")
    static private InvocationContextIF bean2;

    private InvocationContextIF[] beans = new InvocationContextIF[]{bean, bean2};

    public void setup(String[] args, Properties p) {
	props = p;
    }

    public void cleanup() {
    }

    /*
     * testName: setParametersIllegalArgumentException
     * @test_Strategy:
     */
    public void setParametersIllegalArgumentException() throws TestFailedException {
	InvocationContextTestImpl.setParametersIllegalArgumentException(beans);
    }
    
    /*
     * testName: getTarget
     * @test_Strategy: the bean business method getTarget return the identity
     * hashcode for the bean instance, which is compared to the result of
     * InvocationContext.getTarget()'s.  They should be the same.  This test is
     * executed for AroundInvoke methods in both the bean class and in interceptor
     * class.
     */
    public void getTarget() throws TestFailedException {
	InvocationContextTestImpl.getTarget(beans);
    }
    
    /*
     * testName: getContextData
     * @test_Strategy: Put context data in interceptor method and verify it inside
     * finally block after executing business method.  This test is
     * executed for AroundInvoke methods in both the bean class and in interceptor
     * class.
     */
    public void getContextData() throws TestFailedException {
	InvocationContextTestImpl.getContextData(beans);
    }
    
    /*
     * testName: getSetParameters
     * @test_Strategy: the bean business method getSetParametersEmpty takes no
     * params.  InvocationContext.getParameters() should return null or empty params.
     * Setting params to a non-empty array should result in IllegalArgumentException.
     * The bean business method getSetParameters takes 2 String params, verified 
     * and modified in interceptor.  The client should get the result based on the 
     * new params.
     */
    public void getSetParameters() throws TestFailedException {
	InvocationContextTestImpl.getSetParametersEmpty(beans);
	InvocationContextTestImpl.getSetParameters(beans);
    }
    
    /*
     * testName: proceedAgain
     * @test_Strategy: call proceed() from interceptor method.  The first call 
     * results in TestFailedException, and the subsequent proceed() call returns
     * true.  Expecting TestFailedException from the first proceed call, and true
     * value from the second proceed call.
     */
    public void proceedAgain() throws TestFailedException {
	InvocationContextTestImpl.proceedAgain(beans);
    }
}
