/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: AcceptBeanBase.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.sessioncontext;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import static com.sun.ts.tests.ejb30.common.sessioncontext.Constants.FROM_BEAN;
import static com.sun.ts.tests.ejb30.common.sessioncontext.Constants.FROM_CLIENT;
import javax.ejb.SessionContext;

abstract public class AcceptBeanBase 
        implements AcceptLocalIF, AcceptIF
{
    abstract protected SessionContext getSessionContext();
    
    private void verifyRemote(String [] m) throws TestFailedException {
        if(FROM_CLIENT.equals(m[0])) {
            //ok
        } else {
            throw new TestFailedException("Expecting '" + FROM_CLIENT + 
                    "', but actual '" + m[0] + "'");
        }
    }
    
    private void verifyLocal(String [] m) throws TestFailedException {
        if(FROM_BEAN.equals(m[0])) {
            //ok
        } else {
            throw new TestFailedException("Expecting '" + FROM_BEAN + 
                    "', but actual '" + m[0] + "'");
        }
    }

    public void accept(CommonIF bean) throws TestFailedException {
        final String[] m = new String[]{FROM_CLIENT};
        if(bean instanceof Three1IF) {
            Three1IF bob = (Three1IF) bean;
            bob.hi(m);
            verifyRemote(m);
        } else if(bean instanceof Three2IF) {
            Three2IF bob = (Three2IF) bean;
            bob.hi(m);
            verifyRemote(m);
        } else if(bean instanceof ThreeLocal1IF) {
            ThreeLocal1IF bob = (ThreeLocal1IF) bean;
            bob.hi(m);
            verifyLocal(m);
        } else if(bean instanceof ThreeLocal2IF) {
            ThreeLocal2IF bob = (ThreeLocal2IF) bean;
            bob.hi(m);
            verifyLocal(m);
        }
    }
    
    
}
