/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common.security;

import com.sun.org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import com.sun.org.apache.xml.security.signature.Reference;
import com.sun.org.apache.xml.security.signature.SignedInfo;
import com.sun.org.apache.xml.security.transforms.Transform;
import com.sun.org.apache.xml.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xpath.internal.XPathAPI;
import com.sun.xml.wss.ExtendedMessageFilter;
import com.sun.xml.wss.KeyInfoHeaderBlock;
import com.sun.xml.wss.MessageConstants;
import com.sun.xml.wss.PolicyViolationException;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.SignatureHeaderBlock;
import com.sun.xml.wss.Target;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.XWSSecurityRuntimeException;
import com.sun.xml.wss.configuration.AllowSignature;
import com.sun.xml.wss.configuration.SecurityRequirement;
import com.sun.xml.wss.configuration.SecurityRequirements;
import com.sun.xml.wss.configuration.VerifyRequirement;
import com.sun.xml.wss.filter.FilterBase;
import com.sun.xml.wss.helpers.KeyResolver;
import com.sun.xml.wss.helpers.ResolverId;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.TransformerException;
import org.freebxml.omar.common.security.ExtendedSignatureHeaderBlock;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtendedVerifyFilter
extends FilterBase
implements ExtendedMessageFilter {
    ArrayList optionalTargets = null;
    ArrayList optionalNodeList = null;
    private boolean enableLogging = false;
    SecurityRequirement receiverRequirement = null;
    static /* synthetic */ Class class$org$freebxml$omar$common$security$TransformAttachmentContentOnly;
    static /* synthetic */ Class class$org$freebxml$omar$common$security$ExtendedSignatureHeaderBlock;

    private static void registerTransforms() {
        try {
            String transformURI = "http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Content-Only-Transform";
            Transform.register((String)transformURI, (String)(class$org$freebxml$omar$common$security$TransformAttachmentContentOnly == null ? (class$org$freebxml$omar$common$security$TransformAttachmentContentOnly = ExtendedVerifyFilter.class$("org.freebxml.omar.common.security.TransformAttachmentContentOnly")) : class$org$freebxml$omar$common$security$TransformAttachmentContentOnly).getName());
        }
        catch (AlgorithmAlreadyRegisteredException algorithmAlreadyRegisteredException) {
            // empty catch block
        }
    }

    public ExtendedVerifyFilter() {
        ExtendedVerifyFilter.registerTransforms();
    }

    public ExtendedVerifyFilter(SecurityRequirement receiverRequirement, ArrayList optionalTargets) {
        this.receiverRequirement = receiverRequirement;
        this.optionalTargets = optionalTargets;
        ExtendedVerifyFilter.registerTransforms();
    }

    public void init() throws XWSSecurityException {
    }

    public void enableOperationsLog(boolean enable) {
        this.enableLogging = enable;
    }

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        if (!this.verify(secureMessage)) {
            FilterBase.log.log(Level.SEVERE, "WSS0167.signature.verification.failed");
            XWSSecurityException xwsse = new XWSSecurityException("Signature verification failed");
            throw SecurableSoapMessage.newSOAPFaultException((QName)MessageConstants.WSSE_FAILED_CHECK, (String)"Signature verification failed", (Throwable)xwsse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verify(SecurableSoapMessage secureMessage) throws XWSSecurityException, PolicyViolationException {
        boolean bl;
        block16: {
            if (!SecurableSoapMessage.isStrTransformAdded()) {
                try {
                    Transform.register((String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", (String)"com.sun.xml.wss.helpers.TransformSTR");
                }
                catch (AlgorithmAlreadyRegisteredException e) {
                    throw new XWSSecurityException((Throwable)e);
                }
                SecurableSoapMessage.setStrTransformAdded((boolean)true);
            }
            SecurityHeader secHeader = secureMessage.findSecurityHeader();
            ExtendedSignatureHeaderBlock sigBlock = null;
            try {
                sigBlock = (ExtendedSignatureHeaderBlock)secHeader.getCurrentHeaderBlock(class$org$freebxml$omar$common$security$ExtendedSignatureHeaderBlock == null ? (class$org$freebxml$omar$common$security$ExtendedSignatureHeaderBlock = ExtendedVerifyFilter.class$("org.freebxml.omar.common.security.ExtendedSignatureHeaderBlock")) : class$org$freebxml$omar$common$security$ExtendedSignatureHeaderBlock);
                sigBlock.setSoapMessage((SOAPMessage)secureMessage);
            }
            catch (XWSSecurityException e) {
                FilterBase.log.log(Level.SEVERE, "WSS0129.no.dssignature.in.security.headerblock", new Object[]{e});
                secureMessage.generateSecurityHeaderException("WSS0129: Could not retrieve the ds:Signature element from the wsse:Security header block");
            }
            try {
                boolean bool;
                SecurableSoapMessage.setDocMessageAssociation((Document)sigBlock.getOwnerDocument(), (SecurableSoapMessage)secureMessage);
                if (this.receiverRequirement != null) {
                    if (this.optionalTargets != null) {
                        this.optionalNodeList = this.getOptionalNodeList(secureMessage);
                    }
                    this.checkIfReceiverReqsAreMet(this.receiverRequirement, sigBlock, secureMessage);
                }
                this.checkForDsCanonicalizationMethod(sigBlock, secureMessage);
                KeyInfoHeaderBlock keyInfoBlock = sigBlock.getKeyInfoHeaderBlock();
                PublicKey publicKey = (PublicKey)KeyResolver.getKey((KeyInfoHeaderBlock)keyInfoBlock, (boolean)true, (SecurableSoapMessage)secureMessage);
                if (publicKey == null) {
                    FilterBase.log.log(Level.SEVERE, "WSS0336.cannot.locate.publickey.for.signature.verification");
                    throw new XWSSecurityException("Couldn't locate the public key for signature verification");
                }
                if (!SecurableSoapMessage.isWsuIdResolverAdded()) {
                    ResourceResolver.registerAtStart((String)ResolverId.getResolverName());
                    SecurableSoapMessage.setWsuIdResolverAdded((boolean)true);
                }
                try {
                    boolean retVal = sigBlock.checkSignatureValue(publicKey);
                    try {
                        if (this.enableLogging) {
                            this.updateOperationsLog(secureMessage, sigBlock);
                        }
                    }
                    catch (Exception e) {
                        throw new XWSSecurityRuntimeException((Throwable)e);
                    }
                    bool = retVal;
                }
                catch (XWSSecurityException e) {
                    FilterBase.log.log(Level.SEVERE, "WSS0133.exception.while.verifying.signature", new Object[]{e.getCause().getMessage()});
                    throw SecurableSoapMessage.newSOAPFaultException((QName)MessageConstants.WSSE_FAILED_CHECK, (String)"Signature Verification Failed", (Throwable)e.getCause());
                }
                bl = bool;
                Object var10_12 = null;
                if (sigBlock == null) break block16;
            }
            catch (Throwable throwable) {
                block17: {
                    Object var10_13 = null;
                    if (sigBlock == null) break block17;
                    SecurableSoapMessage.removeDocMessageAssociation((Document)sigBlock.getOwnerDocument());
                }
                throw throwable;
            }
            SecurableSoapMessage.removeDocMessageAssociation((Document)sigBlock.getOwnerDocument());
        }
        return bl;
    }

    public void setReceiverRequirement(SecurityRequirement receiverRequirement) {
        this.receiverRequirement = receiverRequirement;
    }

    public void setReceiverRequirements(SecurityRequirements receiverRequirements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void checkForDsCanonicalizationMethod(SignatureHeaderBlock sigBlock, SecurableSoapMessage secureMessage) throws XWSSecurityException {
        Node strTransformNode;
        block6: {
            block5: {
                String strTranformXpath = "ds:SignedInfo/ds:Reference/ds:Transforms/ds:Transform[@Algorithm=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform\"]";
                strTransformNode = null;
                try {
                    strTransformNode = XPathAPI.selectSingleNode((Node)sigBlock.getAsSoapElement(), strTranformXpath, secureMessage.getNSContext());
                    if (null == strTransformNode) break block5;
                    break block6;
                }
                catch (TransformerException te) {
                    throw new XWSSecurityException(te.getMessage(), (Throwable)te);
                }
            }
            return;
        }
        try {
            Node canonicalizationMethod = XPathAPI.selectSingleNode(strTransformNode, "wsse:TransformationParameters/ds:CanonicalizationMethod[@Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"]", secureMessage.getNSContext());
            if (null == canonicalizationMethod) {
                XWSSecurityException xwsse = new XWSSecurityException("http://www.w3.org/2001/10/xml-exc-c14n# CanonicalizationMethod was expected as a TransformationParameter inside the STR-Transform");
                throw SecurableSoapMessage.newSOAPFaultException((QName)MessageConstants.WSSE_UNSUPPORTED_ALGORITHM, (String)xwsse.getMessage(), (Throwable)xwsse);
            }
        }
        catch (TransformerException te) {
            throw new XWSSecurityException((Throwable)te);
        }
    }

    private void updateOperationsLog(SecurableSoapMessage secureMessage, SignatureHeaderBlock sigBlock) throws Exception {
        HashSet<SOAPElement> references = new HashSet<SOAPElement>();
        SignedInfo signedInfo = sigBlock.getDSSignedInfo();
        int length = signedInfo.getLength();
        for (int i = 0; i < length; ++i) {
            Reference reference = signedInfo.item(i);
            String uri = reference.getURI();
            String wsuId = uri.substring(1);
            SOAPElement element = secureMessage.getElementByWsuId(wsuId);
            references.add(element);
        }
        secureMessage.logSignatureReferences(references);
    }

    private ArrayList getOptionalNodeList(SecurableSoapMessage ssm) throws XWSSecurityException {
        if (this.optionalTargets == null) {
            return null;
        }
        ArrayList<Node> optionalNodes = new ArrayList<Node>();
        Iterator i = this.optionalTargets.iterator();
        while (i.hasNext()) {
            Target target = (Target)i.next();
            if (target.getType().equals("uri")) {
                optionalNodes.add((Node)ssm.getMessageParts(target));
                continue;
            }
            NodeList nlist = (NodeList)ssm.getMessageParts(target);
            for (int j = 0; j < nlist.getLength(); ++j) {
                optionalNodes.add(nlist.item(j));
            }
        }
        return optionalNodes;
    }

    private ArrayList convertToArrayList(NodeList nodeList) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                result.add(nodeList.item(i));
            }
        }
        return result;
    }

    private void checkIfReceiverReqsAreMet(SecurityRequirement receiverRequirement, SignatureHeaderBlock sigBlock, SecurableSoapMessage secureMessage) throws PolicyViolationException {
        ArrayList targets = null;
        if (receiverRequirement instanceof VerifyRequirement) {
            targets = ((VerifyRequirement)receiverRequirement).getTargets();
        } else if (receiverRequirement instanceof AllowSignature) {
            targets = ((AllowSignature)receiverRequirement).getTargets();
        }
        SignedInfo signedInfo = sigBlock.getDSSignedInfo();
        ArrayList signedElements = this.getListOfSignedElements(signedInfo, secureMessage);
        Iterator it = targets.iterator();
        int numberOfTargetElements = 0;
        while (it.hasNext()) {
            Element elem;
            Target target = (Target)it.next();
            String targetType = target.getType();
            String targetValue = target.getValue();
            if (targetType.equals("qname")) {
                String xpath = XMLUtil.convertToXpath((String)targetValue);
                NodeList targetsToCheckFor = null;
                try {
                    targetsToCheckFor = XPathAPI.selectNodeList((Node)secureMessage.getSOAPPart(), xpath, secureMessage.getNSContext());
                }
                catch (Exception e) {
                    throw new XWSSecurityRuntimeException((Throwable)e);
                }
                numberOfTargetElements += targetsToCheckFor.getLength();
                this.verifyIfTargetsSigned(this.convertToArrayList(targetsToCheckFor), signedElements, xpath);
                continue;
            }
            if (targetType.equals("xpath")) {
                NodeList targetsToCheckFor = null;
                try {
                    targetsToCheckFor = XPathAPI.selectNodeList((Node)secureMessage.getSOAPPart(), targetValue, secureMessage.getNSContext());
                }
                catch (Exception e) {
                    throw new XWSSecurityRuntimeException((Throwable)e);
                }
                numberOfTargetElements += targetsToCheckFor.getLength();
                this.verifyIfTargetsSigned(this.convertToArrayList(targetsToCheckFor), signedElements, targetValue);
                continue;
            }
            if (!targetType.equals("uri")) continue;
            try {
                elem = XMLUtil.getElementById((Document)secureMessage.getSOAPPart(), (String)targetValue);
            }
            catch (Exception e) {
                throw new XWSSecurityRuntimeException((Throwable)e);
            }
            ArrayList<Element> targetToCheckFor = new ArrayList<Element>();
            if (elem != null) {
                targetToCheckFor.add(elem);
                ++numberOfTargetElements;
            }
            this.verifyIfTargetsSigned(targetToCheckFor, signedElements, targetValue);
        }
        Iterator i = signedElements.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (this.optionalNodeList.contains(n)) continue;
            throw new PolicyViolationException("Target for Signature: " + n.getLocalName() + " does not meet receiver requirements");
        }
    }

    private void verifyIfTargetsSigned(ArrayList targetsToCheckFor, ArrayList signedElements, String concernedTargetXpath) throws PolicyViolationException {
        String errorMessage = "Receiver requirement for signature target: " + concernedTargetXpath + " , has not been met";
        if (targetsToCheckFor.isEmpty()) {
            throw new PolicyViolationException(errorMessage);
        }
        for (int i = 0; i < targetsToCheckFor.size(); ++i) {
            if (!signedElements.contains(targetsToCheckFor.get(i))) {
                throw new PolicyViolationException(errorMessage);
            }
            signedElements.remove(targetsToCheckFor.get(i));
        }
    }

    private ArrayList getListOfSignedElements(SignedInfo signedInfo, SecurableSoapMessage secureMessage) {
        ArrayList<Element> list = new ArrayList<Element>();
        try {
            for (int i = 0; i < signedInfo.getLength(); ++i) {
                Reference reference = signedInfo.item(i);
                String uri = reference.getURI();
                String wsuId = uri.substring(1);
                Element signedElem = XMLUtil.getElementById((Document)secureMessage.getSOAPPart(), (String)wsuId);
                list.add(signedElem);
            }
        }
        catch (Exception e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

