/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*************************************************************************
   Licensed Materials - Property of IBM
   WSEE1.0 (C) Copyright International Business Machines Corp. 2002
   All Rights Reserved.
   US Government Users Restricted Rights - Use, duplication or
   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
**************************************************************************/
/*************************************************************************
   IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE. IN NO EVENT SHALL IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR
   CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
   USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
   OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
   OR PERFORMANCE OF THIS SOFTWARE.
**************************************************************************/

/*
 * $Id: Client.java 62536 2011-04-15 16:35:14Z af70133 $
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_holders.ByteHolder;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;

import java.io.*;
import java.net.*;
import java.util.*;
import java.rmi.*;
import java.math.*;

import javax.xml.rpc.holders.ByteHolder;

import com.sun.javatest.Status;

public class Client extends ServiceEETest
{
    private Properties props = null;

    private final static byte myByte = Byte.MAX_VALUE;
    private final static byte myByteDefault = 0;

    public static void main(String[] args)
    {
	Client theTests = new Client();
	Status s = theTests.run(args, System.out, System.err);
	s.exit();
    }


/*  Test setup */

  /*
     * @class.testArgs:     -ap jaxrpc-url-props.dat
   *   @class.setup_props:
   */

    public void setup(String[] args, Properties p) throws Fault
    {
        logMsg("setup ok");
    }

    public void cleanup()  throws Fault {
        logMsg("cleanup ok");
    }

    /*
     *   @testName:  ByteHolderConstructorTest1
     *
     *   @assertion_ids: JAXRPC:JAVADOC:204;
     *                   WS4EE:SPEC:70;
     *
     *   @test_Strategy: Create instance via ByteHolder() constructor.
     *			Verify ByteHolder object created successfully.
     */
    public void ByteHolderConstructorTest1() throws Fault {
	TestUtil.logTrace("ByteHolderConstructorTest1");
	boolean pass = true;
        try {
	    TestUtil.logMsg("Create instance via ByteHolder() ...");
	    ByteHolder n = new ByteHolder();
	    if (n != null) {
		TestUtil.logMsg("ByteHolder object created successfully");
	    }
	    else {
		TestUtil.logErr("ByteHolder object not created");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("ByteHolderConstructorTest1 failed", e);
        }

	if (!pass)
	    throw new Fault("ByteHolderConstructorTest1 failed");
    }

    /*
     *   @testName:  ByteHolderConstructorTest2
     *
     *   @assertion_ids: JAXRPC:JAVADOC:205;
     *                   WS4EE:SPEC:70;
     *
     *   @test_Strategy: Create instance via ByteHolder(byte) constructor.
     *			Verify ByteHolder object created successfully.
     */
    public void ByteHolderConstructorTest2() throws Fault {
	TestUtil.logTrace("ByteHolderConstructorTest2");
	boolean pass = true;
        try {
	    TestUtil.logMsg("Create instance via ByteHolder(byte) ...");
	    ByteHolder n = new ByteHolder(myByte);
	    if (n != null) {
		TestUtil.logMsg("ByteHolder object created successfully");
	    }
	    else {
		TestUtil.logErr("ByteHolder object not created");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("ByteHolderConstructorTest2 failed", e);
        }

	if (!pass)
	    throw new Fault("ByteHolderConstructorTest2 failed");
    }

    /*
     *   @testName:  getValueTest
     *
     *   @assertion_ids: JAXRPC:JAVADOC:203;
     *                   WS4EE:SPEC:70;
     *
     *   @test_Strategy: Test using both constructors.
     *			 Verify value is set correct in each case.
     */
    public void getValueTest() throws Fault {
	TestUtil.logTrace("getValueTest");
	boolean pass = true;

	if (!getValueTest1()) pass = false;
	if (!getValueTest2()) pass = false;

	if (!pass)
	    throw new Fault("getValueTest failed");
    }

    /*
     * Create instance via ByteHolder().
     * Verify value is set to default.
     */
    private boolean getValueTest1() throws Fault {
	TestUtil.logTrace("getValueTest1");
	boolean pass = true;
        try {
	    TestUtil.logMsg("Create instance via ByteHolder() ...");
	    ByteHolder n = new ByteHolder();
	    if (n != null) {
		byte v = n.value;
		if (v == myByteDefault)
		    TestUtil.logMsg("value set as expected to " + myByteDefault);
		else {
		    TestUtil.logErr("value: expected - " + myByteDefault +
					", received - " + v);
		    pass = false;
		}
	    }
	    else {
		TestUtil.logErr("ByteHolder object not created");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    pass = false;
        }
	return pass;
    }

    /*
     * Create instance via ByteHolder(byte).
     * Verify value is set to default.
     */
    private boolean getValueTest2() throws Fault {
	TestUtil.logTrace("getValueTest2");
	boolean pass = true;
        try {
	    TestUtil.logMsg("Create instance via ByteHolder(byte) ...");
	    ByteHolder n = new ByteHolder(myByte);
	    if (n != null) {
		byte v = n.value;
		if (myByte == v)
		    TestUtil.logMsg("value set as expected: " +
				myByte);
		else {
		    TestUtil.logErr("value: expected - " + myByte +
					", received - " + v);
		    pass = false;
		}
	    }
	    else {
		TestUtil.logErr("ByteHolder object not created");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    pass = false;
        }
	return pass;
    }
}
