/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: HeaderTestImpl.java 62536 2011-04-15 16:35:14Z af70133 $
 */

// This class was generated by the JAXRPC RI, do not edit.
// Contents subject to change without notice.
// JAX-RPC Reference Implementation (1.1, build EA-R8)

package com.sun.ts.tests.jaxrpc.ee.wsi.rpc.literal.headertest;

import java.rmi.RemoteException;

public class HeaderTestImpl implements HeaderTest {
    public ProductOrderResponse submitOrder(ProductOrderRequest poRequest, 
	ConfigHeader configHeader) throws BadOrderFault, ConfigFault, RemoteException {
	ProductOrderResponse poResponse = new ProductOrderResponse();
	String testName = configHeader.getTestName();
	if(testName.equals("GoodOrderTestWithSoapHeaderAndMUFalse")) {
	    if(!ValidHeader(configHeader, false, "Config Header", testName))
		throw new ConfigFault(true, "Invalid ConfigHeader: mustUnderstand="+
		    configHeader.isMustUnderstand()+", message="+
			configHeader.getMessage()+", testName="+testName);
	    poResponse.setItem(poRequest.getItem());
	} else if(testName.equals("GoodOrderTestWithSoapHeaderAndMUTrue")) {
	    if(!ValidHeader(configHeader, true, "Config Header", testName))
		throw new ConfigFault(true, "Invalid ConfigHeader: mustUnderstand="+
		    configHeader.isMustUnderstand()+", message="+
			configHeader.getMessage()+", testName="+testName);
	    poResponse.setItem(poRequest.getItem());
	} else if(testName.equals("SoapHeaderFaultTest")) {
	    throw new ConfigFault(true, "This is a soap header fault ConfigFault");
	} else if(testName.equals("SoapFaultTest")) {
	    throw new BadOrderFault("This is a soap fault BadOrderFault");
	} else {
	    throw new ConfigFault(true, "Invalid ConfigHeader: mustUnderstand="+
		configHeader.isMustUnderstand()+", message="+
		    configHeader.getMessage()+", testName="+testName);
	}
	return poResponse;
    }

    private boolean ValidHeader(ConfigHeader ch, boolean mu, String msg, String test) {
	if(ch.isMustUnderstand() == mu 
		&& ch.getMessage().equals(msg) && ch.getTestName().equals(test))
	    return true;
	else
	    return false;
    }
}
