/*
 * $Id$
 *
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jaxrs.api.rs.ext.runtimedelegate;

import javax.ws.rs.ext.RuntimeDelegate;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 */
public class JAXRSDelegateClient extends JAXRSCommonClient {
	private static final long serialVersionUID = 1L;

	/**
	 * Entry point for different-VM execution.  It should delegate to method
	 * run(String[], PrintWriter, PrintWriter), and this method should not
	 * contain any test configuration.
	 */
	public static void main(String[] args) {
		new JAXRSDelegateClient().run(args);
	}

	/**
	 * Check what is the RuntimeDelegate
	 * @param wantTckRuntimeDelegate 	
	 * @throws Fault
	 * 		when wantTckRuntimeDelegate && RuntimeDelegate.getInstance != TckRuntimeDelegate
	 * 		when !wantTckRuntimeDelegate && RuntimeDelegate.getInstance == TckRuntimeDelegate
	 */
	protected void assertRuntimeDelegate(boolean wantTckRuntimeDelegate)
			throws Fault {
		RuntimeDelegate delegate = RuntimeDelegate.getInstance();
		Class<? extends RuntimeDelegate> clazz = delegate.getClass();
		boolean check = clazz == TckRuntimeDelegate.class;
		check = (wantTckRuntimeDelegate ? check : !check);
		assertFault(check, "TckRuntimeDelegate was",
				wantTckRuntimeDelegate ? "" : " not ", "set", "got ",
				clazz.getName());
		logMsg("Found", clazz.getName());
	}

	protected void assertRuntimeDelegate() throws Fault {
		assertRuntimeDelegate(true);
	}

}
