/*
 * Copyright (c) 2012, 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: WebAppExceptionMapper.java 73688 2014-04-29 17:10:23Z supol $
 */

package com.sun.ts.tests.jaxrs.ee.resource.webappexception.mapper;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class WebAppExceptionMapper implements
		ExceptionMapper<WebApplicationException> {

	@Override
	public Response toResponse(WebApplicationException exception) {
		// When not found, i.e. url is wrong, one get also
		// WebApplicationException
		if (exception.getClass() != WebApplicationException.class) {
			//When response has entity, the ExceptionMapper is not used
			//Let's mark these WebApplicationException with message
			//DirectResponseUsageResource.ENTITY
			if (exception.getMessage().equals(
					DirectResponseUsageResource.ENTITY))
				return Response
						.status(400)
						.entity("WebAppExceptionMapper should not be used when WebApplicationException has an entity")
						.build();
			//Lets mark the WebApplicationException without entity by a message
			//in this case, the WebApplicationException should have been used
			else if (exception.getMessage().equals(ResponseWithNoEntityUsesMapperResource.MESSAGE))
				return Response.status(Status.FOUND).build();
			//default, not a source by TCK, but vi, possible config issue?
			else
				return exception.getResponse();
		}
		return Response.status(Status.ACCEPTED).build();
	}

}
