/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$ 
 */

package com.sun.ts.tests.jaxrs.ee.rs.container.requestcontext.security;

import java.io.IOException;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

/**
 * The methods are called here by reflection from the superclass
 */
@Provider
public class RequestFilter implements ContainerRequestFilter {

	@Override
	public void filter(ContainerRequestContext requestContext)
			throws IOException {
		SecurityContext security = requestContext.getSecurityContext();
		String msg = "security.getUserPrincipal() is null";
		if (security.getUserPrincipal() != null)
			msg = security.getUserPrincipal().getName();
		Response response = Response.ok(msg).build();
		requestContext.abortWith(response);
	}

}
