/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */

package com.sun.ts.tests.jaxrs.ee.rs.delete;


import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value = "/DeleteTest")

public class HttpMethodDeleteTest {

    static String html_content =
            "<html>" + "<head><title>CTS-Delete text/html</title></head>" +
            "<body>CTS-Delete text/html</body></html>";

    @DELETE
    @Produces(value = "text/plain")
    public String getPlain() {
        return "CTS-Delete text/plain";
    }

    @DELETE
    @Produces(value = "text/html")
    public String getHtml() {
        return html_content;
    }

    @DELETE
    @Path(value = "/sub")
    @Produces(value = "text/html")
    public String getSub() {
        return html_content;
    }
}
