/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */
package com.sun.ts.tests.jaxrs.ee.rs.head;

import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value = "/HeadTest")
public class HttpMethodHeadTest {

    @HEAD
    @Produces(value = "text/plain")
    public Response headPlain() {
        return Response.ok().header("CTS-HEAD", "text-plain").build();
    }

    @HEAD
    @Produces(value = "text/html")
    public Response headHtml() {
        return Response.ok().header("CTS-HEAD", "text-html").build();
    }

    @HEAD
    @Path(value = "/sub")
    @Produces(value = "text/html")
    public Response headSub() {
        return Response.ok().header("CTS-HEAD", "sub-text-html").build();
    }
    
    @GET
    @Path(value = "/get")
    public Response get() {
        return Response.ok("HEAD-GET").header("CTS-HEAD", "get").build();
    }    
}
