/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.common.schema30;

import javax.persistence.Basic;
import javax.persistence.Embeddable;
import java.sql.Date;

/*
 * ShelfLife 
 */

@Embeddable
public class ShelfLife implements java.io.Serializable {

    // Instance variables
    private Date inceptionDate;
    private Date soldDate;

    public ShelfLife() {
    }


    public ShelfLife(Date d1, Date d2) {
        inceptionDate = d1;
        soldDate = d2;
    }

    @Basic
    public Date getInceptionDate() {
        return inceptionDate;
    }

    public void setInceptionDate(Date d1) {
        inceptionDate = d1;
    }

    @Basic
    public Date getSoldDate() {
        return soldDate;
    }

    public void setSoldDate(Date d2) {
        soldDate = d2;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("inceptionDate: " + getInceptionDate());
        result.append(", soldDate: " + getSoldDate());
        result.append("]");

        return result.toString();
    }
}
