/*
 * Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 
package com.sun.ts.tests.jpa.core.annotations.embeddableMapValue;

import javax.persistence.*;
import java.util.Map;

/*
 * Employee
 */

@Entity
@Table(name="EMPLOYEE_EMBEDED_ADDRESS")
public class Employee implements java.io.Serializable {

    private int	     	     id;
    private String	     firstName;
    private String	     lastName;
    private Map <String, Address> locationAddress;

    public Employee() {
    }

    public Employee(int id, String firstName, String lastName)
    {
        	this.id = id;
        	this.firstName = firstName;
        	this.lastName = lastName;
    }

    @Id
    @Column(name="ID")
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    @Column(name="FIRSTNAME")
    public String getFirstName() {
        return firstName;
    }
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="LASTNAME")
    public String getLastName() {
        return lastName;
    }
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @ElementCollection
    @CollectionTable(name="COLTAB_EMP_EMBEDED_ADDRESS", joinColumns=@JoinColumn(name="EMPEMBADDRID"))
    @MapKeyColumn(name="ADDRESS_LOCATION")
    public Map <String, Address> getLocationAddress() {
        return locationAddress;
    }
    
    public void setLocationAddress(Map<String, Address> locationAddress) {
        this.locationAddress = locationAddress;
    }

}

