/*
 * Copyright (c) 2008, 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 
package com.sun.ts.tests.jpa.core.annotations.mapkeycolumn;

import javax.persistence.*;
import java.util.Map;

/*
 * Department
 */

@Entity
@Table(name="DEPARTMENT")
public class Department implements java.io.Serializable {

    // Instance variables
    private int  id;
    private String  name;
    private Map<String, Employee> lastNameEmployees;
    private Map<String, Employee> salaryEmployees;

    public Department() {
    }

    public Department(int id, String name) {
        this.id = id;
        this.name = name;
    }


    // ===========================================================
    // getters and setters for the state fields

    @Id
    @Column(name="ID")
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    @Column(name="NAME")
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }

    // ===========================================================
    // getters and setters for the association fields

    @OneToMany(mappedBy="department")
    @MapKeyColumn(name="OFFICE_ID", nullable = false, insertable = true, length = 255, updatable = true, unique = true)
    public Map<String, Employee> getLastNameEmployees() {
        return lastNameEmployees;
    }

    public void setLastNameEmployees(Map<String, Employee> lastNameEmployees) {
        this.lastNameEmployees = lastNameEmployees;
    }

}
