/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: LineItemSuper.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.callback.listeneroverride;

import com.sun.ts.tests.jpa.core.callback.common.CallbackStatusIF;
import com.sun.ts.tests.jpa.core.callback.common.CallbackStatusImpl;
import com.sun.ts.tests.jpa.core.callback.common.ListenerA;
import com.sun.ts.tests.jpa.core.callback.common.ListenerB;

import javax.persistence.Column;
import javax.persistence.EntityListeners;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
@EntityListeners({ListenerA.class, ListenerB.class})
public class LineItemSuper extends CallbackStatusImpl
        implements java.io.Serializable, CallbackStatusIF {
    public int quantity;
    
    public LineItemSuper() {
    }
    
    @Column(name="QUANTITY")
    public int getQuantity() {
        return quantity;
    }
    
    public void setQuantity(int v) {
        quantity = v;
    }
}
