/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.relationship.bidirmanyxmany;

import com.sun.javatest.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;

import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

/**
 * @author Raja Perumal
 */
public class Client extends PMClientBase {

    public Client() {
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Fault {
        TestUtil.logTrace("setup");
        try {

            super.setup(args, p);
            removeTestData();
        } catch (Exception e) {
            TestUtil.logErr("Exception: " , e);
            throw new Fault("Setup failed:", e);
        }
    }

    /*
     * @testName: biDirMXMTest1
     * 
     * @assertion_ids: PERSISTENCE:SPEC:1094; PERSISTENCE:JAVADOC:135;
     *                 PERSISTENCE:JAVADOC:91; PERSISTENCE:SPEC:561;
     *                 PERSISTENCE:SPEC:562; PERSISTENCE:SPEC:567;
     *                 PERSISTENCE:SPEC:570; PERSISTENCE:SPEC:571;
     *                 PERSISTENCE:SPEC:573; PERSISTENCE:SPEC:961;
     *                 PERSISTENCE:SPEC:1028; PERSISTENCE:SPEC:1037;
     *                 PERSISTENCE:SPEC:1038; PERSISTENCE:SPEC:1039
     *
     * @test_Strategy: Bi-Directional RelationShip OneToMany Mapping
     *
     */
    public void biDirMXMTest1() throws Fault {
        TestUtil.logTrace("Begin biDirMXMTest1");
        boolean pass = false;
        try {


            getEntityTransaction().begin();


            BiDirMXMProject project1 = new BiDirMXMProject(1L, "JavaEE", 500.0F);
            BiDirMXMProject project2 = new BiDirMXMProject(2L, "Identity", 300F);

            BiDirMXMPerson person1 = new BiDirMXMPerson(1L, "Duke");
            BiDirMXMPerson person2 = new BiDirMXMPerson(2L, "Foo");

            getEntityManager().persist(project1);
            getEntityManager().persist(project2);
            getEntityManager().persist(person1);
            getEntityManager().persist(person2);

            Vector<BiDirMXMProject> projects = new Vector<BiDirMXMProject>();
            projects.add(project1);
            projects.add(project2);

            person1.setProjects(projects);

            Vector<BiDirMXMProject> projects2 = new Vector<BiDirMXMProject>();
            projects2.add(project2);

            person2.setProjects(projects2);

            getEntityManager().merge(person1);
            getEntityManager().merge(person2);

            getEntityManager().flush();
            getEntityTransaction().commit();
            TestUtil.logTrace("persisted Persons and Project");

            getEntityTransaction().begin();


            TestUtil.logTrace("persisted Persons and Project");

            boolean pass1 = false;
            boolean pass2 = false;

            BiDirMXMPerson newPerson = getEntityManager().find(BiDirMXMPerson.class, 1L);

            if (newPerson != null) {

                Collection<BiDirMXMProject> newProjects = newPerson.getProjects();
                for (BiDirMXMProject prj : newProjects) {
                    if (prj.getName().equals("Identity")) {
                        TestUtil.logTrace("Found Searched Project Identity");
                        pass1 = true;
                    } else if (prj.getName().equals("JavaEE")) {
                        TestUtil.logTrace("Found Searched Project JavaEE");
                        pass2 = true;
                    }
                }

            }

            boolean pass3 = false;
            BiDirMXMPerson newPerson2 = getEntityManager().find(BiDirMXMPerson.class, 2L);

            if (newPerson2 != null) {

                Collection<BiDirMXMProject> newProjects2 = newPerson2.getProjects();
                for (BiDirMXMProject prj : newProjects2) {
                    if (prj.getName().equals("Identity")) {
                        TestUtil.logTrace("Found Searched Project for Person id=2");
                        pass3 = true;
                    }
                }

            }

            if (pass1 && pass2 && pass3) {
                TestUtil.logTrace("biDirMXMTest1: Expected results received");
                pass = true;
            } else {
                TestUtil.logErr("Unexpected results received");
                pass = false;
            }

            getEntityTransaction().commit();

        } catch (Exception e) {

            TestUtil.logErr("Unexpected exception occurred", e);
        } finally {
            try {
                if (getEntityTransaction().isActive()) {
                    getEntityTransaction().rollback();
                }
            } catch (Exception re) {
                TestUtil.logErr("Unexpected Exception in rollback:",re);
            }
        }

        if (!pass) {
            throw new Fault("biDirMXMTest1 failed");
        }
    }

    public void cleanup() throws Fault {
        TestUtil.logTrace("cleanup");
        removeTestData();
        TestUtil.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace("removeTestData");
        if (getEntityTransaction().isActive()) {
            getEntityTransaction().rollback();
        }
        try {
            getEntityTransaction().begin();
            getEntityManager().createNativeQuery("DELETE FROM BIDIRMXMPERSON_BIDIRMXMPROJECT").executeUpdate();
            getEntityManager().createNativeQuery("DELETE FROM BIDIRMXMPERSON").executeUpdate();
            getEntityManager().createNativeQuery("DELETE FROM BIDIRMXMPROJECT").executeUpdate();
            getEntityTransaction().commit();
        } catch (Exception e) {
            TestUtil.logErr("Exception encountered while removing entities:",e);
        } finally {
            try {
                if (getEntityTransaction().isActive()) {
                    getEntityTransaction().rollback();
                }
            } catch (Exception re) {
                TestUtil.logErr("Unexpected Exception in removeTestData:",re);
            }
        }
    }
}

