/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.core.relationship.bidironexone;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;


@Entity
public class BiDir1X1Project implements java.io.Serializable  {

    private long                projId;
    private String              name;
    private float          budget;
    private BiDir1X1Person biDir1X1Person;

    public BiDir1X1Project() {
    }

    public BiDir1X1Project(long projId, String name, float budget) {
        this.projId = projId;
        this.name = name;
        this.budget = budget;
    }

    @Id
    public long getProjId() {
        return projId;

            }
    public void setProjId(long projId) {
        this.projId = projId;
    }

    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }

    public float getBudget() {
        return budget;
    }
    public void setBudget(float budget) {
        this.budget = budget;
    }

    // Bi-directional OnePerson OneProject
    @OneToOne(mappedBy = "project", cascade=CascadeType.ALL)
    public BiDir1X1Person getBiDir1X1Person() {
        return biDir1X1Person;
    }

    public void setBiDir1X1Person(BiDir1X1Person biDir1X1Person) {
        this.biDir1X1Person = biDir1X1Person;
    }

}
