/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestBean.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.types.primarykey.compound;

import com.sun.ts.lib.util.TestUtil;

import javax.persistence.Basic;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name= "PKEY")
public class TestBean implements java.io.Serializable{

   private CompoundPK compoundPK;
   private String brandName;
   private float price;

   public TestBean() {
   }

   public TestBean(CompoundPK pk, String brandName, float price) {
	this.compoundPK = pk;
	this.brandName = brandName;
	this.price = price;
   }

   @EmbeddedId
    public CompoundPK getCompoundPK() {
        return compoundPK;
    }
    public void setCompoundPK(CompoundPK compoundPK) {
        this.compoundPK = compoundPK;
    }

    @Basic
    public String getBrandName() {
        return brandName;
    }
    public void setBrandName(String v) {
        this.brandName = v;
    }

    @Basic
    public float getPrice() {
        return price;
    }
    public void setPrice(float v) {
        this.price = v;
    }


    public void ping() {
	TestUtil.logTrace("[TestBean] ping()");
    }

}

