/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/
package com.sun.ts.tests.jpa.se.cache.xml.disableselective;

import com.sun.javatest.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;

import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import java.util.Properties;

public class Client extends PMClientBase {

    public Client() {
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Fault {
        TestUtil.logTrace("setup");
        try {

            super.setup(args, p);
            removeTestData();

        } catch (Exception e) {
            TestUtil.logErr("Exception: ", e);
            throw new Fault("Setup failed:", e);
        }
    }

    /*
     * @testName: containsTest
     * @assertion_ids: PERSISTENCE:SPEC:1498; PERSISTENCE:SPEC:1498.1;
     *                  PERSISTENCE:SPEC:1498.3; PERSISTENCE:SPEC:1866;
     *                  PERSISTENCE:SPEC:1978;
     * @test_Strategy:  Using the xml shared-cache-mode element with a value of DISABLE_SELECTIVE
     *                  persist some entities with various Cachable values and verify the behavior
     *                  of whether or not each is retained or not in the cache.
     */
    public void containsTest() throws Fault {
        Cache cache;
        boolean pass1 = false;
        boolean pass2 = false;
        if (cachingSupported) {
            try {

                EntityManager em2 = getEntityManager();
                EntityTransaction et = getEntityTransaction();

                et.begin();

                Order order = new Order(1, 101);
                em2.persist(order);
                TestUtil.logTrace("persisted Order " + order);

                Customer cust = new Customer("1", "one");
                em2.persist(cust);
                TestUtil.logTrace("persisted Customer " + cust);

                em2.flush();
                et.commit();

                EntityManagerFactory emf = getEntityManagerFactory();
                cache = emf.getCache();

                if (cache != null) {
                    boolean b1 = cache.contains(Order.class, 1);
                    if (b1) {
                        TestUtil.logTrace("Cache returned: "+b1+", therefore cache does contain order " + order);
                        pass1=true;
                    } else {
                        TestUtil.logErr("Cache returned: "+b1+", therefore cache does not contain order " + order);
                    }
                    boolean b2 = cache.contains(Customer.class, "1");
                    if (!b2) {
                        TestUtil.logTrace("Cache returned: "+b2+", therefore cache does not contain Customer " + cust);
                        pass2=true;
                    } else {
                        TestUtil.logErr("Cache returned: "+b2+", therefore cache does contain Customer " + cust);
                    }

                } else {
                    TestUtil.logErr("Cache returned was null");
                }
            } catch (Exception e) {
                TestUtil.logErr("Unexpected exception occurred", e);
            }
        } else {
            TestUtil.logMsg("Cache not supported, bypassing test");
            pass1 = true;
            pass2 = true;
        }
        if (!pass1 || !pass2) {
            throw new Fault("containsTest failed");
        }

    }


    public void cleanup() throws Fault {
        TestUtil.logTrace("cleanup");
        removeTestData();
        TestUtil.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace("removeTestData");
        if (getEntityTransaction().isActive()) {
            getEntityTransaction().rollback();
        }
        try {
            getEntityTransaction().begin();
            getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            getEntityManager().createNativeQuery("DELETE FROM CUSTOMER_TABLE").executeUpdate();
            getEntityTransaction().commit();
        } catch (Exception e) {
            TestUtil.logErr("Exception encountered while removing entities:", e);
        } finally {
            try {
                if (getEntityTransaction().isActive()) {
                    getEntityTransaction().rollback();
                }
            } catch (Exception re) {
                TestUtil.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

