/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: B.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.se.resource_local;

import javax.persistence.*;

@Entity
@Table(name="BEJB_1X1_BI_BTOB")
public class B implements java.io.Serializable {

    // ===========================================================
    // instance variables 

    protected String id;
    protected String name;
    protected int value;
    protected A a;

    // ===========================================================
    // constructors

    public B() {
    }

    public B(String id, String name, int value)
    {
      this.id = id;
      this.name = name;
      this.value = value;
    }

    public B(String id, String name, int value, A a)
    {
      this.id = id;
      this.name = name;
      this.value = value;
      this.a = a;
    }

   @Id
   public String getId()
    {
        return id;
    }
    public void setId(String id)
    {
        this.id = id;
    }

    @Basic
    public String getName()
    {
        return name;
    }
    public void setName(String name)
    {
        this.name = name;
    }

    @Basic
    public int getValue()
    {
        return value;
    }
    public void setValue(int value) {
        this.value = value;
    }

    // ===========================================================
    // relationship fields

    @OneToOne(cascade=CascadeType.ALL)
    @JoinColumn(name="FK_FOR_AEJB_1X1_BI_BTOB")
    public A getA() {
	return a;
    }
    public void setA(A a) {
	this.a = a;
    }

}
