/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.websocket;

import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.WebSocket;
import jdk.incubator.http.internal.common.Pair;
import jdk.incubator.http.internal.websocket.WebSocketImpl;

public final class BuilderImpl
implements WebSocket.Builder {
    private final HttpClient client;
    private final URI uri;
    private final WebSocket.Listener listener;
    private final Collection<Pair<String, String>> headers = new LinkedList<Pair<String, String>>();
    private final Collection<String> subprotocols = new LinkedList<String>();
    private Duration timeout;

    public BuilderImpl(HttpClient httpClient, URI uRI, WebSocket.Listener listener) {
        this.client = Objects.requireNonNull(httpClient, "client");
        this.uri = Objects.requireNonNull(uRI, "uri");
        this.listener = Objects.requireNonNull(listener, "listener");
    }

    @Override
    public WebSocket.Builder header(String string, String string2) {
        Objects.requireNonNull(string, "name");
        Objects.requireNonNull(string2, "value");
        this.headers.add(Pair.pair(string, string2));
        return this;
    }

    @Override
    public WebSocket.Builder subprotocols(String string, String ... stringArray) {
        Objects.requireNonNull(string, "mostPreferred");
        Objects.requireNonNull(stringArray, "lesserPreferred");
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Objects.requireNonNull(string2, "lesserPreferred[" + i + "]");
            linkedList.add(string2);
        }
        this.subprotocols.clear();
        this.subprotocols.addAll(linkedList);
        return this;
    }

    @Override
    public WebSocket.Builder connectTimeout(Duration duration) {
        this.timeout = Objects.requireNonNull(duration, "timeout");
        return this;
    }

    @Override
    public CompletableFuture<WebSocket> buildAsync() {
        return WebSocketImpl.newInstanceAsync(this);
    }

    HttpClient getClient() {
        return this.client;
    }

    URI getUri() {
        return this.uri;
    }

    WebSocket.Listener getListener() {
        return this.listener;
    }

    Collection<Pair<String, String>> getHeaders() {
        return this.headers;
    }

    Collection<String> getSubprotocols() {
        return this.subprotocols;
    }

    Duration getConnectTimeout() {
        return this.timeout;
    }
}

