/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.createfilter;

import java.io.IOException;
import javax.servlet.*;

public final class CreateFilter implements Filter {

    // The filter configuration object we are associated with.  If this value
    // is null, this filter instance is not currently configured.
    private FilterConfig filterConfig = null;

    public void doFilter(ServletRequest request, ServletResponse response,
            FilterChain chain) throws IOException, ServletException {

        if (filterConfig == null) {
            System.out.println("doFilter of CreateFilter was called but this filter instance is not currently configured");
        } else {
            System.out.println("CREATE_FILTER_INVOKED");
        }

        chain.doFilter(request, response);
    }

    // Remove the filter configuration object for this filter.
    public void destroy() {
    }

    //  initialize the filter configuration object for this filter.
    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }
}
