/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efbt.regpot_desktop.csvconverter;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EObjectToCSVConverter {
    public static String resourceURI = "";

    public static void persistObjectAsCSV(EObject theObject, boolean useLongNames) {
        String csvString = EObjectToCSVConverter.createCSVStringForTable(theObject, useLongNames);
        String fileName = "";
        try {
            if (useLongNames) {
                fileName = String.valueOf(theObject.eClass().getName()) + "_longnames.csv";
                Files.writeString(Path.of(String.valueOf(resourceURI) + '/' + fileName, new String[0]), (CharSequence)csvString, StandardOpenOption.CREATE_NEW);
            } else {
                fileName = String.valueOf(theObject.eClass().getName()) + ".csv";
                Files.writeString(Path.of(String.valueOf(resourceURI) + '/' + fileName, new String[0]), (CharSequence)csvString, StandardOpenOption.CREATE_NEW);
            }
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            System.out.println("File " + fileName + " already exists");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String createCSVStringForTable(EObject theObject, boolean useLongNames) {
        String csvString = "";
        EClass eClass = theObject.eClass();
        EList sfs = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : sfs) {
            boolean cont;
            if (!(eStructuralFeature instanceof EReference) || !(cont = ((EReference)eStructuralFeature).isContainment())) continue;
            boolean headerCreated = false;
            TreeIterator objectContents = theObject.eAllContents();
            while (objectContents.hasNext()) {
                EObject o = (EObject)objectContents.next();
                if (!headerCreated) {
                    csvString = String.valueOf(csvString) + EObjectToCSVConverter.createCSVHeaderStringForRow(o);
                    headerCreated = true;
                }
                csvString = String.valueOf(csvString) + EObjectToCSVConverter.createCSVStringForRow(o, useLongNames);
            }
        }
        return String.valueOf(csvString) + "\n";
    }

    private static String createCSVStringForRow(EObject theObject, boolean useLongNames) {
        String csvString = "";
        EClass eClass = theObject.eClass();
        EList sfs = eClass.getEAllStructuralFeatures();
        boolean firstItem = true;
        for (EStructuralFeature eStructuralFeature : sfs) {
            String referencedItemString;
            Object referencedItem;
            if (firstItem) {
                referencedItem = theObject.eGet(eStructuralFeature, true);
                referencedItemString = EObjectToCSVConverter.getReferencedItemString(eStructuralFeature, referencedItem, useLongNames);
                csvString = String.valueOf(csvString) + referencedItemString;
                firstItem = false;
                continue;
            }
            referencedItem = theObject.eGet(eStructuralFeature, true);
            referencedItemString = EObjectToCSVConverter.getReferencedItemString(eStructuralFeature, referencedItem, useLongNames);
            csvString = String.valueOf(csvString) + "," + referencedItemString;
        }
        EList ops = eClass.getEAllOperations();
        for (EOperation eOperation : ops) {
            String resultString;
            Object result;
            if (firstItem) {
                if (eOperation.getName().contains("_regscenario_") || eOperation.getName().contains("_private")) continue;
                try {
                    result = theObject.eInvoke(eOperation, null);
                    resultString = "null";
                    if (result != null) {
                        resultString = result.toString();
                    }
                    csvString = String.valueOf(csvString) + resultString;
                    firstItem = false;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (eOperation.getName().contains("_regscenario_") || eOperation.getName().contains("_private")) continue;
            try {
                result = theObject.eInvoke(eOperation, null);
                resultString = "null";
                if (result != null) {
                    resultString = result.toString();
                }
                csvString = String.valueOf(csvString) + "," + resultString;
                firstItem = false;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return String.valueOf(csvString) + "\n";
    }

    private static String createCSVHeaderStringForRow(EObject theObject) {
        String csvString = "";
        EClass eClass = theObject.eClass();
        EList sfs = eClass.getEAllStructuralFeatures();
        boolean firstItem = true;
        for (EStructuralFeature eStructuralFeature : sfs) {
            if (firstItem) {
                csvString = String.valueOf(csvString) + eStructuralFeature.getName();
                firstItem = false;
                continue;
            }
            csvString = String.valueOf(csvString) + "," + eStructuralFeature.getName();
        }
        EList ops = eClass.getEAllOperations();
        for (EOperation eOperation : ops) {
            if (firstItem) {
                if (eOperation.getName().contains("_regscenario_") || eOperation.getName().contains("_private")) continue;
                csvString = String.valueOf(csvString) + eOperation.getName();
                firstItem = false;
                continue;
            }
            if (eOperation.getName().contains("_regscenario_") || eOperation.getName().contains("_private")) continue;
            csvString = String.valueOf(csvString) + "," + eOperation.getName();
        }
        return String.valueOf(csvString) + "\n";
    }

    private static String getReferencedItemString(EStructuralFeature eStructuralFeature, Object referencedItem, boolean useLongNames) {
        String returnString = null;
        if (referencedItem == null) {
            returnString = "null";
        } else if (eStructuralFeature instanceof EReference) {
            if (eStructuralFeature.getUpperBound() == 1) {
                EClass eClass = ((EObject)referencedItem).eClass();
                EAttribute idattr = eClass.getEIDAttribute();
                EList features = eClass.getEAllStructuralFeatures();
                for (EStructuralFeature eStructuralFeature2 : features) {
                    Object attributeValue;
                    if (eStructuralFeature2 == idattr && (attributeValue = ((EObject)referencedItem).eGet(eStructuralFeature2)) != null) {
                        returnString = attributeValue.toString();
                    }
                    if (returnString != null) continue;
                    returnString = eStructuralFeature.getName();
                }
            } else {
                returnString = "multiple_" + eStructuralFeature.getName();
            }
        } else if (eStructuralFeature instanceof EAttribute && ((EAttribute)eStructuralFeature).getEAttributeType() instanceof EEnum) {
            returnString = useLongNames ? String.valueOf(((Enumerator)referencedItem).getLiteral()) + "_" + ((Enumerator)referencedItem).getName() : ((Enumerator)referencedItem).getLiteral();
        } else if (((EAttribute)eStructuralFeature).getEAttributeType().getInstanceClassName().equals("java.util.Date")) {
            String pattern = "MM/dd/yyyy";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            returnString = simpleDateFormat.format((Date)referencedItem);
        } else {
            returnString = referencedItem.toString();
        }
        return returnString;
    }
}

