/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.GhostImageFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.IScrollableFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.ViewportUtilities;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.IScrollableEditPart;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.util.EditPartUtilities;

public class ScrollableSelectionFeedbackEditPolicy
extends SelectionEditPolicy {
    private int feedbackAlpha = 100;
    private final List<IFigure> feedbackFigures = new ArrayList<IFigure>();
    private final FigureListener figureListener = source -> {
        if (this.getHost().getSelected() == 2) {
            this.updateFeedback();
        }
    };
    private final LayoutListener layoutListener = new LayoutListener.Stub(){

        public void postLayout(IFigure container) {
            if (ScrollableSelectionFeedbackEditPolicy.this.getHost().getSelected() == 2) {
                ScrollableSelectionFeedbackEditPolicy.this.updateFeedback();
            }
        }
    };
    private final PropertyChangeListener viewportViewLocationChangeListener = event -> {
        if (event.getSource() == ((IScrollableFigure)this.getHostFigure()).getScrollPane().getViewport() && this.getHost().getSelected() != 2) {
            this.getHost().getViewer().deselectAll();
            this.getHost().getViewer().select(this.getHost());
        }
        if (event.getPropertyName().equals("viewLocation")) {
            this.updateFeedback();
        }
    };

    @Override
    public void activate() {
        super.activate();
        for (Object element : ViewportUtilities.getViewportsPath((Viewport)this.getHostFigureViewport(), (Viewport)ViewportUtilities.getRootViewport((IFigure)this.getHostFigure()))) {
            Viewport viewport = (Viewport)element;
            viewport.addPropertyChangeListener(this.viewportViewLocationChangeListener);
        }
    }

    protected void addFeedbackFigure(IFigure feedbackFigure, Rectangle feedbackFigureAbsoluteBounds) {
        this.getFeedbackLayer().translateToRelative((Translatable)feedbackFigureAbsoluteBounds);
        this.getFeedbackLayer().translateFromParent((Translatable)feedbackFigureAbsoluteBounds);
        feedbackFigure.setBounds(feedbackFigureAbsoluteBounds);
        feedbackFigure.validate();
        this.addFeedback(feedbackFigure);
        this.feedbackFigures.add(feedbackFigure);
    }

    protected void createConnectionFeedbackFigure(ConnectionEditPart connectionEditPart) {
        this.addFeedbackFigure((IFigure)new GhostImageFigure(connectionEditPart.getFigure(), this.getAlpha(), this.getLayer("Connection Layer").getBackgroundColor().getRGB()), ScrollableSelectionFeedbackEditPolicy.getAbsoluteBounds(connectionEditPart.getFigure()));
    }

    protected void createConnectionFeedbackFigures() {
        HashSet transitiveNestedConnections = EditPartUtilities.getAllNestedConnectionEditParts(this.getHost());
        for (Object connection : transitiveNestedConnections) {
            if (!(connection instanceof ConnectionEditPart)) continue;
            this.createConnectionFeedbackFigure((ConnectionEditPart)connection);
        }
    }

    protected void createNodeFeedbackFigure(GraphicalEditPart childEditPart) {
        this.addFeedbackFigure((IFigure)new GhostImageFigure(childEditPart.getFigure(), this.getAlpha(), null), ScrollableSelectionFeedbackEditPolicy.getAbsoluteBounds(childEditPart.getFigure()));
    }

    protected void createNodeFeedbackFigures() {
        this.getHost().getChildren().forEach(this::createNodeFeedbackFigure);
    }

    @Override
    public void deactivate() {
        for (Object element : ViewportUtilities.getViewportsPath((Viewport)this.getHostFigureViewport(), (Viewport)ViewportUtilities.getRootViewport((IFigure)this.getHostFigure()))) {
            Viewport viewport = (Viewport)element;
            viewport.removePropertyChangeListener(this.viewportViewLocationChangeListener);
        }
        super.deactivate();
    }

    protected int getAlpha() {
        return this.feedbackAlpha;
    }

    @Override
    protected IFigure getFeedbackLayer() {
        return this.getLayer("Scaled Feedback Layer");
    }

    protected Viewport getHostFigureViewport() {
        return ((IScrollableFigure)this.getHostFigure()).getScrollPane().getViewport();
    }

    protected void hideFeedback() {
        this.feedbackFigures.forEach(this::removeFeedback);
        this.feedbackFigures.clear();
    }

    @Override
    protected void hideSelection() {
        this.getHostFigure().removeLayoutListener(this.layoutListener);
        this.getHostFigure().removeFigureListener(this.figureListener);
        this.hideFeedback();
    }

    public void setAlpha(int alpha) {
        this.feedbackAlpha = alpha;
    }

    @Override
    public void setHost(EditPart host) {
        Assert.isLegal((boolean)(host instanceof IScrollableEditPart));
        super.setHost(host);
    }

    protected void showFeedback() {
        this.getLayer("Primary Layer").validate();
        this.getLayer("Connection Layer").validate();
        Rectangle clientArea = ScrollableSelectionFeedbackEditPolicy.getAbsoluteClientArea(this.getHostFigure());
        boolean primaryLayerChildExceedsViewport = !clientArea.equals((Object)ScrollableSelectionFeedbackEditPolicy.getAbsoluteViewportArea(((IScrollableFigure)this.getHostFigure()).getScrollPane().getViewport()));
        boolean connectionLayerChildExceedsClientArea = false;
        Iterator iterator = this.getLayer("Connection Layer").getChildren().iterator();
        while (iterator.hasNext() && !connectionLayerChildExceedsClientArea) {
            IFigure connectionLayerChild = (IFigure)iterator.next();
            boolean bl = connectionLayerChildExceedsClientArea = ViewportUtilities.getNearestEnclosingViewport((IFigure)connectionLayerChild) == ((IScrollableFigure)this.getHostFigure()).getScrollPane().getViewport() && !clientArea.getExpanded(new Insets(1, 1, 1, 1)).contains(ScrollableSelectionFeedbackEditPolicy.getAbsoluteBounds(connectionLayerChild));
        }
        if (primaryLayerChildExceedsViewport || connectionLayerChildExceedsClientArea) {
            this.createNodeFeedbackFigures();
            this.createConnectionFeedbackFigures();
        }
    }

    @Override
    protected void showSelection() {
        this.getHost().getViewer().reveal(this.getHost());
        this.updateFeedback();
        this.getHostFigure().addLayoutListener(this.layoutListener);
        this.getHostFigure().addFigureListener(this.figureListener);
    }

    protected void updateFeedback() {
        this.hideFeedback();
        if (this.getHost().getSelected() == 2) {
            this.showFeedback();
        }
    }

    private static Rectangle getAbsoluteBounds(IFigure figure) {
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    private static Rectangle getAbsoluteClientArea(IFigure figure) {
        Rectangle clientArea = figure.getClientArea().getCopy();
        figure.translateToParent((Translatable)clientArea);
        figure.translateToAbsolute((Translatable)clientArea);
        return clientArea;
    }

    private static Rectangle getAbsoluteViewportArea(Viewport viewport) {
        Rectangle viewportParentBounds = viewport.getParent().getBounds().getCopy();
        int widthMax = viewport.getHorizontalRangeModel().getMaximum();
        int widthMin = viewport.getHorizontalRangeModel().getMinimum();
        int heightMax = viewport.getVerticalRangeModel().getMaximum();
        int heightMin = viewport.getVerticalRangeModel().getMinimum();
        viewportParentBounds.setSize(widthMax - widthMin, heightMax - heightMin);
        viewportParentBounds.translate(widthMin, heightMin);
        viewportParentBounds.translate(viewport.getViewLocation().getNegated());
        viewport.getParent().translateToAbsolute((Translatable)viewportParentBounds);
        return viewportParentBounds;
    }
}

