/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.debug.ui.JavaDebugHover;

public class LambdaUtils
extends org.eclipse.jdt.internal.debug.core.model.LambdaUtils {
    private static int indexOf(IJavaStackFrame frame, IStackFrame[] stackFrames) {
        int j = 0;
        boolean found = false;
        while (j < stackFrames.length) {
            if (stackFrames[j] == frame) {
                found = true;
                break;
            }
            ++j;
        }
        if (found) {
            return j;
        }
        return -1;
    }

    public static IVariable findLocalVariableFromLambdaScope(IJavaStackFrame frame, ILocalVariable local) throws DebugException, CoreException {
        IVariable var = JavaDebugHover.findLocalVariable(frame, local.getElementName());
        if (var != null) {
            return var;
        }
        IStackFrame[] stackFrames = frame.getThread().getStackFrames();
        int indexOfCurrentFrame = LambdaUtils.indexOf(frame, stackFrames);
        if (indexOfCurrentFrame < 0) {
            return null;
        }
        int i = 1 + indexOfCurrentFrame;
        IJavaElement parent = local.getParent();
        String enclosingMethodName = parent.getElementName();
        List<String> methodTypeNames = LambdaUtils.getArgumentTypeNames(parent);
        while (i < stackFrames.length) {
            IJavaStackFrame currFrame = (IJavaStackFrame)stackFrames[i];
            String methodName = currFrame.getMethodName();
            List typeNames = currFrame.getArgumentTypeNames();
            if (methodName.equals(enclosingMethodName) && typeNames.equals(methodTypeNames)) {
                var = JavaDebugHover.findLocalVariable(currFrame, local.getElementName());
                if (var != null) {
                    return var;
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    private static List<String> getArgumentTypeNames(IJavaElement parent) throws CoreException {
        String[] ptypes;
        if (!(parent instanceof IMethod)) {
            return null;
        }
        IMethod method = (IMethod)parent;
        IType type = method.getDeclaringType();
        if (type == null) {
            return null;
        }
        ArrayList<String> psig = new ArrayList<String>();
        String[] stringArray = ptypes = method.getParameterTypes();
        int n = ptypes.length;
        int n2 = 0;
        while (n2 < n) {
            String ps = stringArray[n2];
            Object resolvedName = JavaModelUtil.getResolvedTypeName((String)ps, (IType)type);
            int arrayCount = Signature.getArrayCount((String)ps);
            int i = 0;
            while (i < arrayCount) {
                resolvedName = (String)resolvedName + "[]";
                ++i;
            }
            psig.add((String)resolvedName);
            ++n2;
        }
        return psig;
    }
}

