/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ischema.IDocumentSection;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.context.XMLDocumentSetupParticpant;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.XMLConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DocSection
extends PDESection {
    private final IDocument fDocument;
    private final XMLConfiguration fSourceConfiguration;
    private SourceViewer fSourceViewer;
    private CTabFolder fTabFolder;
    private final ISchema fSchema;
    private Object fElement;
    private boolean fIgnoreChange;

    public DocSection(PDEFormPage page, Composite parent, IColorManager colorManager) {
        super(page, parent, 128, true);
        this.getSection().setText(PDEUIMessages.DocSection_text);
        this.getSection().setDescription(PDEUIMessages.SchemaEditor_DocSection_desc);
        this.fSourceConfiguration = new XMLConfiguration(colorManager);
        this.fDocument = new Document();
        new XMLDocumentSetupParticpant().setup(this.fDocument);
        this.fSchema = (ISchema)this.getPage().getModel();
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void commit(boolean onSave) {
        this.handleApply();
        super.commit(onSave);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 1));
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        section.setLayoutData((Object)data);
        this.fTabFolder = new CTabFolder(container, 0x800080);
        toolkit.adapt((Control)this.fTabFolder, true, true);
        GridData gd = new GridData(256);
        gd.heightHint = 2;
        this.fTabFolder.setLayoutData((Object)gd);
        toolkit.getColors().initializeSectionToolBarColors();
        Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.fTabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{100}, true);
        this.fTabFolder.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateTabSelection()));
        int styles = 834;
        this.fSourceViewer = new SourceViewer(container, null, styles);
        this.fSourceViewer.configure((SourceViewerConfiguration)this.fSourceConfiguration);
        this.fSourceViewer.setDocument(this.fDocument);
        this.fSourceViewer.addSelectionChangedListener(event -> this.updateSelection(event.getSelection()));
        StyledText styledText = this.fSourceViewer.getTextWidget();
        styledText.setFont(JFaceResources.getTextFont());
        styledText.setMenu(this.getPage().getPDEEditor().getContextMenu());
        styledText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        styledText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DocSection.this.getPage().getPDEEditor().getContributor().updateSelectableActions(null);
            }
        });
        if (!SWT.getPlatform().equals("motif")) {
            toolkit.paintBordersFor(container);
        }
        Control[] children = container.getChildren();
        Control control = children[children.length - 1];
        gd = new GridData(1808);
        gd.widthHint = 50;
        gd.heightHint = 50;
        control.setLayoutData((Object)gd);
        this.createTabs();
        section.setClient((Control)container);
        this.initialize();
        if (this.fTabFolder.getItemCount() > 0) {
            this.fTabFolder.setSelection(0);
            this.updateTabSelection();
        }
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.fSourceViewer.doOperation(3);
            return true;
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            this.fSourceViewer.doOperation(4);
            return true;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.fSourceViewer.doOperation(5);
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            this.fSourceViewer.doOperation(7);
            return true;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.fSourceViewer.doOperation(6);
            return true;
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            this.fSourceViewer.doOperation(1);
            return true;
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            this.fSourceViewer.doOperation(2);
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    public boolean setFormInput(Object input) {
        int index = -1;
        if (input instanceof ISchema) {
            index = 0;
        } else if (input instanceof IDocumentSection) {
            IDocumentSection[] sections = this.fSchema.getDocumentSections();
            int i = 0;
            while (i < sections.length) {
                IDocumentSection section = sections[i];
                if (section.equals(input)) {
                    index = i + 1;
                    break;
                }
                ++i;
            }
        }
        if (index != -1) {
            this.fTabFolder.setSelection(index);
        }
        this.updateEditorInput(input);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private String getTopicName(Object object) {
        if (object instanceof ISchema) {
            return PDEUIMessages.SchemaEditor_topic_overview;
        }
        Object object2 = object;
        if (object2 instanceof IDocumentSection) {
            void section;
            IDocumentSection iDocumentSection = (IDocumentSection)object2;
            IDocumentSection cfr_ignored_0 = (IDocumentSection)object2;
            String sectionId = section.getSectionId();
            if (sectionId.equals("examples")) {
                return PDEUIMessages.SchemaEditor_topic_examples;
            }
            if (sectionId.equals("since")) {
                return PDEUIMessages.SchemaEditor_topic_since;
            }
            if (sectionId.equals("implementation")) {
                return PDEUIMessages.SchemaEditor_topic_implementation;
            }
            if (sectionId.equalsIgnoreCase("apiinfo")) {
                return PDEUIMessages.SchemaEditor_topic_api;
            }
            if (sectionId.equals("copyright")) {
                return PDEUIMessages.SchemaEditor_topic_copyright;
            }
        }
        return "?";
    }

    private void handleApply() {
        if (this.fElement != null) {
            if (this.fElement instanceof ISchema) {
                ((Schema)this.fElement).setDescription(this.fDocument.get());
            } else {
                ((SchemaObject)this.fElement).setDescription(this.fDocument.get());
            }
            this.updateTabImage(this.fTabFolder.getSelection());
        }
    }

    public void initialize() {
        this.fSourceViewer.setEditable(this.fSchema.isEditable());
        this.fDocument.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (!DocSection.this.fIgnoreChange && DocSection.this.fSchema.isEditable()) {
                    DocSection.this.markDirty();
                }
            }

            public void documentAboutToBeChanged(DocumentEvent e) {
            }
        });
        this.updateEditorInput(this.fSchema);
        this.fSchema.addModelChangedListener((IModelChangedListener)this);
    }

    public void dispose() {
        if (this.fSourceConfiguration != null) {
            this.fSourceConfiguration.dispose();
        }
        this.fSchema.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    private void createTabs() {
        IDocumentSection[] sections = this.fSchema.getDocumentSections();
        this.addTab((ISchemaObject)this.fSchema);
        IDocumentSection[] iDocumentSectionArray = sections;
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentSection section = iDocumentSectionArray[n2];
            this.addTab((ISchemaObject)section);
            ++n2;
        }
    }

    private void addTab(ISchemaObject section) {
        String label = this.getTopicName(section);
        CTabItem item = new CTabItem(this.fTabFolder, 0);
        item.setText(label);
        item.setData((Object)section);
        this.updateTabImage(item);
    }

    private void updateTabImage(CTabItem item) {
        ISchemaObject section;
        if (item != null && (section = (ISchemaObject)item.getData()) != null) {
            item.setImage(PDEPlugin.getDefault().getLabelProvider().getImage(section));
        }
    }

    private void updateTabSelection() {
        int index = this.fTabFolder.getSelectionIndex();
        if (this.fSchema.isEditable() && this.isDirty()) {
            this.handleApply();
        }
        if (index == 0) {
            this.updateEditorInput(this.fSchema);
        } else {
            IDocumentSection[] sections = this.fSchema.getDocumentSections();
            this.updateEditorInput(sections[index - 1]);
        }
    }

    public void setFocus() {
        this.fSourceViewer.getTextWidget().setFocus();
        this.updateSelection(this.fSourceViewer.getSelection());
    }

    private void updateSelection(ISelection selection) {
        this.getPage().getPDEEditor().setSelection(selection);
    }

    public void updateEditorInput(Object input) {
        this.fIgnoreChange = true;
        String text = "";
        if (input instanceof ISchemaObject) {
            text = ((ISchemaObject)input).getDescription();
        }
        this.fDocument.set(text == null ? "" : text);
        this.fElement = input;
        this.fIgnoreChange = false;
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
        }
    }

    public void refresh() {
        IDocumentSection[] sections = this.fSchema.getDocumentSections();
        int index = this.fTabFolder.getSelectionIndex();
        if (index == 0) {
            this.updateEditorInput(this.fSchema);
        } else {
            this.updateEditorInput(sections[index - 1]);
        }
        super.refresh();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        return this.fSourceViewer.canDoOperation(5);
    }
}

