/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;
import org.eclipse.ui.externaltools.internal.launchConfigurations.IgnoreWhiteSpaceComparator;
import org.eclipse.ui.externaltools.internal.model.BuilderUtils;
import org.eclipse.ui.externaltools.internal.ui.BuilderLabelProvider;
import org.eclipse.ui.externaltools.internal.ui.EditCommandDialog;
import org.eclipse.ui.externaltools.internal.ui.ExternalToolsUIMessages;
import org.eclipse.ui.progress.IProgressService;

public final class BuilderPropertyPage
extends PropertyPage
implements ICheckStateListener {
    private static final String COMMAND_ENABLED = "CommandEnabled";
    private Button upButton;
    private Button downButton;
    private Button newButton;
    private Button importButton;
    private Button editButton;
    private Button removeButton;
    private boolean userHasMadeChanges = false;
    private List<ILaunchConfiguration> configsToBeDeleted = null;
    private List<ICommand> commandsToBeDeleted = null;
    private CheckboxTableViewer viewer = null;
    private boolean fWarned = false;
    private boolean fCanEdit = false;
    private final ILabelProvider labelProvider = new BuilderLabelProvider();
    private final List<ILaunchConfiguration> newConfigList = new ArrayList<ILaunchConfiguration>();
    private final SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            BuilderPropertyPage.this.handleButtonPressed((Button)e.widget);
        }
    };
    private final ILaunchConfigurationListener configurationListener = new ILaunchConfigurationListener(){

        public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfiguration oldConfig = manager.getMovedFrom(configuration);
            if (oldConfig == null) {
                return;
            }
            if (BuilderPropertyPage.this.newConfigList.remove(oldConfig)) {
                BuilderPropertyPage.this.newConfigList.add(configuration);
            }
            Display.getDefault().asyncExec(() -> {
                TableItem[] items;
                TableItem[] tableItemArray = items = BuilderPropertyPage.this.viewer.getTable().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    Object data = item.getData();
                    if (data == oldConfig) {
                        item.setData((Object)configuration);
                        BuilderPropertyPage.this.viewer.update((Object)configuration, null);
                        break;
                    }
                    ++n2;
                }
            });
        }

        public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        }

        public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        }
    };

    public BuilderPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    private void addBuildersToTable() {
        IProject project = this.getInputProject();
        if (project == null) {
            return;
        }
        ICommand[] commands = null;
        try {
            commands = project.getDescription().getBuildSpec();
        }
        catch (CoreException e) {
            this.handleException((Exception)((Object)e));
            return;
        }
        ICommand[] iCommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            String[] version = new String[]{""};
            ILaunchConfiguration config = BuilderUtils.configFromBuildCommandArgs(project, command.getArguments(), version);
            Object element = null;
            if (config != null) {
                if (!config.isWorkingCopy() && !config.exists()) {
                    Shell shell = this.getShell();
                    if (shell == null) {
                        return;
                    }
                    Status status = new Status(4, "org.eclipse.ui.externaltools", 0, NLS.bind((String)ExternalToolsUIMessages.BuilderPropertyPage_Exists, (Object[])new String[]{config.getName()}), null);
                    ErrorDialog.openError((Shell)this.getShell(), (String)ExternalToolsUIMessages.BuilderPropertyPage_errorTitle, (String)NLS.bind((String)ExternalToolsUIMessages.BuilderPropertyPage_External_Tool_Builder__0__Not_Added_2, (Object[])new String[]{config.getName()}), (IStatus)status);
                    this.userHasMadeChanges = true;
                } else {
                    element = config;
                }
            } else {
                String builderID = command.getBuilderName();
                element = builderID.equals("org.eclipse.ui.externaltools.ExternalToolBuilder") && command.getArguments().get("LaunchConfigHandle") != null ? new ErrorConfig(command) : command;
            }
            if (element != null) {
                this.viewer.add(element);
                this.viewer.setChecked(element, this.isEnabled(element));
            }
            ++n2;
        }
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        button.setEnabled(false);
        button.addSelectionListener(this.buttonListener);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        return button;
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.externaltools.builder_property_page_context");
        Font font = parent.getFont();
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        topLevel.setLayout((Layout)layout);
        topLevel.setLayoutData((Object)new GridData(1808));
        Label description = new Label(topLevel, 64);
        description.setText(ExternalToolsUIMessages.BuilderPropertyPage_description);
        description.setLayoutData((Object)new GridData(768));
        description.setFont(font);
        Composite tableAndButtons = new Composite(topLevel, 0);
        tableAndButtons.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)tableAndButtons, (int)68354);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.addCheckStateListener((ICheckStateListener)this);
        Table builderTable = this.viewer.getTable();
        builderTable.setLayoutData((Object)new GridData(1808));
        builderTable.setFont(font);
        builderTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuilderPropertyPage.this.handleTableSelectionChanged();
            }
        });
        builderTable.addListener(8, event -> {
            if (this.fCanEdit) {
                this.handleEditButtonPressed();
            }
        });
        Composite buttonArea = new Composite(tableAndButtons, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setFont(font);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.newButton = this.createButton(buttonArea, ExternalToolsUIMessages.BuilderPropertyPage_newButton);
        this.importButton = this.createButton(buttonArea, ExternalToolsUIMessages.BuilderPropertyPage__Import____3);
        this.editButton = this.createButton(buttonArea, ExternalToolsUIMessages.BuilderPropertyPage_editButton);
        this.removeButton = this.createButton(buttonArea, ExternalToolsUIMessages.BuilderPropertyPage_removeButton);
        new Label(buttonArea, 16384);
        this.upButton = this.createButton(buttonArea, ExternalToolsUIMessages.BuilderPropertyPage_upButton);
        this.downButton = this.createButton(buttonArea, ExternalToolsUIMessages.BuilderPropertyPage_downButton);
        this.newButton.setEnabled(true);
        this.importButton.setEnabled(true);
        this.addBuildersToTable();
        return topLevel;
    }

    private void setAutobuild(boolean newState) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription wsDescription = workspace.getDescription();
        boolean oldState = wsDescription.isAutoBuilding();
        if (oldState != newState) {
            wsDescription.setAutoBuilding(newState);
            workspace.setDescription(wsDescription);
        }
    }

    private IProject getInputProject() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return (IProject)element;
        }
        Object resource = element.getAdapter(IResource.class);
        if (resource instanceof IProject) {
            return (IProject)resource;
        }
        return null;
    }

    private void handleButtonPressed(Button button) {
        if (button == this.newButton) {
            this.handleNewButtonPressed();
        } else if (button == this.importButton) {
            this.handleImportButtonPressed();
        } else if (button == this.editButton) {
            this.handleEditButtonPressed();
        } else if (button == this.removeButton) {
            this.handleRemoveButtonPressed();
        } else if (button == this.upButton) {
            this.moveSelectionUp();
        } else if (button == this.downButton) {
            this.moveSelectionDown();
        }
        if (this.getControl().isDisposed()) {
            return;
        }
        this.handleTableSelectionChanged();
        this.viewer.getTable().setFocus();
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        boolean checked = event.getChecked();
        if (element instanceof ILaunchConfiguration) {
            this.enableLaunchConfiguration((ILaunchConfiguration)element, checked);
        } else if (element instanceof ICommand) {
            Shell shell = this.getShell();
            if (shell == null) {
                return;
            }
            if (checked) {
                this.enableCommand((ICommand)element, checked);
                return;
            }
            if (!this.fWarned && MessageDialog.openConfirm((Shell)shell, (String)ExternalToolsUIMessages.BuilderPropertyPage_6, (String)ExternalToolsUIMessages.BuilderPropertyPage_7)) {
                this.fWarned = true;
            }
            if (this.fWarned) {
                this.enableCommand((ICommand)element, checked);
            } else {
                this.viewer.removeCheckStateListener((ICheckStateListener)this);
                this.viewer.setChecked(element, true);
                this.viewer.addCheckStateListener((ICheckStateListener)this);
            }
        }
    }

    private void enableLaunchConfiguration(ILaunchConfiguration configuration, boolean enable) {
        ILaunchConfigurationWorkingCopy workingCopy = null;
        try {
            if (configuration instanceof ILaunchConfigurationWorkingCopy) {
                workingCopy = (ILaunchConfigurationWorkingCopy)configuration;
            } else {
                TableItem[] items;
                TableItem[] tableItemArray = items = this.viewer.getTable().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getData() == configuration) {
                        workingCopy = configuration.getWorkingCopy();
                        item.setData((Object)workingCopy);
                    }
                    ++n2;
                }
            }
            if (workingCopy != null) {
                workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_BUILDER_ENABLED", enable);
            }
        }
        catch (CoreException coreException) {
            return;
        }
        this.userHasMadeChanges = true;
    }

    private void enableCommand(ICommand command, boolean enable) {
        HashMap<String, String> args = command.getArguments();
        if (args == null) {
            args = new HashMap<String, String>(1);
        }
        args.put(COMMAND_ENABLED, Boolean.toString(enable));
        command.setArguments(args);
        this.userHasMadeChanges = true;
    }

    private void handleImportButtonPressed() {
        ILaunchConfiguration newConfig;
        block20: {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            List<ILaunchConfigurationType> toolTypes = this.getConfigurationTypes("org.eclipse.ui.externaltools");
            ArrayList<ILaunchConfiguration> configurations = new ArrayList<ILaunchConfiguration>();
            for (ILaunchConfigurationType type : toolTypes) {
                try {
                    ILaunchConfiguration[] configs;
                    ILaunchConfiguration[] iLaunchConfigurationArray = configs = manager.getLaunchConfigurations(type);
                    int n = configs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
                        if (!DebugUITools.isPrivate((ILaunchConfiguration)launchConfiguration)) {
                            configurations.add(launchConfiguration);
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {}
            }
            Shell shell = this.getShell();
            if (shell == null) {
                return;
            }
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new BuilderLabelProvider());
            dialog.setTitle(ExternalToolsUIMessages.BuilderPropertyPage_4);
            dialog.setMessage(ExternalToolsUIMessages.BuilderPropertyPage_5);
            dialog.setElements(configurations.toArray());
            if (dialog.open() == 1) {
                return;
            }
            Object[] results = dialog.getResult();
            if (results.length == 0) {
                return;
            }
            ILaunchConfiguration config = (ILaunchConfiguration)results[0];
            newConfig = null;
            boolean wasAutobuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
            try {
                try {
                    this.setAutobuild(false);
                    newConfig = BuilderUtils.duplicateConfiguration(this.getInputProject(), config);
                }
                catch (CoreException e) {
                    this.handleException((Exception)((Object)e));
                    try {
                        this.setAutobuild(wasAutobuilding);
                    }
                    catch (CoreException e2) {
                        this.handleException((Exception)((Object)e2));
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.setAutobuild(wasAutobuilding);
                }
                catch (CoreException e) {
                    this.handleException((Exception)((Object)e));
                }
                throw throwable;
            }
            try {
                this.setAutobuild(wasAutobuilding);
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        if (newConfig != null) {
            this.userHasMadeChanges = true;
            this.viewer.add((Object)newConfig);
            this.viewer.setChecked((Object)newConfig, this.isEnabled(newConfig));
            this.newConfigList.add(newConfig);
        }
    }

    private void handleRemoveButtonPressed() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection != null) {
            int numSelected = selection.size();
            this.userHasMadeChanges = true;
            for (Object item : selection) {
                if (item instanceof ILaunchConfiguration) {
                    if (this.configsToBeDeleted == null) {
                        this.configsToBeDeleted = new ArrayList<ILaunchConfiguration>(numSelected);
                    }
                    this.configsToBeDeleted.add((ILaunchConfiguration)item);
                } else if (item instanceof ICommand) {
                    if (this.commandsToBeDeleted == null) {
                        this.commandsToBeDeleted = new ArrayList<ICommand>(numSelected);
                    }
                    this.commandsToBeDeleted.add((ICommand)item);
                }
                this.viewer.remove(item);
            }
        }
    }

    private void handleNewButtonPressed() {
        block13: {
            ILaunchConfigurationType type = this.promptForConfigurationType();
            if (type == null) {
                return;
            }
            boolean wasAutobuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
            try {
                try {
                    ILaunchConfigurationWorkingCopy workingCopy = null;
                    String name = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(ExternalToolsUIMessages.BuilderPropertyPage_New_Builder_7);
                    workingCopy = type.newInstance((IContainer)BuilderUtils.getBuilderFolder(this.getInputProject(), true), name);
                    StringBuilder buffer = new StringBuilder("full");
                    buffer.append(',');
                    buffer.append("incremental");
                    buffer.append(',');
                    workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", buffer.toString());
                    workingCopy.setAttribute("editedByExternalToolsMainTab", true);
                    ILaunchConfiguration config = null;
                    this.setAutobuild(false);
                    config = workingCopy.doSave();
                    this.newConfigList.add(config);
                    int code = this.editConfiguration(config);
                    if (code == 1) {
                        this.newConfigList.remove(config);
                        config.delete();
                        break block13;
                    }
                    this.userHasMadeChanges = true;
                    config = this.newConfigList.get(this.newConfigList.size() - 1);
                    this.viewer.add((Object)config);
                    this.viewer.setChecked((Object)config, this.isEnabled(config));
                }
                catch (CoreException e) {
                    this.handleException((Exception)((Object)e));
                    try {
                        this.setAutobuild(wasAutobuilding);
                    }
                    catch (CoreException e2) {
                        this.handleException((Exception)((Object)e2));
                    }
                }
            }
            finally {
                try {
                    this.setAutobuild(wasAutobuilding);
                }
                catch (CoreException e) {
                    this.handleException((Exception)((Object)e));
                }
            }
        }
    }

    private int editConfiguration(ILaunchConfiguration config) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        manager.addLaunchConfigurationListener(this.configurationListener);
        Shell shell = this.getShell();
        if (shell == null) {
            return 1;
        }
        int code = DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)shell, (ILaunchConfiguration)config, (String)"org.eclipse.ui.externaltools.launchGroup.builder");
        manager.removeLaunchConfigurationListener(this.configurationListener);
        return code;
    }

    private ILaunchConfigurationType promptForConfigurationType() {
        List<ILaunchConfigurationType> externalToolTypes = this.getConfigurationTypes("org.eclipse.ui.externaltools.builder");
        Shell shell = this.getShell();
        if (shell == null) {
            return null;
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new BuilderLabelProvider());
        dialog.setElements(externalToolTypes.toArray());
        dialog.setMultipleSelection(false);
        dialog.setTitle(ExternalToolsUIMessages.BuilderPropertyPage_Choose_configuration_type_8);
        dialog.setMessage(ExternalToolsUIMessages.BuilderPropertyPage_Choose_an_external_tool_type_to_create_9);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0) {
            return null;
        }
        return (ILaunchConfigurationType)result[0];
    }

    private List<ILaunchConfigurationType> getConfigurationTypes(String category) {
        ILaunchConfigurationType[] types = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        ArrayList<ILaunchConfigurationType> externalToolTypes = new ArrayList<ILaunchConfigurationType>();
        ILaunchConfigurationType[] iLaunchConfigurationTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationType configurationType = iLaunchConfigurationTypeArray[n2];
            if (category.equals(configurationType.getCategory())) {
                externalToolTypes.add(configurationType);
            }
            ++n2;
        }
        return externalToolTypes;
    }

    private void handleEditButtonPressed() {
        TableItem[] items = this.viewer.getTable().getSelection();
        if (items.length == 0) {
            return;
        }
        TableItem selection = items[0];
        if (selection != null) {
            ICommand command;
            Object data = selection.getData();
            if (data instanceof ILaunchConfiguration) {
                ILaunchConfiguration config = (ILaunchConfiguration)data;
                this.userHasMadeChanges = true;
                boolean wasAutobuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
                try {
                    try {
                        this.setAutobuild(false);
                        this.editConfiguration(config);
                    }
                    catch (CoreException e) {
                        this.handleException((Exception)((Object)e));
                        try {
                            this.setAutobuild(wasAutobuilding);
                        }
                        catch (CoreException e2) {
                            this.handleException((Exception)((Object)e2));
                        }
                    }
                }
                finally {
                    try {
                        this.setAutobuild(wasAutobuilding);
                    }
                    catch (CoreException e) {
                        this.handleException((Exception)((Object)e));
                    }
                }
            } else if (data instanceof ICommand && (command = (ICommand)data).isConfigurable() && this.editCommand(command)) {
                this.userHasMadeChanges = true;
            }
        }
    }

    private boolean editCommand(ICommand data) {
        EditCommandDialog dialog = new EditCommandDialog(this.getShell(), data);
        return dialog.open() == 0;
    }

    private void handleException(Exception e) {
        IStatus[] status = new IStatus[]{e instanceof CoreException ? ((CoreException)((Object)e)).getStatus() : new Status(4, "org.eclipse.ui.externaltools", 0, ExternalToolsUIMessages.BuilderPropertyPage_statusMessage, (Throwable)e)};
        Display.getDefault().asyncExec(() -> {
            Shell shell = this.getShell();
            if (shell != null) {
                ErrorDialog.openError((Shell)shell, (String)ExternalToolsUIMessages.BuilderPropertyPage_errorTitle, (String)ExternalToolsUIMessages.BuilderPropertyPage_errorMessage, (IStatus)status[0]);
            }
        });
    }

    private void handleTableSelectionChanged() {
        this.newButton.setEnabled(true);
        Table builderTable = this.viewer.getTable();
        TableItem[] items = builderTable.getSelection();
        this.fCanEdit = false;
        boolean enableRemove = false;
        boolean enableUp = false;
        boolean enableDown = false;
        if (items != null) {
            boolean validSelection;
            this.fCanEdit = validSelection = items.length > 0;
            enableRemove = validSelection;
            enableUp = validSelection;
            enableDown = validSelection;
            if (items.length > 1) {
                this.fCanEdit = false;
            }
            int[] indices = builderTable.getSelectionIndices();
            int max = builderTable.getItemCount();
            if (indices.length > 0) {
                enableUp = indices[0] != 0;
                enableDown = indices[indices.length - 1] < max - 1;
            }
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                Object data = item.getData();
                if (data instanceof ILaunchConfiguration) {
                    ILaunchConfiguration config = (ILaunchConfiguration)data;
                    String builderName = null;
                    try {
                        builderName = config.getAttribute("org.eclipse.ui.externaltools.ATTR_DISABLED_BUILDER", null);
                    }
                    catch (CoreException coreException) {}
                    if (builderName != null) {
                        IExtension ext = Platform.getExtensionRegistry().getExtension("org.eclipse.core.resources", "builders", builderName);
                        this.fCanEdit = false;
                        enableRemove = ext == null;
                    }
                } else if (data instanceof ErrorConfig) {
                    this.fCanEdit = false;
                } else {
                    ICommand command = (ICommand)data;
                    this.fCanEdit = command.isConfigurable();
                    IExtension ext = Platform.getExtensionRegistry().getExtension("org.eclipse.core.resources", "builders", command.getBuilderName());
                    enableRemove = ext == null;
                    break;
                }
                ++n2;
            }
        }
        this.editButton.setEnabled(this.fCanEdit);
        this.removeButton.setEnabled(enableRemove);
        this.upButton.setEnabled(enableUp);
        this.downButton.setEnabled(enableDown);
    }

    private boolean isEnabled(Object element) {
        if (element instanceof ICommand) {
            ICommand command = (ICommand)element;
            String val = (String)command.getArguments().get(COMMAND_ENABLED);
            if (val != null) {
                return Boolean.parseBoolean(val);
            }
        } else if (element instanceof ILaunchConfiguration) {
            try {
                return ExternalToolsUtil.isBuilderEnabled((ILaunchConfiguration)element);
            }
            catch (CoreException coreException) {
            }
        } else if (element instanceof ErrorConfig) {
            return false;
        }
        return true;
    }

    private void move(TableItem item, int index) {
        this.userHasMadeChanges = true;
        Object data = item.getData();
        item.dispose();
        this.viewer.insert(data, index);
        this.viewer.setChecked(data, this.isEnabled(data));
    }

    private void moveSelectionDown() {
        Table builderTable = this.viewer.getTable();
        int[] indices = builderTable.getSelectionIndices();
        if (indices.length < 1) {
            return;
        }
        int[] newSelection = new int[indices.length];
        int max = builderTable.getItemCount() - 1;
        int i = indices.length - 1;
        while (i >= 0) {
            int index = indices[i];
            if (index < max) {
                this.move(builderTable.getItem(index), index + 1);
                newSelection[i] = index + 1;
            }
            --i;
        }
        builderTable.setSelection(newSelection);
    }

    private void moveSelectionUp() {
        Table builderTable = this.viewer.getTable();
        int[] indices = builderTable.getSelectionIndices();
        int[] newSelection = new int[indices.length];
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index > 0) {
                this.move(builderTable.getItem(index), index - 1);
                newSelection[i] = index - 1;
            }
            ++i;
        }
        builderTable.setSelection(newSelection);
    }

    public boolean performOk() {
        if (!this.userHasMadeChanges) {
            return super.performOk();
        }
        this.userHasMadeChanges = false;
        Table builderTable = this.viewer.getTable();
        int numCommands = builderTable.getItemCount();
        Object[] itemData = new Object[numCommands];
        int i = 0;
        while (i < numCommands) {
            itemData[i] = builderTable.getItem(i).getData();
            ++i;
        }
        IRunnableWithProgress runnable = monitor -> {
            this.doPerformOk(monitor, itemData);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
        };
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.busyCursorWhile(runnable);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            return false;
        }
        return super.performOk();
    }

    private void doPerformOk(IProgressMonitor monitor, Object[] itemData) {
        if (monitor.isCanceled()) {
            return;
        }
        IProject project = this.getInputProject();
        int numCommands = itemData.length;
        monitor.beginTask(ExternalToolsUIMessages.BuilderPropertyPage_3, numCommands + 1);
        ArrayList<ICommand> possibleCommands = new ArrayList<ICommand>(numCommands);
        int i = 0;
        while (i < numCommands) {
            block20: {
                Object data;
                block24: {
                    block22: {
                        block23: {
                            data = itemData[i];
                            if (!(data instanceof ICommand)) break block22;
                            if (this.commandsToBeDeleted == null || !this.commandsToBeDeleted.contains(data)) break block23;
                            data = null;
                            break block20;
                        }
                        ICommand command = (ICommand)data;
                        Map args = command.getArguments();
                        String val = (String)args.get(COMMAND_ENABLED);
                        if (val != null) {
                            if (!Boolean.parseBoolean(val)) {
                                ILaunchConfiguration config = this.disableCommand(command);
                                if (config != null) {
                                    data = BuilderUtils.commandFromLaunchConfig(project, config);
                                }
                            } else {
                                args.remove(COMMAND_ENABLED);
                                command.setArguments(args);
                            }
                        }
                        break block24;
                    }
                    if (data instanceof ILaunchConfiguration) {
                        ILaunchConfiguration config;
                        block21: {
                            ILaunchConfigurationWorkingCopy workingCopy;
                            block19: {
                                config = (ILaunchConfiguration)data;
                                try {
                                    String disabledBuilderName = config.getAttribute("org.eclipse.ui.externaltools.ATTR_DISABLED_BUILDER", null);
                                    if (disabledBuilderName == null || !ExternalToolsUtil.isBuilderEnabled(config)) break block19;
                                    possibleCommands.add(this.translateBackToCommand(config, project));
                                    break block20;
                                }
                                catch (CoreException coreException) {}
                            }
                            if (config instanceof ILaunchConfigurationWorkingCopy && (workingCopy = (ILaunchConfigurationWorkingCopy)config).isDirty()) {
                                try {
                                    workingCopy.doSave();
                                }
                                catch (CoreException coreException) {
                                    Shell shell = this.getShell();
                                    if (shell == null) break block21;
                                    MessageDialog.openError((Shell)shell, (String)ExternalToolsUIMessages.BuilderPropertyPage_39, (String)NLS.bind((String)ExternalToolsUIMessages.BuilderPropertyPage_40, (Object[])new String[]{workingCopy.getName()}));
                                }
                            }
                        }
                        data = BuilderUtils.commandFromLaunchConfig(project, config);
                    } else if (data instanceof ErrorConfig) {
                        data = ((ErrorConfig)data).getCommand();
                    }
                }
                if (data instanceof ICommand) {
                    possibleCommands.add((ICommand)data);
                }
                monitor.worked(1);
            }
            ++i;
        }
        ICommand[] commands = new ICommand[possibleCommands.size()];
        possibleCommands.toArray(commands);
        if (this.checkCommandsForChange(commands)) {
            try {
                IProjectDescription desc = project.getDescription();
                desc.setBuildSpec(commands);
                project.setDescription(desc, 1, monitor);
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
                this.performCancel();
            }
        }
        if (this.configsToBeDeleted != null) {
            this.deleteConfigurations();
        }
        monitor.done();
    }

    private void checkBuilderFolder() {
        try {
            IFolder builderFolder = BuilderUtils.getBuilderFolder(this.getInputProject(), false);
            if (builderFolder != null && builderFolder.exists() && builderFolder.members().length == 0) {
                builderFolder.delete(true, false, null);
            }
        }
        catch (CoreException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private ICommand translateBackToCommand(ILaunchConfiguration config, IProject project) {
        try {
            ICommand newCommand = project.getDescription().newCommand();
            String builderName = config.getAttribute("org.eclipse.ui.externaltools.ATTR_DISABLED_BUILDER", null);
            Map args = config.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", new HashMap(0));
            newCommand.setBuilderName(builderName);
            newCommand.setArguments(args);
            if (this.configsToBeDeleted == null) {
                this.configsToBeDeleted = new ArrayList<ILaunchConfiguration>();
            }
            this.configsToBeDeleted.add(config);
            return newCommand;
        }
        catch (CoreException coreException) {
            Shell shell = this.getShell();
            if (shell != null) {
                MessageDialog.openError((Shell)shell, (String)ExternalToolsUIMessages.BuilderPropertyPage_13, (String)ExternalToolsUIMessages.BuilderPropertyPage_error);
            }
            return null;
        }
    }

    private ILaunchConfiguration disableCommand(ICommand command) {
        List<ILaunchConfigurationType> externalToolTypes;
        Map arguments = command.getArguments();
        if (arguments != null) {
            arguments.remove(COMMAND_ENABLED);
        }
        if ((externalToolTypes = this.getConfigurationTypes("org.eclipse.ui.externaltools.builder")).isEmpty()) {
            return null;
        }
        ILaunchConfigurationType type = externalToolTypes.get(0);
        if (type == null) {
            return null;
        }
        boolean wasAutobuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
        try {
            ILaunchConfigurationWorkingCopy workingCopy = null;
            String builderName = command.getBuilderName();
            String name = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(builderName);
            workingCopy = type.newInstance((IContainer)BuilderUtils.getBuilderFolder(this.getInputProject(), true), name);
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_DISABLED_BUILDER", builderName);
            if (arguments != null) {
                workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", arguments);
            }
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_BUILDER_ENABLED", false);
            ILaunchConfiguration config = null;
            this.setAutobuild(false);
            ILaunchConfiguration iLaunchConfiguration = config = workingCopy.doSave();
            return iLaunchConfiguration;
        }
        catch (CoreException e) {
            this.handleException((Exception)((Object)e));
        }
        finally {
            try {
                this.setAutobuild(wasAutobuilding);
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        return null;
    }

    private void deleteConfigurations() {
        boolean wasAutobuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
        try {
            try {
                this.setAutobuild(false);
                for (ILaunchConfiguration config : this.configsToBeDeleted) {
                    config.delete();
                }
                this.checkBuilderFolder();
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
                try {
                    this.setAutobuild(wasAutobuilding);
                }
                catch (CoreException e2) {
                    this.handleException((Exception)((Object)e2));
                }
            }
        }
        finally {
            try {
                this.setAutobuild(wasAutobuilding);
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkCommandsForChange(ICommand[] newCommands) {
        try {
            ICommand[] oldCommands = this.getInputProject().getDescription().getBuildSpec();
            if (oldCommands.length != newCommands.length) {
                return true;
            }
            IgnoreWhiteSpaceComparator comparator = new IgnoreWhiteSpaceComparator();
            int i = 0;
            while (true) {
                block14: {
                    if (i >= oldCommands.length) {
                        return false;
                    }
                    ICommand oldCommand = oldCommands[i];
                    ICommand newCommand = newCommands[i];
                    String oldName = oldCommand.getBuilderName();
                    String newName = newCommand.getBuilderName();
                    if (oldName == null && newName != null) {
                        return true;
                    }
                    if (oldName != null && !oldName.equals(newName)) {
                        return true;
                    }
                    Map oldArgs = oldCommand.getArguments();
                    Map newArgs = newCommand.getArguments();
                    if (oldArgs == null) {
                        if (newArgs != null) {
                            return true;
                        }
                    } else {
                        String key;
                        Map.Entry entry;
                        if (oldArgs.size() != newArgs.size()) {
                            return true;
                        }
                        Iterator iterator = oldArgs.entrySet().iterator();
                        do {
                            if (!iterator.hasNext()) {
                                if (oldCommand.isBuilding(9) != newCommand.isBuilding(9)) return true;
                                if (oldCommand.isBuilding(15) != newCommand.isBuilding(15)) return true;
                                if (oldCommand.isBuilding(10) != newCommand.isBuilding(10)) return true;
                                if (oldCommand.isBuilding(6) != newCommand.isBuilding(6)) {
                                    return true;
                                }
                                break block14;
                            }
                            entry = iterator.next();
                            key = (String)entry.getKey();
                        } while (comparator.compare((String)entry.getValue(), (String)newArgs.get(key)) == 0);
                        return true;
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    public boolean performCancel() {
        for (ILaunchConfiguration config : this.newConfigList) {
            try {
                config.delete();
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        this.checkBuilderFolder();
        Table builderTable = this.viewer.getTable();
        int numCommands = builderTable.getItemCount();
        int i = 0;
        while (i < numCommands) {
            Object data = builderTable.getItem(i).getData();
            if (data instanceof ICommand) {
                ICommand command = (ICommand)data;
                Map args = command.getArguments();
                args.remove(COMMAND_ENABLED);
                command.setArguments(args);
            }
            ++i;
        }
        return super.performCancel();
    }

    public Shell getShell() {
        if (this.getControl().isDisposed()) {
            return null;
        }
        return super.getShell();
    }

    public static class ErrorConfig {
        private final ICommand command;

        public ErrorConfig(ICommand command) {
            this.command = command;
        }

        public ICommand getCommand() {
            return this.command;
        }
    }
}

