/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.TargetWeaver;
import org.eclipse.pde.internal.core.util.ManifestUtils;
import org.eclipse.pde.internal.core.util.UtilMessages;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public class MinimalState {
    protected State fState;
    protected long fId;
    private boolean fEEListChanged = false;
    private String[] fExecutionEnvironments;
    private boolean fNoProfile;
    protected static StateObjectFactory stateObjectFactory = BundleHelper.getPlatformAdmin().getFactory();
    protected String fSystemBundle = "org.eclipse.osgi";
    private static final String PDE_MANIFEST_BUILDER = "org.eclipse.pde.ManifestBuilder";

    static {
        String nodeQualifier = "org.eclipse.jdt.launching";
        IEclipsePreferences launchingNode = InstanceScope.INSTANCE.getNode(nodeQualifier);
        launchingNode.addPreferenceChangeListener(e -> {
            if (e.getKey().equals("org.eclipse.jdt.launching.PREF_DEFAULT_ENVIRONMENTS_XML")) {
                Object newValue;
                Object oldValue = e.getOldValue() == null ? "" : e.getOldValue();
                Object object = newValue = e.getNewValue() == null ? "" : e.getNewValue();
                if (!oldValue.equals(newValue)) {
                    MinimalState.triggerSystemPackagesReload();
                }
            }
        });
        JavaRuntime.addVMInstallChangedListener((IVMInstallChangedListener)new IVMInstallChangedListener(){

            public void vmRemoved(IVMInstall vm) {
                MinimalState.triggerSystemPackagesReload();
            }

            public void vmChanged(PropertyChangeEvent event) {
                MinimalState.triggerSystemPackagesReload();
            }

            public void vmAdded(IVMInstall vm) {
                MinimalState.triggerSystemPackagesReload();
            }

            public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
                MinimalState.triggerSystemPackagesReload();
            }
        });
    }

    protected MinimalState(MinimalState state) {
        this.fState = stateObjectFactory.createState(state.fState);
        this.fState.setPlatformProperties(state.fState.getPlatformProperties());
        this.fState.setResolver(BundleHelper.getPlatformAdmin().createResolver());
        this.fId = state.fId;
        this.fEEListChanged = state.fEEListChanged;
        this.fExecutionEnvironments = state.fExecutionEnvironments;
        this.fNoProfile = state.fNoProfile;
        this.fSystemBundle = state.fSystemBundle;
    }

    protected MinimalState() {
    }

    public void addBundle(IPluginModelBase model, boolean update) {
        if (model == null) {
            return;
        }
        BundleDescription desc = model.getBundleDescription();
        long bundleId = desc == null || !update ? -1L : desc.getBundleId();
        try {
            String installLocation = model.getInstallLocation();
            if (installLocation == null) {
                throw new IllegalArgumentException("The plugin '" + String.valueOf(model) + "' was not created from a resource in the file system");
            }
            File bundleLocation = new File(installLocation);
            BundleDescription newDesc = this.addBundle(bundleLocation, bundleId, this.loadWorkspaceBundleManifest(bundleLocation, model.getUnderlyingResource()));
            model.setBundleDescription(newDesc);
            if (newDesc == null && update) {
                this.fState.removeBundle(desc);
            }
        }
        catch (CoreException e) {
            PDECore.log(e);
            model.setBundleDescription(null);
        }
    }

    private Map<String, String> loadWorkspaceBundleManifest(File bundleLocation, IResource resource) throws CoreException {
        Map<String, String> manifest = ManifestUtils.loadManifest(bundleLocation);
        if (resource == null || this.hasDeclaredRequiredEE(manifest)) {
            return manifest;
        }
        IJavaProject javaProject = JavaCore.create((IProject)resource.getProject());
        if (!javaProject.exists()) {
            return manifest;
        }
        IVMInstall projectVmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
        IExecutionEnvironment executionEnvironment = Arrays.stream(JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments()).filter(env -> env.isStrictlyCompatible(projectVmInstall)).findFirst().orElse(null);
        if (executionEnvironment != null) {
            manifest.put("Bundle-RequiredExecutionEnvironment", executionEnvironment.getId());
        }
        return manifest;
    }

    private boolean hasDeclaredRequiredEE(Map<String, String> manifest) {
        if (manifest.containsKey("Bundle-RequiredExecutionEnvironment")) {
            return true;
        }
        try {
            String capability = manifest.get("Require-Capability");
            ManifestElement[] header = ManifestElement.parseHeader((String)"Require-Capability", (String)capability);
            if (header != null) {
                if (Arrays.stream(header).map(ManifestElement::getValue).anyMatch("osgi.ee"::equals)) {
                    return true;
                }
            }
            return false;
        }
        catch (BundleException e) {
            return false;
        }
    }

    public BundleDescription addBundle(Map<String, String> manifest, File bundleLocation, long bundleId) throws CoreException {
        try {
            Dictionary dictionaryManifest = FrameworkUtil.asDictionary(manifest);
            BundleDescription descriptor = stateObjectFactory.createBundleDescription(this.fState, dictionaryManifest, bundleLocation.getAbsolutePath(), bundleId == -1L ? this.getNextId() : bundleId);
            if (bundleId == -1L || !this.fState.updateBundle(descriptor)) {
                this.fState.addBundle(descriptor);
            }
            return descriptor;
        }
        catch (BundleException e) {
            MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, NLS.bind((String)UtilMessages.ErrorReadingManifest, (Object)bundleLocation.toString()), null);
            status.add(Status.error((String)e.getMessage()));
            throw new CoreException((IStatus)status);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public BundleDescription addBundle(File bundleLocation, long bundleId) throws CoreException {
        Map<String, String> manifest = ManifestUtils.loadManifest(bundleLocation);
        return this.addBundle(bundleLocation, bundleId, manifest);
    }

    private BundleDescription addBundle(File bundleLocation, long bundleId, Map<String, String> manifest) throws CoreException {
        TargetWeaver.weaveManifest(manifest, bundleLocation);
        BundleDescription desc = this.addBundle(manifest, bundleLocation, bundleId);
        if (desc != null && manifest != null && "true".equals(manifest.get("Eclipse-SystemBundle"))) {
            this.fEEListChanged = true;
            this.fSystemBundle = desc.getSymbolicName();
        }
        if (desc != null) {
            this.addAuxiliaryData(desc, manifest, true);
        }
        return desc;
    }

    protected void addAuxiliaryData(BundleDescription desc, Map<String, String> manifest, boolean hasBundleStructure) {
    }

    public StateDelta resolveState(boolean incremental) {
        return this.internalResolveState(incremental);
    }

    public StateDelta resolveState(String[] symbolicNames) {
        if (this.initializePlatformProperties()) {
            return this.fState.resolve(false);
        }
        ArrayList bundles = new ArrayList();
        String[] stringArray = symbolicNames;
        int n = symbolicNames.length;
        int n2 = 0;
        while (n2 < n) {
            String symbolicName = stringArray[n2];
            BundleDescription[] descriptions = this.fState.getBundles(symbolicName);
            Collections.addAll(bundles, descriptions);
            ++n2;
        }
        return this.fState.resolve(bundles.toArray(new BundleDescription[bundles.size()]));
    }

    private synchronized StateDelta internalResolveState(boolean incremental) {
        boolean fullBuildRequired = this.initializePlatformProperties();
        return this.fState.resolve(incremental && !fullBuildRequired);
    }

    protected boolean initializePlatformProperties() {
        if (this.fExecutionEnvironments == null && !this.fNoProfile) {
            this.setExecutionEnvironments();
        }
        if (this.fEEListChanged) {
            this.fEEListChanged = false;
            Dictionary[] properties = TargetPlatformHelper.getPlatformProperties(this.fExecutionEnvironments, this);
            return this.fState.setPlatformProperties(properties);
        }
        return false;
    }

    public static void triggerSystemPackagesReload() {
        String jobFamily = "pde.internal.ReresolveStateAfterVMorEEchanges";
        Job.getJobManager().cancel((Object)"pde.internal.ReresolveStateAfterVMorEEchanges");
        WorkspaceJob job = new WorkspaceJob("Re-resolve Target state after VM-Install or EE change"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                return MinimalState.reloadSystemPackagesIntoState();
            }

            public boolean belongsTo(Object family) {
                return "pde.internal.ReresolveStateAfterVMorEEchanges".equals(family);
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule(200L);
    }

    public static IStatus reloadSystemPackagesIntoState() {
        PDEState state = PDECore.getDefault().getModelManager().getState();
        if (state.fNoProfile) {
            return Status.OK_STATUS;
        }
        state.fEEListChanged = true;
        StateDelta delta = state.internalResolveState(true);
        if (delta.getChanges().length == 0) {
            return Status.OK_STATUS;
        }
        MultiStatus status = new MultiStatus(MinimalState.class, 0, "Reload of JRE system-packages encountered issues");
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                project.build(6, PDE_MANIFEST_BUILDER, null, null);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            ++n2;
        }
        return status;
    }

    public void removeBundleDescription(BundleDescription description) {
        if (description != null) {
            this.fState.removeBundle(description);
        }
    }

    public void updateBundleDescription(BundleDescription description) {
        if (description != null) {
            this.fState.updateBundle(description);
        }
    }

    public State getState() {
        return this.fState;
    }

    private void setExecutionEnvironments() {
        String jreProfile;
        String[] knownExecutionEnviroments = TargetPlatformHelper.getKnownExecutionEnvironments();
        if (knownExecutionEnviroments.length == 0 && (jreProfile = System.getProperty("pde.jreProfile")) != null && !jreProfile.isEmpty() && "none".equals(jreProfile)) {
            this.fNoProfile = true;
        }
        if (!this.fNoProfile) {
            this.fExecutionEnvironments = knownExecutionEnviroments;
        }
        this.fEEListChanged = true;
    }

    public void addBundleDescription(BundleDescription toAdd) {
        if (toAdd != null) {
            this.fState.addBundle(toAdd);
        }
    }

    public long getNextId() {
        return ++this.fId;
    }

    public String getSystemBundle() {
        return this.fSystemBundle;
    }
}

