/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.editors.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class StringFieldEditor
extends FieldEditor {
    private String fDefaultValue;
    public static final int VALIDATE_ON_KEY_STROKE = 0;
    public static final int VALIDATE_ON_FOCUS_LOST = 1;
    public static int UNLIMITED = -1;
    private boolean isValid;
    protected String fValue;
    Text textField;
    int textFieldStyle;
    public int widthInChars = UNLIMITED;
    private int textLimit = UNLIMITED;
    private String errorMessage;
    private boolean emptyStringAllowed = true;
    private int validateStrategy = 0;

    public String getDefaultValue() {
        return this.fDefaultValue;
    }

    public String getfDefaultValue() {
        return this.fDefaultValue;
    }

    @Override
    protected void setDefaultsImpl(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(this.getStoreKey(), this.fDefaultValue);
    }

    @Override
    protected void initializeFromImpl(ILaunchConfiguration configuration) {
        try {
            this.setStringValue(configuration.getAttribute(this.getStoreKey(), this.fDefaultValue));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void performApplyImpl(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isValid()) {
            configuration.setAttribute(this.getStoreKey(), this.fValue);
        }
    }

    protected StringFieldEditor(String defaultValue, boolean isValid) {
        this.fDefaultValue = defaultValue;
        this.fValue = defaultValue;
        this.isValid = isValid;
        this.textFieldStyle = 4;
    }

    public StringFieldEditor(AbstractConfigurationPage configurationPage, String storeKey, String labelText, int width, int strategy, Composite parent, String defaultValue, int textFieldStyle) {
        this.fDefaultValue = defaultValue;
        this.init(configurationPage, storeKey, labelText);
        this.widthInChars = width;
        this.setValidateStrategy(strategy);
        this.isValid = false;
        this.textFieldStyle = textFieldStyle;
        this.errorMessage = JFaceResources.getString((String)"StringFieldEditor.errorMessage");
        this.createControl(parent);
    }

    public StringFieldEditor(AbstractConfigurationPage configurationPage, String storeKey, String labelText, Composite parent, String defaultValue) {
        this(configurationPage, storeKey, labelText, UNLIMITED, 0, parent, defaultValue, 4);
    }

    public StringFieldEditor(AbstractConfigurationPage configurationPage, String storeKey, String labelText, Composite parent, String defaultValue, int textFieldStyle) {
        this(configurationPage, storeKey, labelText, UNLIMITED, 0, parent, defaultValue, textFieldStyle);
    }

    public StringFieldEditor(AbstractConfigurationPage configurationPage, String storeKey, String labelText, int width, Composite parent) {
        this(configurationPage, storeKey, labelText, width, 0, parent, "", 4);
    }

    public StringFieldEditor(AbstractConfigurationPage configurationPage, String storeKey, String labelText, Composite parent) {
        this(configurationPage, storeKey, labelText, UNLIMITED, parent);
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.textField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected boolean checkState() {
        String txt;
        boolean result = false;
        if (this.emptyStringAllowed) {
            result = true;
        }
        if (this.textField == null) {
            result = false;
        }
        result = (txt = this.textField.getText()).trim().length() > 0 || this.emptyStringAllowed;
        boolean bl = result = result && this.doCheckState();
        if (result) {
            this.clearErrorMessage();
        } else {
            this.showErrorMessage(this.errorMessage);
        }
        return result;
    }

    protected boolean doCheckState() {
        return true;
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.textField = this.getTextControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        if (this.widthInChars != UNLIMITED) {
            GC gc = new GC((Drawable)this.textField);
            try {
                Point extent = gc.textExtent("X");
                gd.widthHint = this.widthInChars * extent.x;
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        this.textField.setLayoutData((Object)gd);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    public String getStringValue() {
        if (this.textField != null) {
            return this.textField.getText();
        }
        return this.fValue;
    }

    protected Text getTextControl() {
        return this.textField;
    }

    public Text getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = this.getConfigurationPage().getWidgetToolkit().newText(parent, this.fDefaultValue, this.textFieldStyle | 0x800);
            this.textField.setFont(parent.getFont());
            if ((this.textFieldStyle & 2) != 0) {
                GridData gridData = new GridData(4, 0x1000000, true, false);
                gridData.widthHint = 200;
                gridData.heightHint = 5 * this.textField.getLineHeight();
                this.textField.setLayoutData((Object)gridData);
            }
            switch (this.validateStrategy) {
                case 0: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyReleased(KeyEvent e) {
                            StringFieldEditor.this.valueChanged();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusLost(FocusEvent e) {
                            StringFieldEditor.this.valueChanged();
                        }
                    });
                    break;
                }
                case 1: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            StringFieldEditor.this.clearErrorMessage();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            StringFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent e) {
                            StringFieldEditor.this.valueChanged();
                            StringFieldEditor.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unknown validate strategy");
                }
            }
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    StringFieldEditor.this.textField = null;
                }
            });
            if (this.textLimit > 0) {
                this.textField.setTextLimit(this.textLimit);
            }
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        return this.textField;
    }

    public boolean isEmptyStringAllowed() {
        return this.emptyStringAllowed;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    protected void refreshValidState() {
        this.isValid = this.checkState();
    }

    public void setEmptyStringAllowed(boolean b) {
        this.emptyStringAllowed = b;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    @Override
    public void setFocus() {
        if (this.textField != null) {
            this.textField.setFocus();
        }
    }

    public void setStringValue(String value) {
        if (this.textField != null) {
            if (value == null) {
                value = "";
            }
            this.fValue = this.textField.getText();
            if (!this.fValue.equals(value)) {
                this.textField.setText(value);
                this.valueChanged();
            }
        }
    }

    public void setTextLimit(int limit) {
        this.textLimit = limit;
        if (this.textField != null) {
            this.textField.setTextLimit(limit);
        }
    }

    public void setValidateStrategy(int value) {
        Assert.isTrue((value == 1 || value == 0 ? 1 : 0) != 0);
        this.validateStrategy = value;
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.errorMessage);
    }

    protected void valueChanged() {
        String newValue;
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid;
        this.refreshValidState();
        if (this.isValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid);
        }
        if (!(newValue = this.textField.getText()).equals(this.fValue)) {
            this.fireValueChanged(this.fStoreKey, this.fValue, newValue);
            this.fValue = newValue;
        }
        this.updateLaunchConfigurationDialog();
    }

    @Override
    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTextControl(parent).setEnabled(enabled);
    }

    public void setEnabled(boolean enabled) {
        if (this.textField != null) {
            super.setEnabled(enabled, this.textField.getParent());
            this.textField.setEnabled(enabled);
        }
    }

    @Override
    protected void clearErrorMessage() {
        if (this.textField != null) {
            this.textField.setBackground(null);
        }
        super.clearErrorMessage();
    }

    @Override
    protected void showErrorMessage(String msg) {
        if (this.textField != null) {
            this.textField.setBackground(Display.getCurrent().getSystemColor(3));
        }
        super.showErrorMessage(msg);
    }
}

