/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.patch.ApplyPatchOperation;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.BodyDeclarationRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.TypedSource;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaElementTransfer;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgDestinationFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgCopyStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jdt.internal.ui.refactoring.reorg.TypedSourceTransfer;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.part.ResourceTransfer;

public class PasteAction
extends SelectionDispatchAction {
    public static final String ID = "org.eclipse.jdt.internal.ui.refactoring.reorg.PasteAction.id";
    private final Clipboard fClipboard;

    public PasteAction(IWorkbenchSite site) {
        this(site, (Clipboard)null);
    }

    public PasteAction(IWorkbenchSite site, Clipboard clipboard) {
        super(site);
        this.fClipboard = clipboard;
        this.setId(ID);
        this.setText(ReorgMessages.PasteAction_4);
        this.setDescription(ReorgMessages.PasteAction_5);
        ISharedImages workbenchImages = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.paste_action");
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
    }

    private Paster[] createEnabledPasters(TransferData[] availableDataTypes, Clipboard clipboard) {
        Shell shell = this.getShell();
        ArrayList<Paster> result = new ArrayList<Paster>(2);
        Paster paster = new ProjectPaster(shell, clipboard);
        if (paster.canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new JavaElementAndResourcePaster(shell, clipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new TypedSourcePaster(shell, clipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new FilePaster(shell, clipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new WorkingSetPaster(shell, clipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new TextPaster(shell, clipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        return result.toArray(new Paster[result.size()]);
    }

    private static Object getContents(final Clipboard clipboard, final Transfer transfer, Shell shell) {
        final Object[] result = new Object[1];
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = clipboard.getContents(transfer);
            }
        });
        return result[0];
    }

    private static boolean isAvailable(Transfer transfer, TransferData[] availableDataTypes) {
        int i = 0;
        while (i < availableDataTypes.length) {
            if (transfer.isSupportedType(availableDataTypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run(IStructuredSelection selection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class FilePaster
    extends Paster {
        protected FilePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        @Override
        public void paste(IJavaElement[] javaElements, IResource[] resources, IWorkingSet[] selectedWorkingSets, TransferData[] availableTypes) throws JavaModelException {
            String[] fileData = this.getClipboardFiles(availableTypes);
            if (fileData == null) {
                return;
            }
            IContainer container = this.getAsContainer(this.getTarget(javaElements, resources));
            if (container == null) {
                return;
            }
            new CopyFilesAndFoldersOperation(this.getShell()).copyFiles(fileData, container);
        }

        private Object getTarget(IJavaElement[] javaElements, IResource[] resources) {
            if (javaElements.length + resources.length == 1) {
                if (javaElements.length == 1) {
                    return javaElements[0];
                }
                return resources[0];
            }
            return this.getCommonParent(javaElements, resources);
        }

        @Override
        public boolean canPasteOn(IJavaElement[] javaElements, IResource[] resources, IWorkingSet[] selectedWorkingSets, List<?> selectedElements) throws JavaModelException {
            Object target = this.getTarget(javaElements, resources);
            return target != null && this.canPasteFilesOn(this.getAsContainer(target)) && selectedWorkingSets.length == 0;
        }

        @Override
        public boolean canEnable(TransferData[] availableDataTypes) {
            return PasteAction.isAvailable((Transfer)FileTransfer.getInstance(), availableDataTypes);
        }

        private boolean canPasteFilesOn(Object target) {
            boolean isPackageFragment = target instanceof IPackageFragment;
            boolean isJavaProject = target instanceof IJavaProject;
            boolean isPackageFragmentRoot = target instanceof IPackageFragmentRoot;
            boolean isContainer = target instanceof IContainer;
            if (!(isPackageFragment || isJavaProject || isPackageFragmentRoot || isContainer)) {
                return false;
            }
            if (isContainer) {
                if (target instanceof IProject) {
                    return ((IProject)target).isOpen();
                }
                return true;
            }
            if (isJavaProject && !((IJavaProject)target).getProject().isOpen()) {
                return false;
            }
            IJavaElement element = (IJavaElement)target;
            return !element.isReadOnly();
        }

        private IContainer getAsContainer(Object target) throws JavaModelException {
            if (target == null) {
                return null;
            }
            if (target instanceof IContainer) {
                return (IContainer)target;
            }
            if (target instanceof IFile) {
                return ((IFile)target).getParent();
            }
            return this.getAsContainer(((IJavaElement)target).getCorrespondingResource());
        }

        private String[] getClipboardFiles(TransferData[] availableDataTypes) {
            FileTransfer transfer = FileTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (String[])PasteAction.getContents(this.getClipboard(), (Transfer)transfer, this.getShell());
            }
            return null;
        }

        private Object getCommonParent(IJavaElement[] javaElements, IResource[] resources) {
            return new ParentChecker(resources, javaElements).getCommonParent();
        }
    }

    private static class JavaElementAndResourcePaster
    extends Paster {
        private TransferData[] fAvailableTypes;

        protected JavaElementAndResourcePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        @Override
        public void paste(IJavaElement[] javaElements, IResource[] resources, IWorkingSet[] selectedWorkingSets, TransferData[] availableTypes) throws JavaModelException, InterruptedException, InvocationTargetException {
            IJavaElement[] clipboardJavaElements;
            IResource[] clipboardResources = this.getClipboardResources(availableTypes);
            if (clipboardResources == null) {
                clipboardResources = new IResource[]{};
            }
            if ((clipboardJavaElements = this.getClipboardJavaElements(availableTypes)) == null) {
                clipboardJavaElements = new IJavaElement[]{};
            }
            Object destination = this.getTarget(javaElements, resources);
            Assert.isNotNull((Object)destination);
            Assert.isLegal((clipboardResources.length + clipboardJavaElements.length > 0 ? 1 : 0) != 0);
            ReorgCopyStarter.create(clipboardJavaElements, clipboardResources, ReorgDestinationFactory.createDestination(destination)).run(this.getShell());
        }

        private Object getTarget(IJavaElement[] javaElements, IResource[] resources) {
            if (javaElements.length + resources.length == 1) {
                if (javaElements.length == 1) {
                    return javaElements[0];
                }
                return resources[0];
            }
            return this.getCommonParent(javaElements, resources);
        }

        private Object getCommonParent(IJavaElement[] javaElements, IResource[] resources) {
            return new ParentChecker(resources, javaElements).getCommonParent();
        }

        @Override
        public boolean canPasteOn(IJavaElement[] javaElements, IResource[] resources, IWorkingSet[] selectedWorkingSets, List<?> selectedElements) throws JavaModelException {
            Object destination;
            IJavaElement[] clipboardJavaElements;
            if (selectedWorkingSets.length != 0) {
                return false;
            }
            IResource[] clipboardResources = this.getClipboardResources(this.fAvailableTypes);
            if (clipboardResources == null) {
                clipboardResources = new IResource[]{};
            }
            if ((clipboardJavaElements = this.getClipboardJavaElements(this.fAvailableTypes)) == null) {
                clipboardJavaElements = new IJavaElement[]{};
            }
            return ReorgCopyStarter.create(clipboardJavaElements, clipboardResources, ReorgDestinationFactory.createDestination(destination = this.getTarget(javaElements, resources))) != null;
        }

        @Override
        public boolean canEnable(TransferData[] availableTypes) {
            this.fAvailableTypes = availableTypes;
            return PasteAction.isAvailable((Transfer)JavaElementTransfer.getInstance(), availableTypes) || PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), availableTypes);
        }
    }

    private static abstract class Paster {
        private final Shell fShell;
        private final Clipboard fClipboard2;

        protected Paster(Shell shell, Clipboard clipboard) {
            this.fShell = shell;
            this.fClipboard2 = clipboard;
        }

        protected final Shell getShell() {
            return this.fShell;
        }

        protected final Clipboard getClipboard() {
            return this.fClipboard2;
        }

        protected final IResource[] getClipboardResources(TransferData[] availableDataTypes) {
            ResourceTransfer transfer = ResourceTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (IResource[])PasteAction.getContents(this.fClipboard2, (Transfer)transfer, this.getShell());
            }
            return null;
        }

        protected final IJavaElement[] getClipboardJavaElements(TransferData[] availableDataTypes) {
            JavaElementTransfer transfer = JavaElementTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (IJavaElement[])PasteAction.getContents(this.fClipboard2, (Transfer)transfer, this.getShell());
            }
            return null;
        }

        protected final TypedSource[] getClipboardTypedSources(TransferData[] availableDataTypes) {
            TypedSourceTransfer transfer = TypedSourceTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (TypedSource[])PasteAction.getContents(this.fClipboard2, (Transfer)transfer, this.getShell());
            }
            return null;
        }

        protected final String getClipboardText(TransferData[] availableDataTypes) {
            TextTransfer transfer = TextTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (String)PasteAction.getContents(this.fClipboard2, (Transfer)transfer, this.getShell());
            }
            return null;
        }

        public abstract boolean canEnable(TransferData[] var1);

        public abstract boolean canPasteOn(IJavaElement[] var1, IResource[] var2, IWorkingSet[] var3, List<?> var4) throws JavaModelException;

        public abstract void paste(IJavaElement[] var1, IResource[] var2, IWorkingSet[] var3, TransferData[] var4) throws JavaModelException, InterruptedException, InvocationTargetException;
    }

    private static class ProjectPaster
    extends Paster {
        protected ProjectPaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        @Override
        public boolean canEnable(TransferData[] availableDataTypes) {
            boolean resourceTransfer = PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), availableDataTypes);
            boolean javaElementTransfer = PasteAction.isAvailable((Transfer)JavaElementTransfer.getInstance(), availableDataTypes);
            if (!javaElementTransfer) {
                return this.canPasteSimpleProjects(availableDataTypes);
            }
            if (!resourceTransfer) {
                return this.canPasteJavaProjects(availableDataTypes);
            }
            return this.canPasteJavaProjects(availableDataTypes) && this.canPasteSimpleProjects(availableDataTypes);
        }

        @Override
        public void paste(IJavaElement[] javaElements, IResource[] resources, IWorkingSet[] selectedWorkingSets, TransferData[] availableTypes) {
            this.pasteProjects(availableTypes);
        }

        private void pasteProjects(TransferData[] availableTypes) {
            this.pasteProjects(this.getProjectsToPaste(availableTypes));
        }

        private void pasteProjects(IProject[] projects) {
            Shell shell = this.getShell();
            int i = 0;
            while (i < projects.length) {
                new CopyProjectOperation(shell).copyProject(projects[i]);
                ++i;
            }
        }

        private IProject[] getProjectsToPaste(TransferData[] availableTypes) {
            IResource[] resources = this.getClipboardResources(availableTypes);
            IJavaElement[] javaElements = this.getClipboardJavaElements(availableTypes);
            HashSet<IResource> result = new HashSet<IResource>();
            if (resources != null) {
                result.addAll(Arrays.asList(resources));
            }
            if (javaElements != null) {
                result.addAll(Arrays.asList(ReorgUtils.getNotNulls(ReorgUtils.getResources(javaElements))));
            }
            Assert.isTrue((result.size() > 0 ? 1 : 0) != 0);
            return result.toArray(new IProject[result.size()]);
        }

        @Override
        public boolean canPasteOn(IJavaElement[] javaElements, IResource[] resources, IWorkingSet[] selectedWorkingSets, List<?> selectedElements) {
            return selectedWorkingSets.length == 0;
        }

        private boolean canPasteJavaProjects(TransferData[] availableDataTypes) {
            IJavaElement[] javaElements = this.getClipboardJavaElements(availableDataTypes);
            return javaElements != null && javaElements.length != 0 && !ReorgUtils.hasElementsNotOfType(javaElements, 2);
        }

        private boolean canPasteSimpleProjects(TransferData[] availableDataTypes) {
            IResource[] resources = this.getClipboardResources(availableDataTypes);
            if (resources == null || resources.length == 0) {
                return false;
            }
            int i = 0;
            while (i < resources.length) {
                if (resources[i].getType() != 4 || !((IProject)resources[i]).isOpen()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private static class TextPaster
    extends Paster {
        private IStorage fPatchStorage;
        private IPackageFragmentRoot fDestination;
        private IPackageFragment fDestinationPack;
        private IType fDestinationType;
        private IMethod fDestinationMethod;
        private int fPackageDeclCount;
        private ParsedCu[] fParsedCus;
        private TransferData[] fAvailableTypes;
        private IPath fVMPath;
        private String fCompilerCompliance;

        protected TextPaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        @Override
        public boolean canEnable(TransferData[] availableTypes) {
            this.fAvailableTypes = availableTypes;
            return PasteAction.isAvailable((Transfer)TextTransfer.getInstance(), availableTypes) && !PasteAction.isAvailable((Transfer)FileTransfer.getInstance(), availableTypes);
        }

        @Override
        public boolean canPasteOn(IJavaElement[] javaElements, IResource[] resources, IWorkingSet[] selectedWorkingSets, List<?> selectedElements) throws JavaModelException {
            final String text = this.getClipboardText(this.fAvailableTypes);
            IEncodedStorage storage = new IEncodedStorage(){

                public <T> T getAdapter(Class<T> adapter) {
                    return null;
                }

                public boolean isReadOnly() {
                    return false;
                }

                public String getName() {
                    return null;
                }

                public IPath getFullPath() {
                    return null;
                }

                public InputStream getContents() throws CoreException {
                    try {
                        return new ByteArrayInputStream(text.getBytes(this.getCharset()));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, JavaUIMessages.JavaPlugin_internal_error, (Throwable)e));
                    }
                }

                public String getCharset() throws CoreException {
                    return "UTF-8";
                }
            };
            try {
                if (ApplyPatchOperation.isPatch((IStorage)storage)) {
                    this.fPatchStorage = storage;
                    return true;
                }
            }
            catch (CoreException coreException) {}
            if (selectedWorkingSets.length > 1) {
                return false;
            }
            if (resources.length != 0) {
                return false;
            }
            if (javaElements.length > 1) {
                return false;
            }
            IJavaProject javaProject = null;
            IJavaElement destination = null;
            if (javaElements.length == 1) {
                destination = javaElements[0];
                javaProject = destination.getJavaProject();
            } else if (selectedWorkingSets.length != 1 && selectedElements.size() != 0) {
                return false;
            }
            this.computeLatestVM();
            this.parseCUs(javaProject, text);
            if (this.fParsedCus.length == 0) {
                return false;
            }
            if (destination == null) {
                return true;
            }
            switch (destination.getElementType()) {
                case 2: {
                    IPackageFragmentRoot[] packageFragmentRoots = ((IJavaProject)destination).getPackageFragmentRoots();
                    int i = 0;
                    while (i < packageFragmentRoots.length) {
                        IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[i];
                        if (this.isWritable(packageFragmentRoot)) {
                            this.fDestination = packageFragmentRoot;
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                case 3: {
                    IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)destination;
                    if (this.isWritable(packageFragmentRoot)) {
                        this.fDestination = packageFragmentRoot;
                        return true;
                    }
                    return false;
                }
                case 4: {
                    IPackageFragment destinationPack = (IPackageFragment)destination;
                    IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)destinationPack.getParent();
                    if (this.isWritable(packageFragmentRoot)) {
                        this.fDestination = packageFragmentRoot;
                        if (this.fPackageDeclCount <= 1) {
                            this.fDestinationPack = destinationPack;
                        }
                        return true;
                    }
                    return false;
                }
                case 5: {
                    IPackageFragment destinationPack = (IPackageFragment)destination.getParent();
                    IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)destinationPack.getParent();
                    if (this.isWritable(packageFragmentRoot)) {
                        this.fDestination = packageFragmentRoot;
                        if (this.fPackageDeclCount <= 1) {
                            this.fDestinationPack = destinationPack;
                            this.fDestinationType = ((ICompilationUnit)destination).findPrimaryType();
                        }
                        return true;
                    }
                    return false;
                }
                case 7: {
                    ICompilationUnit cu = ((IType)destination).getCompilationUnit();
                    if (cu != null) {
                        this.fDestinationType = (IType)destination;
                        this.fDestinationPack = (IPackageFragment)cu.getParent();
                        this.fDestination = (IPackageFragmentRoot)this.fDestinationPack.getParent();
                        return true;
                    }
                    return false;
                }
                case 9: {
                    ICompilationUnit cu = ((IMethod)destination).getCompilationUnit();
                    if (cu != null) {
                        this.fDestinationMethod = (IMethod)destination;
                        this.fDestinationType = (IType)destination.getParent();
                        this.fDestinationPack = (IPackageFragment)cu.getParent();
                        this.fDestination = (IPackageFragmentRoot)this.fDestinationPack.getParent();
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        private boolean isWritable(IPackageFragmentRoot packageFragmentRoot) {
            try {
                return packageFragmentRoot.exists() && !packageFragmentRoot.isArchive() && !packageFragmentRoot.isReadOnly() && packageFragmentRoot.getKind() == 1;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }

        @Override
        public void paste(IJavaElement[] javaElements, IResource[] resources, final IWorkingSet[] selectedWorkingSets, TransferData[] availableTypes) throws JavaModelException, InterruptedException, InvocationTargetException {
            if (this.fPatchStorage != null) {
                IResource resource = null;
                if (resources.length > 0) {
                    resource = resources[0];
                } else if (javaElements.length > 0) {
                    resource = javaElements[0].getResource();
                }
                new org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchOperation(null, this.fPatchStorage, resource, new CompareConfiguration()).openWizard();
                return;
            }
            final IEditorPart[] editorPart = new IEditorPart[1];
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    ArrayList cus;
                    block6: {
                        cus = new ArrayList();
                        try {
                            JavaCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                                public void run(IProgressMonitor pm) throws CoreException {
                                    IWorkingSet ws;
                                    pm.beginTask("", 1 + fParsedCus.length);
                                    if (fDestination == null) {
                                        fDestination = this.createNewProject(new SubProgressMonitor(pm, 1));
                                    } else {
                                        pm.worked(1);
                                    }
                                    IConfirmQuery confirmQuery = new ReorgQueries(this.getShell()).createYesYesToAllNoNoToAllQuery(ReorgMessages.PasteAction_TextPaster_confirmOverwriting, true, 6);
                                    int i = 0;
                                    while (i < fParsedCus.length) {
                                        if (pm.isCanceled()) break;
                                        ICompilationUnit cu = this.pasteCU(fParsedCus[i], (IProgressMonitor)new SubProgressMonitor(pm, 1), confirmQuery);
                                        if (cu != null) {
                                            cus.add(cu);
                                        }
                                        ++i;
                                    }
                                    if (selectedWorkingSets.length == 1 && !"org.eclipse.jdt.internal.ui.OthersWorkingSet".equals((ws = selectedWorkingSets[0]).getId())) {
                                        ArrayList<IAdaptable> newElements = new ArrayList<IAdaptable>();
                                        newElements.addAll(Arrays.asList(ws.getElements()));
                                        newElements.addAll(Arrays.asList(ws.adaptElements(new IAdaptable[]{fDestination.getJavaProject()})));
                                        ws.setElements(newElements.toArray(new IAdaptable[newElements.size()]));
                                    }
                                }
                            }, (IProgressMonitor)monitor);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            monitor.done();
                            break block6;
                        }
                        catch (CoreException e) {
                            try {
                                throw new InvocationTargetException(e);
                            }
                            catch (Throwable throwable) {
                                monitor.done();
                                throw throwable;
                            }
                        }
                        monitor.done();
                    }
                    IFile[] cuResources = ResourceUtil.getFiles(cus.toArray(new ICompilationUnit[cus.size()]));
                    SelectionUtil.selectAndReveal((IResource[])cuResources, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }

                private ICompilationUnit pasteCU(ParsedCu parsedCu, IProgressMonitor pm, IConfirmQuery confirmQuery) throws CoreException, OperationCanceledException {
                    pm.beginTask("", 4);
                    try {
                        IPackageFragment destinationPack;
                        if (fDestinationPack != null) {
                            destinationPack = fDestinationPack;
                            pm.worked(1);
                        } else {
                            String packageName = parsedCu.getPackageName();
                            if (packageName == null) {
                                packageName = ReorgMessages.PasteAction_snippet_default_package_name;
                            }
                            if (!(destinationPack = fDestination.getPackageFragment(packageName)).exists()) {
                                JavaModelUtil.getPackageFragmentRoot((IJavaElement)destinationPack).createPackageFragment(packageName, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                            } else {
                                pm.worked(1);
                            }
                        }
                        String parsedText = Strings.trimIndentation((String)parsedCu.getText(), (IJavaProject)destinationPack.getJavaProject(), (boolean)true);
                        int kind = parsedCu.getKind();
                        if (kind == 8) {
                            String cuName = String.valueOf(parsedCu.getTypeName()) + ".java";
                            ICompilationUnit cu = destinationPack.getCompilationUnit(cuName);
                            boolean alreadyExists = cu.exists();
                            if (alreadyExists) {
                                String msg = Messages.format(ReorgMessages.PasteAction_TextPaster_exists, new Object[]{BasicElementLabels.getResourceName((String)cuName)});
                                boolean overwrite = confirmQuery.confirm(msg);
                                if (!overwrite) {
                                    return null;
                                }
                                editorPart[0] = this.openCu(cu);
                            }
                            parsedText = parsedText.replaceAll("\r\n?|\n", StubUtility.getLineDelimiterUsed((IJavaElement)cu));
                            destinationPack.createCompilationUnit(cuName, parsedText, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                            if (!alreadyExists) {
                                editorPart[0] = this.openCu(cu);
                            }
                            if (fDestinationPack != null) {
                                if (fDestinationPack.getElementName().length() == 0) {
                                    this.removePackageDeclaration(cu);
                                } else {
                                    cu.createPackageDeclaration(fDestinationPack.getElementName(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                                }
                            } else {
                                String packageName = destinationPack.getElementName();
                                if (packageName.length() > 0) {
                                    cu.createPackageDeclaration(packageName, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                                }
                            }
                            if (!alreadyExists && editorPart[0] != null) {
                                editorPart[0].doSave((IProgressMonitor)new SubProgressMonitor(pm, 1));
                            }
                            ICompilationUnit iCompilationUnit = cu;
                            return iCompilationUnit;
                        }
                        if (kind == 4 || kind == 2) {
                            ICompilationUnit iCompilationUnit = this.pasteBodyDeclsOrStatements(destinationPack, parsedText, kind, (IProgressMonitor)new SubProgressMonitor(pm, 2));
                            return iCompilationUnit;
                        }
                        throw new IllegalStateException("Unexpected kind: " + kind);
                    }
                    finally {
                        pm.done();
                    }
                }

                private ICompilationUnit pasteBodyDeclsOrStatements(IPackageFragment destinationPack, String parsedText, int kind, IProgressMonitor pm) throws CoreException, JavaModelException {
                    String typeName;
                    IType type;
                    ICompilationUnit cu;
                    if (fDestinationType != null) {
                        cu = fDestinationType.getCompilationUnit();
                        type = fDestinationType;
                        typeName = fDestinationType.getElementName();
                    } else {
                        typeName = ReorgMessages.PasteAction_snippet_default_type_name;
                        cu = destinationPack.getCompilationUnit(String.valueOf(typeName) + ".java");
                        type = cu.getType(typeName);
                    }
                    if (cu.exists()) {
                        editorPart[0] = this.openCu(cu);
                        ITextFileBuffer fileBuffer = RefactoringFileBuffers.acquire(cu);
                        try {
                            IDocument document = fileBuffer.getDocument();
                            ASTParser parser = ASTParser.newParser((int)9);
                            parser.setProject(cu.getJavaProject());
                            parser.setSource(document.get().toCharArray());
                            parser.setStatementsRecovery(true);
                            CompilationUnit cuNode = (CompilationUnit)parser.createAST(pm);
                            AbstractTypeDeclaration typeDecl = type.exists() ? ASTNodeSearchUtil.getAbstractTypeDeclarationNode(type, cuNode) : null;
                            MethodDeclaration methodDecl = fDestinationMethod != null ? ASTNodeSearchUtil.getMethodDeclarationNode(fDestinationMethod, cuNode) : null;
                            ITrackedNodePosition textPosition = this.createOrFillTypeDeclaration(cuNode, document, cu, typeDecl, typeName, methodDecl, kind, parsedText);
                            EditorUtility.revealInEditor(editorPart[0], textPosition.getStartPosition() + textPosition.getLength(), 0);
                        }
                        finally {
                            RefactoringFileBuffers.release(cu);
                        }
                    } else {
                        String cuContent;
                        String delim = StubUtility.getLineDelimiterUsed((IJavaElement)cu);
                        String fileComment = null;
                        if (StubUtility.doAddComments(cu.getJavaProject())) {
                            fileComment = CodeGeneration.getFileComment(cu, delim);
                        }
                        if ((cuContent = CodeGeneration.getCompilationUnitContent(cu, fileComment, null, "", delim)) == null) {
                            cuContent = "";
                        }
                        Document document = new Document(cuContent);
                        ASTParser parser = ASTParser.newParser((int)9);
                        parser.setProject(cu.getJavaProject());
                        parser.setSource(cuContent.toCharArray());
                        parser.setStatementsRecovery(true);
                        CompilationUnit cuNode = (CompilationUnit)parser.createAST(pm);
                        ITrackedNodePosition textPosition = this.createOrFillTypeDeclaration(cuNode, (IDocument)document, cu, null, typeName, null, kind, parsedText);
                        destinationPack.createCompilationUnit(cu.getElementName(), document.get(), false, null);
                        editorPart[0] = this.openCu(cu);
                        EditorUtility.revealInEditor(editorPart[0], textPosition.getStartPosition() + textPosition.getLength(), 0);
                    }
                    return cu;
                }

                private ITrackedNodePosition createOrFillTypeDeclaration(CompilationUnit cuNode, IDocument document, ICompilationUnit cu, AbstractTypeDeclaration typeDecl, String typeName, MethodDeclaration methodDecl, int kind, String parsedText) throws CoreException {
                    ITrackedNodePosition textPosition;
                    AST ast = cuNode.getAST();
                    ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                    String delim = StubUtility.getLineDelimiterUsed((IJavaElement)cu);
                    if (typeDecl == null) {
                        String typeComment;
                        typeDecl = ast.newTypeDeclaration();
                        typeDecl.getName().setIdentifier(typeName);
                        if (StubUtility.doAddComments(cu.getJavaProject()) && (typeComment = CodeGeneration.getTypeComment(cu, typeName, delim)) != null) {
                            typeDecl.setJavadoc((Javadoc)rewrite.createStringPlaceholder(typeComment, 29));
                        }
                        typeDecl.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
                        String typeBody = CodeGeneration.getTypeBody("org.eclipse.jdt.ui.text.codetemplates.classbody", cu, typeName, delim);
                        if (typeBody != null) {
                            BodyDeclaration typeBodyNode = (BodyDeclaration)rewrite.createStringPlaceholder(typeBody, 31);
                            ListRewrite bodyRewrite = rewrite.getListRewrite((ASTNode)typeDecl, typeDecl.getBodyDeclarationsProperty());
                            bodyRewrite.insertFirst((ASTNode)typeBodyNode, null);
                        }
                        rewrite.getListRewrite((ASTNode)cuNode, CompilationUnit.TYPES_PROPERTY).insertLast((ASTNode)typeDecl, null);
                    }
                    if (kind == 4) {
                        ListRewrite bodyRewrite = rewrite.getListRewrite((ASTNode)typeDecl, typeDecl.getBodyDeclarationsProperty());
                        BodyDeclaration textNode = (BodyDeclaration)rewrite.createStringPlaceholder(parsedText, 31);
                        bodyRewrite.insertLast((ASTNode)textNode, null);
                        textPosition = rewrite.track((ASTNode)textNode);
                    } else {
                        if (methodDecl == null || methodDecl.getBody() == null) {
                            String methodComment;
                            String qualifiedtypeName;
                            methodDecl = ast.newMethodDeclaration();
                            String string = qualifiedtypeName = fDestinationType != null ? fDestinationType.getFullyQualifiedName('.') : String.valueOf(cu.getParent().getElementName()) + '.' + typeName;
                            if (StubUtility.doAddComments(cu.getJavaProject()) && (methodComment = CodeGeneration.getMethodComment(cu, qualifiedtypeName, methodDecl, null, delim)) != null) {
                                methodDecl.setJavadoc((Javadoc)rewrite.createStringPlaceholder(methodComment, 29));
                            }
                            methodDecl.modifiers().addAll(ast.newModifiers(9));
                            String methodName = "main";
                            methodDecl.getName().setIdentifier(methodName);
                            SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
                            param.setType((Type)ast.newArrayType((Type)ast.newSimpleType((Name)ast.newSimpleName("String"))));
                            param.getName().setIdentifier("args");
                            methodDecl.parameters().add(param);
                            Block block = ast.newBlock();
                            methodDecl.setBody(block);
                            rewrite.getListRewrite((ASTNode)typeDecl, typeDecl.getBodyDeclarationsProperty()).insertLast((ASTNode)methodDecl, null);
                        }
                        Block body = methodDecl.getBody();
                        ListRewrite statementsRewrite = rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY);
                        Statement textNode = (Statement)rewrite.createStringPlaceholder(parsedText, 20);
                        statementsRewrite.insertLast((ASTNode)textNode, null);
                        textPosition = rewrite.track((ASTNode)textNode);
                    }
                    DocumentRewriteSession rewriteSession = null;
                    if (document instanceof IDocumentExtension4) {
                        rewriteSession = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
                    }
                    TextEdit edit = rewrite.rewriteAST(document, cu.getJavaProject().getOptions(true));
                    try {
                        edit.apply(document, 2);
                        ITrackedNodePosition iTrackedNodePosition = textPosition;
                        return iTrackedNodePosition;
                    }
                    catch (MalformedTreeException e) {
                        JavaPlugin.log(e);
                    }
                    catch (BadLocationException e) {
                        JavaPlugin.log(e);
                    }
                    finally {
                        if (rewriteSession != null) {
                            ((IDocumentExtension4)document).stopRewriteSession(rewriteSession);
                        }
                    }
                    return null;
                }

                private IPackageFragmentRoot createNewProject(SubProgressMonitor pm) throws CoreException {
                    IProject srcFolder;
                    IProject project;
                    pm.beginTask("", 10);
                    int i = 1;
                    do {
                        String name = Messages.format(ReorgMessages.PasteAction_projectName, i == 1 ? "" : new Integer(i));
                        project = JavaPlugin.getWorkspace().getRoot().getProject(name);
                        ++i;
                    } while (project.exists());
                    BuildPathsBlock.createProject(project, null, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pm, 3));
                    BuildPathsBlock.addJavaNature(project, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pm, 1));
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    IPreferenceStore store = PreferenceConstants.getPreferenceStore();
                    String sourceFolderName = store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName");
                    if (store.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects") && sourceFolderName.length() > 0) {
                        IFolder folder = project.getFolder(sourceFolderName);
                        if (!folder.exists()) {
                            folder.create(false, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pm, 1));
                        }
                        srcFolder = folder;
                    } else {
                        srcFolder = project;
                    }
                    if (fCompilerCompliance != null) {
                        Map options = javaProject.getOptions(false);
                        JavaModelUtil.setComplianceOptions((Map)options, (String)fCompilerCompliance);
                        JavaModelUtil.setDefaultClassfileOptions((Map)options, (String)fCompilerCompliance);
                        javaProject.setOptions(options);
                    }
                    IClasspathEntry srcEntry = JavaCore.newSourceEntry((IPath)srcFolder.getFullPath());
                    IClasspathEntry jreEntry = JavaCore.newContainerEntry((IPath)fVMPath);
                    IPath outputLocation = BuildPathsBlock.getDefaultOutputLocation(javaProject);
                    IClasspathEntry[] cpes = new IClasspathEntry[]{srcEntry, jreEntry};
                    javaProject.setRawClasspath(cpes, outputLocation, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pm, 1));
                    return javaProject.getPackageFragmentRoot((IResource)srcFolder);
                }

                private void removePackageDeclaration(ICompilationUnit cu) throws JavaModelException, CoreException {
                    IPackageDeclaration[] packageDeclarations = cu.getPackageDeclarations();
                    if (packageDeclarations.length != 0) {
                        ITextFileBuffer buffer = null;
                        try {
                            try {
                                buffer = RefactoringFileBuffers.acquire(cu);
                                ISourceRange sourceRange = packageDeclarations[0].getSourceRange();
                                buffer.getDocument().replace(sourceRange.getOffset(), sourceRange.getLength(), "");
                            }
                            catch (BadLocationException e) {
                                JavaPlugin.log(e);
                                if (buffer != null) {
                                    RefactoringFileBuffers.release(cu);
                                }
                            }
                        }
                        finally {
                            if (buffer != null) {
                                RefactoringFileBuffers.release(cu);
                            }
                        }
                    }
                }
            };
            Object context = JavaPlugin.getActiveWorkbenchWindow();
            if (context == null) {
                context = new BusyIndicatorRunnableContext();
            }
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, op, (ISchedulingRule)JavaPlugin.getWorkspace().getRoot());
            if (editorPart[0] != null) {
                editorPart[0].getEditorSite().getPage().activate((IWorkbenchPart)editorPart[0]);
            }
        }

        private IEditorPart openCu(ICompilationUnit cu) {
            try {
                return JavaUI.openInEditor((IJavaElement)cu, true, true);
            }
            catch (PartInitException e) {
                JavaPlugin.log(e);
                return null;
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return null;
            }
        }

        private void parseCUs(IJavaProject javaProject, String text) {
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(text.toCharArray());
            ArrayList<ParsedCu> cus = new ArrayList<ParsedCu>();
            int start = 0;
            boolean tokensScanned = false;
            this.fPackageDeclCount = 0;
            while (true) {
                int tok;
                try {
                    tok = scanner.getNextToken();
                }
                catch (InvalidInputException invalidInputException) {
                    tok = 158;
                }
                if (tok == 214) {
                    int packageStart;
                    List<ParsedCu> parsed;
                    ++this.fPackageDeclCount;
                    if (tokensScanned && (parsed = ParsedCu.parseCus(javaProject, this.fCompilerCompliance, text.substring(start, packageStart = scanner.getCurrentTokenStartPosition()))).size() > 0) {
                        cus.addAll(parsed);
                        start = packageStart;
                    }
                } else if (tok == 158) {
                    List<ParsedCu> parsed = ParsedCu.parseCus(javaProject, this.fCompilerCompliance, text.substring(start, text.length()));
                    if (parsed.size() <= 0) break;
                    cus.addAll(parsed);
                    break;
                }
                tokensScanned = true;
            }
            this.fParsedCus = cus.toArray(new ParsedCu[cus.size()]);
        }

        private void computeLatestVM() {
            IVMInstall bestVM = JavaRuntime.getDefaultVMInstall();
            String bestVersion = this.getVMVersion(bestVM);
            IExecutionEnvironmentsManager eeManager = JavaRuntime.getExecutionEnvironmentsManager();
            IExecutionEnvironment bestEE = null;
            IExecutionEnvironment[] ees = eeManager.getExecutionEnvironments();
            int j = 0;
            while (j < ees.length) {
                IExecutionEnvironment ee = ees[j];
                IVMInstall vm = ee.getDefaultVM();
                String ver = this.getVMVersion(vm);
                if (ver != null) {
                    if (bestVersion == null || JavaModelUtil.isVersionLessThan((String)bestVersion, (String)ver) || bestVersion.equals(ver)) {
                        bestVersion = ver;
                        bestEE = ee;
                    }
                } else {
                    String eeVer = JavaModelUtil.getExecutionEnvironmentCompliance((IExecutionEnvironment)ee);
                    IVMInstall[] compatibleVMs = ee.getCompatibleVMs();
                    int i = 0;
                    while (i < compatibleVMs.length) {
                        vm = compatibleVMs[i];
                        ver = this.getVMVersion(vm);
                        if (eeVer.equals(ver) && (bestVersion == null || JavaModelUtil.isVersionLessThan((String)bestVersion, (String)ver) || bestVersion.equals(ver))) {
                            bestVersion = ver;
                            bestEE = ee;
                            break;
                        }
                        ++i;
                    }
                }
                ++j;
            }
            IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < vmTypes.length) {
                IVMInstall[] vms = vmTypes[i].getVMInstalls();
                int j2 = 0;
                while (j2 < vms.length) {
                    IVMInstall vm = vms[j2];
                    String ver = this.getVMVersion(vm);
                    if (ver != null && (bestVersion == null || JavaModelUtil.isVersionLessThan((String)bestVersion, (String)ver))) {
                        bestVersion = ver;
                        bestVM = vm;
                        bestEE = null;
                    }
                    ++j2;
                }
                ++i;
            }
            if (bestEE != null) {
                this.fVMPath = JavaRuntime.newJREContainerPath(bestEE);
                this.fCompilerCompliance = bestVersion;
            } else if (bestVM != null) {
                this.fVMPath = JavaRuntime.newJREContainerPath((IVMInstall)bestVM);
                this.fCompilerCompliance = bestVersion;
            } else {
                this.fVMPath = JavaRuntime.newDefaultJREContainerPath();
            }
        }

        private String getVMVersion(IVMInstall vm) {
            if (vm instanceof IVMInstall2) {
                IVMInstall2 vm2 = (IVMInstall2)vm;
                return JavaModelUtil.getCompilerCompliance((IVMInstall2)vm2, null);
            }
            return null;
        }

        private static class ParsedCu {
            private final String fText;
            private final int fKind;
            private final String fTypeName;
            private final String fPackageName;

            public static List<ParsedCu> parseCus(IJavaProject javaProject, String compilerCompliance, String text) {
                List statements;
                List bodyDeclarations;
                ASTParser parser = ASTParser.newParser((int)9);
                if (javaProject != null) {
                    parser.setProject(javaProject);
                } else if (compilerCompliance != null) {
                    Hashtable options = JavaCore.getOptions();
                    JavaModelUtil.setComplianceOptions((Map)options, (String)compilerCompliance);
                    parser.setCompilerOptions((Map)options);
                }
                parser.setSource(text.toCharArray());
                parser.setStatementsRecovery(true);
                CompilationUnit unit = (CompilationUnit)parser.createAST(null);
                if (unit.types().size() > 0) {
                    return ParsedCu.parseAsTypes(text, unit);
                }
                parser.setProject(javaProject);
                parser.setSource(text.toCharArray());
                parser.setStatementsRecovery(true);
                parser.setKind(4);
                ASTNode root = parser.createAST(null);
                if (root instanceof TypeDeclaration && (bodyDeclarations = ((TypeDeclaration)root).bodyDeclarations()).size() > 0) {
                    return Collections.singletonList(new ParsedCu(text, 4, null, null));
                }
                parser.setProject(javaProject);
                parser.setSource(text.toCharArray());
                parser.setStatementsRecovery(true);
                parser.setKind(2);
                root = parser.createAST(null);
                if (root instanceof Block && (statements = ((Block)root).statements()).size() > 0) {
                    return Collections.singletonList(new ParsedCu(text, 2, null, null));
                }
                return Collections.emptyList();
            }

            private static List<ParsedCu> parseAsTypes(String text, CompilationUnit unit) {
                String packageName = "";
                PackageDeclaration pack = unit.getPackage();
                if (pack != null) {
                    packageName = pack.getName().getFullyQualifiedName();
                }
                ArrayList<ParsedCu> cus = new ArrayList<ParsedCu>();
                List types = unit.types();
                int startOffset = 0;
                String typeName = null;
                int maxVisibility = -1;
                for (AbstractTypeDeclaration type : types) {
                    if (typeName == null) {
                        maxVisibility = JdtFlags.getVisibilityCode((BodyDeclaration)type);
                        typeName = type.getName().getIdentifier();
                        continue;
                    }
                    int visibility = JdtFlags.getVisibilityCode((BodyDeclaration)type);
                    if (visibility == 1 && maxVisibility == 1) {
                        int prevEnd = type.getStartPosition();
                        String source = text.substring(startOffset, prevEnd);
                        cus.add(new ParsedCu(source, 8, typeName, packageName));
                        startOffset = prevEnd;
                        typeName = type.getName().getIdentifier();
                        maxVisibility = visibility;
                        continue;
                    }
                    if (!JdtFlags.isHigherVisibility((int)visibility, (int)maxVisibility)) continue;
                    maxVisibility = visibility;
                    typeName = type.getName().getIdentifier();
                }
                if (typeName != null) {
                    String source = text.substring(startOffset);
                    cus.add(new ParsedCu(source, 8, typeName, packageName));
                }
                return cus;
            }

            private ParsedCu(String text, int kind, String typeName, String packageName) {
                this.fText = text;
                this.fTypeName = typeName;
                this.fPackageName = packageName;
                this.fKind = kind;
            }

            public String getTypeName() {
                return this.fTypeName;
            }

            public String getPackageName() {
                return this.fPackageName;
            }

            public String getText() {
                return this.fText;
            }

            public int getKind() {
                return this.fKind;
            }
        }
    }

    private static class TypedSourcePaster
    extends Paster {
        private TransferData[] fAvailableTypes;

        protected TypedSourcePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        @Override
        public boolean canEnable(TransferData[] availableTypes) {
            this.fAvailableTypes = availableTypes;
            return PasteAction.isAvailable((Transfer)TypedSourceTransfer.getInstance(), availableTypes);
        }

        @Override
        public boolean canPasteOn(IJavaElement[] selectedJavaElements, IResource[] selectedResources, IWorkingSet[] selectedWorkingSets, List<?> selectedElements) throws JavaModelException {
            if (selectedResources.length != 0 || selectedWorkingSets.length != 0) {
                return false;
            }
            TypedSource[] typedSources = this.getClipboardTypedSources(this.fAvailableTypes);
            IJavaElement destination = TypedSourcePaster.getTarget(selectedJavaElements, selectedResources);
            if (destination instanceof IJavaElement) {
                return ReorgTypedSourcePasteStarter.create(typedSources, destination) != null;
            }
            return false;
        }

        @Override
        public void paste(IJavaElement[] selectedJavaElements, IResource[] selectedResources, IWorkingSet[] selectedWorkingSets, TransferData[] availableTypes) throws JavaModelException, InterruptedException, InvocationTargetException {
            TypedSource[] typedSources = this.getClipboardTypedSources(availableTypes);
            IJavaElement destination = TypedSourcePaster.getTarget(selectedJavaElements, selectedResources);
            ReorgTypedSourcePasteStarter.create(typedSources, destination).run(this.getShell());
        }

        private static IJavaElement getTarget(IJavaElement[] selectedJavaElements, IResource[] selectedResources) {
            Assert.isTrue((selectedResources.length == 0 ? 1 : 0) != 0);
            if (selectedJavaElements.length == 1) {
                return TypedSourcePaster.getAsTypeOrCu(selectedJavaElements[0]);
            }
            Object parent = new ParentChecker(selectedResources, selectedJavaElements).getCommonParent();
            if (parent instanceof IJavaElement) {
                return TypedSourcePaster.getAsTypeOrCu((IJavaElement)parent);
            }
            return null;
        }

        private static IJavaElement getAsTypeOrCu(IJavaElement element) {
            if (element.getElementType() == 5 || element.getElementType() == 7) {
                return element;
            }
            IJavaElement ancestorType = element.getAncestor(7);
            if (ancestorType != null) {
                return ancestorType;
            }
            return ReorgUtils.getCompilationUnit(element);
        }

        private static class PasteTypedSourcesRefactoring
        extends Refactoring {
            private final TypedSource[] fSources;
            private IJavaElement fDestination;

            static PasteTypedSourcesRefactoring create(TypedSource[] sources) {
                if (!PasteTypedSourcesRefactoring.isAvailable(sources)) {
                    return null;
                }
                return new PasteTypedSourcesRefactoring(sources);
            }

            public RefactoringStatus setDestination(IJavaElement destination) {
                this.fDestination = destination;
                if (ReorgUtils.getCompilationUnit(destination) == null) {
                    return RefactoringStatus.createFatalErrorStatus((String)ReorgMessages.PasteAction_wrong_destination);
                }
                if (!destination.exists()) {
                    return RefactoringStatus.createFatalErrorStatus((String)ReorgMessages.PasteAction_element_doesnot_exist);
                }
                if (!this.canPasteAll(destination)) {
                    return RefactoringStatus.createFatalErrorStatus((String)ReorgMessages.PasteAction_invalid_destination);
                }
                return new RefactoringStatus();
            }

            private boolean canPasteAll(IJavaElement destination) {
                int i = 0;
                while (i < this.fSources.length) {
                    if (!PasteTypedSourcesRefactoring.canPaste(this.fSources[i].getType(), destination)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            private static boolean canPaste(int elementType, IJavaElement destination) {
                IType ancestorType = PasteTypedSourcesRefactoring.getAncestorType(destination);
                if (ancestorType != null) {
                    return PasteTypedSourcesRefactoring.canPasteToType(elementType);
                }
                return PasteTypedSourcesRefactoring.canPasteToCu(elementType);
            }

            private static boolean canPasteToType(int elementType) {
                return elementType == 7 || elementType == 8 || elementType == 10 || elementType == 9;
            }

            private static boolean canPasteToCu(int elementType) {
                return elementType == 11 || elementType == 7 || elementType == 13;
            }

            PasteTypedSourcesRefactoring(TypedSource[] sources) {
                Assert.isNotNull((Object)sources);
                Assert.isTrue((sources.length != 0 ? 1 : 0) != 0);
                this.fSources = sources;
            }

            private static boolean isAvailable(TypedSource[] sources) {
                return sources != null && sources.length > 0;
            }

            public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
                return new RefactoringStatus();
            }

            public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
                RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.getDestinationCu()}), this.getValidationContext());
                return result;
            }

            public Change createChange(IProgressMonitor pm) throws CoreException {
                ASTParser p = ASTParser.newParser((int)9);
                p.setSource(this.getDestinationCu());
                CompilationUnit cuNode = (CompilationUnit)p.createAST(pm);
                ASTRewrite rewrite = ASTRewrite.create((AST)cuNode.getAST());
                TypedSource source = null;
                int i = this.fSources.length - 1;
                while (i >= 0) {
                    source = this.fSources[i];
                    ASTNode destination = this.getDestinationNodeForSourceElement(this.fDestination, source.getType(), cuNode);
                    if (destination != null) {
                        if (destination instanceof CompilationUnit) {
                            PasteTypedSourcesRefactoring.insertToCu(rewrite, this.createNewNodeToInsertToCu(source, rewrite), (CompilationUnit)destination);
                        } else if (destination instanceof AbstractTypeDeclaration) {
                            PasteTypedSourcesRefactoring.insertToType(rewrite, this.createNewNodeToInsertToType(source, rewrite), (AbstractTypeDeclaration)destination);
                        }
                    }
                    --i;
                }
                CompilationUnitChange result = new CompilationUnitChange(ReorgMessages.PasteAction_change_name, this.getDestinationCu());
                try {
                    ITextFileBuffer buffer = RefactoringFileBuffers.acquire(this.getDestinationCu());
                    TextEdit rootEdit = rewrite.rewriteAST(buffer.getDocument(), this.fDestination.getJavaProject().getOptions(true));
                    if (this.getDestinationCu().isWorkingCopy()) {
                        result.setSaveMode(4);
                    }
                    TextChangeCompatibility.addTextEdit((TextChange)result, (String)ReorgMessages.PasteAction_edit_name, (TextEdit)rootEdit);
                }
                finally {
                    RefactoringFileBuffers.release(this.getDestinationCu());
                }
                return result;
            }

            private static void insertToType(ASTRewrite rewrite, ASTNode node, AbstractTypeDeclaration typeDeclaration) {
                switch (node.getNodeType()) {
                    case 23: 
                    case 28: 
                    case 31: 
                    case 55: 
                    case 71: 
                    case 81: {
                        rewrite.getListRewrite((ASTNode)typeDeclaration, typeDeclaration.getBodyDeclarationsProperty()).insertAt(node, BodyDeclarationRewrite.getInsertionIndex((BodyDeclaration)node, typeDeclaration.bodyDeclarations()), null);
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false, (String)String.valueOf(node.getNodeType()));
                    }
                }
            }

            private static void insertToCu(ASTRewrite rewrite, ASTNode node, CompilationUnit cuNode) {
                switch (node.getNodeType()) {
                    case 55: 
                    case 71: 
                    case 81: {
                        rewrite.getListRewrite((ASTNode)cuNode, CompilationUnit.TYPES_PROPERTY).insertAt(node, BodyDeclarationRewrite.getInsertionIndex((BodyDeclaration)((AbstractTypeDeclaration)node), cuNode.types()), null);
                        break;
                    }
                    case 26: {
                        rewrite.getListRewrite((ASTNode)cuNode, CompilationUnit.IMPORTS_PROPERTY).insertLast(node, null);
                        break;
                    }
                    case 35: {
                        if (cuNode.getPackage() != null) break;
                        rewrite.set((ASTNode)cuNode, (StructuralPropertyDescriptor)CompilationUnit.PACKAGE_PROPERTY, (Object)node, null);
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false, (String)String.valueOf(node.getNodeType()));
                    }
                }
            }

            private ASTNode getDestinationNodeForSourceElement(IJavaElement destination, int kind, CompilationUnit unit) throws JavaModelException {
                IType ancestor = PasteTypedSourcesRefactoring.getAncestorType(destination);
                if (ancestor != null) {
                    return ASTNodeSearchUtil.getAbstractTypeDeclarationNode(ancestor, unit);
                }
                if (kind == 7 || kind == 11 || kind == 13 || kind == 12) {
                    return unit;
                }
                return null;
            }

            private static IType getAncestorType(IJavaElement destinationElement) {
                return destinationElement.getElementType() == 7 ? (IType)destinationElement : (IType)destinationElement.getAncestor(7);
            }

            private ASTNode createNewNodeToInsertToCu(TypedSource source, ASTRewrite rewrite) {
                switch (source.getType()) {
                    case 7: {
                        return rewrite.createStringPlaceholder(source.getSource(), 55);
                    }
                    case 11: {
                        return rewrite.createStringPlaceholder(source.getSource(), 35);
                    }
                    case 13: {
                        return rewrite.createStringPlaceholder(source.getSource(), 26);
                    }
                }
                Assert.isTrue((boolean)false, (String)String.valueOf(source.getType()));
                return null;
            }

            private ASTNode createNewNodeToInsertToType(TypedSource source, ASTRewrite rewrite) {
                switch (source.getType()) {
                    case 7: {
                        return rewrite.createStringPlaceholder(source.getSource(), 55);
                    }
                    case 9: {
                        return rewrite.createStringPlaceholder(source.getSource(), 31);
                    }
                    case 8: {
                        return rewrite.createStringPlaceholder(source.getSource(), 23);
                    }
                    case 10: {
                        return rewrite.createStringPlaceholder(source.getSource(), 28);
                    }
                }
                Assert.isTrue((boolean)false);
                return null;
            }

            private ICompilationUnit getDestinationCu() {
                return ReorgUtils.getCompilationUnit(this.fDestination);
            }

            public String getName() {
                return ReorgMessages.PasteAction_name;
            }
        }

        private static class ReorgTypedSourcePasteStarter {
            private final PasteTypedSourcesRefactoring fPasteRefactoring;

            private ReorgTypedSourcePasteStarter(PasteTypedSourcesRefactoring pasteRefactoring) {
                Assert.isNotNull((Object)((Object)pasteRefactoring));
                this.fPasteRefactoring = pasteRefactoring;
            }

            public static ReorgTypedSourcePasteStarter create(TypedSource[] typedSources, IJavaElement destination) {
                Assert.isNotNull((Object)typedSources);
                Assert.isNotNull((Object)destination);
                PasteTypedSourcesRefactoring pasteRefactoring = PasteTypedSourcesRefactoring.create(typedSources);
                if (pasteRefactoring == null) {
                    return null;
                }
                if (!pasteRefactoring.setDestination(destination).isOK()) {
                    return null;
                }
                return new ReorgTypedSourcePasteStarter(pasteRefactoring);
            }

            public void run(Shell parent) throws InterruptedException, InvocationTargetException {
                ProgressMonitorDialog context = new ProgressMonitorDialog(parent);
                new RefactoringExecutionHelper(this.fPasteRefactoring, RefactoringCore.getConditionCheckingFailedSeverity(), 3, parent, (IRunnableContext)context).perform(false, false);
            }
        }
    }

    private static class WorkingSetPaster
    extends Paster {
        protected WorkingSetPaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        @Override
        public void paste(IJavaElement[] selectedJavaElements, IResource[] selectedResources, IWorkingSet[] selectedWorkingSets, TransferData[] availableTypes) throws JavaModelException, InterruptedException, InvocationTargetException {
            Object[] resources;
            IWorkingSet workingSet = selectedWorkingSets[0];
            HashSet<IAdaptable> elements = new HashSet<IAdaptable>(Arrays.asList(workingSet.getElements()));
            IJavaElement[] javaElements = this.getClipboardJavaElements(availableTypes);
            if (javaElements != null) {
                int i = 0;
                while (i < javaElements.length) {
                    if (!ReorgUtils.containsElementOrParent(elements, javaElements[i])) {
                        elements.add((IAdaptable)javaElements[i]);
                    }
                    ++i;
                }
            }
            if ((resources = this.getClipboardResources(availableTypes)) != null) {
                ArrayList realJavaElements = new ArrayList();
                ArrayList realResource = new ArrayList();
                ReorgUtils.splitIntoJavaElementsAndResources(resources, realJavaElements, realResource);
                for (IJavaElement element : realJavaElements) {
                    if (ReorgUtils.containsElementOrParent(elements, element)) continue;
                    elements.add((IAdaptable)element);
                }
                for (IJavaElement element : realResource) {
                    if (ReorgUtils.containsElementOrParent(elements, (IResource)element)) continue;
                    elements.add((IAdaptable)element);
                }
            }
            workingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }

        @Override
        public boolean canEnable(TransferData[] availableTypes) {
            return PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), availableTypes) || PasteAction.isAvailable((Transfer)JavaElementTransfer.getInstance(), availableTypes);
        }

        @Override
        public boolean canPasteOn(IJavaElement[] selectedJavaElements, IResource[] selectedResources, IWorkingSet[] selectedWorkingSets, List<?> selectedElements) throws JavaModelException {
            if (selectedResources.length != 0 || selectedJavaElements.length != 0 || selectedWorkingSets.length != 1) {
                return false;
            }
            IWorkingSet ws = selectedWorkingSets[0];
            return !"org.eclipse.jdt.internal.ui.OthersWorkingSet".equals(ws.getId());
        }
    }
}

