/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.animation;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.AnimationManager;
import fr.inria.zvtm.animation.DefaultTimingHandler;
import fr.inria.zvtm.animation.EndAction;
import fr.inria.zvtm.animation.TimingHandler;
import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.portals.Portal;
import fr.inria.zvtm.glyphs.DPath;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.Translucent;
import fr.inria.zvtm.lens.FixedSizeLens;
import java.awt.Point;
import java.awt.geom.Point2D;
import net.jcip.annotations.Immutable;
import org.jdesktop.animation.timing.interpolation.Interpolator;

@Immutable
public class AnimationFactory {
    private final AnimationManager animationManager;

    AnimationFactory(AnimationManager am) {
        this.animationManager = am;
    }

    public Animation createAnimation(int duration, Object subject, Animation.Dimension dimension, TimingHandler handler) {
        return this.createAnimation(duration, 1.0, Animation.RepeatBehavior.LOOP, subject, dimension, handler);
    }

    public Animation createAnimation(int duration, double repeatCount, Animation.RepeatBehavior repeatBehavior, Object subject, Animation.Dimension dimension, TimingHandler handler) {
        Animation retval = new Animation(this.animationManager, duration, repeatCount, repeatBehavior, subject, dimension, handler);
        return this.animationManager.createAnimation(duration, repeatCount, repeatBehavior, subject, dimension, handler);
    }

    public Animation createAnimation(int duration, double repeatCount, Animation.RepeatBehavior repeatBehavior, Object subject, Animation.Dimension dimension, TimingHandler handler, Interpolator interpolator) {
        return this.animationManager.createAnimation(duration, repeatCount, repeatBehavior, subject, dimension, handler, interpolator);
    }

    public Animation createCameraTranslation(int duration, final Camera camera, final Point2D.Double data, final boolean relative, Interpolator interpolator, final EndAction endAction) {
        return this.createAnimation(duration, 1.0, Animation.RepeatBehavior.LOOP, camera, Animation.Dimension.POSITION, new DefaultTimingHandler(){
            private double startX = Double.MIN_VALUE;
            private double startY = Double.MIN_VALUE;
            private double endX = Double.MIN_VALUE;
            private double endY = Double.MIN_VALUE;

            @Override
            public void begin(Object subject, Animation.Dimension dim) {
                this.startX = camera.getLocation().vx;
                this.startY = camera.getLocation().vy;
                this.endX = relative ? camera.getLocation().vx + data.x : data.x;
                this.endY = relative ? camera.getLocation().vy + data.y : data.y;
            }

            @Override
            public void end(Object subject, Animation.Dimension dim) {
                if (null != endAction) {
                    endAction.execute(subject, dim);
                }
            }

            @Override
            public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                camera.moveTo(this.startX + (double)fraction * (this.endX - this.startX), this.startY + (double)fraction * (this.endY - this.startY));
            }
        }, interpolator);
    }

    public Animation createCameraAltAnim(int duration, final Camera camera, final double data, final boolean relative, Interpolator interpolator, final EndAction endAction) {
        return this.createAnimation(duration, 1.0, Animation.RepeatBehavior.LOOP, camera, Animation.Dimension.ALTITUDE, new DefaultTimingHandler(){
            private double startZ = Double.MIN_VALUE;
            private double endZ = Double.MAX_VALUE;

            @Override
            public void begin(Object subject, Animation.Dimension dim) {
                this.startZ = camera.getAltitude();
                this.endZ = relative ? camera.getAltitude() + data : data;
            }

            @Override
            public void end(Object subject, Animation.Dimension dim) {
                if (null != endAction) {
                    endAction.execute(subject, dim);
                }
            }

            @Override
            public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                camera.setAltitude(this.startZ + (double)fraction * (this.endZ - this.startZ));
            }
        }, interpolator);
    }

    public Animation createGlyphTranslation(int duration, final Glyph glyph, final Point2D.Double data, final boolean relative, Interpolator interpolator, final EndAction endAction) {
        return this.createAnimation(duration, 1.0, Animation.RepeatBehavior.LOOP, glyph, Animation.Dimension.POSITION, new DefaultTimingHandler(){
            private double startX = Double.MIN_VALUE;
            private double startY = Double.MIN_VALUE;
            private double endX = Double.MIN_VALUE;
            private double endY = Double.MIN_VALUE;

            @Override
            public void begin(Object subject, Animation.Dimension dim) {
                this.startX = glyph.getLocation().x;
                this.startY = glyph.getLocation().y;
                this.endX = relative ? glyph.getLocation().x + data.x : data.x;
                this.endY = relative ? glyph.getLocation().y + data.y : data.y;
            }

            @Override
            public void end(Object subject, Animation.Dimension dim) {
                if (null != endAction) {
                    endAction.execute(subject, dim);
                }
            }

            @Override
            public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                glyph.moveTo(this.startX + (double)fraction * (this.endX - this.startX), this.startY + (double)fraction * (this.endY - this.startY));
            }
        }, interpolator);
    }

    public Animation createGlyphSizeAnim(int duration, final Glyph glyph, final double data, final boolean relative, Interpolator interpolator, final EndAction endAction) {
        return this.createAnimation(duration, 1.0, Animation.RepeatBehavior.LOOP, glyph, Animation.Dimension.SIZE, new DefaultTimingHandler(){
            private double startSize = Double.MIN_VALUE;
            private double endSize = Double.MIN_VALUE;

            @Override
            public void begin(Object subject, Animation.Dimension dim) {
                this.startSize = glyph.getSize();
                double d = this.endSize = relative ? glyph.getSize() + data : data;
                if (this.endSize < 0.0) {
                    throw new IllegalStateException("Cannot animate a Glyph size to a negative value");
                }
            }

            @Override
            public void end(Object subject, Animation.Dimension dim) {
                if (null != endAction) {
                    endAction.execute(subject, dim);
                }
            }

            @Override
            public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                glyph.sizeTo(this.startSize + (double)fraction * (this.endSize - this.startSize));
            }
        }, interpolator);
    }

    public Animation createGlyphOrientationAnim(int duration, final Glyph glyph, final double data, final boolean relative, Interpolator interpolator, final EndAction endAction) {
        return this.createAnimation(duration, 1.0, Animation.RepeatBehavior.LOOP, glyph, Animation.Dimension.ORIENTATION, new DefaultTimingHandler(){
            private double startAngle = Double.MIN_VALUE;
            private double endAngle = Double.MIN_VALUE;

            @Override
            public void begin(Object subject, Animation.Dimension dim) {
                this.startAngle = glyph.getOrient();
                this.endAngle = relative ? glyph.getOrient() + data : data;
            }

            @Override
            public void end(Object subject, Animation.Dimension dim) {
                if (null != endAction) {
                    endAction.execute(subject, dim);
                }
            }

            @Override
            public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                glyph.orientTo(this.startAngle + (double)fraction * (this.endAngle - this.startAngle));
            }
        }, interpolator);
    }

    public Animation createGlyphFillColorAnim(int duration, final Glyph glyph, final float[] data, final boolean relative, Interpolator interpolator, final EndAction endAction) {
        return this.createAnimation(duration, 1.0, Animation.RepeatBehavior.LOOP, glyph, Animation.Dimension.FILLCOLOR, new DefaultTimingHandler(){
            private float startH = Float.MIN_VALUE;
            private float startS = Float.MIN_VALUE;
            private float startV = Float.MIN_VALUE;
            private float endH = Float.MIN_VALUE;
            private float endS = Float.MIN_VALUE;
            private float endV = Float.MIN_VALUE;

            @Override
            public void begin(Object subject, Animation.Dimension dim) {
                float[] startColor = glyph.getHSVColor();
                this.startH = startColor[0];
                this.startS = startColor[1];
                this.startV = startColor[2];
                this.endH = relative ? this.startH + data[0] : data[0];
                this.endS = relative ? this.startS + data[1] : data[1];
                this.endV = relative ? this.startV + data[2] : data[2];
            }

            @Override
            public void end(Object subject, Animation.Dimension dim) {
                if (null != endAction) {
                    endAction.execute(subject, dim);
                }
            }

            @Override
            public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                glyph.setHSVColor(this.startH + fraction * (this.endH - this.startH), this.startS + fraction * (this.endS - this.startS), this.startV + fraction * (this.endV - this.startV));
            }
        }, interpolator);
    }

    public Animation createGlyphBorderColorAnim(int duration, final Glyph glyph, final float[] data, final boolean relative, Interpolator interpolator, final EndAction endAction) {
        return this.createAnimation(duration, 1.0, Animation.RepeatBehavior.LOOP, glyph, Animation.Dimension.BORDERCOLOR, new DefaultTimingHandler(){
            private float startH = Float.MIN_VALUE;
            private float startS = Float.MIN_VALUE;
            private float startV = Float.MIN_VALUE;
            private float endH = Float.MIN_VALUE;
            private float endS = Float.MIN_VALUE;
            private float endV = Float.MIN_VALUE;

            @Override
            public void begin(Object subject, Animation.Dimension dim) {
                float[] startColor = glyph.getHSVbColor();
                this.startH = startColor[0];
                this.startS = startColor[1];
                this.startV = startColor[2];
                this.endH = relative ? this.startH + data[0] : data[0];
                this.endS = relative ? this.startS + data[1] : data[1];
                this.endV = relative ? this.startV + data[2] : data[2];
            }

            @Override
            public void end(Object subject, Animation.Dimension dim) {
                if (null != endAction) {
                    endAction.execute(subject, dim);
                }
            }

            @Override
            public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                glyph.setHSVbColor(this.startH + fraction * (this.endH - this.startH), this.startS + fraction * (this.endS - this.startS), this.startV + fraction * (this.endV - this.startV));
            }
        }, interpolator);
    }

    public Animation createTranslucencyAnim(int duration, final Translucent translucent, final float data, final boolean relative, Interpolator interpolator, final EndAction endAction) {
        return this.createAnimation(duration, 1.0, Animation.RepeatBehavior.LOOP, translucent, Animation.Dimension.TRANSLUCENCY, new DefaultTimingHandler(){
            private float startA = Float.MIN_VALUE;
            private float endA = Float.MIN_VALUE;

            @Override
            public void begin(Object subject, Animation.Dimension dim) {
                this.startA = translucent.getTranslucencyValue();
                this.endA = relative ? this.startA + data : data;
            }

            @Override
            public void end(Object subject, Animation.Dimension dim) {
                if (null != endAction) {
                    endAction.execute(subject, dim);
                }
            }

            @Override
            public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                translucent.setTranslucencyValue(this.startA + fraction * (this.endA - this.startA));
            }
        }, interpolator);
    }

    public Animation createPortalTranslation(int duration, final Portal portal, final Point data, final boolean relative, Interpolator interpolator, final EndAction endAction) {
        return this.createAnimation(duration, 1.0, Animation.RepeatBehavior.LOOP, portal, Animation.Dimension.POSITION, new DefaultTimingHandler(){
            private int startX = Integer.MIN_VALUE;
            private int startY = Integer.MIN_VALUE;
            private int endX = Integer.MIN_VALUE;
            private int endY = Integer.MIN_VALUE;

            @Override
            public void begin(Object subject, Animation.Dimension dim) {
                this.startX = portal.x;
                this.startY = portal.y;
                this.endX = relative ? portal.x + data.x : data.x;
                this.endY = relative ? portal.y + data.y : data.y;
            }

            @Override
            public void end(Object subject, Animation.Dimension dim) {
                if (null != endAction) {
                    endAction.execute(subject, dim);
                }
            }

            @Override
            public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                portal.moveTo(this.startX + (int)(fraction * (float)(this.endX - this.startX)), this.startY + (int)(fraction * (float)(this.endY - this.startY)));
            }
        }, interpolator);
    }

    public Animation createPortalSizeAnim(int duration, final Portal portal, final int wdata, final int hdata, final boolean relative, Interpolator interpolator, final EndAction endAction) {
        return this.createAnimation(duration, 1.0, Animation.RepeatBehavior.LOOP, portal, Animation.Dimension.SIZE, new DefaultTimingHandler(){
            private int startW = Integer.MIN_VALUE;
            private int startH = Integer.MIN_VALUE;
            private int endW = Integer.MIN_VALUE;
            private int endH = Integer.MIN_VALUE;

            @Override
            public void begin(Object subject, Animation.Dimension dim) {
                this.startW = portal.w;
                this.startH = portal.h;
                this.endW = relative ? this.startW + wdata : wdata;
                this.endH = relative ? this.startH + hdata : hdata;
            }

            @Override
            public void end(Object subject, Animation.Dimension dim) {
                if (null != endAction) {
                    endAction.execute(subject, dim);
                }
            }

            @Override
            public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                portal.sizeTo(this.startW + (int)(fraction * (float)(this.endW - this.startW)), this.startH + (int)(fraction * (float)(this.endH - this.startH)));
            }
        }, interpolator);
    }

    public Animation createLensMagAnim(int duration, final FixedSizeLens lens, final float data, final boolean relative, Interpolator interpolator, final EndAction endAction) {
        return this.createAnimation(duration, 1.0, Animation.RepeatBehavior.LOOP, lens, Animation.Dimension.LENS_MAG, new DefaultTimingHandler(){
            private float startMag = Float.MIN_VALUE;
            private float endMag = Float.MIN_VALUE;

            @Override
            public void begin(Object subject, Animation.Dimension dim) {
                this.startMag = lens.getMaximumMagnification();
                float f = this.endMag = relative ? this.startMag + data : data;
                if (this.endMag > this.startMag) {
                    lens.setMagRasterDimensions(Math.round(2.0f * this.endMag * (float)lens.getOuterRadius()));
                }
            }

            @Override
            public void end(Object subject, Animation.Dimension dim) {
                if (null != endAction) {
                    endAction.execute(subject, dim);
                }
                if (this.endMag < this.startMag) {
                    lens.setMagRasterDimensions(Math.round(2.0f * this.endMag * (float)lens.getOuterRadius()));
                }
            }

            @Override
            public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                lens.setMaximumMagnification(this.startMag + fraction * (this.endMag - this.startMag), false);
            }
        }, interpolator);
    }

    public Animation createLensMagRadiusAnim(int duration, final FixedSizeLens lens, final float magData, final int orData, final int irData, final boolean relative, Interpolator interpolator, final EndAction endAction) {
        return this.createAnimation(duration, 1.0, Animation.RepeatBehavior.LOOP, lens, Animation.Dimension.LENS_MAG_RADIUS, new DefaultTimingHandler(){
            private float startMag = Float.MIN_VALUE;
            private float endMag = Float.MIN_VALUE;
            private int startOr = Integer.MIN_VALUE;
            private int endOr = Integer.MIN_VALUE;
            private int startIr = Integer.MIN_VALUE;
            private int endIr = Integer.MIN_VALUE;
            private int startBufSize = Integer.MIN_VALUE;
            private int endBufSize = Integer.MIN_VALUE;

            @Override
            public void begin(Object subject, Animation.Dimension dim) {
                this.startMag = lens.getMaximumMagnification();
                this.endMag = relative ? this.startMag + magData : magData;
                this.startOr = lens.getOuterRadius();
                this.endOr = relative ? this.startOr + orData : orData;
                this.startIr = lens.getInnerRadius();
                this.endIr = relative ? this.startIr + irData : irData;
                this.startBufSize = Math.round(2.0f * this.startMag * (float)this.startOr);
                this.endBufSize = Math.round(2.0f * this.endMag * (float)this.endOr);
                if (this.endBufSize > this.startBufSize) {
                    lens.setMagRasterDimensions(this.endBufSize);
                }
            }

            @Override
            public void end(Object subject, Animation.Dimension dim) {
                if (null != endAction) {
                    endAction.execute(subject, dim);
                }
                if (this.endBufSize < this.startBufSize) {
                    lens.setMagRasterDimensions(this.endBufSize);
                }
            }

            @Override
            public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                lens.setMMandRadii(this.startMag + fraction * (this.endMag - this.startMag), this.startOr + (int)(fraction * (float)(this.endOr - this.startOr)), this.startIr + (int)(fraction * (float)(this.endIr - this.startIr)), false);
            }
        }, interpolator);
    }

    public Animation createLensRadiusAnim(int duration, final FixedSizeLens lens, final int orData, final int irData, final boolean relative, Interpolator interpolator, final EndAction endAction) {
        return this.createAnimation(duration, 1.0, Animation.RepeatBehavior.LOOP, lens, Animation.Dimension.LENS_RADIUS, new DefaultTimingHandler(){
            private float mag = Float.MIN_VALUE;
            private int startOr = Integer.MIN_VALUE;
            private int endOr = Integer.MIN_VALUE;
            private int startIr = Integer.MIN_VALUE;
            private int endIr = Integer.MIN_VALUE;
            private int startBufSize = Integer.MIN_VALUE;
            private int endBufSize = Integer.MIN_VALUE;

            @Override
            public void begin(Object subject, Animation.Dimension dim) {
                this.mag = lens.getMaximumMagnification();
                this.startOr = lens.getOuterRadius();
                this.endOr = relative ? this.startOr + orData : orData;
                this.startIr = lens.getInnerRadius();
                this.endIr = relative ? this.startIr + irData : irData;
                this.startBufSize = Math.round(2.0f * this.mag * (float)this.startOr);
                this.endBufSize = Math.round(2.0f * this.mag * (float)this.endOr);
                if (this.endBufSize > this.startBufSize) {
                    lens.setMagRasterDimensions(this.endBufSize);
                }
            }

            @Override
            public void end(Object subject, Animation.Dimension dim) {
                if (null != endAction) {
                    endAction.execute(subject, dim);
                }
                if (this.endBufSize < this.startBufSize) {
                    lens.setMagRasterDimensions(this.endBufSize);
                }
            }

            @Override
            public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                lens.setRadii(this.startOr + (int)(fraction * (float)(this.endOr - this.startOr)), this.startIr + (int)(fraction * (float)(this.endIr - this.startIr)), false);
            }
        }, interpolator);
    }

    public Animation createPathAnim(int duration, final DPath path, final Point2D.Double[] data, final boolean relative, Interpolator interpolator, final EndAction endAction) {
        return this.createAnimation(duration, 1.0, Animation.RepeatBehavior.LOOP, path, Animation.Dimension.PATH, new DefaultTimingHandler(){
            private Point2D.Double[] startPoints;
            private Point2D.Double[] endPoints;
            private Point2D.Double[] coords;
            private Point2D.Double[] tempPoints;

            @Override
            public void begin(Object subject, Animation.Dimension dim) {
                if (data.length != path.getNumberOfPoints()) {
                    throw new IllegalStateException("'data' element count must be equal to the path element count");
                }
                this.startPoints = new Point2D.Double[path.getNumberOfPoints()];
                this.endPoints = new Point2D.Double[this.startPoints.length];
                this.tempPoints = new Point2D.Double[this.startPoints.length];
                this.coords = path.getAllPointsCoordinates();
                System.arraycopy(this.coords, 0, this.startPoints, 0, this.coords.length);
                for (int i = 0; i < this.startPoints.length; ++i) {
                    this.endPoints[i] = new Point2D.Double(relative ? this.startPoints[i].x + data[i].x : data[i].x, relative ? this.startPoints[i].y + data[i].y : data[i].y);
                    this.tempPoints[i] = new Point2D.Double();
                }
            }

            @Override
            public void end(Object subject, Animation.Dimension dim) {
                if (null != endAction) {
                    endAction.execute(subject, dim);
                }
            }

            @Override
            public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
                for (int i = 0; i < this.tempPoints.length; ++i) {
                    this.tempPoints[i].x = this.startPoints[i].x + (double)fraction * (this.endPoints[i].x - this.startPoints[i].x);
                    this.tempPoints[i].y = this.startPoints[i].y + (double)fraction * (this.endPoints[i].y - this.startPoints[i].y);
                    path.edit(this.tempPoints, true);
                }
            }
        }, interpolator);
    }
}

