/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.CBCElement;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.MOVElement;
import fr.inria.zvtm.glyphs.PathElement;
import fr.inria.zvtm.glyphs.QDCElement;
import fr.inria.zvtm.glyphs.RectangularShape;
import fr.inria.zvtm.glyphs.SEGElement;
import fr.inria.zvtm.glyphs.projection.ProjectedCoords;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Arrays;

public class DPath<T>
extends Glyph
implements RectangularShape {
    public static final short DRAW_GENERAL_PATH = 0;
    public static final short DRAW_SUBPATHS = 1;
    short drawingMethod = 0;
    static final short MOV = 0;
    static final short SEG = 1;
    static final short QDC = 2;
    static final short CBC = 3;
    public ProjectedCoords[] pc;
    PathElement[] elements;
    Point2D.Double endPoint;
    double spx;
    double spy;
    public double vw;
    public double vh;
    GeneralPath gp;
    GeneralPath dgp;
    int hw;
    int hh;
    int lhw;
    int lhh;

    public DPath() {
        this(0.0, 0.0, 0, Color.BLACK);
    }

    public DPath(int z) {
        this(0.0, 0.0, z, Color.BLACK);
    }

    public DPath(double x, double y, int z, Color c) {
        this(x, y, z, c, 1.0f);
    }

    public DPath(double x, double y, int z, Color c, float alpha) {
        this(x, y, z, c, alpha, 0);
    }

    public DPath(double x, double y, int z, Color c, float alpha, short m) {
        this.spx = x;
        this.spy = y;
        this.vz = z;
        this.endPoint = new Point2D.Double(this.spx, this.spy);
        this.vx = this.spx;
        this.vy = this.spy;
        this.elements = new PathElement[0];
        this.computeBounds();
        this.updateJava2DGeneralPath();
        this.sensit = true;
        this.setColor(c);
        this.setTranslucencyValue(alpha);
        this.setDrawingMethod(m);
    }

    public DPath(PathIterator pi, int z, Color c) {
        this(pi, z, c, 1.0f);
    }

    public DPath(PathIterator pi, int z, Color c, float alpha) {
        this.vz = z;
        this.setPath(pi);
        this.sensit = true;
        this.setColor(c);
        this.setTranslucencyValue(alpha);
    }

    public void setPath(PathIterator pi) {
        double[] cds = new double[6];
        if (pi.currentSegment(cds) == 0) {
            this.spx = cds[0];
            this.spy = cds[1];
            pi.next();
        } else {
            this.spx = 0.0;
            this.spy = 0.0;
        }
        this.endPoint = new Point2D.Double(this.spx, this.spy);
        this.vx = this.spx;
        this.vy = this.spy;
        this.elements = new PathElement[0];
        while (!pi.isDone()) {
            int type = pi.currentSegment(cds);
            switch (type) {
                case 3: {
                    this.addCbCurve(cds[4], cds[5], cds[0], cds[1], cds[2], cds[3], true);
                    break;
                }
                case 2: {
                    this.addQdCurve(cds[2], cds[3], cds[0], cds[1], true);
                    break;
                }
                case 1: {
                    this.addSegment(cds[0], cds[1], true);
                    break;
                }
                case 0: {
                    this.jump(cds[0], cds[1], true);
                }
            }
            pi.next();
        }
    }

    public void addCbCurve(double x, double y, double x1, double y1, double x2, double y2, boolean abs) {
        CBCElement e;
        if (abs) {
            e = new CBCElement(x, y, x1, y1, x2, y2, this.pc != null ? this.pc.length : 0);
            this.endPoint.setLocation(x, y);
        } else {
            e = new CBCElement(this.endPoint.x + x, this.endPoint.y + y, this.endPoint.x + x1, this.endPoint.y + y1, this.endPoint.x + x2, this.endPoint.y + y2, this.pc != null ? this.pc.length : 0);
            this.endPoint.setLocation(this.endPoint.x + x, this.endPoint.y + y);
        }
        PathElement[] tmp = new PathElement[this.elements.length + 1];
        System.arraycopy(this.elements, 0, tmp, 0, this.elements.length);
        tmp[this.elements.length] = e;
        Arrays.fill(this.elements, null);
        this.elements = tmp;
        this.computeBounds();
        this.updateJava2DGeneralPath();
    }

    public void addQdCurve(double x, double y, double x1, double y1, boolean abs) {
        QDCElement e;
        if (abs) {
            e = new QDCElement(x, y, x1, y1, this.pc != null ? this.pc.length : 0);
            this.endPoint.setLocation(x, y);
        } else {
            e = new QDCElement(this.endPoint.x + x, this.endPoint.y + y, this.endPoint.x + x1, this.endPoint.y + y1, this.pc != null ? this.pc.length : 0);
            this.endPoint.setLocation(this.endPoint.x + x, this.endPoint.y + y);
        }
        PathElement[] tmp = new PathElement[this.elements.length + 1];
        System.arraycopy(this.elements, 0, tmp, 0, this.elements.length);
        tmp[this.elements.length] = e;
        Arrays.fill(this.elements, null);
        this.elements = tmp;
        this.computeBounds();
        this.updateJava2DGeneralPath();
    }

    public void addSegment(double x, double y, boolean abs) {
        if (abs) {
            this.endPoint.setLocation(x, y);
        } else {
            this.endPoint.setLocation(this.endPoint.x + x, this.endPoint.y + y);
        }
        PathElement[] tmp = new PathElement[this.elements.length + 1];
        System.arraycopy(this.elements, 0, tmp, 0, this.elements.length);
        tmp[this.elements.length] = new SEGElement(this.endPoint.x, this.endPoint.y, this.pc != null ? this.pc.length : 0);
        Arrays.fill(this.elements, null);
        this.elements = tmp;
        this.computeBounds();
        this.updateJava2DGeneralPath();
    }

    public void jump(double x, double y, boolean abs) {
        if (abs) {
            this.endPoint.setLocation(x, y);
        } else {
            this.endPoint.setLocation(this.endPoint.x + x, this.endPoint.y + y);
        }
        if (this.elements.length == 0) {
            this.spx = this.vx = this.endPoint.x;
            this.spy = this.vy = this.endPoint.y;
        } else {
            PathElement[] tmp = new PathElement[this.elements.length + 1];
            System.arraycopy(this.elements, 0, tmp, 0, this.elements.length);
            tmp[this.elements.length] = new MOVElement(this.endPoint.x, this.endPoint.y, this.pc != null ? this.pc.length : 0);
            Arrays.fill(this.elements, null);
            this.elements = tmp;
        }
        this.computeBounds();
        this.updateJava2DGeneralPath();
    }

    @Override
    public double getWidth() {
        return this.vw;
    }

    @Override
    public double getHeight() {
        return this.vh;
    }

    @Override
    public void setWidth(double w) {
    }

    @Override
    public void setHeight(double h) {
    }

    public Point2D.Double getStartPoint() {
        return new Point2D.Double(this.spx, this.spy);
    }

    public Point2D.Double getEndPoint() {
        return new Point2D.Double(this.endPoint.x, this.endPoint.y);
    }

    public double getStartPointX() {
        return this.spx;
    }

    public double getStartPointY() {
        return this.spy;
    }

    public double getEndPointX() {
        return this.endPoint.x;
    }

    public double getEndPointY() {
        return this.endPoint.y;
    }

    @Override
    public void initCams(int nbCam) {
        int i;
        this.pc = new ProjectedCoords[nbCam];
        for (i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjectedCoords();
        }
        for (i = 0; i < this.elements.length; ++i) {
            this.elements[i].initCams(nbCam);
        }
    }

    @Override
    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjectedCoords[] ta = this.pc;
                this.pc = new ProjectedCoords[ta.length + 1];
                System.arraycopy(ta, 0, this.pc, 0, ta.length);
                this.pc[this.pc.length - 1] = new ProjectedCoords();
            } else {
                System.err.println("DPath:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjectedCoords[1];
            this.pc[0] = new ProjectedCoords();
        } else {
            System.err.println("DPath:Error while adding camera " + verifIndex);
        }
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i].addCamera(verifIndex);
        }
    }

    @Override
    public void removeCamera(int index) {
        this.pc[index] = null;
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i].removeCamera(index);
        }
    }

    @Override
    public void resetMouseIn() {
    }

    @Override
    public void resetMouseIn(int i) {
    }

    @Override
    public void sizeTo(double s) {
    }

    @Override
    public void reSize(double factor) {
    }

    @Override
    public void move(double x, double y) {
        Object[] t = new Point2D.Double[this.getNumberOfPoints()];
        Arrays.fill(t, new Point2D.Double(x, y));
        this.edit((Point2D.Double[])t, false);
        this.propagateMove(x, y);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void moveTo(double x, double y) {
        this.propagateMove(x - this.vx, y - this.vy);
        Object[] t = new Point2D.Double[this.getNumberOfPoints()];
        Arrays.fill(t, new Point2D.Double(x - this.vx, y - this.vy));
        this.edit((Point2D.Double[])t, false);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void orientTo(double angle) {
    }

    @Override
    public double getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = Math.sqrt(this.vw * this.vw + this.vh * this.vh);
    }

    public void computeBounds() {
        Point2D.Double[] allPoints = this.getAllPointsCoordinates();
        if (allPoints.length == 0) {
            this.vx = this.spx;
            this.vy = this.spy;
            this.vw = 0.0;
            this.vh = 0.0;
            return;
        }
        double[] wnes = new double[]{allPoints[0].x, allPoints[0].y, allPoints[0].x, allPoints[0].y};
        for (int i = 1; i < allPoints.length; ++i) {
            if (allPoints[i].x < wnes[0]) {
                wnes[0] = allPoints[i].x;
            }
            if (allPoints[i].x > wnes[2]) {
                wnes[2] = allPoints[i].x;
            }
            if (allPoints[i].y < wnes[3]) {
                wnes[3] = allPoints[i].y;
            }
            if (!(allPoints[i].y > wnes[1])) continue;
            wnes[1] = allPoints[i].y;
        }
        this.vx = (wnes[0] + wnes[2]) / 2.0;
        this.vy = (wnes[1] + wnes[3]) / 2.0;
        this.vw = wnes[2] - wnes[0];
        this.vh = wnes[1] - wnes[3];
        this.computeSize();
    }

    @Override
    public double[] getBounds() {
        double[] res = new double[]{this.vx - this.vw / 2.0, this.vy + this.vh / 2.0, this.vx + this.vw / 2.0, this.vy - this.vh / 2.0};
        return res;
    }

    public boolean coordsInsideBoundingBox(double x, double y) {
        return x >= this.vx - this.vw / 2.0 && x <= this.vx + this.vw / 2.0 && y >= this.vy - this.vh / 2.0 && y <= this.vy + this.vh / 2.0;
    }

    @Override
    public double getOrient() {
        return this.orient;
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return false;
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return false;
    }

    @Override
    public short mouseInOut(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return 0;
    }

    @Override
    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.hw = d.width / 2;
        this.hh = d.height / 2;
        this.pc[i].cx = this.hw + (int)Math.round((this.spx - c.vx) * this.coef);
        this.pc[i].cy = this.hh - (int)Math.round((this.spy - c.vy) * this.coef);
        if (this.elements.length == 0) {
            return;
        }
        this.elements[0].project(i, this.hw, this.hh, c, this.coef, this.pc[i].cx, this.pc[i].cy);
        for (int j = 1; j < this.elements.length; ++j) {
            this.elements[j].project(i, this.hw, this.hh, c, this.coef, this.elements[j - 1].getX(i), this.elements[j - 1].getY(i));
        }
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.lhw = lensWidth / 2;
        this.lhh = lensHeight / 2;
        this.pc[i].lcx = this.lhw + (int)Math.round((this.spx - lensx) * this.coef);
        this.pc[i].lcy = this.lhh - (int)Math.round((this.spy - lensy) * this.coef);
        if (this.elements.length == 0) {
            return;
        }
        this.elements[0].projectForLens(i, this.lhw, this.lhh, lensx, lensy, this.coef, this.pc[i].lcx, this.pc[i].lcy);
        for (int j = 1; j < this.elements.length; ++j) {
            this.elements[j].projectForLens(i, this.lhw, this.lhh, lensx, lensy, this.coef, this.elements[j - 1].getlX(i), this.elements[j - 1].getlY(i));
        }
    }

    public void setDrawingMethod(short m) {
        this.drawingMethod = m;
    }

    public short getDrawingMethod() {
        return this.drawingMethod;
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        g.setColor(this.color);
        if (this.coef * this.vw >= 1.0 || this.coef * this.vh >= 1.0) {
            if (this.drawingMethod == 0) {
                AffineTransform atgp = AffineTransform.getTranslateInstance(dx + this.pc[i].cx, dy + this.pc[i].cy);
                atgp.concatenate(AffineTransform.getScaleInstance(this.coef, this.coef));
                g.setTransform(atgp);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    if (this.alphaC != null) {
                        g.setComposite(this.alphaC);
                        g.draw(this.dgp);
                        g.setComposite(acO);
                    } else {
                        g.draw(this.dgp);
                    }
                    g.setStroke(stdS);
                } else if (this.alphaC != null) {
                    g.setComposite(this.alphaC);
                    g.draw(this.dgp);
                    g.setComposite(acO);
                } else {
                    g.draw(this.dgp);
                }
                g.setTransform(stdT);
            } else if (this.stroke != null) {
                g.translate(dx, dy);
                g.setStroke(this.stroke);
                if (this.alphaC != null) {
                    g.setComposite(this.alphaC);
                    for (int j = 0; j < this.elements.length; ++j) {
                        if (this.elements[j].type == 0) continue;
                        g.draw(this.elements[j].getShape(i));
                    }
                    g.setComposite(acO);
                } else {
                    for (int j = 0; j < this.elements.length; ++j) {
                        if (this.elements[j].type == 0) continue;
                        g.draw(this.elements[j].getShape(i));
                    }
                }
                g.translate(-dx, -dy);
                g.setStroke(stdS);
            } else {
                g.translate(dx, dy);
                if (this.alphaC != null) {
                    g.setComposite(this.alphaC);
                    for (int j = 0; j < this.elements.length; ++j) {
                        if (this.elements[j].type == 0) continue;
                        g.draw(this.elements[j].getShape(i));
                    }
                    g.setComposite(acO);
                } else {
                    for (int j = 0; j < this.elements.length; ++j) {
                        if (this.elements[j].type == 0) continue;
                        g.draw(this.elements[j].getShape(i));
                    }
                }
                g.translate(-dx, -dy);
            }
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        g.setColor(this.color);
        if (this.coef * this.vw >= 1.0 || this.coef * this.vh >= 1.0) {
            if (this.drawingMethod == 0) {
                AffineTransform atgp = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx, dy + this.pc[i].lcy);
                atgp.concatenate(AffineTransform.getScaleInstance(this.coef, this.coef));
                g.setTransform(atgp);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    if (this.alphaC != null) {
                        g.setComposite(this.alphaC);
                        g.draw(this.dgp);
                        g.setComposite(acO);
                    } else {
                        g.draw(this.dgp);
                    }
                    g.setStroke(stdS);
                } else if (this.alphaC != null) {
                    g.setComposite(this.alphaC);
                    g.draw(this.dgp);
                    g.setComposite(acO);
                } else {
                    g.draw(this.dgp);
                }
                g.setTransform(stdT);
            } else if (this.stroke != null) {
                g.translate(dx, dy);
                g.setStroke(this.stroke);
                if (this.alphaC != null) {
                    g.setComposite(this.alphaC);
                    for (int j = 0; j < this.elements.length; ++j) {
                        if (this.elements[j].type == 0) continue;
                        g.draw(this.elements[j].getlShape(i));
                    }
                    g.setComposite(acO);
                } else {
                    for (int j = 0; j < this.elements.length; ++j) {
                        if (this.elements[j].type == 0) continue;
                        g.draw(this.elements[j].getlShape(i));
                    }
                }
                g.translate(-dx, -dy);
                g.setStroke(stdS);
            } else {
                g.translate(dx, dy);
                if (this.alphaC != null) {
                    g.setComposite(this.alphaC);
                    for (int j = 0; j < this.elements.length; ++j) {
                        if (this.elements[j].type == 0) continue;
                        g.draw(this.elements[j].getlShape(i));
                    }
                    g.setComposite(acO);
                } else {
                    for (int j = 0; j < this.elements.length; ++j) {
                        if (this.elements[j].type == 0) continue;
                        g.draw(this.elements[j].getlShape(i));
                    }
                }
                g.translate(-dx, -dy);
            }
        }
    }

    @Override
    public boolean visibleInRegion(double wb, double nb, double eb, double sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        return this.vx - this.vw / 2.0 <= eb && this.vx + this.vw / 2.0 >= wb && this.vy - this.vh / 2.0 <= nb && this.vy + this.vh / 2.0 >= sb;
    }

    @Override
    public boolean containedInRegion(double wb, double nb, double eb, double sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        return this.vx + this.vw / 2.0 <= eb && this.vx - this.vw / 2.0 >= wb && this.vy + this.vh / 2.0 <= nb && this.vy - this.vh / 2.0 >= sb;
    }

    @Override
    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return this.gp.intersects(dvx - dvr, dvy - dvr, 2.0 * dvr, 2.0 * dvr) && !this.gp.contains(dvx - dvr, dvy - dvr, 2.0 * dvr, 2.0 * dvr);
    }

    @Override
    public Object clone() {
        DPath<T> res = new DPath<T>(this.getJava2DPathIterator(), this.vz, this.color, this.alphaC != null ? this.alphaC.getAlpha() : 1.0f);
        return res;
    }

    @Override
    public void highlight(boolean b, Color selectedColor) {
        boolean update = false;
        if (b) {
            if (this.cursorInsideColor != null) {
                this.color = this.cursorInsideColor;
                update = true;
            }
        } else if (this.isSelected() && selectedColor != null) {
            this.color = selectedColor;
            update = true;
        } else if (this.cursorInsideColor != null) {
            this.color = this.fColor;
            update = true;
        }
        if (update) {
            VirtualSpaceManager.INSTANCE.repaint();
        }
    }

    public void editElement(int index, double sx, double sy, double ex, double ey, Point2D.Double[] ctrlPoints, boolean abs) {
        if (index > -1 && index < this.elements.length && this.elements[index] != null) {
            if (index > 0) {
                if (abs) {
                    this.elements[index - 1].x = sx;
                    this.elements[index - 1].y = sy;
                } else {
                    this.elements[index - 1].x += sx;
                    this.elements[index - 1].y += sy;
                }
            } else if (abs) {
                this.spx = sx;
                this.spy = sy;
            } else {
                this.spx += sx;
                this.spy += sy;
            }
            PathElement el = this.elements[index];
            switch (el.type) {
                case 2: {
                    if (ctrlPoints == null || ctrlPoints.length <= 0 || ctrlPoints[0] == null) break;
                    if (abs) {
                        ((QDCElement)el).ctrlx = ctrlPoints[0].x;
                        ((QDCElement)el).ctrly = ctrlPoints[0].y;
                        break;
                    }
                    ((QDCElement)el).ctrlx += ctrlPoints[0].x;
                    ((QDCElement)el).ctrly += ctrlPoints[0].y;
                    break;
                }
                case 3: {
                    if (ctrlPoints == null || ctrlPoints.length <= 1 || ctrlPoints[0] == null || ctrlPoints[1] == null) break;
                    if (abs) {
                        ((CBCElement)el).ctrlx1 = ctrlPoints[0].x;
                        ((CBCElement)el).ctrly1 = ctrlPoints[0].y;
                        ((CBCElement)el).ctrlx2 = ctrlPoints[1].x;
                        ((CBCElement)el).ctrly2 = ctrlPoints[1].y;
                        break;
                    }
                    ((CBCElement)el).ctrlx1 += ctrlPoints[0].x;
                    ((CBCElement)el).ctrly1 += ctrlPoints[0].y;
                    ((CBCElement)el).ctrlx2 += ctrlPoints[1].x;
                    ((CBCElement)el).ctrly2 += ctrlPoints[1].y;
                }
            }
            if (abs) {
                el.x = ex;
                el.y = ey;
            } else {
                el.x += ex;
                el.y += ey;
            }
            if (index == this.elements.length - 1) {
                this.endPoint = new Point2D.Double(el.x, el.y);
            }
        }
        this.computeBounds();
        this.updateJava2DGeneralPath();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public void edit(Point2D.Double[] points, boolean abs) {
        int totalPointsCount = 1;
        block8: for (int i = 0; i < this.elements.length; ++i) {
            ++totalPointsCount;
            switch (this.elements[i].type) {
                case 3: {
                    totalPointsCount += 2;
                    continue block8;
                }
                case 2: {
                    ++totalPointsCount;
                }
            }
        }
        if (points != null && points.length == totalPointsCount) {
            if (abs) {
                this.spx = points[0].x;
                this.spy = points[0].y;
            } else {
                this.spx += points[0].x;
                this.spy += points[0].y;
            }
            int offset = 0;
            for (int i = 0; i < this.elements.length; ++i) {
                switch (this.elements[i].type) {
                    case 3: {
                        if (abs) {
                            ((CBCElement)this.elements[i]).ctrlx1 = points[i + 1 + offset].x;
                            ((CBCElement)this.elements[i]).ctrly1 = points[i + 1 + offset].y;
                            ((CBCElement)this.elements[i]).ctrlx2 = points[i + 2 + offset].x;
                            ((CBCElement)this.elements[i]).ctrly2 = points[i + 2 + offset].y;
                            this.elements[i].x = points[i + 3 + offset].x;
                            this.elements[i].y = points[i + 3 + offset].y;
                        } else {
                            ((CBCElement)this.elements[i]).ctrlx1 += points[i + 1 + offset].x;
                            ((CBCElement)this.elements[i]).ctrly1 += points[i + 1 + offset].y;
                            ((CBCElement)this.elements[i]).ctrlx2 += points[i + 2 + offset].x;
                            ((CBCElement)this.elements[i]).ctrly2 += points[i + 2 + offset].y;
                            this.elements[i].x += points[i + 3 + offset].x;
                            this.elements[i].y += points[i + 3 + offset].y;
                        }
                        offset += 2;
                        break;
                    }
                    case 2: {
                        if (abs) {
                            ((QDCElement)this.elements[i]).ctrlx = points[i + 1 + offset].x;
                            ((QDCElement)this.elements[i]).ctrly = points[i + 1 + offset].y;
                            this.elements[i].x = points[i + 2 + offset].x;
                            this.elements[i].y = points[i + 2 + offset].y;
                        } else {
                            ((QDCElement)this.elements[i]).ctrlx += points[i + 1 + offset].x;
                            ((QDCElement)this.elements[i]).ctrly += points[i + 1 + offset].y;
                            this.elements[i].x += points[i + 2 + offset].x;
                            this.elements[i].y += points[i + 2 + offset].y;
                        }
                        ++offset;
                        break;
                    }
                    default: {
                        if (abs) {
                            this.elements[i].x = points[i + 1 + offset].x;
                            this.elements[i].y = points[i + 1 + offset].y;
                            break;
                        }
                        this.elements[i].x += points[i + 1 + offset].x;
                        this.elements[i].y += points[i + 1 + offset].y;
                    }
                }
                if (i != this.elements.length - 1) continue;
                this.endPoint = new Point2D.Double(this.elements[i].x, this.elements[i].y);
            }
        }
        this.computeBounds();
        this.updateJava2DGeneralPath();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public int getElementsCount() {
        if (this.elements != null) {
            return this.elements.length;
        }
        return 0;
    }

    public int getElementType(int index) {
        if (this.elements != null && index > -1 && index < this.elements.length && this.elements[index] != null) {
            return this.elements[index].type;
        }
        return -1;
    }

    public Point2D.Double[] getElementPointsCoordinates(int index) {
        Point2D.Double[] result = null;
        if (this.elements != null && index > -1 && index < this.elements.length && this.elements[index] != null) {
            switch (this.elements[index].type) {
                case 3: {
                    result = new Point2D.Double[4];
                    result[0] = index == 0 ? new Point2D.Double(this.spx, this.spy) : new Point2D.Double(this.elements[index - 1].x, this.elements[index - 1].y);
                    result[3] = new Point2D.Double(this.elements[index].x, this.elements[index].y);
                    result[1] = new Point2D.Double(((CBCElement)this.elements[index]).ctrlx1, ((CBCElement)this.elements[index]).ctrly1);
                    result[2] = new Point2D.Double(((CBCElement)this.elements[index]).ctrlx2, ((CBCElement)this.elements[index]).ctrly2);
                    break;
                }
                case 2: {
                    result = new Point2D.Double[3];
                    result[0] = index == 0 ? new Point2D.Double(this.spx, this.spy) : new Point2D.Double(this.elements[index - 1].x, this.elements[index - 1].y);
                    result[2] = new Point2D.Double(this.elements[index].x, this.elements[index].y);
                    result[1] = new Point2D.Double(((QDCElement)this.elements[index]).ctrlx, ((QDCElement)this.elements[index]).ctrly);
                    break;
                }
                default: {
                    result = new Point2D.Double[]{index == 0 ? new Point2D.Double(this.spx, this.spy) : new Point2D.Double(this.elements[index - 1].x, this.elements[index - 1].y), new Point2D.Double(this.elements[index].x, this.elements[index].y)};
                }
            }
        }
        return result;
    }

    public int getNumberOfPoints() {
        int totalNumberOfPoints = 1;
        block4: for (int i = 0; i < this.elements.length; ++i) {
            ++totalNumberOfPoints;
            short type = this.elements[i].type;
            switch (type) {
                case 3: {
                    totalNumberOfPoints += 2;
                    continue block4;
                }
                case 2: {
                    ++totalNumberOfPoints;
                }
            }
        }
        return totalNumberOfPoints;
    }

    public Point2D.Double[] getAllPointsCoordinates() {
        int totalNumberOfPoints = this.getNumberOfPoints();
        Point2D.Double[] result = new Point2D.Double[totalNumberOfPoints];
        int offset = 0;
        result[0] = new Point2D.Double(this.spx, this.spy);
        block4: for (int i = 0; i < this.elements.length; ++i) {
            switch (this.elements[i].type) {
                case 3: {
                    PathElement el = (CBCElement)this.elements[i];
                    result[i + 1 + offset] = new Point2D.Double(el.ctrlx1, el.ctrly1);
                    result[i + 2 + offset] = new Point2D.Double(el.ctrlx2, el.ctrly2);
                    result[i + 3 + offset] = new Point2D.Double(el.x, el.y);
                    offset += 2;
                    continue block4;
                }
                case 2: {
                    PathElement el = (QDCElement)this.elements[i];
                    result[i + 1 + offset] = new Point2D.Double(((QDCElement)el).ctrlx, ((QDCElement)el).ctrly);
                    result[i + 2 + offset] = new Point2D.Double(((QDCElement)el).x, ((QDCElement)el).y);
                    ++offset;
                    continue block4;
                }
                default: {
                    result[i + 1 + offset] = new Point2D.Double(this.elements[i].x, this.elements[i].y);
                }
            }
        }
        return result;
    }

    public static Point2D.Double[] getFlattenedCoordinates(DPath path, Point2D.Double startPoint, Point2D.Double endPoint, boolean abs) {
        Point2D.Double[] result = path.getAllPointsCoordinates();
        if (!abs) {
            startPoint = new Point2D.Double(result[0].x + startPoint.x, result[0].y + startPoint.y);
            endPoint = new Point2D.Double(result[result.length - 1].x + endPoint.x, result[result.length - 1].y + endPoint.y);
        }
        double dx = (endPoint.x - startPoint.x) / (double)result.length;
        double dy = (endPoint.y - startPoint.y) / (double)result.length;
        for (int i = 0; i < result.length - 1; ++i) {
            result[i].x = startPoint.x + (double)i * dx;
            result[i].y = startPoint.y + (double)i * dy;
        }
        result[result.length - 1].x = endPoint.x;
        result[result.length - 1].y = endPoint.y;
        return result;
    }

    public PathIterator getSVGPathIterator() {
        GeneralPath res = new GeneralPath();
        res.moveTo((float)this.spx, (float)(-this.spy));
        block6: for (int i = 0; i < this.getElementsCount(); ++i) {
            int elType = this.getElementType(i);
            Point2D.Double[] pts = this.getElementPointsCoordinates(i);
            switch (elType) {
                case 3: {
                    res.curveTo((float)pts[1].x, (float)(-pts[1].y), (float)pts[2].x, (float)(-pts[2].y), (float)pts[3].x, (float)(-pts[3].y));
                    continue block6;
                }
                case 2: {
                    res.quadTo((float)pts[1].x, (float)(-pts[1].y), (float)pts[2].x, (float)(-pts[2].y));
                    continue block6;
                }
                case 1: {
                    res.lineTo((float)pts[1].x, (float)(-pts[1].y));
                    continue block6;
                }
                case 0: {
                    res.moveTo((float)pts[1].x, (float)(-pts[1].y));
                }
            }
        }
        return res.getPathIterator(null);
    }

    public void updateJava2DGeneralPath() {
        this.gp = new GeneralPath();
        this.gp.moveTo((float)this.spx, (float)this.spy);
        this.dgp = new GeneralPath();
        this.dgp.moveTo(0.0f, 0.0f);
        block6: for (int i = 0; i < this.getElementsCount(); ++i) {
            int elType = this.getElementType(i);
            Point2D.Double[] pts = this.getElementPointsCoordinates(i);
            switch (elType) {
                case 3: {
                    this.gp.curveTo((float)pts[1].x, (float)pts[1].y, (float)pts[2].x, (float)pts[2].y, (float)pts[3].x, (float)pts[3].y);
                    this.dgp.curveTo((float)(pts[1].x - this.spx), (float)(-pts[1].y + this.spy), (float)(pts[2].x - this.spx), (float)(-pts[2].y + this.spy), (float)(pts[3].x - this.spx), (float)(-pts[3].y + this.spy));
                    continue block6;
                }
                case 2: {
                    this.gp.quadTo((float)pts[1].x, (float)pts[1].y, (float)pts[2].x, (float)pts[2].y);
                    this.dgp.quadTo((float)(pts[1].x - this.spx), (float)(-pts[1].y + this.spy), (float)(pts[2].x - this.spx), (float)(-pts[2].y + this.spy));
                    continue block6;
                }
                case 1: {
                    this.gp.lineTo((float)pts[1].x, (float)pts[1].y);
                    this.dgp.lineTo((float)(pts[1].x - this.spx), (float)(-pts[1].y + this.spy));
                    continue block6;
                }
                case 0: {
                    this.gp.moveTo((float)pts[1].x, (float)pts[1].y);
                    this.dgp.moveTo((float)(pts[1].x - this.spx), (float)(-pts[1].y + this.spy));
                }
            }
        }
    }

    public GeneralPath getJava2DGeneralPath() {
        return this.gp;
    }

    @Override
    public Shape getJava2DShape() {
        return this.getJava2DGeneralPath();
    }

    public PathIterator getJava2DPathIterator() {
        return this.gp.getPathIterator(null);
    }

    public double getStartTangentOrientation() {
        double res = 0.0;
        if (this.elements.length > 0) {
            PathElement el = this.elements[0];
            double sx = 0.0;
            double sy = 0.0;
            switch (el.type) {
                case 3: {
                    sx = ((CBCElement)el).ctrlx1;
                    sy = ((CBCElement)el).ctrly1;
                    break;
                }
                case 2: {
                    sx = ((QDCElement)el).ctrlx;
                    sy = ((QDCElement)el).ctrly;
                    break;
                }
                default: {
                    sx = el.x;
                    sy = el.y;
                }
            }
            if (this.spx == sx) {
                res = this.spy > sy ? 1.5707963705062866 : 4.71238899230957;
            } else {
                double tan = (this.spy - sy) / (this.spx - sx);
                res = Math.atan(tan);
                if (this.spx < sx) {
                    res += Math.PI;
                }
                if (this.spx > sx && this.spy < sy) {
                    res += Math.PI * 2;
                }
            }
        }
        return res;
    }

    public double getEndTangentOrientation() {
        double res = 0.0;
        if (this.elements.length > 0) {
            PathElement el = this.elements[this.elements.length - 1];
            double sx = 0.0;
            double sy = 0.0;
            switch (el.type) {
                case 3: {
                    sx = ((CBCElement)el).ctrlx2;
                    sy = ((CBCElement)el).ctrly2;
                    break;
                }
                case 2: {
                    sx = ((QDCElement)el).ctrlx;
                    sy = ((QDCElement)el).ctrly;
                    break;
                }
                default: {
                    if (this.elements.length > 1) {
                        sx = this.elements[this.elements.length - 2].x;
                        sy = this.elements[this.elements.length - 2].y;
                        break;
                    }
                    sx = this.spx;
                    sy = this.spy;
                }
            }
            if (el.x == sx) {
                res = el.y > sy ? 1.5707963705062866 : 4.71238899230957;
            } else {
                double tan = (el.y - sy) / (el.x - sx);
                res = Math.atan(tan);
                if (el.x < sx) {
                    res += Math.PI;
                }
                if (el.x > sx && el.y < sy) {
                    res += Math.PI * 2;
                }
            }
        }
        return res;
    }
}

