/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.VText;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VTextOr<T>
extends VText {
    public VTextOr(String t, double or) {
        this(0.0, 0.0, 0, Color.BLACK, t, or, 0, 1.0f, 1.0f);
    }

    public VTextOr(double x, double y, int z, Color c, String t, double or) {
        this(x, y, z, c, t, or, 0, 1.0f, 1.0f);
    }

    public VTextOr(double x, double y, int z, Color c, String t, double or, short ta) {
        this(x, y, z, c, t, or, ta, 1.0f, 1.0f);
    }

    public VTextOr(double x, double y, int z, Color c, String t, double or, short ta, float scale) {
        this(x, y, z, c, t, or, ta, scale, 1.0f);
    }

    public VTextOr(double x, double y, int z, Color c, String t, double or, short ta, float scale, float alpha) {
        super(x, y, z, c, t, ta);
        this.orient = or;
        this.scaleFactor = scale;
        this.setTranslucencyValue(alpha);
    }

    @Override
    public void orientTo(double angle) {
        this.orient = angle;
        this.invalidate();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return false;
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (!this.pc[i].valid) {
            g.setFont(this.font != null ? this.font : VTextOr.getMainFont());
            Rectangle2D bounds = g.getFontMetrics().getStringBounds(this.text, g);
            this.pc[i].cw = (int)Math.abs(Math.round(bounds.getWidth() * (double)this.scaleFactor));
            this.pc[i].ch = (int)Math.abs(Math.round(bounds.getHeight() * (double)this.scaleFactor));
            this.pc[i].valid = true;
        }
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        g.setColor(this.color);
        double trueCoef = (double)this.scaleFactor * this.coef;
        if (trueCoef * (double)this.fontSize > (double)VText.TEXT_AS_LINE_PROJ_COEF || !this.zoomSensitive) {
            AffineTransform at;
            g.setFont(this.font != null ? this.font : VTextOr.getMainFont());
            if (this.text_anchor == 0) {
                at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx, this.pc[i].cy);
                if (this.zoomSensitive) {
                    at.concatenate(AffineTransform.getScaleInstance(trueCoef, trueCoef));
                }
                if (this.orient != 0.0) {
                    at.concatenate(AffineTransform.getRotateInstance(-this.orient));
                }
            } else if (this.text_anchor == 1) {
                at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx, dy + this.pc[i].cy);
                if (this.zoomSensitive) {
                    at.concatenate(AffineTransform.getScaleInstance(trueCoef, trueCoef));
                }
                if (this.orient != 0.0) {
                    at.concatenate(AffineTransform.getRotateInstance(-this.orient));
                }
                at.concatenate(AffineTransform.getTranslateInstance(-this.pc[i].cw / 2.0 / (double)this.scaleFactor, 0.0));
            } else {
                at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx, dy + this.pc[i].cy);
                if (this.zoomSensitive) {
                    at.concatenate(AffineTransform.getScaleInstance(trueCoef, trueCoef));
                }
                if (this.orient != 0.0) {
                    at.concatenate(AffineTransform.getRotateInstance(-this.orient));
                }
                at.concatenate(AffineTransform.getTranslateInstance(-this.pc[i].cw / (double)this.scaleFactor, 0.0));
            }
            g.setTransform(at);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.drawString(this.text, 0.0f, 0.0f);
                g.setComposite(acO);
            } else {
                g.drawString(this.text, 0.0f, 0.0f);
            }
            g.setTransform(stdT);
        } else {
            g.fillRect(dx + this.pc[i].cx, this.pc[i].cy, 1, 1);
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (!this.pc[i].lvalid) {
            g.setFont(this.font != null ? this.font : VTextOr.getMainFont());
            Rectangle2D bounds = g.getFontMetrics().getStringBounds(this.text, g);
            this.pc[i].lcw = (int)Math.abs(Math.round(bounds.getWidth() * (double)this.scaleFactor));
            this.pc[i].lch = (int)Math.abs(Math.round(bounds.getHeight() * (double)this.scaleFactor));
            this.pc[i].lvalid = true;
        }
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        g.setColor(this.color);
        double trueCoef = (double)this.scaleFactor * this.coef;
        if (trueCoef * (double)this.fontSize > (double)VText.TEXT_AS_LINE_PROJ_COEF || !this.zoomSensitive) {
            AffineTransform at;
            g.setFont(this.font != null ? this.font : VTextOr.getMainFont());
            if (this.text_anchor == 0) {
                at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx, this.pc[i].lcy);
                if (this.zoomSensitive) {
                    at.concatenate(AffineTransform.getScaleInstance(trueCoef, trueCoef));
                }
                if (this.orient != 0.0) {
                    at.concatenate(AffineTransform.getRotateInstance(-this.orient));
                }
            } else if (this.text_anchor == 1) {
                at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx, dy + this.pc[i].lcy);
                if (this.zoomSensitive) {
                    at.concatenate(AffineTransform.getScaleInstance(trueCoef, trueCoef));
                }
                if (this.orient != 0.0) {
                    at.concatenate(AffineTransform.getRotateInstance(-this.orient));
                }
                at.concatenate(AffineTransform.getTranslateInstance(-this.pc[i].lcw / 2.0 / (double)this.scaleFactor, 0.0));
            } else {
                at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx, dy + this.pc[i].lcy);
                if (this.zoomSensitive) {
                    at.concatenate(AffineTransform.getScaleInstance(trueCoef, trueCoef));
                }
                if (this.orient != 0.0) {
                    at.concatenate(AffineTransform.getRotateInstance(-this.orient));
                }
                at.concatenate(AffineTransform.getTranslateInstance(-this.pc[i].lcw / (double)this.scaleFactor, 0.0));
            }
            g.setTransform(at);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.drawString(this.text, 0.0f, 0.0f);
                g.setComposite(acO);
            } else {
                g.drawString(this.text, 0.0f, 0.0f);
            }
            g.setTransform(stdT);
        } else {
            g.fillRect(dx + this.pc[i].lcx, this.pc[i].lcy, 1, 1);
        }
    }

    @Override
    public Object clone() {
        VTextOr<T> res = new VTextOr<T>(this.vx, this.vy, this.vz, this.color, new StringBuffer(this.text).toString(), this.orient, this.text_anchor);
        res.cursorInsideColor = this.cursorInsideColor;
        return res;
    }
}

