/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.svg;

import fr.inria.zvtm.engine.Utils;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.glyphs.DPath;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VCircle;
import fr.inria.zvtm.glyphs.VEllipse;
import fr.inria.zvtm.glyphs.VImage;
import fr.inria.zvtm.glyphs.VPolygon;
import fr.inria.zvtm.glyphs.VRectangleOr;
import fr.inria.zvtm.glyphs.VRoundRect;
import fr.inria.zvtm.glyphs.VSegment;
import fr.inria.zvtm.glyphs.VText;
import fr.inria.zvtm.svg.Context;
import fr.inria.zvtm.svg.Metadata;
import fr.inria.zvtm.svg.SVGStyle;
import fr.inria.zvtm.svg.SVGWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGReader {
    public static final String _polyline = "polyline";
    public static final String _line = "line";
    public static final String _rect = "rect";
    public static final String _image = "image";
    public static final String _ellipse = "ellipse";
    public static final String _circle = "circle";
    public static final String _path = "path";
    public static final String _text = "text";
    public static final String _polygon = "polygon";
    public static final String _g = "g";
    public static final String _a = "a";
    public static final String _title = "title";
    public static final String _fill = "fill";
    public static final String _stroke = "stroke";
    public static final String _strokewidth = "stroke-width";
    public static final String _strokedasharray = "stroke-dasharray";
    public static final String _fillopacity = "fill-opacity";
    public static final String _fontfamily = "font-family";
    public static final String _fontsize = "font-size";
    public static final String _fontweight = "font-weight";
    public static final String _fontstyle = "font-style";
    public static final String _fillCSS = "fill:";
    public static final String _strokeCSS = "stroke:";
    public static final String _strokewidthCSS = "stroke-width:";
    public static final String _strokedasharrayCSS = "stroke-dasharray:";
    public static final String _fillopacityCSS = "fill-opacity:";
    public static final String _fontfamilyCSS = "font-family:";
    public static final String _fontsizeCSS = "font-size:";
    public static final String _fontweightCSS = "font-weight:";
    public static final String _fontstyleCSS = "font-style:";
    public static final String _style = "style";
    public static final String _class = "class";
    public static final String _cx = "cx";
    public static final String _cy = "cy";
    public static final String _rx = "rx";
    public static final String _ry = "ry";
    public static final String _r = "r";
    public static final String _d = "d";
    public static final String _x = "x";
    public static final String _y = "y";
    public static final String _x1 = "x1";
    public static final String _y1 = "y1";
    public static final String _x2 = "x2";
    public static final String _y2 = "y2";
    public static final String _width = "width";
    public static final String _height = "height";
    public static final String _points = "points";
    public static final String _textanchor = "text-anchor";
    public static final String _start = "start";
    public static final String _middle = "middle";
    public static final String _end = "end";
    public static final String _inherit = "inherit";
    public static final String _pt = "pt";
    public static final String _id = "id";
    public static final String _transform = "transform";
    public static final String _translate = "translate";
    public static final String _viewBox = "viewBox";
    public static final String xlinkURI = "http://www.w3.org/1999/xlink";
    public static final String _href = "href";
    public static final String HTTP_SCHEME = "http://";
    public static final String FILE_SCHEME = "file:/";
    public static final String FILE_PROTOCOL = "file";
    public static final String EMPTY_STRING = "";
    public static final String COMMA_SEP = ",";
    public static final String SPACE_SEP = " ";
    public static final String LINE_SEP = "\n";
    static final String STYLING_INSTRUCTION_SEP = ";";
    static Hashtable fontCache = new Hashtable();
    static double xoffset = 0.0;
    static double yoffset = 0.0;
    static double scale = 1.0;
    public static float RRARCR = 0.4f;
    protected static Hashtable strokes = new Hashtable();
    protected static String SOLID_DASH_PATTERN = "solid";
    static final short fill_INDEX = 0;
    static final short stroke_INDEX = 1;
    static final short strokewidth_INDEX = 2;
    static final short strokedasharray_INDEX = 3;
    static final short fillopacity_INDEX = 4;
    static final short fontfamily_INDEX = 5;
    static final short fontsize_INDEX = 6;
    static final short fontweight_INDEX = 7;
    static final short fontstyle_INDEX = 8;
    static final String LOAD_EXTERNAL_DTD_URL = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    public static void setPositionOffset(double dx, double dy) {
        xoffset = dx;
        yoffset = dy;
    }

    public static Point2D.Double getPositionOffset() {
        return new Point2D.Double(xoffset, yoffset);
    }

    public static boolean checkSVGPath(String svg) {
        boolean res = true;
        byte[] chrs = svg.getBytes();
        for (int i = 0; i < chrs.length; ++i) {
            if (chrs[i] == 32 || chrs[i] == 45 || chrs[i] >= 48 && chrs[i] <= 57 || chrs[i] == 67 || chrs[i] == 72 || chrs[i] == 76 || chrs[i] == 77 || chrs[i] == 81 || chrs[i] == 86 || chrs[i] == 99 || chrs[i] == 104 || chrs[i] == 108 || chrs[i] == 109 || chrs[i] == 113 || chrs[i] == 118 || chrs[i] == 101 || chrs[i] == 69 || chrs[i] == 44 || chrs[i] == 46) continue;
            res = false;
            System.err.println("SVG Path: char '" + svg.substring(i, i + 1) + "' not supported");
            break;
        }
        return res;
    }

    private static void processNextSVGPathCommand(StringBuffer svg, DPath ph, StringBuffer lastCommand) {
        if (svg.length() > 0) {
            block0 : switch (svg.charAt(0)) {
                case 'M': {
                    svg.deleteCharAt(0);
                    double x = SVGReader.getNextNumber(svg) + xoffset;
                    double y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.jump(x, -y, true);
                    lastCommand.setCharAt(0, 'M');
                    break;
                }
                case 'm': {
                    svg.deleteCharAt(0);
                    double x = SVGReader.getNextNumber(svg) + xoffset;
                    double y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.jump(x, -y, false);
                    lastCommand.setCharAt(0, 'm');
                    break;
                }
                case 'L': {
                    svg.deleteCharAt(0);
                    double x = SVGReader.getNextNumber(svg) + xoffset;
                    double y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.addSegment(x, -y, true);
                    lastCommand.setCharAt(0, 'L');
                    break;
                }
                case 'l': {
                    svg.deleteCharAt(0);
                    double x = SVGReader.getNextNumber(svg) + xoffset;
                    double y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.addSegment(x, -y, false);
                    lastCommand.setCharAt(0, 'l');
                    break;
                }
                case 'H': {
                    svg.deleteCharAt(0);
                    double x = SVGReader.getNextNumber(svg) + xoffset;
                    ph.addSegment(x, 0.0, true);
                    lastCommand.setCharAt(0, 'H');
                    break;
                }
                case 'h': {
                    svg.deleteCharAt(0);
                    double x = SVGReader.getNextNumber(svg) + xoffset;
                    ph.addSegment(x, 0.0, false);
                    lastCommand.setCharAt(0, 'h');
                    break;
                }
                case 'V': {
                    svg.deleteCharAt(0);
                    double y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.addSegment(0.0, -y, true);
                    lastCommand.setCharAt(0, 'V');
                    break;
                }
                case 'v': {
                    svg.deleteCharAt(0);
                    double y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.addSegment(0.0, -y, false);
                    lastCommand.setCharAt(0, 'v');
                    break;
                }
                case 'C': {
                    svg.deleteCharAt(0);
                    double x1 = SVGReader.getNextNumber(svg) + xoffset;
                    double y1 = SVGReader.getNextNumber(svg) + yoffset;
                    double x2 = SVGReader.getNextNumber(svg) + xoffset;
                    double y2 = SVGReader.getNextNumber(svg) + yoffset;
                    double x = SVGReader.getNextNumber(svg) + xoffset;
                    double y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.addCbCurve(x, -y, x1, -y1, x2, -y2, true);
                    lastCommand.setCharAt(0, 'C');
                    break;
                }
                case 'c': {
                    svg.deleteCharAt(0);
                    double x1 = SVGReader.getNextNumber(svg) + xoffset;
                    double y1 = SVGReader.getNextNumber(svg) + yoffset;
                    double x2 = SVGReader.getNextNumber(svg) + xoffset;
                    double y2 = SVGReader.getNextNumber(svg) + yoffset;
                    double x = SVGReader.getNextNumber(svg) + xoffset;
                    double y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.addCbCurve(x, -y, x1, -y1, x2, -y2, false);
                    lastCommand.setCharAt(0, 'c');
                    break;
                }
                case 'Q': {
                    svg.deleteCharAt(0);
                    double x1 = SVGReader.getNextNumber(svg) + xoffset;
                    double y1 = SVGReader.getNextNumber(svg) + yoffset;
                    double x = SVGReader.getNextNumber(svg) + xoffset;
                    double y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.addQdCurve(x, -y, x1, -y1, true);
                    lastCommand.setCharAt(0, 'Q');
                    break;
                }
                case 'q': {
                    svg.deleteCharAt(0);
                    double x1 = SVGReader.getNextNumber(svg) + xoffset;
                    double y1 = SVGReader.getNextNumber(svg) + yoffset;
                    double x = SVGReader.getNextNumber(svg) + xoffset;
                    double y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.addQdCurve(x, -y, x1, -y1, false);
                    lastCommand.setCharAt(0, 'q');
                    break;
                }
                default: {
                    switch (lastCommand.charAt(0)) {
                        case 'M': {
                            double x = SVGReader.getNextNumber(svg) + xoffset;
                            double y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.jump(x, -y, true);
                            break block0;
                        }
                        case 'm': {
                            double x = SVGReader.getNextNumber(svg) + xoffset;
                            double y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.jump(x, -y, false);
                            break block0;
                        }
                        case 'L': {
                            double x = SVGReader.getNextNumber(svg) + xoffset;
                            double y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.addSegment(x, -y, true);
                            break block0;
                        }
                        case 'l': {
                            double x = SVGReader.getNextNumber(svg) + xoffset;
                            double y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.addSegment(x, -y, false);
                            break block0;
                        }
                        case 'H': {
                            double x = SVGReader.getNextNumber(svg) + xoffset;
                            ph.addSegment(x, 0.0, true);
                            break block0;
                        }
                        case 'h': {
                            double x = SVGReader.getNextNumber(svg) + xoffset;
                            ph.addSegment(x, 0.0, false);
                            break block0;
                        }
                        case 'V': {
                            double y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.addSegment(0.0, -y, true);
                            break block0;
                        }
                        case 'v': {
                            double y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.addSegment(0.0, -y, false);
                            break block0;
                        }
                        case 'C': {
                            double x1 = SVGReader.getNextNumber(svg) + xoffset;
                            double y1 = SVGReader.getNextNumber(svg) + yoffset;
                            double x2 = SVGReader.getNextNumber(svg) + xoffset;
                            double y2 = SVGReader.getNextNumber(svg) + yoffset;
                            double x = SVGReader.getNextNumber(svg) + xoffset;
                            double y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.addCbCurve(x, -y, x1, -y1, x2, -y2, true);
                            break block0;
                        }
                        case 'c': {
                            double x1 = SVGReader.getNextNumber(svg) + xoffset;
                            double y1 = SVGReader.getNextNumber(svg) + yoffset;
                            double x2 = SVGReader.getNextNumber(svg) + xoffset;
                            double y2 = SVGReader.getNextNumber(svg) + yoffset;
                            double x = SVGReader.getNextNumber(svg) + xoffset;
                            double y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.addCbCurve(x, -y, x1, -y1, x2, -y2, false);
                            break block0;
                        }
                        case 'Q': {
                            double x1 = SVGReader.getNextNumber(svg) + xoffset;
                            double y1 = SVGReader.getNextNumber(svg) + yoffset;
                            double x = SVGReader.getNextNumber(svg) + xoffset;
                            double y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.addQdCurve(x, -y, x1, -y1, true);
                            break block0;
                        }
                        case 'q': {
                            double x1 = SVGReader.getNextNumber(svg) + xoffset;
                            double y1 = SVGReader.getNextNumber(svg) + yoffset;
                            double x = SVGReader.getNextNumber(svg) + xoffset;
                            double y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.addQdCurve(x, -y, x1, -y1, false);
                            break block0;
                        }
                    }
                }
            }
        }
    }

    public static Color getColor(String s) {
        if (s == null) {
            return null;
        }
        try {
            if (s.startsWith("rgb(")) {
                StringTokenizer st = new StringTokenizer(s.substring(4, s.length() - 1), COMMA_SEP);
                String[] ar = new String[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    ar[i++] = st.nextToken();
                }
                if (ar[0].endsWith("%")) {
                    float r = new Float(ar[0].substring(0, ar[0].length() - 1)).floatValue() / 100.0f;
                    float g = new Float(ar[1].substring(0, ar[1].length() - 1)).floatValue() / 100.0f;
                    float b = new Float(ar[2].substring(0, ar[2].length() - 1)).floatValue() / 100.0f;
                    return new Color(r, g, b);
                }
                int r = new Float(ar[0]).intValue();
                int g = new Float(ar[1]).intValue();
                int b = new Float(ar[2]).intValue();
                return new Color(r, g, b);
            }
            if (s.startsWith("#")) {
                String s2 = s.length() == 4 ? s.substring(1, 2) + s.substring(1, 2) + s.substring(2, 3) + s.substring(2, 3) + s.substring(3, 4) + s.substring(3, 4) : s.substring(1, s.length());
                int r = Integer.parseInt(s2.substring(0, 2), 16);
                int g = Integer.parseInt(s2.substring(2, 4), 16);
                int b = Integer.parseInt(s2.substring(4, 6), 16);
                return new Color(r, g, b);
            }
            if (s.startsWith("none")) {
                return null;
            }
            Color c = Utils.getColorByKeyword((String)s);
            if (c != null) {
                return c;
            }
            return null;
        }
        catch (Exception ex) {
            System.err.println("Error: SVGReader.getColor(): " + ex);
            return Color.WHITE;
        }
    }

    public static SVGStyle getStyle(String s, Element e) {
        SVGStyle ss = new SVGStyle();
        boolean[] attributesSet = new boolean[9];
        if (s != null) {
            s = s.replaceAll(LINE_SEP, EMPTY_STRING);
            s = s.replaceAll(SPACE_SEP, EMPTY_STRING);
            StringTokenizer st = new StringTokenizer(s, STYLING_INSTRUCTION_SEP);
            while (st.hasMoreTokens()) {
                String instr = st.nextToken();
                if (instr.startsWith(_fillCSS)) {
                    ss.setFillColor(SVGReader.getColor(instr.substring(5, instr.length())));
                    attributesSet[0] = true;
                    continue;
                }
                if (instr.startsWith(_strokeCSS)) {
                    ss.setStrokeColor(SVGReader.getColor(instr.substring(7, instr.length())));
                    attributesSet[1] = true;
                    continue;
                }
                if (instr.startsWith(_strokewidthCSS)) {
                    ss.setStrokeWidth(instr.substring(13, instr.length()));
                    attributesSet[2] = true;
                    continue;
                }
                if (instr.startsWith(_strokedasharrayCSS)) {
                    ss.setStrokeDashArray(instr.substring(17, instr.length()));
                    attributesSet[3] = true;
                    continue;
                }
                if (instr.startsWith(_fillopacityCSS)) {
                    ss.setAlphaTransparencyValue(new Float(instr.substring(13, instr.length())));
                    attributesSet[4] = true;
                    continue;
                }
                if (instr.startsWith(_fontfamilyCSS)) {
                    ss.setFontFamily(instr.substring(12, instr.length()));
                    attributesSet[5] = true;
                    continue;
                }
                if (instr.startsWith(_fontsizeCSS)) {
                    ss.setFontSize(instr.substring(10, instr.length()));
                    attributesSet[6] = true;
                    continue;
                }
                if (instr.startsWith(_fontweightCSS)) {
                    ss.setFontWeight(instr.substring(12, instr.length()));
                    attributesSet[7] = true;
                    continue;
                }
                if (!instr.startsWith(_fontstyleCSS)) continue;
                ss.setFontStyle(instr.substring(11, instr.length()));
                attributesSet[8] = true;
            }
        }
        if (e != null) {
            if (!attributesSet[0] && e.hasAttribute(_fill)) {
                ss.setFillColor(SVGReader.getColor(e.getAttribute(_fill)));
            }
            if (!attributesSet[1] && e.hasAttribute(_stroke)) {
                ss.setStrokeColor(SVGReader.getColor(e.getAttribute(_stroke)));
            }
            if (!attributesSet[2] && e.hasAttribute(_strokewidth)) {
                ss.setStrokeWidth(e.getAttribute(_strokewidth));
            }
            if (!attributesSet[3] && e.hasAttribute(_strokedasharray)) {
                ss.setStrokeDashArray(e.getAttribute(_strokedasharray));
            }
            if (!attributesSet[4] && e.hasAttribute(_fillopacity)) {
                ss.setAlphaTransparencyValue(new Float(e.getAttribute(_fillopacity)));
            }
            if (!attributesSet[5] && e.hasAttribute(_fontfamily)) {
                ss.setFontFamily(e.getAttribute(_fontfamily));
            }
            if (!attributesSet[6] && e.hasAttribute(_fontsize)) {
                ss.setFontSize(e.getAttribute(_fontsize));
            }
            if (!attributesSet[7] && e.hasAttribute(_fontweight)) {
                ss.setFontWeight(e.getAttribute(_fontweight));
            }
            if (!attributesSet[8] && e.hasAttribute(_fontstyle)) {
                ss.setFontStyle(e.getAttribute(_fontstyle));
            }
        }
        return ss.hasStylingInformation() ? ss : null;
    }

    public static void translateSVGPolygon(String s, Vector<Point2D.Double> res) {
        StringBuffer svg = new StringBuffer(s);
        while (svg.length() > 0) {
            Utils.delLeadingSpaces((StringBuffer)svg);
            SVGReader.processNextSVGCoords(svg, res);
        }
    }

    private static void processNextSVGCoords(StringBuffer svg, Vector<Point2D.Double> res) {
        if (svg.length() > 0) {
            double x = SVGReader.getNextNumber(svg);
            double y = SVGReader.getNextNumber(svg);
            if (scale != 1.0) {
                x *= scale;
                y *= scale;
            }
            res.add(new Point2D.Double(x += xoffset, y += yoffset));
        }
    }

    private static void seekSecondCoord(StringBuffer sb) {
        Utils.delLeadingSpaces((StringBuffer)sb);
        while (sb.length() > 0 && (Character.isWhitespace(sb.charAt(0)) || sb.charAt(0) == ',')) {
            sb.deleteCharAt(0);
        }
    }

    static double getNextNumber(StringBuffer sb) {
        double res = 0.0;
        SVGReader.seekSecondCoord(sb);
        StringBuffer dgb = new StringBuffer();
        while (sb.length() > 0 && (Character.isDigit(sb.charAt(0)) || sb.charAt(0) == '-' || sb.charAt(0) == '.' || sb.charAt(0) == 'e' || sb.charAt(0) == 'E' || sb.charAt(0) == '+')) {
            dgb.append(sb.charAt(0));
            sb.deleteCharAt(0);
        }
        if (dgb.length() > 0) {
            res = Double.parseDouble(dgb.toString());
        }
        return res;
    }

    public static void assignStroke(Glyph g, SVGStyle ss) {
        BasicStroke bs;
        float[] sda;
        Float sw = ss.getStrokeWidth();
        if (sw == null) {
            sw = new Float(1.0f);
        }
        if ((sda = ss.getStrokeDashArray()) != null) {
            String dashPattern = Utils.arrayOffloatAsCSStrings((float[])sda);
            if (strokes.containsKey(sw)) {
                Hashtable h1 = (Hashtable)strokes.get(sw);
                if (h1.containsKey(dashPattern)) {
                    bs = (BasicStroke)h1.get(dashPattern);
                } else {
                    bs = new BasicStroke(sw.floatValue(), 0, 0, SVGWriter.DEFAULT_MITER_LIMIT, sda, SVGWriter.DEFAULT_DASH_OFFSET);
                    h1.put(dashPattern, bs);
                }
            } else {
                bs = new BasicStroke(sw.floatValue(), 0, 0, SVGWriter.DEFAULT_MITER_LIMIT, sda, SVGWriter.DEFAULT_DASH_OFFSET);
                Hashtable<String, BasicStroke> h1 = new Hashtable<String, BasicStroke>();
                h1.put(dashPattern, bs);
                strokes.put(sw, h1);
            }
        } else if (strokes.containsKey(sw)) {
            Hashtable h1 = (Hashtable)strokes.get(sw);
            if (h1.containsKey(SOLID_DASH_PATTERN)) {
                bs = (BasicStroke)h1.get(SOLID_DASH_PATTERN);
            } else {
                bs = new BasicStroke(sw.floatValue());
                h1.put(SOLID_DASH_PATTERN, bs);
            }
        } else {
            bs = new BasicStroke(sw.floatValue());
            Hashtable<String, BasicStroke> h1 = new Hashtable<String, BasicStroke>();
            h1.put(SOLID_DASH_PATTERN, bs);
            strokes.put(sw, h1);
        }
        g.setStroke((Stroke)bs);
    }

    public static boolean isRectangle(Vector<Point2D.Double> v) {
        if (v.size() == 4 || v.size() == 5) {
            Point2D.Double p1 = v.elementAt(0);
            Point2D.Double p2 = v.elementAt(1);
            Point2D.Double p3 = v.elementAt(2);
            Point2D.Double p4 = v.elementAt(3);
            return p2.x == p3.x && p1.y == p2.y && p3.y == p4.y && p1.x == p4.x || p2.y == p3.y && p1.x == p2.x && p3.x == p4.x && p1.y == p4.y;
        }
        return false;
    }

    public static VEllipse createEllipse(Element e) {
        return SVGReader.createEllipse(e, null, false);
    }

    public static VEllipse createEllipse(Element e, Context ctx) {
        return SVGReader.createEllipse(e, ctx, false);
    }

    public static VEllipse createEllipse(Element e, Context ctx, boolean meta) {
        VEllipse res;
        double x = Double.parseDouble(e.getAttribute(_cx));
        double y = Double.parseDouble(e.getAttribute(_cy));
        double w = 2.0 * Double.parseDouble(e.getAttribute(_rx));
        double h = 2.0 * Double.parseDouble(e.getAttribute(_ry));
        if (scale != 1.0) {
            x *= scale;
            y *= scale;
            w *= scale;
            h *= scale;
        }
        x += xoffset;
        y += yoffset;
        SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
        if (ss != null) {
            if (ss.hasTransparencyInformation()) {
                if (ss.getFillColor() == null) {
                    res = new VEllipse(x, -y, 0, w, h, Color.WHITE, Color.BLACK, ss.getAlphaTransparencyValue());
                    res.setFilled(false);
                } else {
                    res = new VEllipse(x, -y, 0, w, h, ss.getFillColor(), Color.BLACK, ss.getAlphaTransparencyValue());
                }
            } else if (ss.getFillColor() == null) {
                res = new VEllipse(x, -y, 0, w, h, Color.WHITE, Color.BLACK, 1.0f);
                res.setFilled(false);
            } else {
                res = new VEllipse(x, -y, 0, w, h, ss.getFillColor(), Color.BLACK, 1.0f);
            }
            Color border = ss.getStrokeColor();
            if (border != null) {
                float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
            } else if (ss.hasStrokeColorInformation()) {
                res.setDrawBorder(false);
            }
            if (ss.requiresSpecialStroke()) {
                SVGReader.assignStroke((Glyph)res, ss);
            }
        } else if (ctx != null) {
            if (ctx.hasTransparencyInformation()) {
                if (ctx.getFillColor() == null) {
                    res = new VEllipse(x, -y, 0, w, h, Color.WHITE, Color.BLACK, ctx.getAlphaTransparencyValue());
                    res.setFilled(false);
                } else {
                    res = new VEllipse(x, -y, 0, w, h, ctx.getFillColor(), Color.BLACK, ctx.getAlphaTransparencyValue());
                }
            } else if (ctx.getFillColor() == null) {
                res = new VEllipse(x, -y, 0, w, h, Color.WHITE, Color.BLACK, 1.0f);
                res.setFilled(false);
            } else {
                res = new VEllipse(x, -y, 0, w, h, ctx.getFillColor(), Color.BLACK, 1.0f);
            }
            Color border = ctx.getStrokeColor();
            if (border != null) {
                float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
            }
        } else {
            res = new VEllipse(x, -y, 0, w, h, Color.WHITE, Color.BLACK, 1.0f);
        }
        if (meta) {
            SVGReader.setMetadata((Glyph)res, ctx);
        }
        if (e.hasAttribute(_class)) {
            res.setType(e.getAttribute(_class));
        }
        return res;
    }

    public static VCircle createCircle(Element e) {
        return SVGReader.createCircle(e, null, false);
    }

    public static VCircle createCircle(Element e, Context ctx) {
        return SVGReader.createCircle(e, ctx, false);
    }

    public static VCircle createCircle(Element e, Context ctx, boolean meta) {
        VCircle res;
        double x = Double.parseDouble(e.getAttribute(_cx));
        double y = Double.parseDouble(e.getAttribute(_cy));
        double d = 2.0 * Double.parseDouble(e.getAttribute(_r));
        if (scale != 1.0) {
            x *= scale;
            y *= scale;
            d *= scale;
        }
        x += xoffset;
        y += yoffset;
        SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
        if (ss != null) {
            if (ss.hasTransparencyInformation()) {
                if (ss.getFillColor() == null) {
                    res = new VCircle(x, -y, 0, d, Color.WHITE, Color.BLACK, 1.0f);
                    res.setFilled(false);
                } else {
                    res = new VCircle(x, -y, 0, d, ss.getFillColor(), Color.BLACK, ss.getAlphaTransparencyValue());
                }
            } else if (ss.getFillColor() == null) {
                res = new VCircle(x, -y, 0, d, Color.WHITE, Color.BLACK, 1.0f);
                res.setFilled(false);
            } else {
                res = new VCircle(x, -y, 0, d, ss.getFillColor(), Color.BLACK, 1.0f);
            }
            Color border = ss.getStrokeColor();
            if (border != null) {
                float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
            } else if (ss.hasStrokeColorInformation()) {
                res.setDrawBorder(false);
            }
            if (ss.requiresSpecialStroke()) {
                SVGReader.assignStroke((Glyph)res, ss);
            }
        } else {
            res = new VCircle(x, -y, 0, d, Color.WHITE, Color.BLACK, 1.0f);
        }
        if (meta) {
            SVGReader.setMetadata((Glyph)res, ctx);
        }
        if (e.hasAttribute(_class)) {
            res.setType(e.getAttribute(_class));
        }
        return res;
    }

    public static VText createText(Element e) {
        return SVGReader.createText(e, null, false);
    }

    public static VText createText(Element e, Context ctx) {
        return SVGReader.createText(e, ctx, false);
    }

    public static VText createText(Element e, Context ctx, boolean meta) {
        VText res;
        String tx = e.getFirstChild() == null ? EMPTY_STRING : e.getFirstChild().getNodeValue();
        double x = Double.parseDouble(e.getAttribute(_x));
        double y = Double.parseDouble(e.getAttribute(_y));
        if (scale != 1.0) {
            x *= scale;
            y *= scale;
        }
        x += xoffset;
        y += yoffset;
        short ta = 0;
        if (e.hasAttribute(_textanchor)) {
            String tas = e.getAttribute(_textanchor);
            if (tas.equals(_middle)) {
                ta = 1;
            } else if (tas.equals(_end)) {
                ta = 2;
            } else if (tas.equals(_inherit)) {
                System.err.println("SVGReader::'inherit' value for text-anchor attribute not supported yet");
            }
        }
        Color tc = Color.BLACK;
        SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
        if (ss != null) {
            if (ss.getStrokeColor() == null) {
                if (ss.getFillColor() != null) {
                    tc = ss.getFillColor();
                }
            } else {
                tc = ss.getStrokeColor();
            }
            res = ss.hasTransparencyInformation() ? new VText(x, -y, 0, tc, tx, ta, 1.0f, ss.getAlphaTransparencyValue()) : new VText(x, -y, 0, tc, tx, ta, 1.0f, 1.0f);
            Font f = ss.getDefinedFont(ctx);
            if (SVGReader.specialFont(f, VText.getMainFont())) {
                res.setFont(f);
            }
        } else if (ctx != null) {
            res = ctx.hasTransparencyInformation() ? new VText(x, -y, 0, tc, tx, ta, 1.0f, ctx.getAlphaTransparencyValue()) : new VText(x, -y, 0, tc, tx, ta, 1.0f, 1.0f);
            Font f = ctx.getDefinedFont();
            if (SVGReader.specialFont(f, VText.getMainFont())) {
                res.setFont(f);
            }
        } else {
            res = new VText(x, -y, 0, tc, tx, ta, 1.0f, 1.0f);
        }
        if (meta) {
            SVGReader.setMetadata((Glyph)res, ctx);
        }
        if (e.hasAttribute(_class)) {
            res.setType(e.getAttribute(_class));
        }
        return res;
    }

    public static VRectangleOr createRectangleFromPolygon(Element e) {
        return SVGReader.createRectangleFromPolygon(e, null, false);
    }

    public static VRectangleOr createRectangleFromPolygon(Element e, Context ctx) {
        return SVGReader.createRectangleFromPolygon(e, ctx, false);
    }

    public static VRectangleOr createRectangleFromPolygon(Element e, Context ctx, boolean meta) {
        Vector<Point2D.Double> coords = new Vector<Point2D.Double>();
        SVGReader.translateSVGPolygon(e.getAttribute(_points), coords);
        if (SVGReader.isRectangle(coords)) {
            VRectangleOr res;
            Point2D.Double p1 = coords.elementAt(0);
            Point2D.Double p2 = coords.elementAt(1);
            Point2D.Double p3 = coords.elementAt(2);
            Point2D.Double p4 = coords.elementAt(3);
            double l = Math.min(p1.x, Math.min(p2.x, Math.min(p3.x, p4.x)));
            double u = Math.max(p1.y, Math.max(p2.y, Math.max(p3.y, p4.y)));
            double r = Math.max(p1.x, Math.max(p2.x, Math.max(p3.x, p4.x)));
            double d = Math.min(p1.y, Math.min(p2.y, Math.min(p3.y, p4.y)));
            Point2D.Double pNW = new Point2D.Double(l, u);
            Point2D.Double pNE = new Point2D.Double(r, u);
            Point2D.Double pSE = new Point2D.Double(r, d);
            Point2D.Double pSW = new Point2D.Double(l, d);
            double h = Math.abs(pSE.y - pNE.y);
            double w = Math.abs(pNW.x - pNE.x);
            double x = pNE.x - w / 2.0;
            double y = pNE.y - h / 2.0;
            SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
            if (ss != null) {
                if (ss.hasTransparencyInformation()) {
                    if (ss.getFillColor() == null) {
                        res = new VRectangleOr(x, -y, 0, w, h, Color.WHITE, Color.BLACK, 0.0, ss.getAlphaTransparencyValue());
                        res.setFilled(false);
                    } else {
                        res = new VRectangleOr(x, -y, 0, w, h, ss.getFillColor(), Color.BLACK, 0.0, ss.getAlphaTransparencyValue());
                    }
                } else if (ss.getFillColor() == null) {
                    res = new VRectangleOr(x, -y, 0, w, h, Color.WHITE, Color.BLACK, 0.0, 1.0f);
                    res.setFilled(false);
                } else {
                    res = new VRectangleOr(x, -y, 0, w, h, ss.getFillColor(), Color.BLACK, 0.0, 1.0f);
                }
                Color border = ss.getStrokeColor();
                if (border != null) {
                    float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                    res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
                } else if (ss.hasStrokeColorInformation()) {
                    res.setDrawBorder(false);
                }
                if (ss.requiresSpecialStroke()) {
                    SVGReader.assignStroke((Glyph)res, ss);
                }
            } else if (ctx != null) {
                if (ctx.hasTransparencyInformation()) {
                    if (ctx.getFillColor() == null) {
                        res = new VRectangleOr(x, -y, 0, w, h, Color.WHITE, Color.BLACK, 0.0, ctx.getAlphaTransparencyValue());
                        res.setFilled(false);
                    } else {
                        res = new VRectangleOr(x, -y, 0, w, h, ctx.getFillColor(), Color.BLACK, 0.0, ctx.getAlphaTransparencyValue());
                    }
                } else if (ctx.getFillColor() == null) {
                    res = new VRectangleOr(x, -y, 0, w, h, Color.WHITE, Color.BLACK, 0.0, 1.0f);
                    res.setFilled(false);
                } else {
                    res = new VRectangleOr(x, -y, 0, w, h, ctx.getFillColor(), Color.BLACK, 0.0, 1.0f);
                }
                Color border = ctx.getStrokeColor();
                if (border != null) {
                    float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                    res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
                } else if (ctx.hasStrokeColorInformation()) {
                    res.setDrawBorder(false);
                }
            } else {
                res = new VRectangleOr(x, -y, 0, w, h, Color.WHITE, Color.BLACK, 0.0, 1.0f);
            }
            if (meta) {
                SVGReader.setMetadata((Glyph)res, ctx);
            }
            if (e.hasAttribute(_class)) {
                res.setType(e.getAttribute(_class));
            }
            return res;
        }
        return null;
    }

    public static VRoundRect createRoundRectFromPolygon(Element e) {
        return SVGReader.createRoundRectFromPolygon(e, null, false);
    }

    public static VRoundRect createRoundRectFromPolygon(Element e, Context ctx) {
        return SVGReader.createRoundRectFromPolygon(e, ctx, false);
    }

    public static VRoundRect createRoundRectFromPolygon(Element e, Context ctx, boolean meta) {
        Vector<Point2D.Double> coords = new Vector<Point2D.Double>();
        SVGReader.translateSVGPolygon(e.getAttribute(_points), coords);
        if (SVGReader.isRectangle(coords)) {
            VRoundRect res;
            Point2D.Double p1 = coords.elementAt(0);
            Point2D.Double p2 = coords.elementAt(1);
            Point2D.Double p3 = coords.elementAt(2);
            Point2D.Double p4 = coords.elementAt(3);
            double l = Math.min(p1.x, Math.min(p2.x, Math.min(p3.x, p4.x)));
            double u = Math.max(p1.y, Math.max(p2.y, Math.max(p3.y, p4.y)));
            double r = Math.max(p1.x, Math.max(p2.x, Math.max(p3.x, p4.x)));
            double d = Math.min(p1.y, Math.min(p2.y, Math.min(p3.y, p4.y)));
            Point2D.Double pNW = new Point2D.Double(l, u);
            Point2D.Double pNE = new Point2D.Double(r, u);
            Point2D.Double pSE = new Point2D.Double(r, d);
            Point2D.Double pSW = new Point2D.Double(l, d);
            double h = Math.abs(pSE.y - pNE.y);
            double w = Math.abs(pNW.x - pNE.x);
            double x = pNE.x - w / 2.0;
            double y = pNE.y - h / 2.0;
            SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
            if (ss != null) {
                if (ss.hasTransparencyInformation()) {
                    if (ss.getFillColor() == null) {
                        res = new VRoundRect(x, -y, 0, w, h, Color.WHITE, Color.BLACK, ss.getAlphaTransparencyValue(), (double)Math.round((double)RRARCR * Math.min(w, h)), (double)Math.round((double)RRARCR * Math.min(w, h)));
                        res.setFilled(false);
                    } else {
                        res = new VRoundRect(x, -y, 0, w, h, ss.getFillColor(), Color.BLACK, ss.getAlphaTransparencyValue(), (double)Math.round((double)RRARCR * Math.min(w, h)), (double)Math.round((double)RRARCR * Math.min(w, h)));
                    }
                } else if (ss.getFillColor() == null) {
                    res = new VRoundRect(x, -y, 0, w, h, Color.WHITE, Color.BLACK, 1.0f, (double)Math.round((double)RRARCR * Math.min(w, h)), (double)Math.round((double)RRARCR * Math.min(w, h)));
                    res.setFilled(false);
                } else {
                    res = new VRoundRect(x, -y, 0, w, h, ss.getFillColor(), Color.BLACK, 1.0f, (double)Math.round((double)RRARCR * Math.min(w, h)), (double)Math.round((double)RRARCR * Math.min(w, h)));
                }
                Color border = ss.getStrokeColor();
                if (border != null) {
                    float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                    res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
                } else if (ss.hasStrokeColorInformation()) {
                    res.setDrawBorder(false);
                }
                if (ss.requiresSpecialStroke()) {
                    SVGReader.assignStroke((Glyph)res, ss);
                }
            } else if (ctx != null) {
                if (ctx.hasTransparencyInformation()) {
                    if (ctx.getFillColor() == null) {
                        res = new VRoundRect(x, -y, 0, w, h, Color.WHITE, Color.BLACK, ctx.getAlphaTransparencyValue(), (double)Math.round((double)RRARCR * Math.min(w, h)), (double)Math.round((double)RRARCR * Math.min(w, h)));
                        res.setFilled(false);
                    } else {
                        res = new VRoundRect(x, -y, 0, w, h, ctx.getFillColor(), Color.BLACK, ctx.getAlphaTransparencyValue(), (double)Math.round((double)RRARCR * Math.min(w, h)), (double)Math.round((double)RRARCR * Math.min(w, h)));
                    }
                } else if (ctx.getFillColor() == null) {
                    res = new VRoundRect(x, -y, 0, w, h, Color.WHITE, Color.BLACK, 1.0f, (double)Math.round((double)RRARCR * Math.min(w, h)), (double)Math.round((double)RRARCR * Math.min(w, h)));
                    res.setFilled(false);
                } else {
                    res = new VRoundRect(x, -y, 0, w, h, ctx.getFillColor(), Color.BLACK, 1.0f, (double)Math.round((double)RRARCR * Math.min(w, h)), (double)Math.round((double)RRARCR * Math.min(w, h)));
                }
                Color border = ctx.getStrokeColor();
                if (border != null) {
                    float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                    res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
                } else if (ctx.hasStrokeColorInformation()) {
                    res.setDrawBorder(false);
                }
            } else {
                res = new VRoundRect(x, -y, 0, w, h, Color.WHITE, Color.BLACK, 1.0f, (double)Math.round((double)RRARCR * Math.min(w, h)), (double)Math.round((double)RRARCR * Math.min(w, h)));
            }
            if (meta) {
                SVGReader.setMetadata((Glyph)res, ctx);
            }
            if (e.hasAttribute(_class)) {
                res.setType(e.getAttribute(_class));
            }
            return res;
        }
        return null;
    }

    public static VRectangleOr createRectangle(Element e) {
        return SVGReader.createRectangle(e, null, false);
    }

    public static VRectangleOr createRectangle(Element e, Context ctx) {
        return SVGReader.createRectangle(e, ctx, false);
    }

    public static VRectangleOr createRectangle(Element e, Context ctx, boolean meta) {
        VRectangleOr res;
        double x = Double.parseDouble(e.getAttribute(_x));
        double y = Double.parseDouble(e.getAttribute(_y));
        double w = Double.parseDouble(e.getAttribute(_width));
        double h = Double.parseDouble(e.getAttribute(_height));
        if (scale != 1.0) {
            x *= scale;
            y *= scale;
            w *= scale;
            h *= scale;
        }
        x += xoffset;
        y += yoffset;
        SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
        if (ss != null) {
            if (ss.hasTransparencyInformation()) {
                if (ss.getFillColor() == null) {
                    res = new VRectangleOr(x + w, -y - h, 0, w, h, Color.WHITE, Color.BLACK, 0.0, ss.getAlphaTransparencyValue());
                    res.setFilled(false);
                } else {
                    res = new VRectangleOr(x + w, -y - h, 0, w, h, ss.getFillColor(), Color.BLACK, 0.0, ss.getAlphaTransparencyValue());
                }
            } else if (ss.getFillColor() == null) {
                res = new VRectangleOr(x + w, -y - h, 0, w, h, Color.WHITE, Color.BLACK, 0.0, 1.0f);
                res.setFilled(false);
            } else {
                res = new VRectangleOr(x + w, -y - h, 0, w, h, ss.getFillColor(), Color.BLACK, 0.0, 1.0f);
            }
            Color border = ss.getStrokeColor();
            if (border != null) {
                float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
            } else if (ss.hasStrokeColorInformation()) {
                res.setDrawBorder(false);
            }
            if (ss.requiresSpecialStroke()) {
                SVGReader.assignStroke((Glyph)res, ss);
            }
        } else if (ctx != null) {
            if (ctx.hasTransparencyInformation()) {
                if (ctx.getFillColor() == null) {
                    res = new VRectangleOr(x + w, -y - h, 0, w, h, Color.WHITE, Color.BLACK, 0.0, ctx.getAlphaTransparencyValue());
                    res.setFilled(false);
                } else {
                    res = new VRectangleOr(x + w, -y - h, 0, w, h, ctx.getFillColor(), Color.BLACK, 0.0, ctx.getAlphaTransparencyValue());
                }
            } else if (ctx.getFillColor() == null) {
                res = new VRectangleOr(x + w, -y - h, 0, w, h, Color.WHITE, Color.BLACK, 0.0, 1.0f);
                res.setFilled(false);
            } else {
                res = new VRectangleOr(x + w, -y - h, 0, w, h, ctx.getFillColor(), Color.BLACK, 0.0, 1.0f);
            }
            Color border = ctx.getStrokeColor();
            if (border != null) {
                float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
            } else if (ctx.hasStrokeColorInformation()) {
                res.setDrawBorder(false);
            }
        } else {
            res = new VRectangleOr(x + w, -y - h, 0, w, h, Color.WHITE, Color.BLACK, 0.0, 1.0f);
        }
        if (meta) {
            SVGReader.setMetadata((Glyph)res, ctx);
        }
        if (e.hasAttribute(_class)) {
            res.setType(e.getAttribute(_class));
        }
        return res;
    }

    public static Glyph createImage(Element e, Context ctx, boolean meta, Hashtable imageStore, String documentParentURL) {
        return SVGReader.createImage(e, ctx, meta, imageStore, documentParentURL, null);
    }

    public static VImage createImage(Element e, Context ctx, boolean meta, Hashtable imageStore, String documentParentURL, String fallbackParentURL) {
        ImageIcon ii;
        String imagePath;
        String height;
        double x = Double.parseDouble(e.getAttribute(_x)) + xoffset;
        double y = Double.parseDouble(e.getAttribute(_y)) + yoffset;
        String width = e.getAttribute(_width);
        if (width.endsWith("px")) {
            width = width.substring(0, width.length() - 2);
        }
        if ((height = e.getAttribute(_height)).endsWith("px")) {
            height = height.substring(0, height.length() - 2);
        }
        double w = Double.parseDouble(width);
        double h = Double.parseDouble(height);
        double hw = w / 2.0;
        double hh = h / 2.0;
        VImage res = null;
        if (e.hasAttributeNS(xlinkURI, _href) && (imagePath = e.getAttributeNS(xlinkURI, _href)).length() > 0 && (ii = SVGReader.getImage(imagePath, documentParentURL, fallbackParentURL, imageStore)) != null) {
            int aw = ii.getIconWidth();
            int ah = ii.getIconHeight();
            double wr = w / (double)aw;
            double hr = h / (double)ah;
            res = wr != 1.0 || hr != 1.0 ? new VImage(x + hw, -y - hh, 0, ii.getImage(), Math.min(wr, hr), 1.0f) : new VImage(x + hw, -y - hh, 0, ii.getImage(), 1.0, 1.0f);
        }
        if (res != null) {
            if (e.hasAttribute(_class)) {
                res.setType(e.getAttribute(_class));
            }
            if (meta) {
                SVGReader.setMetadata(res, ctx);
            }
        }
        return res;
    }

    public static VPolygon createPolygon(Element e) {
        return SVGReader.createPolygon(e, null, false);
    }

    public static VPolygon createPolygon(Element e, Context ctx) {
        return SVGReader.createPolygon(e, ctx, false);
    }

    public static VPolygon createPolygon(Element e, Context ctx, boolean meta) {
        VPolygon res;
        Vector<Point2D.Double> coords = new Vector<Point2D.Double>();
        SVGReader.translateSVGPolygon(e.getAttribute(_points), coords);
        Point2D.Double[] coords2 = new Point2D.Double[coords.size()];
        for (int i = 0; i < coords2.length; ++i) {
            Point2D.Double lp = coords.elementAt(i);
            coords2[i] = new Point2D.Double(lp.x, -lp.y);
        }
        SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
        if (ss != null) {
            if (ss.hasTransparencyInformation()) {
                if (ss.getFillColor() == null) {
                    res = new VPolygon(coords2, 0, Color.WHITE, Color.BLACK, ss.getAlphaTransparencyValue());
                    res.setFilled(false);
                } else {
                    res = new VPolygon(coords2, 0, ss.getFillColor(), Color.BLACK, ss.getAlphaTransparencyValue());
                }
            } else if (ss.getFillColor() == null) {
                res = new VPolygon(coords2, 0, Color.WHITE, Color.BLACK, 1.0f);
                res.setFilled(false);
            } else {
                res = new VPolygon(coords2, 0, ss.getFillColor(), Color.BLACK, 1.0f);
            }
            Color border = ss.getStrokeColor();
            if (border != null) {
                float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
            } else if (ss.hasStrokeColorInformation()) {
                res.setDrawBorder(false);
            }
            if (ss.requiresSpecialStroke()) {
                SVGReader.assignStroke((Glyph)res, ss);
            }
        } else if (ctx != null) {
            if (ctx.hasTransparencyInformation()) {
                if (ctx.getFillColor() == null) {
                    res = new VPolygon(coords2, 0, Color.WHITE, Color.BLACK, ctx.getAlphaTransparencyValue());
                    res.setFilled(false);
                } else {
                    res = new VPolygon(coords2, 0, ctx.getFillColor(), Color.BLACK, ctx.getAlphaTransparencyValue());
                }
            } else if (ctx.getFillColor() == null) {
                res = new VPolygon(coords2, 0, Color.WHITE, Color.BLACK, 1.0f);
                res.setFilled(false);
            } else {
                res = new VPolygon(coords2, 0, ctx.getFillColor(), Color.BLACK, 1.0f);
            }
            Color border = ctx.getStrokeColor();
            if (border != null) {
                float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
            } else if (ctx.hasStrokeColorInformation()) {
                res.setDrawBorder(false);
            }
        } else {
            res = new VPolygon(coords2, 0, Color.WHITE, Color.BLACK, 1.0f);
        }
        if (meta) {
            SVGReader.setMetadata((Glyph)res, ctx);
        }
        if (e.hasAttribute(_class)) {
            res.setType(e.getAttribute(_class));
        }
        return res;
    }

    public static VSegment[] createPolyline(Element e) {
        return SVGReader.createPolyline(e, null, false);
    }

    public static VSegment[] createPolyline(Element e, Context ctx) {
        return SVGReader.createPolyline(e, ctx, false);
    }

    public static VSegment[] createPolyline(Element e, Context ctx, boolean meta) {
        Vector<Point2D.Double> coords = new Vector<Point2D.Double>();
        SVGReader.translateSVGPolygon(e.getAttribute(_points), coords);
        VSegment[] res = new VSegment[coords.size() - 1];
        Color border = Color.black;
        SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
        if (ss != null) {
            border = ss.getStrokeColor();
            if (border == null) {
                border = ss.hasStrokeColorInformation() ? Color.WHITE : Color.BLACK;
            }
        } else if (ctx != null) {
            border = ctx.getStrokeColor() != null ? ctx.getStrokeColor() : (ctx.hasStrokeColorInformation() ? Color.WHITE : Color.BLACK);
        }
        for (int i = 0; i < coords.size() - 1; ++i) {
            Point2D.Double lp1 = coords.elementAt(i);
            Point2D.Double lp2 = coords.elementAt(i + 1);
            res[i] = new VSegment(lp1.x, -lp1.y, lp2.x, -lp2.y, 0, border, 1.0f);
            if (ss != null && ss.requiresSpecialStroke()) {
                SVGReader.assignStroke((Glyph)res[i], ss);
            }
            if (meta) {
                SVGReader.setMetadata((Glyph)res[i], ctx);
            }
            if (!e.hasAttribute(_class)) continue;
            res[i].setType(e.getAttribute(_class));
        }
        return res;
    }

    public static VSegment createLine(Element e) {
        return SVGReader.createLine(e, null, false);
    }

    public static VSegment createLine(Element e, Context ctx) {
        return SVGReader.createLine(e, ctx, false);
    }

    public static VSegment createLine(Element e, Context ctx, boolean meta) {
        VSegment res;
        double x1 = Double.parseDouble(e.getAttribute(_x1));
        double y1 = Double.parseDouble(e.getAttribute(_y1));
        double x2 = Double.parseDouble(e.getAttribute(_x2));
        double y2 = Double.parseDouble(e.getAttribute(_y2));
        if (scale != 1.0) {
            x1 *= scale;
            y1 *= scale;
            x2 *= scale;
            y2 *= scale;
        }
        x1 += xoffset;
        y1 += yoffset;
        x2 += xoffset;
        y2 += yoffset;
        Color border = Color.black;
        SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
        if (ss != null) {
            border = ss.getStrokeColor();
            if (border == null) {
                Color color = border = ss.hasStrokeColorInformation() ? Color.WHITE : Color.BLACK;
            }
            res = ss.hasTransparencyInformation() ? new VSegment(x1, -y1, x2, -y2, 0, border, ss.getAlphaTransparencyValue()) : new VSegment(x1, -y1, x2, -y2, 0, border, 1.0f);
        } else if (ctx != null) {
            if (ctx.getStrokeColor() != null) {
                border = ctx.getStrokeColor();
            } else {
                Color color = border = ctx.hasStrokeColorInformation() ? Color.WHITE : Color.BLACK;
            }
            res = ctx.hasTransparencyInformation() ? new VSegment(x1, -y1, x2, -y2, 0, border, ctx.getAlphaTransparencyValue()) : new VSegment(x1, -y1, x2, -y2, 0, border, 1.0f);
        } else {
            res = new VSegment(x1, -y1, x2, -y2, 0, border, 1.0f);
        }
        if (ss != null && ss.requiresSpecialStroke()) {
            SVGReader.assignStroke((Glyph)res, ss);
        }
        if (meta) {
            SVGReader.setMetadata((Glyph)res, ctx);
        }
        if (e.hasAttribute(_class)) {
            res.setType(e.getAttribute(_class));
        }
        return res;
    }

    public static DPath createPath(Element e, DPath ph) {
        return SVGReader.createPath(e, ph, null, false);
    }

    public static DPath createPath(Element e, DPath ph, Context ctx) {
        return SVGReader.createPath(e, ph, ctx, false);
    }

    public static DPath createPath(Element e, DPath ph, Context ctx, boolean meta) {
        StringBuffer svg = new StringBuffer(e.getAttribute(_d));
        if (SVGReader.checkSVGPath(svg.toString())) {
            Color border;
            StringBuffer lastCommand = new StringBuffer("M");
            while (svg.length() > 0) {
                Utils.delLeadingSpaces((StringBuffer)svg);
                SVGReader.processNextSVGPathCommand(svg, ph, lastCommand);
            }
            SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
            if (ss != null && ss.hasStrokeColorInformation()) {
                Color border2 = ss.getStrokeColor();
                float[] hsv = Color.RGBtoHSB(border2.getRed(), border2.getGreen(), border2.getBlue(), new float[3]);
                ph.setHSVColor(hsv[0], hsv[1], hsv[2]);
                if (ss.requiresSpecialStroke()) {
                    SVGReader.assignStroke((Glyph)ph, ss);
                }
            } else if (ctx != null && (border = ctx.getStrokeColor()) != null) {
                float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                ph.setHSVColor(hsv[0], hsv[1], hsv[2]);
            }
            if (meta) {
                SVGReader.setMetadata((Glyph)ph, ctx);
            }
            if (e.hasAttribute(_class)) {
                ph.setType(e.getAttribute(_class));
            }
            return ph;
        }
        return null;
    }

    public static DPath createPath(String d, DPath ph) {
        return SVGReader.createPath(d, ph, null, false);
    }

    public static DPath createPath(String d, DPath ph, Context ctx) {
        return SVGReader.createPath(d, ph, ctx, false);
    }

    public static DPath createPath(String d, DPath ph, Context ctx, boolean meta) {
        StringBuffer svg = new StringBuffer(d);
        if (SVGReader.checkSVGPath(svg.toString())) {
            StringBuffer lastCommand = new StringBuffer("M");
            while (svg.length() > 0) {
                Utils.delLeadingSpaces((StringBuffer)svg);
                SVGReader.processNextSVGPathCommand(svg, ph, lastCommand);
            }
            if (meta) {
                SVGReader.setMetadata((Glyph)ph, ctx);
            }
            return ph;
        }
        return null;
    }

    public static void load(Document d, VirtualSpace vs, boolean meta, String documentURL) {
        SVGReader.load(d, vs, meta, documentURL, null);
    }

    public static void load(Document d, VirtualSpace vs, boolean meta, String documentURL, String fallbackParentURL) {
        String documentParentURL = documentURL.substring(0, documentURL.lastIndexOf("/") + 1);
        Element svgRoot = d.getDocumentElement();
        NodeList objects = svgRoot.getChildNodes();
        Hashtable imageStore = new Hashtable();
        for (int i = 0; i < objects.getLength(); ++i) {
            Node obj = objects.item(i);
            if (obj.getNodeType() != 1) continue;
            SVGReader.processNode((Element)obj, vs, null, false, meta, documentParentURL, fallbackParentURL, imageStore);
        }
    }

    private static void processNode(Element e, VirtualSpace vs, Context ctx, boolean mainFontSet, boolean meta, String documentParentURL, String fallbackParentURL, Hashtable imageStore) {
        String tagName = e.getTagName();
        if (tagName.equals(_rect)) {
            vs.addGlyph((Glyph)SVGReader.createRectangle(e, ctx, meta));
        } else if (tagName.equals(_ellipse)) {
            vs.addGlyph((Glyph)SVGReader.createEllipse(e, ctx, meta));
        } else if (tagName.equals(_circle)) {
            vs.addGlyph((Glyph)SVGReader.createCircle(e, ctx, meta));
        } else if (tagName.equals(_path)) {
            vs.addGlyph((Glyph)SVGReader.createPath(e, new DPath(), ctx, meta));
        } else if (tagName.equals(_text)) {
            vs.addGlyph((Glyph)SVGReader.createText(e, ctx, meta));
        } else if (tagName.equals(_polygon)) {
            VRectangleOr g = SVGReader.createRectangleFromPolygon(e, ctx, meta);
            if (g != null) {
                vs.addGlyph((Glyph)g);
            } else {
                vs.addGlyph((Glyph)SVGReader.createPolygon(e, ctx, meta));
            }
        } else if (tagName.equals(_polyline)) {
            VSegment[] segments = SVGReader.createPolyline(e, ctx, meta);
            for (int i = 0; i < segments.length; ++i) {
                vs.addGlyph((Glyph)segments[i]);
            }
        } else if (tagName.equals(_line)) {
            vs.addGlyph((Glyph)SVGReader.createLine(e, ctx, meta));
        } else if (tagName.equals(_image)) {
            if (SVGReader.isSVGImage(e)) {
                String height;
                String imagePath = e.getAttributeNS(xlinkURI, _href);
                URL imageURL = SVGReader.getImageURL(imagePath, documentParentURL, fallbackParentURL);
                String width = e.getAttribute(_width);
                if (width.endsWith("px")) {
                    width = width.substring(0, width.length() - 2);
                }
                if ((height = e.getAttribute(_height)).endsWith("px")) {
                    height = height.substring(0, height.length() - 2);
                }
                double w = Double.parseDouble(width);
                double h = Double.parseDouble(height);
                double x = Double.parseDouble(e.getAttribute(_x));
                double y = Double.parseDouble(e.getAttribute(_y));
                double xos = xoffset;
                double yos = yoffset;
                xoffset += x;
                yoffset += y;
                String imPath = imageURL.toString();
                Document imageDoc = SVGReader.parseSVG(imPath, false);
                Element svgRoot = imageDoc.getDocumentElement();
                String viewBox = svgRoot.getAttribute(_viewBox);
                String[] vbs = viewBox.split(SPACE_SEP);
                String xorigin = vbs[0];
                String yorigin = vbs[1];
                String iwidth = vbs[2];
                String iheight = vbs[3];
                double xor = Double.parseDouble(xorigin);
                double yor = Double.parseDouble(yorigin);
                double iw = Double.parseDouble(iwidth);
                double ih = Double.parseDouble(iheight);
                scale = w / iw;
                xoffset -= xor * scale;
                yoffset -= yor * scale;
                SVGReader.load(imageDoc, vs, meta, imPath);
                scale = 1.0;
                xoffset = xos;
                yoffset = yos;
            } else {
                VImage g = SVGReader.createImage(e, ctx, meta, imageStore, documentParentURL, fallbackParentURL);
                if (g != null) {
                    vs.addGlyph((Glyph)g);
                }
            }
        } else if (tagName.equals(_g)) {
            NodeList titles;
            String transform;
            if (ctx == null) {
                ctx = new Context();
            }
            double xos = xoffset;
            double yos = yoffset;
            if (e.hasAttribute(_transform) && (transform = e.getAttribute(_transform)).startsWith(_translate)) {
                String ty;
                String tx;
                int rp;
                int transl = transform.indexOf(_translate);
                String tlate = transform.substring(transl + 10, rp = transform.indexOf(")", transl));
                String[] split = tlate.split(COMMA_SEP);
                if (split.length >= 2) {
                    tx = split[0].trim();
                    ty = split[1].trim();
                } else {
                    split = tlate.split(SPACE_SEP);
                    tx = split[0].trim();
                    ty = split[1].trim();
                }
                xoffset += Double.valueOf(tx) * scale;
                yoffset += Double.valueOf(ty) * scale;
            }
            NodeList objects = e.getChildNodes();
            boolean setAFont = false;
            if (e.hasAttribute(_style)) {
                ctx.add(e.getAttribute(_style));
                if (!mainFontSet) {
                    Font f = ctx.getDefinedFont();
                    if (f != null) {
                        VText.setMainFont((Font)f);
                        setAFont = true;
                    }
                } else {
                    setAFont = true;
                }
            }
            if ((titles = e.getElementsByTagName(_title)).getLength() > 0) {
                try {
                    ctx.setTitle(((Element)titles.item(0)).getFirstChild().getNodeValue());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (e.hasAttribute(_id)) {
                try {
                    ctx.setClosestAncestorGroupID(e.getAttribute(_id));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (e.hasAttribute(_id)) {
                try {
                    ctx.setClosestAncestorGroupClass(e.getAttribute(_class));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            for (int i = 0; i < objects.getLength(); ++i) {
                Node obj = objects.item(i);
                if (obj.getNodeType() != 1) continue;
                SVGReader.processNode((Element)obj, vs, ctx.duplicate(), setAFont, meta, documentParentURL, fallbackParentURL, imageStore);
            }
            xoffset = xos;
            yoffset = yos;
        } else if (tagName.equals(_a)) {
            NodeList objects = e.getChildNodes();
            boolean setAFont = false;
            if (e.hasAttribute(_style)) {
                if (ctx != null) {
                    ctx.add(e.getAttribute(_style));
                } else {
                    ctx = new Context(e.getAttribute(_style));
                }
                if (!mainFontSet) {
                    Font f = ctx.getDefinedFont();
                    if (f != null) {
                        VText.setMainFont((Font)f);
                        setAFont = true;
                    }
                } else {
                    setAFont = true;
                }
            }
            if (e.hasAttributeNS(xlinkURI, _href)) {
                if (ctx == null) {
                    ctx = new Context();
                }
                ctx.setURL(e.getAttributeNS(xlinkURI, _href));
            }
            if (e.hasAttributeNS(xlinkURI, _title)) {
                if (ctx == null) {
                    ctx = new Context();
                }
                ctx.setURLTitle(e.getAttributeNS(xlinkURI, _title));
            }
            for (int i = 0; i < objects.getLength(); ++i) {
                Node obj = objects.item(i);
                if (obj.getNodeType() != 1) continue;
                SVGReader.processNode((Element)obj, vs, ctx != null ? ctx.duplicate() : null, setAFont, meta, documentParentURL, fallbackParentURL, imageStore);
            }
        } else if (!tagName.equals(_title)) {
            System.err.println("SVGReader: unsupported element: " + tagName);
        }
    }

    public static Font getFont(String fontFamily, int fontStyle, int fontSize) {
        Font res;
        if (fontCache.containsKey(fontFamily)) {
            Vector fontData;
            Vector v = (Vector)fontCache.get(fontFamily);
            for (int i = 0; i < v.size(); ++i) {
                fontData = (Vector)v.elementAt(i);
                if ((Integer)fontData.elementAt(0) != fontStyle || (Integer)fontData.elementAt(1) != fontSize) continue;
                return (Font)fontData.elementAt(2);
            }
            fontData = new Vector();
            fontData.addElement(new Integer(fontStyle));
            fontData.addElement(new Integer(fontSize));
            res = new Font(fontFamily, fontStyle, fontSize);
            fontData.addElement(res);
            v.addElement(fontData);
            fontCache.put(fontFamily, v);
        } else {
            Vector<Serializable> fontData = new Vector<Serializable>();
            fontData.addElement(new Integer(fontStyle));
            fontData.addElement(new Integer(fontSize));
            res = new Font(fontFamily, fontStyle, fontSize);
            fontData.addElement(res);
            Vector<Vector<Serializable>> v = new Vector<Vector<Serializable>>();
            v.addElement(fontData);
            fontCache.put(fontFamily, v);
        }
        return res;
    }

    private static void setMetadata(Glyph g, Context ctx) {
        if (ctx != null && (ctx.getURL() != null || ctx.getURLTitle() != null || ctx.getTitle() != null || ctx.getClosestAncestorGroupID() != null || ctx.getClosestAncestorGroupClass() != null)) {
            g.setOwner((Object)new Metadata(ctx.getURL(), ctx.getTitle(), ctx.getURLTitle(), ctx.getClosestAncestorGroupID(), ctx.getClosestAncestorGroupClass()));
        }
    }

    private static boolean specialFont(Font cFont, Font mFont) {
        if (cFont == null) {
            return false;
        }
        return !cFont.getFamily().equals(mFont.getFamily()) || cFont.getSize() != mFont.getSize() || cFont.getStyle() != mFont.getStyle();
    }

    static URL getImageURL(String imagePath, String documentParentURL, String fallbackParentURL) {
        URL imageURL = null;
        if (imagePath.startsWith(FILE_SCHEME) || imagePath.startsWith(HTTP_SCHEME)) {
            try {
                imageURL = new URL(imagePath);
            }
            catch (MalformedURLException ex) {
                System.err.println("Failed to identify image location: " + imagePath);
            }
        } else if (imagePath.charAt(0) == '/') {
            imagePath = "file://" + imagePath;
            try {
                imageURL = new URL(imagePath);
            }
            catch (MalformedURLException ex) {
                System.err.println("Failed to identify image location: " + imagePath);
            }
        } else if (imagePath.substring(1, 3).equals(":\\")) {
            imagePath = "file:///" + imagePath.replace('\\', '/').replace(':', '|');
            try {
                imageURL = new URL(imagePath);
            }
            catch (MalformedURLException ex) {
                System.err.println("Failed to identify image location: " + imagePath);
            }
        } else {
            String absImagePath = documentParentURL + imagePath;
            try {
                imageURL = new URL(absImagePath);
            }
            catch (MalformedURLException ex) {
                System.err.println("Failed to identify image location: " + imagePath);
            }
            if (imageURL.getProtocol().equals(FILE_PROTOCOL) && fallbackParentURL != null) {
                try {
                    if (!new File(new URI(imageURL.toString())).exists()) {
                        absImagePath = fallbackParentURL + imagePath;
                        try {
                            imageURL = new URL(absImagePath);
                        }
                        catch (MalformedURLException ex) {}
                    }
                }
                catch (Exception ex) {
                    System.err.println("Image icon was found neither at\n" + documentParentURL + imagePath + "nor at\n" + fallbackParentURL + imagePath);
                }
            }
        }
        return imageURL;
    }

    static ImageIcon getImage(String imagePath, String documentParentURL, String fallbackParentURL, Hashtable imageStore) {
        URL imageURL = SVGReader.getImageURL(imagePath, documentParentURL, fallbackParentURL);
        ImageIcon res = null;
        if (imageStore.containsKey(imageURL)) {
            res = (ImageIcon)imageStore.get(imageURL);
        } else {
            try {
                res = new ImageIcon(imageURL);
                imageStore.put(imageURL, res);
            }
            catch (Exception ex) {
                System.err.println("Failed to load image from: " + imageURL.toString());
                res = null;
            }
        }
        return res;
    }

    static boolean isSVGImage(Element e) {
        String imagePath;
        return e.hasAttributeNS(xlinkURI, _href) && (imagePath = e.getAttributeNS(xlinkURI, _href)).endsWith(".svg");
    }

    static Document parseSVG(String uri, boolean validation) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validation);
            if (!validation) {
                factory.setAttribute(LOAD_EXTERNAL_DTD_URL, Boolean.FALSE);
            }
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document res = builder.parse(uri);
            return res;
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

