/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.ui.views.symbexlauncher;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.efm.execution.core.SymbexPreferenceUtil;
import org.eclipse.efm.execution.ui.views.symbexlauncher.SymbexWorkflowView;

public class LaunchConfigurationManager
implements ILaunchConfigurationListener {
    private static final String SYMBEX_LAUNCH_CONFIGURATION_TYPE = "org.eclipse.efm.execution.launchconfiguration.sew_type";
    private SymbexWorkflowView symbexWorkflowView;
    private static ILaunchManager fLaunchManager;
    private static ILaunchConfigurationType fLaunchConfigurationType;
    private final ILaunchConfiguration[] EMPTY_CONFIGURATIONS = new ILaunchConfiguration[0];
    private final String[] EMPTY_NAMES = new String[0];
    protected ILaunchConfiguration[] fConfigurations;
    protected String[] fNames;
    protected ILaunchConfiguration fSelection;

    public LaunchConfigurationManager(SymbexWorkflowView symbexWorkflowView) {
        this.symbexWorkflowView = symbexWorkflowView;
        fLaunchManager = null;
        fLaunchConfigurationType = null;
        this.fConfigurations = this.EMPTY_CONFIGURATIONS;
        this.fNames = this.EMPTY_NAMES;
        this.fSelection = null;
        this.addLaunchConfigurationListener();
        this.refresh();
    }

    public void refresh() {
        fLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        fLaunchConfigurationType = fLaunchManager.getLaunchConfigurationType(SYMBEX_LAUNCH_CONFIGURATION_TYPE);
        try {
            this.fConfigurations = fLaunchManager.getLaunchConfigurations(fLaunchConfigurationType);
            if (this.fSelection == null && this.fConfigurations.length > 0) {
                this.fSelection = this.fConfigurations[0];
            }
            this.fNames = new String[this.fConfigurations.length];
            int i = 0;
            while (i < this.fConfigurations.length) {
                this.fNames[i] = this.fConfigurations[i].getName();
                ++i;
            }
            this.select(SymbexPreferenceUtil.getStringPreference((String)"org.eclipse.efm.execution.core.PREF_LAUNCH_CONFIGURATION_SELECTION"));
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.fConfigurations = this.EMPTY_CONFIGURATIONS;
            this.fNames = this.EMPTY_NAMES;
        }
    }

    public boolean isPopulated() {
        return this.fConfigurations.length > 0;
    }

    public ILaunchConfiguration[] getConfigurations() {
        return this.fConfigurations;
    }

    public ILaunchConfiguration firstConfiguration() {
        return this.fConfigurations[0];
    }

    public ILaunchConfiguration getConfiguration(int index) {
        return this.fConfigurations[index];
    }

    public ILaunchConfiguration getSelection() {
        return this.fSelection;
    }

    public int getSelectionIndex() {
        int index = 0;
        while (index < this.fConfigurations.length) {
            if (this.fSelection == this.fConfigurations[index]) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean hasSelection() {
        return this.fSelection != null;
    }

    public void initializeSelection(int defaultIndex) {
        if (this.fSelection == null) {
            this.select(defaultIndex);
        }
    }

    public void select(int index) {
        this.fSelection = index >= 0 && index < this.fConfigurations.length ? this.fConfigurations[index] : null;
    }

    public void select(String configurationName) {
        if (configurationName != null) {
            ILaunchConfiguration[] iLaunchConfigurationArray = this.fConfigurations;
            int n = this.fConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
                if (configurationName.equals(launchConfiguration.getName())) {
                    this.fSelection = launchConfiguration;
                    break;
                }
                ++n2;
            }
        } else {
            this.select(0);
        }
    }

    public String[] getNames() {
        return this.fNames;
    }

    private void addLaunchConfigurationListener() {
        fLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        fLaunchManager.addLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public void dispose() {
        fLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        fLaunchManager.removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        this.refresh();
        this.symbexWorkflowView.refreshLaunchConfigurationsGUI();
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        String chg_name;
        if (configuration.isWorkingCopy()) {
            return;
        }
        List<String> contents = Arrays.asList(this.fNames);
        if (contents.contains(chg_name = configuration.getName())) {
            int new_index = contents.indexOf(chg_name);
            this.symbexWorkflowView.launchConfigurationChanged(configuration, new_index);
        } else {
            this.symbexWorkflowView.launchConfigurationChanged(configuration, -1);
        }
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        this.refresh();
        this.symbexWorkflowView.refreshLaunchConfigurationsGUI();
    }
}

