/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.core.workflow.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum HeuristicClassKind implements Enumerator
{
    BASIC(0, "BASIC", "BASIC"),
    NAIVE(1, "NAIVE", "NAIVE"),
    SMART(2, "SMART", "SMART"),
    AGRESSIVE(3, "AGRESSIVE", "AGRESSIVE"),
    NOTHING_ELSE(4, "NOTHING_ELSE", "NOTHING_ELSE");

    public static final int BASIC_VALUE = 0;
    public static final int NAIVE_VALUE = 1;
    public static final int SMART_VALUE = 2;
    public static final int AGRESSIVE_VALUE = 3;
    public static final int NOTHING_ELSE_VALUE = 4;
    private static final HeuristicClassKind[] VALUES_ARRAY;
    public static final List<HeuristicClassKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new HeuristicClassKind[]{BASIC, NAIVE, SMART, AGRESSIVE, NOTHING_ELSE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static HeuristicClassKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HeuristicClassKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HeuristicClassKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HeuristicClassKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HeuristicClassKind get(int value) {
        switch (value) {
            case 0: {
                return BASIC;
            }
            case 1: {
                return NAIVE;
            }
            case 2: {
                return SMART;
            }
            case 3: {
                return AGRESSIVE;
            }
            case 4: {
                return NOTHING_ELSE;
            }
        }
        return null;
    }

    private HeuristicClassKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

