/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.core.workflow.common.impl;

import org.eclipse.efm.execution.core.workflow.common.CheckingScopeKind;
import org.eclipse.efm.execution.core.workflow.common.CommonFactory;
import org.eclipse.efm.execution.core.workflow.common.CommonPackage;
import org.eclipse.efm.execution.core.workflow.common.ConsoleLogFormat;
import org.eclipse.efm.execution.core.workflow.common.ConsoleVerbosityKind;
import org.eclipse.efm.execution.core.workflow.common.CoverageHeuristic;
import org.eclipse.efm.execution.core.workflow.common.CoverageScopeKind;
import org.eclipse.efm.execution.core.workflow.common.DebuglevelKind;
import org.eclipse.efm.execution.core.workflow.common.DeveloperTuningOption;
import org.eclipse.efm.execution.core.workflow.common.GraphExplorationLimit;
import org.eclipse.efm.execution.core.workflow.common.GraphExplorationQueue;
import org.eclipse.efm.execution.core.workflow.common.GraphExplorationStrategyKind;
import org.eclipse.efm.execution.core.workflow.common.HeuristicClassKind;
import org.eclipse.efm.execution.core.workflow.common.Location;
import org.eclipse.efm.execution.core.workflow.common.Manifest;
import org.eclipse.efm.execution.core.workflow.common.Project;
import org.eclipse.efm.execution.core.workflow.common.RedundancyDetection;
import org.eclipse.efm.execution.core.workflow.common.SymbexOption;
import org.eclipse.efm.execution.core.workflow.common.TraceElement;
import org.eclipse.efm.execution.core.workflow.common.TraceElementKind;
import org.eclipse.efm.execution.core.workflow.common.TraceSpecification;
import org.eclipse.efm.execution.core.workflow.common.Workspace;
import org.eclipse.efm.execution.core.workflow.common.impl.ConsoleLogFormatImpl;
import org.eclipse.efm.execution.core.workflow.common.impl.CoverageHeuristicImpl;
import org.eclipse.efm.execution.core.workflow.common.impl.DeveloperTuningOptionImpl;
import org.eclipse.efm.execution.core.workflow.common.impl.GraphExplorationLimitImpl;
import org.eclipse.efm.execution.core.workflow.common.impl.GraphExplorationQueueImpl;
import org.eclipse.efm.execution.core.workflow.common.impl.LocationImpl;
import org.eclipse.efm.execution.core.workflow.common.impl.ManifestImpl;
import org.eclipse.efm.execution.core.workflow.common.impl.ProjectImpl;
import org.eclipse.efm.execution.core.workflow.common.impl.RedundancyDetectionImpl;
import org.eclipse.efm.execution.core.workflow.common.impl.SymbexOptionImpl;
import org.eclipse.efm.execution.core.workflow.common.impl.TraceElementImpl;
import org.eclipse.efm.execution.core.workflow.common.impl.TraceSpecificationImpl;
import org.eclipse.efm.execution.core.workflow.common.impl.WorkspaceImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class CommonFactoryImpl
extends EFactoryImpl
implements CommonFactory {
    public static CommonFactory init() {
        try {
            CommonFactory theCommonFactory = (CommonFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/efm/Workflow/Common");
            if (theCommonFactory != null) {
                return theCommonFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new CommonFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createWorkspace();
            }
            case 1: {
                return this.createLocation();
            }
            case 2: {
                return this.createProject();
            }
            case 3: {
                return this.createGraphExplorationLimit();
            }
            case 4: {
                return this.createGraphExplorationQueue();
            }
            case 5: {
                return this.createConsoleLogFormat();
            }
            case 6: {
                return this.createTraceElement();
            }
            case 7: {
                return this.createTraceSpecification();
            }
            case 8: {
                return this.createManifest();
            }
            case 9: {
                return this.createSymbexOption();
            }
            case 11: {
                return this.createCoverageHeuristic();
            }
            case 12: {
                return this.createDeveloperTuningOption();
            }
            case 13: {
                return this.createRedundancyDetection();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 14: {
                return this.createGraphExplorationStrategyKindFromString(eDataType, initialValue);
            }
            case 15: {
                return this.createConsoleVerbosityKindFromString(eDataType, initialValue);
            }
            case 16: {
                return this.createTraceElementKindFromString(eDataType, initialValue);
            }
            case 17: {
                return this.createHeuristicClassKindFromString(eDataType, initialValue);
            }
            case 18: {
                return this.createCoverageScopeKindFromString(eDataType, initialValue);
            }
            case 19: {
                return this.createCheckingScopeKindFromString(eDataType, initialValue);
            }
            case 20: {
                return this.createDebuglevelKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 14: {
                return this.convertGraphExplorationStrategyKindToString(eDataType, instanceValue);
            }
            case 15: {
                return this.convertConsoleVerbosityKindToString(eDataType, instanceValue);
            }
            case 16: {
                return this.convertTraceElementKindToString(eDataType, instanceValue);
            }
            case 17: {
                return this.convertHeuristicClassKindToString(eDataType, instanceValue);
            }
            case 18: {
                return this.convertCoverageScopeKindToString(eDataType, instanceValue);
            }
            case 19: {
                return this.convertCheckingScopeKindToString(eDataType, instanceValue);
            }
            case 20: {
                return this.convertDebuglevelKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Workspace createWorkspace() {
        WorkspaceImpl workspace = new WorkspaceImpl();
        return workspace;
    }

    @Override
    public Location createLocation() {
        LocationImpl location = new LocationImpl();
        return location;
    }

    @Override
    public Project createProject() {
        ProjectImpl project = new ProjectImpl();
        return project;
    }

    @Override
    public GraphExplorationLimit createGraphExplorationLimit() {
        GraphExplorationLimitImpl graphExplorationLimit = new GraphExplorationLimitImpl();
        return graphExplorationLimit;
    }

    @Override
    public GraphExplorationQueue createGraphExplorationQueue() {
        GraphExplorationQueueImpl graphExplorationQueue = new GraphExplorationQueueImpl();
        return graphExplorationQueue;
    }

    @Override
    public ConsoleLogFormat createConsoleLogFormat() {
        ConsoleLogFormatImpl consoleLogFormat = new ConsoleLogFormatImpl();
        return consoleLogFormat;
    }

    @Override
    public TraceElement createTraceElement() {
        TraceElementImpl traceElement = new TraceElementImpl();
        return traceElement;
    }

    @Override
    public TraceSpecification createTraceSpecification() {
        TraceSpecificationImpl traceSpecification = new TraceSpecificationImpl();
        return traceSpecification;
    }

    @Override
    public Manifest createManifest() {
        ManifestImpl manifest = new ManifestImpl();
        return manifest;
    }

    @Override
    public SymbexOption createSymbexOption() {
        SymbexOptionImpl symbexOption = new SymbexOptionImpl();
        return symbexOption;
    }

    @Override
    public CoverageHeuristic createCoverageHeuristic() {
        CoverageHeuristicImpl coverageHeuristic = new CoverageHeuristicImpl();
        return coverageHeuristic;
    }

    @Override
    public DeveloperTuningOption createDeveloperTuningOption() {
        DeveloperTuningOptionImpl developerTuningOption = new DeveloperTuningOptionImpl();
        return developerTuningOption;
    }

    @Override
    public RedundancyDetection createRedundancyDetection() {
        RedundancyDetectionImpl redundancyDetection = new RedundancyDetectionImpl();
        return redundancyDetection;
    }

    public GraphExplorationStrategyKind createGraphExplorationStrategyKindFromString(EDataType eDataType, String initialValue) {
        GraphExplorationStrategyKind result = GraphExplorationStrategyKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertGraphExplorationStrategyKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ConsoleVerbosityKind createConsoleVerbosityKindFromString(EDataType eDataType, String initialValue) {
        ConsoleVerbosityKind result = ConsoleVerbosityKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertConsoleVerbosityKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public TraceElementKind createTraceElementKindFromString(EDataType eDataType, String initialValue) {
        TraceElementKind result = TraceElementKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertTraceElementKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public HeuristicClassKind createHeuristicClassKindFromString(EDataType eDataType, String initialValue) {
        HeuristicClassKind result = HeuristicClassKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertHeuristicClassKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public CoverageScopeKind createCoverageScopeKindFromString(EDataType eDataType, String initialValue) {
        CoverageScopeKind result = CoverageScopeKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertCoverageScopeKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public CheckingScopeKind createCheckingScopeKindFromString(EDataType eDataType, String initialValue) {
        CheckingScopeKind result = CheckingScopeKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertCheckingScopeKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DebuglevelKind createDebuglevelKindFromString(EDataType eDataType, String initialValue) {
        DebuglevelKind result = DebuglevelKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDebuglevelKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public CommonPackage getCommonPackage() {
        return (CommonPackage)this.getEPackage();
    }

    @Deprecated
    public static CommonPackage getPackage() {
        return CommonPackage.eINSTANCE;
    }
}

