/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.DefaultSelectionAction;
import fr.inria.zvtm.engine.DynaSpotTimer;
import fr.inria.zvtm.engine.Utils;
import fr.inria.zvtm.engine.VCursor;
import fr.inria.zvtm.event.DynaSpotListener;
import fr.inria.zvtm.event.SelectionListener;
import fr.inria.zvtm.glyphs.Glyph;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.util.HashMap;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class DynaPicker {
    HashMap gida = new HashMap(20);
    int DYNASPOT_MAX_RADIUS = 16;
    int LAG_TIME = 120;
    int REDUC_TIME = 180;
    Color DYNASPOT_COLOR = Color.LIGHT_GRAY;
    float DYNASPOT_MAX_TRANSLUCENCY = 0.3f;
    AlphaComposite dsST = AlphaComposite.getInstance(3, this.DYNASPOT_MAX_TRANSLUCENCY);
    public static final short DYNASPOT_VISIBILITY_INVISIBLE = 0;
    public static final short DYNASPOT_VISIBILITY_VISIBLE = 1;
    public static final short DYNASPOT_VISIBILITY_FADEIN = 2;
    public static final short DYNASPOT_VISIBILITY_FADEOUT = 3;
    short dynaSpotVisibility = 1;
    VCursor cursor;
    int MIN_SPEED = 100;
    int MAX_SPEED = 300;
    float ds_aa;
    float ds_ab;
    float ds_ra;
    float ds_rb;
    int dynaSpotRadius = 0;
    boolean dynaSpotActivated = false;
    boolean showDynarea = true;
    Timer dstimer;
    DynaSpotTimer dynaspotTimer;
    double opacity = 1.0;
    double[] dynawnes = new double[4];
    Ellipse2D dynaspotVSshape = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
    static final int NB_SPEED_POINTS = 4;
    long[] cursor_time = new long[4];
    int[] cursor_x = new int[4];
    int[] cursor_y = new int[4];
    float[] speeds = new float[3];
    float mean_speed = 0.0f;
    boolean dynaspot_triggered = false;
    long lastTimeAboveMinSpeed = -1L;
    boolean reducing = false;
    long reducStartTime = 0L;
    DynaSpotListener dsl;
    Camera refToCam4DynaPick = null;
    Glyph lastDynaPicked = null;
    SelectionListener sl;

    DynaPicker(VCursor c) {
        this.cursor = c;
        this.computeParams();
        this.setSelectionListener(new DefaultSelectionAction());
    }

    void computeParams() {
        this.ds_aa = (float)this.DYNASPOT_MAX_RADIUS / (float)(this.MAX_SPEED - this.MIN_SPEED);
        this.ds_ab = (float)(-this.DYNASPOT_MAX_RADIUS * this.MIN_SPEED) / (float)(this.MAX_SPEED - this.MIN_SPEED);
        this.ds_ra = (float)(-this.DYNASPOT_MAX_RADIUS) / (float)this.REDUC_TIME;
        this.ds_ra = (float)(-this.DYNASPOT_MAX_RADIUS) / (float)(this.REDUC_TIME * this.REDUC_TIME);
        this.ds_rb = this.DYNASPOT_MAX_RADIUS;
    }

    public void setDynaSpotVisibility(short v) {
        this.dynaSpotVisibility = v;
        this.showDynarea = this.dynaSpotVisibility != 0;
    }

    public void setDynaSpotColor(Color c) {
        this.DYNASPOT_COLOR = c;
    }

    public Color getDynaSpotColor() {
        return this.DYNASPOT_COLOR;
    }

    public void setDynaSpotTranslucence(float a) {
        this.DYNASPOT_MAX_TRANSLUCENCY = a;
        this.dsST = AlphaComposite.getInstance(3, this.DYNASPOT_MAX_TRANSLUCENCY);
    }

    public float getDynaSpotTranslucence() {
        return this.DYNASPOT_MAX_TRANSLUCENCY;
    }

    public void setDynaSpotLagTime(int t) {
        this.LAG_TIME = t;
    }

    public int getDynaSpotLagTime() {
        return this.LAG_TIME;
    }

    public void setDynaSpotReducTime(int t) {
        this.REDUC_TIME = t;
        this.computeParams();
    }

    public int getDynaSpotReducTime() {
        return this.REDUC_TIME;
    }

    void initDynaSpotTimer() {
        this.dstimer = new Timer();
        this.dynaspotTimer = new DynaSpotTimer(this);
        this.dstimer.scheduleAtFixedRate((TimerTask)this.dynaspotTimer, 40L, 20L);
    }

    public void updateDynaSpot(long currentTime) {
        int i;
        for (i = 1; i < 4; ++i) {
            this.cursor_time[i - 1] = this.cursor_time[i];
            this.cursor_x[i - 1] = this.cursor_x[i];
            this.cursor_y[i - 1] = this.cursor_y[i];
        }
        this.cursor_time[3] = currentTime;
        this.cursor_x[3] = this.cursor.jpx;
        this.cursor_y[3] = this.cursor.jpy;
        for (i = 0; i < this.speeds.length; ++i) {
            this.speeds[i] = (float)Math.sqrt((this.cursor_x[i + 1] - this.cursor_x[i]) * (this.cursor_x[i + 1] - this.cursor_x[i]) + (this.cursor_y[i + 1] - this.cursor_y[i]) * (this.cursor_y[i + 1] - this.cursor_y[i])) / (float)(this.cursor_time[i + 1] - this.cursor_time[i]);
        }
        this.mean_speed = 0.0f;
        for (i = 0; i < this.speeds.length; ++i) {
            this.mean_speed += this.speeds[i];
        }
        this.mean_speed = this.mean_speed / (float)this.speeds.length * 1000.0f;
        if (this.dynaspot_triggered) {
            if (this.mean_speed > (float)this.MIN_SPEED) {
                this.lastTimeAboveMinSpeed = System.currentTimeMillis();
                if (this.mean_speed > (float)this.MAX_SPEED && this.dynaSpotRadius < this.DYNASPOT_MAX_RADIUS) {
                    this.updateDynaSpotArea(this.DYNASPOT_MAX_RADIUS);
                }
            } else if (this.lastTimeAboveMinSpeed > 0L && currentTime - this.lastTimeAboveMinSpeed >= (long)this.LAG_TIME) {
                this.lastTimeAboveMinSpeed = -1L;
                this.reducing = true;
                this.reducStartTime = currentTime;
                this.dynaspot_triggered = false;
            }
        } else if (this.mean_speed > (float)this.MIN_SPEED) {
            this.lastTimeAboveMinSpeed = System.currentTimeMillis();
            this.dynaspot_triggered = true;
            if (this.mean_speed > (float)this.MAX_SPEED) {
                if (this.dynaSpotRadius < this.DYNASPOT_MAX_RADIUS) {
                    this.updateDynaSpotArea(this.DYNASPOT_MAX_RADIUS);
                }
            } else {
                this.updateDynaSpotArea(Math.round(this.ds_aa * this.mean_speed + this.ds_ab));
            }
        } else if (this.reducing) {
            if (currentTime - this.reducStartTime >= (long)this.REDUC_TIME) {
                this.updateDynaSpotArea(0);
                this.reducing = false;
            } else {
                this.updateDynaSpotArea(Math.round(this.ds_ra * (float)(currentTime - this.reducStartTime) + this.ds_rb));
                this.updateDynaSpotArea(Math.round(this.ds_ra * (float)((currentTime - this.reducStartTime) * (currentTime - this.reducStartTime)) + this.ds_rb));
            }
        }
        this.cursor.owningView.repaint();
    }

    void updateDynaSpotArea(int r) {
        this.dynaSpotRadius = r;
        this.dynaPick();
        if (this.dsl != null) {
            this.dsl.spotSizeChanged(this.cursor, this.dynaSpotRadius);
        }
    }

    public int getDynaSpotRadius() {
        return this.dynaSpotRadius;
    }

    public void setDynaSpotListener(DynaSpotListener dsl) {
        this.dsl = dsl;
    }

    public DynaSpotListener getDynaSpotListener() {
        return this.dsl;
    }

    public void activateDynaSpot(boolean b) {
        this.dynaSpotActivated = b;
        if (this.dynaSpotActivated) {
            if (this.dstimer != null) {
                this.dstimer.cancel();
            }
            this.initDynaSpotTimer();
        } else {
            try {
                this.dstimer.cancel();
                this.dstimer = null;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public boolean isDynaSpotActivated() {
        return this.dynaSpotActivated;
    }

    public void setDynaSpotMaxRadius(int r) {
        this.DYNASPOT_MAX_RADIUS = r < 0 ? 0 : r;
        this.computeParams();
    }

    public int getDynaSpotMaxRadius() {
        return this.DYNASPOT_MAX_RADIUS;
    }

    void dynaPick() {
        this.dynaPick(this.refToCam4DynaPick);
    }

    public void setSelectionListener(SelectionListener sl) {
        this.sl = sl;
    }

    public SelectionListener getSelectionListener() {
        return this.sl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Glyph dynaPick(Camera c) {
        if (c == null) {
            return null;
        }
        this.refToCam4DynaPick = c;
        Vector<Glyph> drawnGlyphs = c.getOwningSpace().getDrawnGlyphs(c.getIndex());
        Glyph selectedGlyph = null;
        double distanceToSelectedGlyph = -1.0;
        int gumIndex = -1;
        int cgumIndex = -1;
        double unprojectedDSRadius = (c.focal + c.altitude) / c.focal * (double)this.dynaSpotRadius;
        this.dynawnes[0] = this.cursor.vx - unprojectedDSRadius;
        this.dynawnes[1] = this.cursor.vy + unprojectedDSRadius;
        this.dynawnes[2] = this.cursor.vx + unprojectedDSRadius;
        this.dynawnes[3] = this.cursor.vy - unprojectedDSRadius;
        this.dynaspotVSshape.setFrame(this.dynawnes[0], this.dynawnes[3], 2.0 * unprojectedDSRadius, 2.0 * unprojectedDSRadius);
        Vector<Glyph> vector = drawnGlyphs;
        synchronized (vector) {
            for (int i = 0; i < drawnGlyphs.size(); ++i) {
                Glyph g = drawnGlyphs.elementAt(i);
                if (!g.isSensitive()) continue;
                cgumIndex = Utils.indexOfGlyph(this.cursor.getPicker().pickedGlyphs, g, this.cursor.getPicker().maxIndex + 1);
                if (cgumIndex > -1) {
                    if (cgumIndex > gumIndex) {
                        gumIndex = cgumIndex;
                        selectedGlyph = g;
                        distanceToSelectedGlyph = 0.0;
                    }
                    this.gida.put(g, null);
                    continue;
                }
                if (g.visibleInRegion(this.dynawnes[0], this.dynawnes[1], this.dynawnes[2], this.dynawnes[3], c.getIndex()) && g.visibleInDisc(this.cursor.vx, this.cursor.vy, unprojectedDSRadius, this.dynaspotVSshape, c.getIndex(), this.cursor.jpx, this.cursor.jpy, this.dynaSpotRadius)) {
                    this.gida.put(g, null);
                    double d = Math.sqrt((g.vx - this.cursor.vx) * (g.vx - this.cursor.vx) + (g.vy - this.cursor.vy) * (g.vy - this.cursor.vy));
                    if (distanceToSelectedGlyph != -1.0 && !(d < distanceToSelectedGlyph)) continue;
                    selectedGlyph = g;
                    distanceToSelectedGlyph = d;
                    continue;
                }
                if (!this.gida.containsKey(g)) continue;
                this.gida.remove(g);
                if (this.sl == null) continue;
                this.sl.glyphSelected(g, false);
            }
        }
        if (selectedGlyph != null && this.sl != null) {
            this.sl.glyphSelected(selectedGlyph, true);
        }
        if (this.lastDynaPicked != null && selectedGlyph != this.lastDynaPicked && this.sl != null) {
            this.sl.glyphSelected(this.lastDynaPicked, false);
        }
        this.lastDynaPicked = selectedGlyph;
        return selectedGlyph;
    }

    public Set getGlyphsInDynaSpotRegion(Camera c) {
        return this.gida.keySet();
    }
}

