/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.event.ViewListener;
import fr.inria.zvtm.glyphs.VText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.Timer;

public class StdViewPanel
extends ViewPanel {
    protected JPanel panel = new JPanel(){

        @Override
        public void paint(Graphics g) {
            if (StdViewPanel.this.backBuffer != null) {
                g.drawImage(StdViewPanel.this.backBuffer, 0, 0, StdViewPanel.this.panel);
            }
        }
    };
    BufferedImage backBuffer;
    int backBufferW = 0;
    int backBufferH = 0;
    private Graphics2D backBufferGraphics = null;
    Dimension oldSize;
    Graphics2D lensG2D = null;
    private Timer edtTimer;

    @Override
    public Component getComponent() {
        return this.panel;
    }

    StdViewPanel(Vector<Camera> cameras, View v, boolean arfome) {
        ActionListener taskPerformer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StdViewPanel.this.drawOffscreen();
            }
        };
        this.edtTimer = new Timer(20, taskPerformer);
        this.panel.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (StdViewPanel.this.panel.isShowing()) {
                    StdViewPanel.this.start();
                } else {
                    StdViewPanel.this.stop();
                }
            }
        });
        this.parent = v;
        this.cams = new Camera[cameras.size()];
        this.evHs = new ViewListener[this.cams.length];
        for (int nbcam = 0; nbcam < cameras.size(); ++nbcam) {
            this.cams[nbcam] = cameras.get(nbcam);
        }
        this.visibilityPadding = new int[this.cams.length][4];
        for (int i = 0; i < this.visibilityPadding.length; ++i) {
            Arrays.fill(this.visibilityPadding[i], 0);
        }
        this.drawInLens = new boolean[this.cams.length];
        this.drawInContext = new boolean[this.cams.length];
        Arrays.fill(this.drawInLens, true);
        Arrays.fill(this.drawInContext, true);
        this.panel.setBackground(this.backColor);
        this.panel.addMouseListener(this);
        this.panel.addMouseMotionListener(this);
        this.panel.addMouseWheelListener(this);
        this.panel.addComponentListener(this);
        this.panel.setDoubleBuffered(false);
        this.setAutoRequestFocusOnMouseEnter(arfome);
        this.setAWTCursor(-1);
        this.size = this.panel.getSize();
        if (VirtualSpaceManager.debugModeON()) {
            System.out.println("View refresh time set to " + this.getRefreshRate() + "ms");
        }
    }

    private void start() {
        this.backBufferGraphics = null;
        this.edtTimer.start();
    }

    @Override
    void stop() {
        this.edtTimer.stop();
        if (this.stableRefToBackBufferGraphics != null) {
            this.stableRefToBackBufferGraphics.dispose();
        }
    }

    private void updateOffscreenBuffer() {
        this.size = this.panel.getSize();
        if (this.size.width != this.oldSize.width || this.size.height != this.oldSize.height || this.backBufferW != this.size.width || this.backBufferH != this.size.height) {
            this.backBuffer = null;
            if (this.backBufferGraphics != null) {
                this.backBufferGraphics.dispose();
                this.backBufferGraphics = null;
            }
            if (this.lens != null) {
                this.lens.resetMagnificationBuffer();
                if (this.lensG2D != null) {
                    this.lensG2D.dispose();
                    this.lensG2D = null;
                }
            }
            if (VirtualSpaceManager.debugModeON()) {
                System.out.println("Resizing JPanel: (" + this.oldSize.width + "x" + this.oldSize.height + ") -> (" + this.size.width + "x" + this.size.height + ")");
            }
            this.oldSize = this.size;
            this.updateAntialias = true;
            this.updateFont = true;
        }
        if (this.backBuffer == null) {
            this.gconf = this.panel.getGraphicsConfiguration();
            this.backBuffer = this.gconf.createCompatibleImage(this.size.width > 0 ? this.size.width : 1, this.size.height > 0 ? this.size.height : 1);
            this.backBufferW = this.backBuffer.getWidth();
            this.backBufferH = this.backBuffer.getHeight();
            if (this.backBufferGraphics != null) {
                this.backBufferGraphics.dispose();
                this.backBufferGraphics = null;
            }
        }
        if (this.backBufferGraphics == null) {
            this.backBufferGraphics = this.backBuffer.createGraphics();
            this.updateAntialias = true;
            this.updateFont = true;
        }
        if (this.lens != null) {
            this.lensG2D = this.lens.getMagnificationGraphics();
            this.lensG2D.setFont(VText.getMainFont());
            if (this.antialias) {
                this.lensG2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                this.lensG2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }
        if (this.updateFont) {
            this.backBufferGraphics.setFont(VText.getMainFont());
            if (this.lensG2D != null) {
                this.lensG2D.setFont(VText.getMainFont());
            }
            this.updateFont = false;
        }
        if (this.updateAntialias) {
            if (this.antialias) {
                this.backBufferGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this.lensG2D != null) {
                    this.lensG2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
            } else {
                this.backBufferGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                if (this.lensG2D != null) {
                    this.lensG2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
            }
            this.updateAntialias = false;
        }
        this.stableRefToBackBufferGraphics = this.backBufferGraphics;
        this.standardStroke = this.stableRefToBackBufferGraphics.getStroke();
        this.standardTransform = this.stableRefToBackBufferGraphics.getTransform();
    }

    private void drawScene(boolean drawLens) {
        block14: {
            if (drawLens) {
                if (this.lensG2D == null) {
                    this.updateOffscreenBuffer();
                }
                this.lensG2D.setPaintMode();
                this.lensG2D.setBackground(this.backColor);
                this.lensG2D.clearRect(0, 0, this.lens.mbw, this.lens.mbh);
            }
            for (int nbcam = 0; nbcam < this.cams.length; ++nbcam) {
                if (this.cams[nbcam] == null || !this.cams[nbcam].enabled || !this.cams[nbcam].eager && !this.cams[nbcam].shouldRepaint()) continue;
                this.camIndex = this.cams[nbcam].getIndex();
                this.drawnGlyphs = this.cams[nbcam].parentSpace.getDrawnGlyphs(this.camIndex);
                this.drawnGlyphs.removeAllElements();
                double uncoef = (this.cams[nbcam].focal + this.cams[nbcam].altitude) / this.cams[nbcam].focal;
                double viewW = this.size.width;
                double viewH = this.size.height;
                double viewWC = this.cams[nbcam].vx - (viewW / 2.0 - (double)this.visibilityPadding[nbcam][0]) * uncoef;
                double viewNC = this.cams[nbcam].vy + (viewH / 2.0 - (double)this.visibilityPadding[nbcam][1]) * uncoef;
                double viewEC = this.cams[nbcam].vx + (viewW / 2.0 - (double)this.visibilityPadding[nbcam][2]) * uncoef;
                double viewSC = this.cams[nbcam].vy - (viewH / 2.0 - (double)this.visibilityPadding[nbcam][3]) * uncoef;
                double lviewWC = 0.0;
                double lviewNC = 0.0;
                double lviewEC = 0.0;
                double lviewSC = 0.0;
                double lensVx = 0.0;
                double lensVy = 0.0;
                if (drawLens && this.drawInLens[nbcam]) {
                    lviewWC = this.cams[nbcam].vx + (double)(this.lens.lx - this.lens.lensWidth / 2) * uncoef;
                    lviewNC = this.cams[nbcam].vy + (double)(-this.lens.ly + this.lens.lensHeight / 2) * uncoef;
                    lviewEC = this.cams[nbcam].vx + (double)(this.lens.lx + this.lens.lensWidth / 2) * uncoef;
                    lviewSC = this.cams[nbcam].vy + (double)(-this.lens.ly - this.lens.lensHeight / 2) * uncoef;
                    lensVx = (lviewWC + lviewEC) / 2.0;
                    lensVy = (lviewSC + lviewNC) / 2.0;
                }
                this.gll = this.cams[nbcam].parentSpace.getDrawingList();
                for (int i = 0; i < this.gll.length; ++i) {
                    if (this.gll[i] == null || !this.gll[i].visibleInViewport(viewWC, viewNC, viewEC, viewSC, this.cams[nbcam])) continue;
                    if (this.drawInContext[nbcam]) {
                        this.gll[i].project(this.cams[nbcam], this.size);
                        if (this.gll[i].isVisible()) {
                            this.gll[i].draw(this.stableRefToBackBufferGraphics, this.size.width, this.size.height, this.cams[nbcam].getIndex(), this.standardStroke, this.standardTransform, 0, 0);
                        }
                    }
                    if (drawLens && this.drawInLens[nbcam] && this.gll[i].visibleInViewport(lviewWC, lviewNC, lviewEC, lviewSC, this.cams[nbcam])) {
                        this.gll[i].projectForLens(this.cams[nbcam], this.lens.mbw, this.lens.mbh, this.lens.getMaximumMagnification(), lensVx, lensVy);
                        if (this.gll[i].isVisibleThroughLens()) {
                            this.gll[i].drawForLens(this.lensG2D, this.lens.mbw, this.lens.mbh, this.cams[nbcam].getIndex(), this.standardStroke, this.standardTransform, 0, 0);
                        }
                    }
                    this.cams[nbcam].parentSpace.drewGlyph(this.gll[i], this.camIndex);
                }
            }
            this.foregroundHook();
            if (drawLens) {
                try {
                    this.lens.transform(this.backBuffer);
                    this.lens.drawBoundary(this.stableRefToBackBufferGraphics);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    if (VirtualSpaceManager.debugModeON()) {
                        ex.printStackTrace();
                    }
                }
                catch (NullPointerException ex2) {
                    if (!VirtualSpaceManager.debugModeON()) break block14;
                    ex2.printStackTrace();
                }
            }
        }
    }

    private void drawCursor() {
        this.stableRefToBackBufferGraphics.setColor(this.parent.mouse.hcolor);
        if (this.drawDrag) {
            this.stableRefToBackBufferGraphics.drawLine(this.origDragx, this.origDragy, this.parent.mouse.jpx, this.parent.mouse.jpy);
        }
        if (this.drawRect) {
            this.stableRefToBackBufferGraphics.drawRect(Math.min(this.origDragx, this.parent.mouse.jpx), Math.min(this.origDragy, this.parent.mouse.jpy), Math.max(this.origDragx, this.parent.mouse.jpx) - Math.min(this.origDragx, this.parent.mouse.jpx), Math.max(this.origDragy, this.parent.mouse.jpy) - Math.min(this.origDragy, this.parent.mouse.jpy));
        }
        if (this.drawOval) {
            if (this.circleOnly) {
                this.stableRefToBackBufferGraphics.drawOval(this.origDragx - Math.abs(this.origDragx - this.parent.mouse.jpx), this.origDragy - Math.abs(this.origDragx - this.parent.mouse.jpx), 2 * Math.abs(this.origDragx - this.parent.mouse.jpx), 2 * Math.abs(this.origDragx - this.parent.mouse.jpx));
            } else {
                this.stableRefToBackBufferGraphics.drawOval(this.origDragx - Math.abs(this.origDragx - this.parent.mouse.jpx), this.origDragy - Math.abs(this.origDragy - this.parent.mouse.jpy), 2 * Math.abs(this.origDragx - this.parent.mouse.jpx), 2 * Math.abs(this.origDragy - this.parent.mouse.jpy));
            }
        }
        if (this.sfopw) {
            this.stableRefToBackBufferGraphics.drawImage(this.FIRST_ORDER_PAN_WIDGET, this.fopw_x, this.fopw_y, null);
        }
        if (this.drawVTMcursor) {
            this.stableRefToBackBufferGraphics.setXORMode(this.backColor);
            this.parent.mouse.draw(this.stableRefToBackBufferGraphics);
            this.oldX = this.parent.mouse.jpx;
            this.oldY = this.parent.mouse.jpy;
        }
    }

    private void doCursorPicking() {
        block3: {
            try {
                this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                if (this.parent.mouse.isSensitive()) {
                    this.parent.mouse.getPicker().computePickedGlyphList(this.evHs[this.activeLayer], this.cams[this.activeLayer], this);
                }
            }
            catch (NullPointerException ex) {
                if (!VirtualSpaceManager.debugModeON()) break block3;
                System.err.println("viewpanel.run.drawdrag " + ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawOffscreen() {
        block19: {
            this.oldSize = this.panel.getSize();
            if (this.notBlank) {
                if (this.repaintable) {
                    if (this.repaintASAP) {
                        try {
                            this.repaintASAP = false;
                            this.updateCursorOnly = false;
                            this.updateOffscreenBuffer();
                            this.stableRefToBackBufferGraphics.setPaintMode();
                            this.stableRefToBackBufferGraphics.setBackground(this.backColor);
                            this.stableRefToBackBufferGraphics.clearRect(0, 0, this.size.width, this.size.height);
                            this.backgroundHook();
                            if (this.lens != null) {
                                this.drawScene(true);
                            } else {
                                this.drawScene(false);
                            }
                            this.afterLensHook();
                            this.drawPortals();
                            this.portalsHook();
                            if (this.cursor_inside) {
                                this.doCursorPicking();
                                this.drawCursor();
                            }
                            if (this.stableRefToBackBufferGraphics != this.backBufferGraphics) break block19;
                            this.panel.paintImmediately(0, 0, this.size.width, this.size.height);
                            if (this.repaintListener != null) {
                                this.repaintListener.viewRepainted(this.parent);
                            }
                            StdViewPanel stdViewPanel = this;
                            synchronized (stdViewPanel) {
                                this.lastButOneRepaint = this.lastRepaint;
                                this.lastRepaint = System.currentTimeMillis();
                                this.delay = this.lastRepaint - this.lastButOneRepaint;
                                break block19;
                            }
                        }
                        catch (NullPointerException ex0) {
                            if (VirtualSpaceManager.debugModeON()) {
                                System.err.println("viewpanel.run (probably due to backBuffer.createGraphics()) " + ex0);
                                ex0.printStackTrace();
                            }
                            break block19;
                        }
                    }
                    if (this.updateCursorOnly) {
                        block20: {
                            this.updateCursorOnly = false;
                            this.doCursorPicking();
                            if (this.drawVTMcursor) {
                                try {
                                    this.stableRefToBackBufferGraphics.setXORMode(this.backColor);
                                    this.stableRefToBackBufferGraphics.setColor(this.parent.mouse.color);
                                    this.stableRefToBackBufferGraphics.drawLine(this.oldX - this.parent.mouse.size, this.oldY, this.oldX + this.parent.mouse.size, this.oldY);
                                    this.stableRefToBackBufferGraphics.drawLine(this.oldX, this.oldY - this.parent.mouse.size, this.oldX, this.oldY + this.parent.mouse.size);
                                    this.stableRefToBackBufferGraphics.drawLine(this.parent.mouse.jpx - this.parent.mouse.size, this.parent.mouse.jpy, this.parent.mouse.jpx + this.parent.mouse.size, this.parent.mouse.jpy);
                                    this.stableRefToBackBufferGraphics.drawLine(this.parent.mouse.jpx, this.parent.mouse.jpy - this.parent.mouse.size, this.parent.mouse.jpx, this.parent.mouse.jpy + this.parent.mouse.size);
                                    this.oldX = this.parent.mouse.jpx;
                                    this.oldY = this.parent.mouse.jpy;
                                }
                                catch (NullPointerException ex47) {
                                    if (!VirtualSpaceManager.debugModeON()) break block20;
                                    System.err.println("viewpanel.run.runview.drawVTMcursor " + ex47);
                                }
                            }
                        }
                        this.panel.paintImmediately(0, 0, this.size.width, this.size.height);
                    }
                }
            } else {
                this.updateOffscreenBuffer();
                this.stableRefToBackBufferGraphics.setPaintMode();
                this.stableRefToBackBufferGraphics.setColor(this.blankColor);
                this.stableRefToBackBufferGraphics.fillRect(0, 0, this.panel.getWidth(), this.panel.getHeight());
                this.portalsHook();
                this.panel.paintImmediately(0, 0, this.size.width, this.size.height);
                if (this.repaintListener != null) {
                    this.repaintListener.viewRepainted(this.parent);
                }
            }
        }
    }

    @Override
    void eraseCursor() {
        block3: {
            try {
                if (this.drawVTMcursor) {
                    this.stableRefToBackBufferGraphics.setXORMode(this.backColor);
                    this.stableRefToBackBufferGraphics.setColor(this.parent.mouse.color);
                    this.stableRefToBackBufferGraphics.drawLine(this.parent.mouse.jpx - this.parent.mouse.size, this.parent.mouse.jpy, this.parent.mouse.jpx + this.parent.mouse.size, this.parent.mouse.jpy);
                    this.stableRefToBackBufferGraphics.drawLine(this.parent.mouse.jpx, this.parent.mouse.jpy - this.parent.mouse.size, this.parent.mouse.jpx, this.parent.mouse.jpy + this.parent.mouse.size);
                    this.panel.paintImmediately(0, 0, this.size.width, this.size.height);
                }
            }
            catch (NullPointerException ex47) {
                if (!VirtualSpaceManager.debugModeON()) break block3;
                System.err.println("viewpanel.run.runview.drawVTMcursor " + ex47);
            }
        }
    }

    @Override
    public BufferedImage getImage() {
        return this.backBuffer;
    }

    @Override
    public void setRefreshRate(int rr) {
        this.edtTimer.setDelay(rr);
    }

    @Override
    public int getRefreshRate() {
        return this.edtTimer.getDelay();
    }
}

