/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.lens;

import fr.inria.zvtm.engine.LowPassFilter;
import fr.inria.zvtm.engine.SpeedCoupling;
import fr.inria.zvtm.glyphs.Translucency;
import fr.inria.zvtm.glyphs.Translucent;
import fr.inria.zvtm.lens.BGaussianLens;
import fr.inria.zvtm.lens.DGTrailingTimer;
import fr.inria.zvtm.lens.TemporalLens;
import fr.inria.zvtm.lens.TemporalParamListener;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Timer;
import java.util.TimerTask;

public class SCBGaussianLens
extends BGaussianLens
implements TemporalLens {
    protected double frequency = -1.0;
    protected long mLastSampleTime = -1L;
    protected int xOffset = -10;
    protected int yOffset = 10;
    protected double maxDist = 2 * Math.abs(this.xOffset);
    protected LowPassFilter filter = new LowPassFilter();
    protected Point2D currentPos = new Point2D.Double(0.0, 0.0);
    protected Point2D parentPos = new Point2D.Double(0.0, 0.0);
    protected Point2D targetPos = new Point2D.Double(0.0, 0.0);
    protected Timer timer;
    protected DGTrailingTimer mouseStillUpdater;
    protected double cutoffParamA = 0.01;
    protected double cutoffParamB = 0.05;
    protected SpeedCoupling speedCoupling = new SpeedCoupling();
    protected boolean speedCoupled = true;
    protected float dMM = this.MM;
    protected float maxTranslucency = 1.0f;
    protected float scRingRadius = this.LR2;
    protected boolean doRing = false;
    protected boolean doDrawRing = false;
    TemporalParamListener tpl;
    float a = 1.0f;
    float b = 0.0f;
    protected float mindMM = 1.0f;
    boolean doDrawMaxFlatTop = false;
    boolean doSpeedBlendOuterRadius = true;
    boolean doSpeedBlendFlatTop = true;

    public SCBGaussianLens() {
        this.initTimer();
    }

    public SCBGaussianLens(float mm) {
        super(mm);
        this.dMM = this.MM;
        this.initTimer();
    }

    public SCBGaussianLens(float mm, float tc, float tf, int outerRadius, int innerRadius) {
        super(mm, tc, tf, outerRadius, innerRadius);
        this.dMM = this.MM;
        this.initTimer();
    }

    public SCBGaussianLens(float mm, float tc, float tf, int outerRadius, int innerRadius, int x, int y) {
        super(mm, tc, tf, outerRadius, innerRadius, x, y);
        this.dMM = this.MM;
        this.initTimer();
    }

    void initTimer() {
        this.speedCoupling.setCoefParameters(0.15f, 0.0f);
        this.speedCoupling.setSpeedParameters(75.0f);
        this.speedCoupling.setTimeParameters(200L, 500L);
        this.timer = new Timer();
        this.mouseStillUpdater = new DGTrailingTimer(this);
        this.timer.scheduleAtFixedRate((TimerTask)this.mouseStillUpdater, 40L, 10L);
    }

    void computeOpacityFactors(float minT, float maxT) {
        this.a = maxT - minT;
        this.b = minT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAbsolutePosition(int ax, int ay, long absTime) {
        SCBGaussianLens sCBGaussianLens = this;
        synchronized (sCBGaussianLens) {
            super.setAbsolutePosition(ax, ay);
            if (this.speedCoupled) {
                this.updateFrequency(absTime);
                this.updateTimeBasedParams(ax, ay);
                if (this.speedCoupling != null) {
                    this.speedCoupling.addPoint(ax, ay, absTime);
                }
            }
        }
    }

    public void updateFrequency() {
        this.updateFrequency(System.currentTimeMillis());
    }

    public void updateFrequency(long currentTime) {
        if (this.frequency == -1.0) {
            this.frequency = 1.0;
        } else if (currentTime != this.mLastSampleTime) {
            this.frequency = 1000.0 / (double)(currentTime - this.mLastSampleTime);
        }
        this.mLastSampleTime = currentTime;
    }

    @Override
    public void updateTimeBasedParams(int cx, int cy) {
        this.parentPos.setLocation(cx, cy);
        this.updateTimeBasedParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimeBasedParams() {
        SCBGaussianLens sCBGaussianLens = this;
        synchronized (sCBGaussianLens) {
            float bR;
            double opacity;
            if (this.speedCoupling != null) {
                opacity = 1.0 - (double)this.speedCoupling.getCoef();
            } else {
                this.targetPos.setLocation(this.parentPos.getX() + (double)this.xOffset, this.parentPos.getY() + (double)this.yOffset);
                double distAway = this.targetPos.distance(this.currentPos);
                opacity = 1.0 - Math.min(1.0, distAway / this.maxDist);
                this.filter.setCutOffFrequency((1.0 - opacity) * this.cutoffParamA + this.cutoffParamB);
                this.currentPos = this.filter.apply(this.targetPos, this.frequency);
                int tx = (int)Math.round(this.currentPos.getX());
                int ty = (int)Math.round(this.currentPos.getY());
                tx = Math.max(tx, this.w / 2);
                ty = Math.min(ty, this.owningView.parent.getPanelSize().height - this.h / 2);
            }
            float nMMTf = (float)opacity * this.a + this.b;
            if (Math.abs(this.MMTf - nMMTf) > 0.01f) {
                this.MMTf = nMMTf;
                this.setDynamicTranslucency();
                this.owningView.parent.repaint();
                if (this.tpl != null) {
                    this.tpl.parameterUpdated();
                }
            }
            this.dMM = (float)opacity * (this.MM - this.mindMM) + this.mindMM;
            if (this.doRing && Math.abs((bR = Math.min((float)this.LR2, (float)opacity * (float)this.LR2 + 1.0f)) - this.scRingRadius) > 1.0f) {
                this.scRingRadius = bR;
                this.owningView.parent.repaint();
            }
        }
    }

    void setDynamicTranslucency() {
        this.cT = (this.MMTf - this.MMTc) / 2.0f;
        this.eT = (this.MMTf + this.MMTc) / 2.0f;
        this.owningView.parent.repaint();
    }

    public void setCutoffFrequencyParameters(double a, double b) {
        this.cutoffParamA = a;
        this.cutoffParamB = b;
    }

    public void setSpeedCoupling(SpeedCoupling sc) {
        this.speedCoupled = true;
        this.speedCoupling = sc;
    }

    @Override
    public void setNoUpdateWhenMouseStill(boolean b) {
        this.mouseStillUpdater.setEnabled(!b);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.timer.cancel();
    }

    @Override
    public void gf(float x, float y, float[] g) {
        this.d = Math.sqrt((x - (float)this.sw - (float)this.lx) * (x - (float)this.sw - (float)this.lx) + (y - (float)this.sh - (float)this.ly) * (y - (float)this.sh - (float)this.ly));
        if (this.d <= (double)this.LR2) {
            g[0] = g[1] = this.dMM;
        } else if (this.d <= (double)this.LR1) {
            g[0] = g[1] = (float)(this.cT * Math.cos(this.aT * this.d + this.bT) + this.eT);
        } else {
            g[1] = 1.0f;
            g[0] = 1.0f;
        }
    }

    public void setMinMagFactor(float minMagFac) {
        this.mindMM = minMagFac = minMagFac < 1.0f ? 1.0f : minMagFac;
    }

    public void setMaxTranslucency(float maxAlpha) {
        this.computeOpacityFactors(0.0f, maxAlpha);
        this.maxTranslucency = maxAlpha;
    }

    public void setDoRing(boolean b) {
        this.doRing = b;
    }

    public boolean getDoRing() {
        return this.doRing;
    }

    public void setDoDrawRing(boolean b) {
        this.doDrawRing = b;
    }

    public void setDrawMaxFlatTop(boolean b) {
        this.doDrawMaxFlatTop = b;
    }

    public void setSpeedBlendRadii(boolean bft, boolean bor) {
        this.doSpeedBlendFlatTop = bft;
        this.doSpeedBlendOuterRadius = bor;
    }

    @Override
    public void drawBoundary(Graphics2D g2d) {
        Color bColor = null;
        Color rColor = null;
        if (bColor != null) {
            g2d.setColor(bColor);
            g2d.drawOval(this.lx + this.w / 2 - this.lensWidth / 2, this.ly + this.h / 2 - this.lensHeight / 2, this.lensWidth, this.lensHeight);
        }
        if (rColor != null) {
            this.lensProjectedWidth = Math.round((float)this.lensWidth / this.MM);
            this.lensProjectedHeight = Math.round((float)this.lensHeight / this.MM);
            g2d.setColor(rColor);
            g2d.setComposite(Translucency.acs[Math.round((1.0f - this.MMTf) * 20.0f)]);
            g2d.drawOval(this.lx + this.w / 2 - this.lensProjectedWidth / 2, this.ly + this.h / 2 - this.lensProjectedHeight / 2, this.lensProjectedWidth, this.lensProjectedHeight);
            g2d.setComposite(Translucent.acO);
        }
        if (this.doRing && rColor != null) {
            g2d.setColor(rColor);
            float dbr = Math.max((float)this.lensProjectedWidth / 2.0f, this.scRingRadius - 2.0f);
            g2d.drawOval(this.lx + this.w / 2 - (int)dbr, this.ly + this.h / 2 - (int)dbr, 2 * (int)dbr, 2 * (int)dbr);
        }
    }

    @Override
    public float getActualMaximumMagnification() {
        return this.dMM;
    }

    @Override
    public float getActualRingRadius() {
        return this.scRingRadius;
    }

    @Override
    public void setTemporalParamListener(TemporalParamListener tpl) {
        this.tpl = tpl;
    }

    @Override
    public TemporalParamListener getTemporalParamListener() {
        return this.tpl;
    }

    public void setSpeedCoupled(boolean b) {
        this.speedCoupled = b;
    }

    public boolean getSpeedCoupled() {
        return this.speedCoupled;
    }
}

