/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.lens;

import fr.inria.zvtm.engine.LowPassFilter;
import fr.inria.zvtm.engine.SpeedCoupling;
import fr.inria.zvtm.glyphs.Translucency;
import fr.inria.zvtm.glyphs.Translucent;
import fr.inria.zvtm.lens.DGTrailingTimer;
import fr.inria.zvtm.lens.FSGaussianLens;
import fr.inria.zvtm.lens.TemporalLens;
import fr.inria.zvtm.lens.TemporalParamListener;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Timer;
import java.util.TimerTask;

public class SCFGaussianLens
extends FSGaussianLens
implements TemporalLens {
    protected double frequency = -1.0;
    protected long mLastSampleTime = -1L;
    protected int xOffset = -10;
    protected int yOffset = 10;
    protected double maxDist = 2 * Math.abs(this.xOffset);
    protected LowPassFilter filter = new LowPassFilter();
    protected Point2D currentPos = new Point2D.Double(0.0, 0.0);
    protected Point2D parentPos = new Point2D.Double(0.0, 0.0);
    protected Point2D targetPos = new Point2D.Double(0.0, 0.0);
    protected Timer timer;
    protected DGTrailingTimer mouseStillUpdater;
    protected double cutoffParamA = 0.1;
    protected double cutoffParamB = 0.01;
    protected SpeedCoupling speedCoupling = null;
    protected float dMM = this.MM;
    protected float scRingRadius = this.LR2;
    protected boolean doRing = false;
    protected boolean doDrawRing = false;
    TemporalParamListener tpl;
    protected float mindMM = 1.0f;
    boolean doDrawMaxFlatTop = false;
    boolean doSpeedBlendOuterRadius = true;
    boolean doSpeedBlendFlatTop = true;

    public SCFGaussianLens() {
        this.initTimer();
    }

    public SCFGaussianLens(float mm) {
        super(mm);
        this.dMM = this.MM;
        this.initTimer();
    }

    public SCFGaussianLens(float mm, int outerRadius, int innerRadius) {
        super(mm, outerRadius, innerRadius);
        this.dMM = this.MM;
        this.initTimer();
    }

    public SCFGaussianLens(float mm, int outerRadius, int innerRadius, int x, int y) {
        super(mm, outerRadius, innerRadius, x, y);
        this.dMM = this.MM;
        this.initTimer();
    }

    void initTimer() {
        this.timer = new Timer();
        this.mouseStillUpdater = new DGTrailingTimer(this);
        this.timer.scheduleAtFixedRate((TimerTask)this.mouseStillUpdater, 40L, 10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAbsolutePosition(int ax, int ay, long absTime) {
        SCFGaussianLens sCFGaussianLens = this;
        synchronized (sCFGaussianLens) {
            super.setAbsolutePosition(ax, ay);
            this.updateFrequency(absTime);
            this.updateTimeBasedParams(ax, ay);
            if (this.speedCoupling != null) {
                this.speedCoupling.addPoint(ax, ay, absTime);
            }
        }
    }

    public void updateFrequency() {
        this.updateFrequency(System.currentTimeMillis());
    }

    public void updateFrequency(long currentTime) {
        if (this.frequency == -1.0) {
            this.frequency = 1.0;
        } else if (currentTime != this.mLastSampleTime) {
            this.frequency = 1000.0 / (double)(currentTime - this.mLastSampleTime);
        }
        this.mLastSampleTime = currentTime;
    }

    @Override
    public void updateTimeBasedParams(int cx, int cy) {
        this.parentPos.setLocation(cx, cy);
        this.updateTimeBasedParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimeBasedParams() {
        SCFGaussianLens sCFGaussianLens = this;
        synchronized (sCFGaussianLens) {
            float bR;
            double opacity;
            if (this.speedCoupling != null) {
                opacity = 1.0 - (double)this.speedCoupling.getCoef();
            } else {
                this.targetPos.setLocation(this.parentPos.getX() + (double)this.xOffset, this.parentPos.getY() + (double)this.yOffset);
                double distAway = this.targetPos.distance(this.currentPos);
                opacity = 1.0 - Math.min(1.0, distAway / this.maxDist);
                this.filter.setCutOffFrequency((1.0 - opacity) * this.cutoffParamA + this.cutoffParamB);
                this.currentPos = this.filter.apply(this.targetPos, this.frequency);
                int tx = (int)Math.round(this.currentPos.getX());
                int ty = (int)Math.round(this.currentPos.getY());
                tx = Math.max(tx, this.w / 2);
                ty = Math.min(ty, this.owningView.parent.getPanelSize().height - this.h / 2);
            }
            float nMM = (float)opacity * (this.MM - this.mindMM) + this.mindMM;
            if (Math.abs(this.dMM - nMM) > 0.1f) {
                this.dMM = nMM;
                this.setDynamicMagnification();
                this.owningView.parent.repaint();
                if (this.tpl != null) {
                    this.tpl.parameterUpdated();
                }
            }
            if (this.doRing && Math.abs((bR = Math.min((float)this.LR2, (float)opacity * (float)this.LR2 + 1.0f)) - this.scRingRadius) > 1.0f) {
                this.scRingRadius = bR;
                this.owningView.parent.repaint();
            }
        }
    }

    void setDynamicMagnification() {
        this.c = (this.dMM - 1.0f) / 2.0f;
        this.e = (1.0f + this.dMM) / 2.0f;
        this.owningView.parent.repaint();
    }

    public void setCutoffFrequencyParameters(double a, double b) {
        this.cutoffParamA = a;
        this.cutoffParamB = b;
    }

    public void setSpeedCoupling(SpeedCoupling sc) {
        this.speedCoupling = sc;
    }

    @Override
    public void setNoUpdateWhenMouseStill(boolean b) {
        this.mouseStillUpdater.setEnabled(!b);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.timer.cancel();
    }

    @Override
    public void gf(float x, float y, float[] g) {
        this.d = Math.sqrt((x - (float)this.sw - (float)this.lx) * (x - (float)this.sw - (float)this.lx) + (y - (float)this.sh - (float)this.ly) * (y - (float)this.sh - (float)this.ly));
        if (this.d <= (double)this.LR2) {
            g[0] = g[1] = this.dMM;
        } else if (this.d <= (double)this.LR1) {
            g[0] = g[1] = (float)(this.c * Math.cos(this.a * this.d + this.b) + this.e);
        } else {
            g[1] = 1.0f;
            g[0] = 1.0f;
        }
    }

    public void setMinMagFactor(float minMagFac) {
        this.mindMM = minMagFac = minMagFac < 1.0f ? 1.0f : minMagFac;
    }

    public void setDoRing(boolean b) {
        this.doRing = b;
    }

    public boolean getDoRing() {
        return this.doRing;
    }

    public void setDoDrawRing(boolean b) {
        this.doDrawRing = b;
    }

    public void setDrawMaxFlatTop(boolean b) {
        this.doDrawMaxFlatTop = b;
    }

    public void setSpeedBlendRadii(boolean bft, boolean bor) {
        this.doSpeedBlendFlatTop = bft;
        this.doSpeedBlendOuterRadius = bor;
    }

    @Override
    public void drawBoundary(Graphics2D g2d) {
        if (this.doSpeedBlendOuterRadius) {
            g2d.setComposite(Translucency.acs[Math.round((this.dMM / (1.0f - this.MM) + this.MM / (this.MM - 1.0f)) * 20.0f)]);
        }
        if (this.r1Color != null) {
            g2d.setColor(this.r1Color);
            g2d.drawOval(this.lx + this.w / 2 - this.LR1, this.ly + this.h / 2 - this.LR1, 2 * this.LR1, 2 * this.LR1);
        }
        if (this.doSpeedBlendFlatTop && !this.doSpeedBlendOuterRadius) {
            g2d.setComposite(Translucency.acs[Math.round((this.dMM / (1.0f - this.MM) + this.MM / (this.MM - 1.0f)) * 20.0f)]);
        } else if (!this.doSpeedBlendFlatTop && this.doSpeedBlendOuterRadius) {
            g2d.setComposite(Translucent.acO);
        }
        if (this.r2Color != null) {
            int r2 = Math.round(this.dMM / this.MM * (float)this.LR2);
            g2d.setColor(this.r2Color);
            g2d.drawOval(this.lx + this.w / 2 - r2, this.ly + this.h / 2 - r2, 2 * r2, 2 * r2);
        }
        g2d.setComposite(Translucent.acO);
        if (this.doDrawMaxFlatTop && this.r2Color != null) {
            g2d.setColor(this.r2Color);
            g2d.drawOval(this.lx + this.w / 2 - this.LR2, this.ly + this.h / 2 - this.LR2, 2 * this.LR2, 2 * this.LR2);
        }
        if (this.doRing && this.r2Color != null && this.doDrawRing) {
            g2d.setColor(this.r2Color);
            float dbr = Math.max(5.0f, this.scRingRadius - 2.0f);
            g2d.drawOval(this.lx + this.w / 2 - (int)dbr, this.ly + this.h / 2 - (int)dbr, 2 * (int)dbr, 2 * (int)dbr);
        }
    }

    @Override
    public float getActualMaximumMagnification() {
        return this.dMM;
    }

    @Override
    public float getActualRingRadius() {
        return this.scRingRadius;
    }

    @Override
    public void setTemporalParamListener(TemporalParamListener tpl) {
        this.tpl = tpl;
    }

    @Override
    public TemporalParamListener getTemporalParamListener() {
        return this.tpl;
    }
}

