/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors.mctr.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.cfg.ConfigFileHandler;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.common.utils.StringUtils;
import org.eclipse.titan.executor.Activator;
import org.eclipse.titan.executor.TITANConsole;
import org.eclipse.titan.executor.TITANDebugConsole;
import org.eclipse.titan.executor.designerconnection.EnvironmentHelper;
import org.eclipse.titan.executor.executors.BaseExecutor;
import org.eclipse.titan.executor.executors.ExecuteDialog;
import org.eclipse.titan.executor.executors.mctr.cli.BackgroundThread;
import org.eclipse.titan.executor.properties.FieldEditorPropertyPage;
import org.eclipse.titan.executor.views.executormonitor.ComponentElement;
import org.eclipse.titan.executor.views.executormonitor.HostControllerElement;
import org.eclipse.titan.executor.views.executormonitor.InformationElement;
import org.eclipse.titan.executor.views.executormonitor.MainControllerElement;
import org.eclipse.titan.executor.views.notification.Notification;
import org.eclipse.titan.executor.views.testexecution.ExecutedTestcase;
import org.eclipse.titan.executor.views.testexecution.TestExecutionView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public final class CliExecutor
extends BaseExecutor {
    private static final String EXTERNAL_TERMINATION = "Execution terminated from outside";
    private Action automaticExecution;
    private Action startHC;
    private Action cmtc;
    private Action smtc;
    private Action emtc;
    private Action exit;
    private Action info;
    private String fastLine;
    private int fastOffset;
    private boolean simpleExecutionRunning = false;
    private boolean running = false;
    private int suspectedLastState;
    private BackgroundThread thread;
    private boolean createMTCRequested = false;
    private boolean executeRequested = false;
    private List<String> executeList = new ArrayList<String>();
    private boolean shutdownRequested = false;
    private boolean executingConfigFile = false;
    private ConfigFileHandler configHandler;
    private static final Pattern EXECUTION_FINISHED_PATTERN = Pattern.compile("^MTC@(.+): Test case (.*) finished\\. Verdict: (.*)$");
    private final Matcher executionFinishedMatcher = EXECUTION_FINISHED_PATTERN.matcher("");
    private static final Pattern REASON_PATTERN = Pattern.compile("^(.*) reason: (.*)$");
    private final Matcher reasonMatcher = REASON_PATTERN.matcher("");
    private static final Pattern SUCCESSFUL_STARTUP_PATTERN = Pattern.compile("(\\w+)@(.+): Listening on TCP port (\\d+).");
    private final Matcher successfulStartUpMatcher = SUCCESSFUL_STARTUP_PATTERN.matcher("");
    private static final Pattern FULL_SUCCESSFUL_STARTUP_PATTERN = Pattern.compile("(\\w+)@(.+): Listening on IP address (.+) and TCP port (\\d+).");
    private final Matcher fullSuccessfulStartUpMatcher = FULL_SUCCESSFUL_STARTUP_PATTERN.matcher("");
    private static final Pattern HC_CONNECTED_PATTERN = Pattern.compile(" New HC connected from (.+)");
    private final Matcher hcConnectedMatcher = HC_CONNECTED_PATTERN.matcher("");
    private static final Pattern ERROR_STARTUP_PATTERN = Pattern.compile("Error: (.+)");
    private static final String MTC_CREATED = " MTC is created.";
    private static final String TEST_EXECUTION_FINISHED = " Test execution finished.";
    private static final String EXECUTE_SECTION_FINISHED = " Execution of [EXECUTE] section finished.";
    private static final String TERMINATING_MTC = " Terminating MTC.";
    private static final String MTC_TERMINATED = " MTC terminated.";
    private static final String SHUTDOWN_COMPLETE = " Shutdown complete.";
    private static final Pattern MC_STATE_PATTERN = Pattern.compile("^ MC state: (.+)$");
    private static final Pattern PAUSE_PATTERN = Pattern.compile("^ pause function: (.+)$");
    private static final Pattern CONSOLE_LOGGING_PATTERN = Pattern.compile("^ console logging: (.+)$");
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("^  - (\\S*)( \\[.*\\])?( \\(.*\\))?:$");
    private static final Pattern HC_STATE_PATTERN = Pattern.compile("^     HC state: (.*)$");
    private static final Pattern HC_NAME_COMPONENT_PATTERN = Pattern.compile("^      - name: (.*), component reference: (.*)$");
    private static final Pattern HC_COMPONENT_PATTERN = Pattern.compile("^      - component reference: (.*)$");
    private static final Pattern HC_COMPONENT_TYPE_PATTERN = Pattern.compile("^         component type: (.*)$");
    private static final Pattern HC_COMPONENT_STATE_PATTERN = Pattern.compile("^         state: (.*)$");
    private static final Pattern HC_EXECUTED_PATTERN = Pattern.compile("^         executed (.*): (.*)$");
    private static final Pattern HC_LOCAL_VERDICT_PATTERN = Pattern.compile("^         local verdict: (.*)$");
    private IProcess process;
    private final StringBuilder builder = new StringBuilder();

    public CliExecutor(ILaunchConfiguration configuration) throws CoreException {
        super(configuration);
        if (null == this.configFilePath) {
            Status status = new Status(4, "org.eclipse.titan.executor", 0, "Could not launch beacuse the configuration file's path is null", null);
            throw new CoreException((IStatus)status);
        }
        this.running = true;
        this.suspectedLastState = 0;
        this.createActions();
        this.updateUI();
        int mcStateRefreshTimeout = configuration.getAttribute("org.eclipse.titan.executor.MainControllerStateRefreshTimeout", 5);
        this.thread = new BackgroundThread("cli state refresher", mcStateRefreshTimeout, this);
    }

    private void createActions() {
        this.automaticExecution = new Action("automatic execution"){

            public void run() {
                CliExecutor.this.simpleExecutionRunning = true;
                CliExecutor.this.startExecution(false);
            }
        };
        this.automaticExecution.setToolTipText("automatic execution");
        this.automaticExecution.setEnabled(true);
        this.startHC = new Action("start Host Controllers"){

            public void run() {
                CliExecutor.this.startHostControllers();
            }
        };
        this.startHC.setToolTipText("start Host Controller");
        this.cmtc = new Action("create MTC"){

            public void run() {
                CliExecutor.this.createMainTestComponent();
            }
        };
        this.cmtc.setToolTipText("create Main Test Component");
        this.smtc = new Action("start execution"){

            public void run() {
                CliExecutor.this.startExecution(false);
            }
        };
        this.smtc.setToolTipText("start execution");
        this.emtc = new Action("terminate the MTC"){

            public void run() {
                CliExecutor.this.terminateMainTestComponent();
            }
        };
        this.emtc.setToolTipText("terminate the Main Test Component");
        this.exit = new Action("exit"){

            public void run() {
                CliExecutor.this.exit();
                CliExecutor.this.disposeHostControllers();
            }
        };
        this.exit.setToolTipText("exit");
        this.exit.setEnabled(true);
        this.info = new Action("update information"){

            public void run() {
                CliExecutor.this.info();
            }
        };
        this.info.setToolTipText("update information");
        this.info.setEnabled(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.startHC = null;
        this.cmtc = null;
        this.smtc = null;
        this.emtc = null;
        this.info = null;
    }

    @Override
    public MenuManager createMenu(MenuManager manager) {
        if (this.running) {
            manager.add((IAction)this.automaticExecution);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.startHC);
            manager.add((IAction)this.cmtc);
            manager.add((IAction)this.smtc);
            manager.add((IAction)this.emtc);
            manager.add((IAction)this.exit);
            manager.add((IAction)this.info);
        }
        return super.createMenu(manager);
    }

    @Override
    public void startSession(ILaunch arg2) {
        Process proc;
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        Map<String, String> env = pb.environment();
        if (!this.appendEnvironmentalVariables) {
            env.clear();
        }
        if (null != this.environmentalVariables) {
            try {
                EnvironmentHelper.resolveVariables(env, this.environmentalVariables);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        EnvironmentHelper.setTitanPath(env);
        EnvironmentHelper.set_LICENSE_FILE_PATH(env);
        String mctrCliPath = this.getMctrPath(env);
        ArrayList<String> command = new ArrayList<String>();
        command.add("sh");
        command.add("-c");
        if (this.addConfigFilePath(mctrCliPath, command)) {
            return;
        }
        this.printCommandToTitanConsole(command);
        pb.command(command);
        pb.redirectErrorStream(true);
        if (null != this.workingdirectoryPath) {
            File workingDir = new File(this.workingdirectoryPath);
            if (!workingDir.exists()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError(null, (String)"Execution failed", (String)("The working directory `" + CliExecutor.this.workingdirectoryPath + "' does not exist."));
                    }
                });
            }
            pb.directory(workingDir);
        }
        try {
            proc = pb.start();
            InputStream inputstream = proc.getInputStream();
            if (inputstream.markSupported()) {
                inputstream.mark(40000);
            }
            BufferedReader stdout = new BufferedReader(new InputStreamReader(inputstream));
            this.processWelcomeScreen(stdout);
            if (inputstream.markSupported()) {
                inputstream.reset();
            }
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            proc = null;
        }
        if (null != proc) {
            this.process = DebugPlugin.newProcess((ILaunch)arg2, (Process)proc, (String)"Main Controller");
            IStreamsProxy proxy = this.process.getStreamsProxy();
            if (null != proxy) {
                IStreamMonitor outputStreamMonitor = proxy.getOutputStreamMonitor();
                IStreamListener outputListener = new IStreamListener(){

                    public void streamAppended(String text, IStreamMonitor monitor) {
                        CliExecutor.this.processConsoleOutput(text);
                    }
                };
                if (null != outputStreamMonitor) {
                    this.processConsoleOutput(outputStreamMonitor.getContents());
                    outputStreamMonitor.addListener(outputListener);
                }
            }
            this.info();
        }
        super.startSession(arg2);
        if (null == proc || null == this.process || this.process.isTerminated()) {
            this.terminate(true);
        }
        if (null != Activator.getMainView()) {
            Activator.getMainView().refreshAll();
        }
        if (null != this.thread) {
            this.thread.start();
        }
    }

    private boolean addConfigFilePath(String mctrCliPath, List<String> command) {
        if (this.isLogFolderSet()) {
            if (!StringUtils.isNullOrEmpty((String)this.configFilePath)) {
                this.configHandler = this.readConfigFile();
                if (this.configHandler == null) {
                    ErrorReporter.parallelErrorDisplayInMessageDialog((String)"An error was found while processing the configuration file", (String)"Please refer to the Error Log view for further information.");
                    return true;
                }
                if (this.configHandler.isErroneous()) {
                    if (this.configHandler.parseExceptions().isEmpty()) {
                        ErrorReporter.parallelErrorDisplayInMessageDialog((String)"An error was found while processing the configuration file", (String)"Please refer to the Error Log view for further information.");
                    } else {
                        Throwable exception = (Throwable)this.configHandler.parseExceptions().get(this.configHandler.parseExceptions().size() - 1);
                        ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Error while processing the configuration file", (String)(exception.getMessage() + "\n Please refer to the Error Log view for further information."));
                    }
                    return true;
                }
            } else {
                this.logFileNameDefined = false;
            }
            if (!StringUtils.isNullOrEmpty((String)this.configFilePath)) {
                command.add(" sleep 1; " + mctrCliPath + " '" + PathConverter.convert((String)this.configFilePath, (boolean)true, (MessageConsole)TITANDebugConsole.getConsole()) + "'");
            } else {
                command.add(" sleep 1; " + mctrCliPath);
            }
        } else {
            this.temporalConfigFile = null;
            if (!StringUtils.isNullOrEmpty((String)this.configFilePath)) {
                command.add(" sleep 1; " + mctrCliPath + " '" + PathConverter.convert((String)this.configFilePath, (boolean)true, (MessageConsole)TITANDebugConsole.getConsole()) + "'");
            } else {
                command.add(" sleep 1; " + mctrCliPath);
            }
        }
        return false;
    }

    private boolean isLogFolderSet() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String preferenceValue = FieldEditorPropertyPage.getOverlayedPreferenceValue(preferenceStore, (IResource)this.project, "org.eclipse.titan.executor.preferences.ExecutorPreferencePage", "setLogFolder");
        return Boolean.parseBoolean(preferenceValue);
    }

    private void printCommandToTitanConsole(List<String> command) {
        MessageConsoleStream stream = TITANConsole.getConsole().newMessageStream();
        for (String c : command) {
            stream.print(c + ' ');
        }
        stream.println();
    }

    private String getMctrPath(Map<String, String> env) {
        String mctrCliPath;
        if (env.containsKey("TTCN3_DIR")) {
            mctrCliPath = "$TTCN3_DIR/bin/mctr_cli";
        } else {
            TITANDebugConsole.getConsole().newMessageStream().println("warning: TTCN3_DIR environment variable is not set");
            mctrCliPath = "mctr_cli";
        }
        return mctrCliPath;
    }

    private void createMainTestComponent() {
        this.createMTCRequested = true;
        switch (this.suspectedLastState) {
            case 0: 
            case 1: 
            case 2: {
                this.startHostControllers();
                return;
            }
        }
        IStreamsProxy proxy = this.process.getStreamsProxy();
        if (proxy != null) {
            try {
                proxy.write("cmtc \n");
                this.createMTCRequested = false;
            }
            catch (IOException e) {
                ErrorReporter.logError((String)EXTERNAL_TERMINATION);
                this.terminate(true);
            }
        }
    }

    private void startExecution(boolean automaticExecution) {
        ConfigFileHandler tempConfigHandler;
        if (automaticExecution && !StringUtils.isNullOrEmpty((String)this.configFilePath) && !(tempConfigHandler = this.readConfigFile()).isErroneous() && !tempConfigHandler.getExecuteElements().isEmpty()) {
            this.executionStarted = true;
            this.executeList.add("smtc \n");
            this.executeRequested = true;
            if (8 == this.suspectedLastState) {
                this.executeNextTestElement();
            } else {
                this.createMainTestComponent();
            }
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                boolean invalidSelection = false;
                do {
                    ExecuteDialog dialog = new ExecuteDialog(null);
                    dialog.setControlparts(CliExecutor.this.availableControlParts);
                    dialog.setTestcases(CliExecutor.this.availableTestcases);
                    dialog.setTestsets(CliExecutor.this.availableTestSetNames);
                    if (!StringUtils.isNullOrEmpty((String)CliExecutor.this.configFilePath)) {
                        dialog.setConfigurationFile(CliExecutor.this.configFilePath);
                    }
                    dialog.setSelection(CliExecutor.this.lastTimeSelection, CliExecutor.this.lastTimeSelectionTime, CliExecutor.this.lastTimeSelectionType);
                    if (dialog.open() != 0) {
                        CliExecutor.this.executionStarted = false;
                        CliExecutor.this.shutdownSession();
                        return;
                    }
                    String selectedName = dialog.getSelectedElement();
                    CliExecutor.this.lastTimeSelectionType = dialog.getSelectionType();
                    CliExecutor.this.lastTimeSelection = selectedName;
                    CliExecutor.this.lastTimeSelectionTime = dialog.getSelectionTimes();
                    switch (CliExecutor.this.lastTimeSelectionType) {
                        case TESTCASE: {
                            invalidSelection = false;
                            for (int i = 0; i < CliExecutor.this.lastTimeSelectionTime; ++i) {
                                CliExecutor.this.executeList.add("smtc " + selectedName + '\n');
                            }
                            CliExecutor.this.executedTests.ensureCapacity(CliExecutor.this.executedTests.size() + CliExecutor.this.lastTimeSelectionTime);
                            break;
                        }
                        case TESTSET: {
                            invalidSelection = false;
                            int index = CliExecutor.this.availableTestSetNames.indexOf(CliExecutor.this.lastTimeSelection);
                            List contents = (List)CliExecutor.this.availableTestSetContents.get(index);
                            for (int j = 0; j < CliExecutor.this.lastTimeSelectionTime; ++j) {
                                for (String content : contents) {
                                    CliExecutor.this.executeList.add("smtc " + content + '\n');
                                }
                            }
                            CliExecutor.this.executedTests.ensureCapacity(CliExecutor.this.executedTests.size() + CliExecutor.this.lastTimeSelectionTime * contents.size());
                            break;
                        }
                        case CONTROLPART: {
                            invalidSelection = false;
                            for (int i = 0; i < CliExecutor.this.lastTimeSelectionTime; ++i) {
                                CliExecutor.this.executeList.add("smtc " + selectedName + '\n');
                            }
                            CliExecutor.this.executedTests.ensureCapacity(CliExecutor.this.executedTests.size() + CliExecutor.this.lastTimeSelectionTime * 5);
                            break;
                        }
                        case CONFIGURATIONFILE: {
                            ConfigFileHandler tempConfigHandler = CliExecutor.this.readConfigFile();
                            List configurationFileElements = tempConfigHandler.getExecuteElements();
                            if (configurationFileElements.isEmpty()) {
                                invalidSelection = true;
                                Display.getDefault().syncExec((Runnable)new BaseExecutor.EmptyExecutionRunnable());
                                break;
                            }
                            invalidSelection = false;
                            for (int i = 0; i < CliExecutor.this.lastTimeSelectionTime; ++i) {
                                CliExecutor.this.executeList.add("smtc \n");
                            }
                            break;
                        }
                    }
                    CliExecutor.this.executeRequested = true;
                } while (invalidSelection);
                CliExecutor.this.executionStarted = true;
                if (8 == CliExecutor.this.suspectedLastState) {
                    CliExecutor.this.executeNextTestElement();
                } else {
                    CliExecutor.this.createMainTestComponent();
                }
                CliExecutor.this.saveLastTimeUsageInfo();
            }
        });
    }

    private void executeNextTestElement() {
        if (8 != this.suspectedLastState) {
            this.createMainTestComponent();
            return;
        }
        if (this.executeList.isEmpty()) {
            return;
        }
        String testElement = this.executeList.remove(0);
        IStreamsProxy proxy = this.process.getStreamsProxy();
        if (proxy != null) {
            try {
                this.suspectedLastState = 11;
                proxy.write(testElement);
                if ("smtc \n".equals(testElement)) {
                    this.executingConfigFile = true;
                }
            }
            catch (IOException e) {
                ErrorReporter.logError((String)EXTERNAL_TERMINATION);
                this.terminate(true);
            }
        }
    }

    private void terminateMainTestComponent() {
        IStreamsProxy proxy = this.process.getStreamsProxy();
        if (proxy != null) {
            try {
                proxy.write("emtc \n");
            }
            catch (IOException e) {
                ErrorReporter.logError((String)EXTERNAL_TERMINATION);
                this.terminate(true);
            }
        }
    }

    private void exit() {
        IStreamsProxy proxy = this.process.getStreamsProxy();
        if (proxy != null) {
            try {
                proxy.write("exit \n");
            }
            catch (IOException e) {
                ErrorReporter.logError((String)EXTERNAL_TERMINATION);
                this.terminate(true);
            }
        }
    }

    public void info() {
        IStreamsProxy proxy = this.process.getStreamsProxy();
        if (proxy != null) {
            try {
                proxy.write("info \n");
            }
            catch (IOException e) {
                ErrorReporter.logError((String)EXTERNAL_TERMINATION);
                this.terminate(true);
            }
        }
    }

    @Override
    protected void shutdownSession() {
        this.shutdownRequested = true;
        switch (this.suspectedLastState) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                this.exit();
                this.disposeHostControllers();
                this.shutdownRequested = false;
                this.createMTCRequested = false;
                this.executeRequested = false;
                break;
            }
            default: {
                this.terminateMainTestComponent();
            }
        }
        super.shutdownSession();
    }

    private void processInfoOutput(BufferedReader stdout) {
        MainControllerElement tempRoot = new MainControllerElement("Temporal root", this);
        this.readFullLineOnly(stdout);
        if (this.fastLine == null) {
            return;
        }
        Matcher matcher = MC_STATE_PATTERN.matcher(this.fastLine);
        if (!matcher.matches()) {
            this.fastLine = null;
            return;
        }
        String mcStateName = matcher.group(1);
        tempRoot.setStateInfo(new InformationElement("State: " + mcStateName));
        this.readFullLineOnly(stdout);
        this.suspectedLastState = CliExecutor.getMCStateFromName(mcStateName);
        if (this.fastLine == null || !" host information:".equals(this.fastLine)) {
            this.fastLine = null;
            return;
        }
        this.readFullLineOnly(stdout);
        if (this.fastLine != null) {
            if (this.fastLine.startsWith("  -")) {
                while (this.fastLine != null && this.fastLine.startsWith("  -")) {
                    this.processInfoOutputHC(stdout, tempRoot);
                }
            } else if ("  no HCs are connected".equals(this.fastLine)) {
                this.readFullLineOnly(stdout);
            }
        } else {
            this.fastLine = null;
            return;
        }
        if (this.fastLine == null || !PAUSE_PATTERN.matcher(this.fastLine).matches()) {
            this.fastLine = null;
            return;
        }
        tempRoot.setPauseInfo(new InformationElement(this.fastLine.trim()));
        this.readFullLineOnly(stdout);
        if (this.fastLine == null || !CONSOLE_LOGGING_PATTERN.matcher(this.fastLine).matches()) {
            this.fastLine = null;
            return;
        }
        tempRoot.setConsoleLoggingInfo(new InformationElement(this.fastLine.trim()));
        if (this.mainControllerRoot != null) {
            this.mainControllerRoot.children().clear();
            this.mainControllerRoot.transferData(tempRoot);
        }
    }

    private void processInfoOutputHC(BufferedReader stdout, MainControllerElement root) {
        HostControllerElement tempHost;
        Matcher matcher = HOSTNAME_PATTERN.matcher(this.fastLine);
        if (matcher.matches()) {
            String localHostName;
            tempHost = new HostControllerElement("Host Controller");
            root.addHostController(tempHost);
            String hostIPAddress = matcher.group(1);
            tempHost.setIPAddressInfo(new InformationElement("IP address: " + hostIPAddress));
            String hostIpNumber = matcher.group(2);
            if (hostIpNumber != null && hostIpNumber.length() > 0) {
                tempHost.setIPNumberInfo(new InformationElement("IP number: " + hostIpNumber.substring(2, hostIpNumber.length() - 1)));
            }
            if ((localHostName = matcher.group(3)) != null && localHostName.length() > 0) {
                tempHost.setHostNameInfo(new InformationElement("Local host name: " + localHostName.substring(2, localHostName.length() - 1)));
            }
        } else {
            this.fastLine = null;
            return;
        }
        this.readFullLineOnly(stdout);
        if (this.fastLine == null || !this.fastLine.startsWith("     operating system")) {
            this.fastLine = null;
            return;
        }
        tempHost.setOperatingSystemInfo(new InformationElement(this.fastLine.trim()));
        this.readFullLineOnly(stdout);
        if (this.fastLine == null || !HC_STATE_PATTERN.matcher(this.fastLine).matches()) {
            this.fastLine = null;
            return;
        }
        tempHost.setStateInfo(new InformationElement(this.fastLine.trim()));
        this.readFullLineOnly(stdout);
        if (this.fastLine != null && "     test component information:".equals(this.fastLine)) {
            this.readFullLineOnly(stdout);
            if (this.fastLine != null && this.fastLine.startsWith("      no components on this host")) {
                this.readFullLineOnly(stdout);
            } else {
                while (this.fastLine != null && this.fastLine.startsWith("      - ")) {
                    this.processInfoOutputComponent(stdout, tempHost);
                }
            }
        } else {
            this.fastLine = null;
        }
    }

    private void processInfoOutputComponent(BufferedReader stdout, HostControllerElement host) {
        ComponentElement tempComponent;
        Matcher matcher = HC_NAME_COMPONENT_PATTERN.matcher(this.fastLine);
        if (matcher.matches()) {
            tempComponent = new ComponentElement("Component " + matcher.group(1), new InformationElement("Component reference: " + matcher.group(2)));
            host.addComponent(tempComponent);
            this.readFullLineOnly(stdout);
        } else {
            matcher = HC_COMPONENT_PATTERN.matcher(this.fastLine);
            if (matcher.matches()) {
                tempComponent = new ComponentElement("Component " + matcher.group(1));
                host.addComponent(tempComponent);
                this.readFullLineOnly(stdout);
            } else {
                this.fastLine = null;
                return;
            }
        }
        if (this.fastLine != null && HC_COMPONENT_TYPE_PATTERN.matcher(this.fastLine).matches()) {
            tempComponent.setTypeInfo(new InformationElement(this.fastLine.trim()));
            this.readFullLineOnly(stdout);
        }
        if (this.fastLine == null || !HC_COMPONENT_STATE_PATTERN.matcher(this.fastLine).matches()) {
            this.fastLine = null;
            return;
        }
        tempComponent.setStateInfo(new InformationElement(this.fastLine.trim()));
        this.readFullLineOnly(stdout);
        if (this.fastLine != null && HC_EXECUTED_PATTERN.matcher(this.fastLine).matches()) {
            tempComponent.setExecutedInfo(new InformationElement(this.fastLine.trim()));
            this.readFullLineOnly(stdout);
        }
        if (this.fastLine != null && HC_LOCAL_VERDICT_PATTERN.matcher(this.fastLine).matches()) {
            tempComponent.setLocalVerdictInfo(new InformationElement(this.fastLine.trim()));
            this.readFullLineOnly(stdout);
        }
    }

    private void processWelcomeScreen(BufferedReader stdout) {
        boolean started = false;
        try {
            String line = stdout.readLine();
            while (!started && line != null) {
                Matcher m = SUCCESSFUL_STARTUP_PATTERN.matcher(line);
                if (m.matches()) {
                    started = true;
                    this.mcHost = m.group(2);
                    this.mcPort = m.group(3);
                    this.suspectedLastState = 1;
                } else {
                    m = FULL_SUCCESSFUL_STARTUP_PATTERN.matcher(line);
                    if (m.matches()) {
                        started = true;
                        this.mcHost = m.group(3);
                        this.mcPort = m.group(4);
                        this.suspectedLastState = 1;
                    } else {
                        m = ERROR_STARTUP_PATTERN.matcher(line);
                        if (m.matches()) {
                            started = true;
                            this.suspectedLastState = 1;
                        } else {
                            line = stdout.readLine();
                        }
                    }
                }
                this.addNotification(new Notification(new Formatter().format("%1$tF %1$tH:%1$tM:%1$tS.%1$tL000", new Date()).toString(), "", "", line));
            }
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
    }

    private void testExecution() {
        if (this.fastLine != null && this.verdictExtraction && this.executionFinishedMatcher.reset(this.fastLine).matches()) {
            String reason = this.executionFinishedMatcher.group(3);
            if (this.reasonMatcher.reset(reason).matches()) {
                this.executedTests.add(new ExecutedTestcase(new Formatter().format("%1$tF %1$tH:%1$tM:%1$tS.%1$tL000", new Date()).toString(), this.executionFinishedMatcher.group(2), this.reasonMatcher.group(1), this.reasonMatcher.group(2)));
            } else {
                this.executedTests.add(new ExecutedTestcase(new Formatter().format("%1$tF %1$tH:%1$tM:%1$tS.%1$tL000", new Date()).toString(), this.executionFinishedMatcher.group(2), this.executionFinishedMatcher.group(3), ""));
            }
        }
    }

    private void processConsoleOutput(String text) {
        if (this.thread != null) {
            this.thread.reset();
        }
        this.builder.append(text);
        StringReader reader = new StringReader(this.builder.toString());
        BufferedReader stdout = new BufferedReader(reader);
        this.fastOffset = 0;
        this.readFullLineOnly(stdout);
        while (this.fastLine != null) {
            while (this.fastLine.startsWith("MC2> ")) {
                this.fastLine = this.fastLine.substring(5);
            }
            if (this.fastLine.startsWith("MC information:")) {
                this.processInfoOutput(stdout);
                if (this.fastLine == null) break;
                if (Activator.getMainView() != null) {
                    Activator.getMainView().refreshAll();
                }
            } else if (this.fastLine.startsWith("MTC@")) {
                this.addNotification(new Notification(new Formatter().format("%1$tF %1$tH:%1$tM:%1$tS.%1$tL000", new Date()).toString(), "", "", this.fastLine));
                this.testExecution();
            } else if (this.fastLine.startsWith("MC@")) {
                this.addNotification(new Notification(new Formatter().format("%1$tF %1$tH:%1$tM:%1$tS.%1$tL000", new Date()).toString(), "", "", this.fastLine));
                int index = this.fastLine.indexOf(58);
                String shortversion = this.fastLine.substring(index + 1);
                if (SHUTDOWN_COMPLETE.equals(shortversion)) {
                    this.running = false;
                    this.executeRequested = false;
                    this.createMTCRequested = false;
                    if (this.mainControllerRoot != null) {
                        this.mainControllerRoot.setTerminated();
                    }
                    if (Activator.getMainView() != null) {
                        Activator.getMainView().refreshAll();
                    }
                    if (this.thread != null) {
                        this.thread.cancel();
                        this.thread = null;
                    }
                } else if (this.hcConnectedMatcher.reset(shortversion).matches()) {
                    this.suspectedLastState = 3;
                } else if (MTC_CREATED.equals(shortversion)) {
                    this.suspectedLastState = 8;
                } else if (TEST_EXECUTION_FINISHED.equals(shortversion)) {
                    if (!this.executingConfigFile) {
                        this.suspectedLastState = 8;
                    }
                } else if (EXECUTE_SECTION_FINISHED.equals(shortversion)) {
                    this.suspectedLastState = 8;
                    this.executingConfigFile = false;
                } else if (TERMINATING_MTC.equals(shortversion)) {
                    this.suspectedLastState = 9;
                } else if (MTC_TERMINATED.equals(shortversion)) {
                    this.suspectedLastState = 5;
                } else if (this.successfulStartUpMatcher.reset(this.fastLine).matches()) {
                    this.mcHost = this.successfulStartUpMatcher.group(2);
                    this.mcPort = this.successfulStartUpMatcher.group(3);
                    this.suspectedLastState = 1;
                } else if (this.fullSuccessfulStartUpMatcher.reset(shortversion).matches()) {
                    this.mcHost = this.fullSuccessfulStartUpMatcher.group(1);
                    this.mcPort = this.fullSuccessfulStartUpMatcher.group(2);
                    this.suspectedLastState = 1;
                }
            } else {
                this.addNotification(new Notification(new Formatter().format("%1$tF %1$tH:%1$tM:%1$tS.%1$tL000", new Date()).toString(), "", "", this.fastLine));
            }
            this.builder.delete(0, this.fastOffset);
            if (Activator.getMainView() != null) {
                Activator.getMainView().refreshIfSelected(this.mainControllerRoot);
            } else {
                TestExecutionView.refreshInput(this);
            }
            this.fastOffset = 0;
            this.readFullLineOnly(stdout);
            TITANDebugConsole.getConsole().newMessageStream().println("MC in suspected state: " + this.suspectedLastState);
        }
        this.statusChangeHandler();
    }

    private void readFullLineOnly(BufferedReader stdout) {
        try {
            this.fastLine = stdout.readLine();
            if (this.fastLine == null) {
                return;
            }
            this.fastOffset += this.fastLine.length();
            if (this.builder.length() < this.fastOffset + 1) {
                this.fastLine = null;
                return;
            }
            char c = this.builder.charAt(this.fastOffset);
            if (c == '\n') {
                ++this.fastOffset;
                return;
            }
            if (c == '\r') {
                if (this.builder.length() > this.fastOffset + 1 && this.builder.charAt(this.fastOffset + 1) == '\n') {
                    ++this.fastOffset;
                }
                ++this.fastOffset;
                return;
            }
            this.fastLine = null;
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
    }

    private void statusChangeHandler() {
        switch (this.suspectedLastState) {
            case 1: 
            case 2: {
                if (!this.automaticExecuteSectionExecution) break;
                this.automaticExecuteSectionExecution = false;
                this.simpleExecutionRunning = true;
                this.startExecution(true);
                break;
            }
            case 3: 
            case 5: {
                if (this.createMTCRequested) {
                    this.createMainTestComponent();
                    break;
                }
                if (!this.shutdownRequested) break;
                this.shutdownSession();
                break;
            }
            case 8: {
                if (this.executeList.isEmpty()) {
                    this.executeRequested = false;
                }
                if (this.executeRequested) {
                    this.executeNextTestElement();
                    break;
                }
                if (!this.simpleExecutionRunning && !this.shutdownRequested) break;
                this.shutdownSession();
                break;
            }
            case 0: {
                this.shutdownRequested = false;
                break;
            }
            case 6: {
                break;
            }
        }
        this.updateUI();
    }

    private void updateUI() {
        if (this.startHC != null) {
            this.startHC.setEnabled(1 == this.suspectedLastState || 2 == this.suspectedLastState);
            this.cmtc.setEnabled(1 == this.suspectedLastState || 2 == this.suspectedLastState || 3 == this.suspectedLastState || 5 == this.suspectedLastState);
            this.smtc.setEnabled(8 == this.suspectedLastState);
            this.emtc.setEnabled(8 == this.suspectedLastState);
        }
    }

    @Override
    public boolean isTerminated() {
        return !this.running;
    }

    @Override
    public IProcess getProcess() {
        return this.process;
    }

    @Override
    public void terminate(boolean external) {
        if (external) {
            this.running = false;
            this.executeRequested = false;
            this.createMTCRequested = false;
            if (this.thread != null) {
                this.thread.reset();
                this.thread = null;
            }
            if (this.mainControllerRoot != null) {
                this.mainControllerRoot.setTerminated();
            }
        } else {
            this.exit();
        }
        this.disposeHostControllers();
    }

    private static int getMCStateFromName(String mcStateName) {
        if ("inactive".equals(mcStateName)) {
            return 0;
        }
        if ("listening".equals(mcStateName)) {
            return 1;
        }
        if ("listening (configured)".equals(mcStateName)) {
            return 2;
        }
        if ("HC connected".equals(mcStateName)) {
            return 3;
        }
        if ("configuring...".equals(mcStateName)) {
            return 4;
        }
        if ("active".equals(mcStateName)) {
            return 5;
        }
        if ("creating MTC...".equals(mcStateName)) {
            return 7;
        }
        if ("terminating MTC...".equals(mcStateName)) {
            return 9;
        }
        if ("ready".equals(mcStateName)) {
            return 8;
        }
        if ("executing control part".equals(mcStateName)) {
            return 10;
        }
        if ("executing testcase".equals(mcStateName)) {
            return 11;
        }
        if ("terminating testcase...".equals(mcStateName)) {
            return 12;
        }
        if ("paused after testcase".equals(mcStateName)) {
            return 13;
        }
        if ("shutting down...".equals(mcStateName)) {
            return 6;
        }
        return 8;
    }

    @Override
    protected String getDefaultLogFileName() {
        return "%e.%h-part%i-%r.%s";
    }

    @Override
    protected String generateCfgString() {
        String result = super.generateCfgString();
        if (this.configHandler != null) {
            result = result + this.configHandler.toStringResolved(new ArrayList());
        }
        return result;
    }
}

