/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.models;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.eclipse.titan.common.utils.ObjectUtils;
import org.eclipse.titan.log.viewer.models.TimeInterval;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;

public class FilterPattern {
    private SortedMap<String, Boolean> eventsToFilter = null;
    private boolean inclusive = true;
    private Map<Field, Boolean> fieldsToFilter = null;
    private String filterExpression = null;
    private boolean caseSensitive = false;
    private boolean regularExpression = false;
    private TimeInterval timeInterval = null;
    private Pattern filterExpressionCompiled = null;
    private boolean containsSilentEvents = false;

    public FilterPattern(Map<String, Boolean> eventsToFilter, boolean inclusive, boolean containsSilentEvents) {
        this.setEventsToFilter(eventsToFilter, inclusive, containsSilentEvents);
    }

    public FilterPattern(String filterExpression, Map<Field, Boolean> fieldsToFilter, boolean caseSensitive, boolean regularExpression) {
        this.setFilterExpression(filterExpression, fieldsToFilter, caseSensitive, regularExpression);
    }

    public FilterPattern(TimeInterval timeInterval) {
        this.setTimeInterval(timeInterval);
    }

    public FilterPattern(FilterPattern otherPattern) {
        this.setEventsToFilter(otherPattern.eventsToFilter, otherPattern.inclusive, otherPattern.containsSilentEvents);
        this.setFilterExpression(otherPattern.getFilterExpression(), otherPattern.getFieldsToFilter(), otherPattern.isCaseSensitive(), otherPattern.isRegularExpression());
        this.setTimeInterval(otherPattern.getTimeInterval());
    }

    public SortedMap<String, Boolean> getEventsToFilter() {
        return this.eventsToFilter;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public void setInclusive(boolean inclusive) {
        this.inclusive = inclusive;
    }

    public Map<Field, Boolean> getFieldsToFilter() {
        return this.fieldsToFilter;
    }

    public String getFilterExpression() {
        return this.filterExpression != null ? this.filterExpression : "";
    }

    public TimeInterval getTimeInterval() {
        return this.timeInterval;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        if (this.caseSensitive == isCaseSensitive) {
            return;
        }
        this.caseSensitive = isCaseSensitive;
        this.compileFilterExpression();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setRegularExpression(boolean isRegularExpression) {
        if (this.regularExpression == isRegularExpression) {
            return;
        }
        this.regularExpression = isRegularExpression;
        this.compileFilterExpression();
    }

    public boolean isRegularExpression() {
        return this.regularExpression;
    }

    public boolean containsSilentEvents() {
        return this.containsSilentEvents;
    }

    public void setTimeInterval(TimeInterval timeInterval) {
        if (timeInterval != null) {
            this.timeInterval = new TimeInterval(timeInterval);
            return;
        }
        this.timeInterval = null;
    }

    public void setEventsToFilter(Map<String, Boolean> eventsToFilter, boolean inclusive, boolean containsSilentEvents) {
        this.inclusive = inclusive;
        this.containsSilentEvents = containsSilentEvents;
        if (eventsToFilter != null) {
            this.eventsToFilter = new TreeMap<String, Boolean>();
            for (Map.Entry<String, Boolean> entry : eventsToFilter.entrySet()) {
                this.eventsToFilter.put(entry.getKey(), entry.getValue());
            }
            return;
        }
        this.eventsToFilter = null;
    }

    public boolean isEventIgnored(String event) {
        if (this.inclusive) {
            return (Boolean)this.eventsToFilter.get(event) == false;
        }
        return (Boolean)this.eventsToFilter.get(event);
    }

    public void setFilterExpression(String filterExpression, Map<Field, Boolean> fieldsToFilter, boolean isCaseSensitive, boolean isRegularExpression) {
        if (filterExpression != null && fieldsToFilter != null) {
            this.filterExpression = filterExpression;
            this.caseSensitive = isCaseSensitive;
            this.regularExpression = isRegularExpression;
            this.fieldsToFilter = new HashMap<Field, Boolean>(fieldsToFilter.size());
            for (Map.Entry<Field, Boolean> entry : fieldsToFilter.entrySet()) {
                this.fieldsToFilter.put(entry.getKey(), entry.getValue());
            }
            this.compileFilterExpression();
        } else {
            this.filterExpression = null;
            this.fieldsToFilter = null;
        }
    }

    public void compileFilterExpression() {
        String regexp = this.isRegularExpression() ? this.filterExpression : this.convertToRegex(this.filterExpression);
        this.filterExpressionCompiled = this.caseSensitive ? Pattern.compile(regexp, 32) : Pattern.compile(regexp, 34);
    }

    public String convertToRegex(String pattern) {
        if (pattern == null || pattern.length() == 0) {
            return ".*";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        if (pattern.charAt(0) == '*') {
            ++i;
        }
        builder.append(".*");
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            switch (c) {
                case '*': {
                    builder.append(".*");
                    break;
                }
                case '?': {
                    builder.append(".");
                    break;
                }
                case '\\': {
                    if (i < pattern.length() - 1 && (pattern.charAt(i + 1) == '*' || pattern.charAt(i + 1) == '?')) {
                        builder.append("\\" + pattern.charAt(i + 1));
                        ++i;
                        break;
                    }
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    builder.append("\\");
                    builder.append(c);
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            ++i;
        }
        if (builder.charAt(builder.length() - 2) != '.' || builder.charAt(builder.length() - 1) != '*') {
            builder.append(".*");
        }
        return builder.toString();
    }

    public boolean isMessageMatching(String message) {
        return this.filterExpressionCompiled.matcher(message).matches();
    }

    public boolean match(LogRecord record) {
        if (this.eventsToFilter != null && !this.eventsToFilter.isEmpty() && this.inclusive != (Boolean)this.eventsToFilter.get(record.getEventType())) {
            return false;
        }
        if (this.timeInterval != null && !this.timeInterval.contains(record.getTimestamp())) {
            return false;
        }
        if (this.filterExpression.length() > 0 && this.fieldsToFilter != null && !this.fieldsToFilter.isEmpty()) {
            boolean b = false;
            for (Map.Entry<Field, Boolean> entry : this.fieldsToFilter.entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                switch (entry.getKey()) {
                    case MESSAGE: {
                        if (!this.filterExpressionCompiled.matcher(record.getMessage()).matches()) break;
                        b = true;
                        break;
                    }
                    case SOURCE_INFO: {
                        if (!this.filterExpressionCompiled.matcher(record.getSourceInformation()).matches()) break;
                        b = true;
                        break;
                    }
                }
            }
            if (!b) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        FilterPattern rhs = (FilterPattern)o;
        return ObjectUtils.equals((Object)this.timeInterval, (Object)rhs.timeInterval) && ObjectUtils.equals(this.eventsToFilter, rhs.eventsToFilter) && ObjectUtils.equals((Object)this.filterExpression, (Object)rhs.filterExpression) && ObjectUtils.equals((Object)this.caseSensitive, (Object)rhs.caseSensitive) && ObjectUtils.equals((Object)this.regularExpression, (Object)rhs.regularExpression) && ObjectUtils.equals((Object)this.inclusive, (Object)rhs.inclusive) && ObjectUtils.equals(this.fieldsToFilter, rhs.fieldsToFilter);
    }

    public int hashCode() {
        return ObjectUtils.hash((Object[])new Object[]{this.eventsToFilter, this.fieldsToFilter, this.filterExpression, this.inclusive, this.caseSensitive, this.regularExpression, this.timeInterval});
    }

    public static enum Field {
        SOURCE_INFO,
        MESSAGE;

    }
}

