/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.readers;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.text.ParseException;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.log.viewer.models.LogRecordIndex;
import org.eclipse.titan.log.viewer.parsers.RecordParser;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;

public class TestFileReader
implements Closeable {
    private RandomAccessFile randomAccessFile;
    private LogRecordIndex[] logRecordIndexes;
    private int currentRecord;

    public TestFileReader(URI fileURI, LogRecordIndex[] logRecordIndexes) throws IOException {
        if (logRecordIndexes == null || logRecordIndexes.length == 0) {
            throw new IOException("Log record index array is empty!");
        }
        this.currentRecord = 0;
        this.logRecordIndexes = logRecordIndexes;
        long fileOffset = logRecordIndexes[this.currentRecord].getFileOffset();
        this.randomAccessFile = new RandomAccessFile(new File(fileURI), "r");
        this.randomAccessFile.seek(fileOffset);
    }

    public void setCurrentLogRecord(int currentRecord) throws IOException {
        this.currentRecord = currentRecord;
        long fileOffset = this.logRecordIndexes[this.currentRecord].getFileOffset();
        this.randomAccessFile.seek(fileOffset);
    }

    public boolean hasNextRecord() {
        return this.currentRecord < this.logRecordIndexes.length;
    }

    public int size() {
        return this.logRecordIndexes.length;
    }

    public LogRecord getNextRecord() throws IOException, ParseException {
        LogRecord aRecord;
        String logData = this.readNextRecord();
        try {
            RecordParser recordParser = new RecordParser();
            aRecord = recordParser.parse(logData);
            aRecord.setRecordOffset(this.logRecordIndexes[this.currentRecord].getFileOffset());
            aRecord.setRecordLength(this.logRecordIndexes[this.currentRecord].getRecordLength());
            aRecord.setRecordNumber(this.currentRecord);
            ++this.currentRecord;
        }
        catch (ParseException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            ParseException throwable = new ParseException("Could not parse the " + this.currentRecord + "th record ", 0);
            throwable.initCause(e);
            throw throwable;
        }
        return aRecord;
    }

    @Override
    public void close() throws IOException {
        this.clean();
    }

    private String readNextRecord() throws IOException {
        String s = new String(this.getNextRecordFromFile());
        return s.trim();
    }

    private byte[] getNextRecordFromFile() throws IOException {
        int nextLen = this.logRecordIndexes[this.currentRecord].getRecordLength();
        byte[] buffer = new byte[nextLen];
        this.randomAccessFile.read(buffer, 0, nextLen);
        return buffer;
    }

    private void clean() {
        IOUtils.closeQuietly((Closeable)this.randomAccessFile);
        this.randomAccessFile = null;
    }
}

