/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.view;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Frame;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Lifeline;
import org.eclipse.titan.log.viewer.views.msc.ui.core.LifelineHeader;
import org.eclipse.titan.log.viewer.views.msc.ui.core.MSCNode;
import org.eclipse.titan.log.viewer.views.msc.ui.view.DiagramToolTip;
import org.eclipse.titan.log.viewer.views.msc.ui.view.NGC;
import org.eclipse.titan.log.viewer.views.msc.ui.view.ScrollView;
import org.eclipse.titan.log.viewer.views.msc.util.MSCConstants;

public class MSCWidget
extends ScrollView
implements ISelectionProvider,
SelectionListener,
DisposeListener {
    private DiagramToolTip toolTip = null;
    private Frame frame;
    private Image overView = null;
    private MSCNode dragAndDrop = null;
    private MSCNode currentGraphNode = null;
    private boolean zoomInMode = false;
    private boolean zoomOutMode = false;
    private boolean dragAndDropEnabled = false;
    private int dragX = 0;
    private int dragY = 0;
    private int dragAndDropOffsetX;
    private float zoomValue = 1.0f;
    private Set<ISelectionChangedListener> registeredListeners = new HashSet<ISelectionChangedListener>();

    public MSCWidget(Composite parent, int style) {
        super(parent, style | 0x40000, true);
        this.toolTip = new DiagramToolTip(this.getViewControl());
        super.addDisposeListener((DisposeListener)this);
        this.getViewControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                MSCWidget.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                MSCWidget.this.redraw();
            }
        });
    }

    public boolean isNormalMode() {
        return !this.zoomInMode && !this.zoomOutMode;
    }

    public void resizeContents(Frame frame) {
        int width = Math.round((float)frame.getWidth() * this.zoomValue);
        int height = Math.round((float)frame.getHeight() * this.zoomValue);
        this.resizeContents(width, height);
    }

    public void setFrame(Frame theFrame, boolean resetPosition) {
        this.frame = theFrame;
        if (resetPosition) {
            this.setContentsPos(0, 0);
            this.resizeContents(this.frame);
            this.redraw();
        }
        if (this.overView != null) {
            this.overView.dispose();
        }
        this.overView = null;
        this.resizeContents(this.frame);
    }

    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public boolean setContentsPos(int x, int y) {
        int tempX = x;
        if (x < 0) {
            tempX = 0;
        }
        int tempY = y;
        if (y < 0) {
            tempY = 0;
        }
        if (this.frame == null) {
            return false;
        }
        if (tempX + this.getVisibleWidth() > this.getContentsWidth()) {
            tempX = this.getContentsWidth() - this.getVisibleWidth();
        }
        if (tempY + this.getVisibleHeight() > this.getContentsHeight()) {
            tempY = this.getContentsHeight() - this.getVisibleHeight();
        }
        return super.setContentsPos(tempX, tempY);
    }

    @Override
    protected void contentsMouseHover(MouseEvent event) {
        if (this.frame != null) {
            int y;
            int x = Math.round((float)event.x / this.zoomValue);
            MSCNode graphNode = this.frame.getNodeAt(x, y = Math.round((float)event.y / this.zoomValue));
            if (graphNode != null) {
                this.toolTip.showToolTip(graphNode.getName());
            } else {
                this.toolTip.hideToolTip();
            }
        }
    }

    @Override
    protected void contentsMouseMoveEvent(MouseEvent e) {
        this.toolTip.hideToolTip();
        if ((e.stateMask & SWT.BUTTON_MASK) != 0 && (this.dragAndDrop != null || this.dragAndDropEnabled)) {
            this.dragAndDropEnabled = false;
            if (this.currentGraphNode instanceof LifelineHeader) {
                this.dragAndDrop = this.currentGraphNode;
                ((LifelineHeader)this.dragAndDrop).setDragAndDropMode(true);
            }
            if (this.dragAndDrop != null) {
                this.dragX = Math.round((float)e.x / this.zoomValue);
                this.dragY = Math.round((float)e.y / this.zoomValue);
                this.redraw();
            }
        } else {
            super.contentsMouseMoveEvent(e);
        }
    }

    @Override
    protected void contentsMouseUpEvent(MouseEvent event) {
        this.toolTip.hideToolTip();
        if (this.dragAndDrop != null) {
            if (this.overView != null && !this.overView.isDisposed()) {
                this.overView.dispose();
            }
            this.overView = null;
            Lifeline node = this.frame.getCloserLifeline(this.dragX);
            if (node != null) {
                Lifeline currLifeline = ((LifelineHeader)this.dragAndDrop).getLifeline();
                int rx = Math.round((float)node.getX() * this.zoomValue);
                if (rx > event.x || Math.round((float)rx + (float)node.getWidth() * this.zoomValue) < event.x) {
                    this.frame.moveLifeLineToPosition(currLifeline, node.getIndex());
                }
            }
            ((LifelineHeader)this.dragAndDrop).setDragAndDropMode(false);
            this.dragAndDrop = null;
        }
        this.redraw();
        if (this.frame == null) {
            return;
        }
        super.contentsMouseUpEvent(event);
    }

    @Override
    protected void contentsMouseDownEvent(MouseEvent event) {
        this.toolTip.hideToolTip();
        if ((this.zoomInMode || this.zoomOutMode) && event.button == 1) {
            int cx = Math.round((float)event.x / this.zoomValue);
            int cy = Math.round((float)event.y / this.zoomValue);
            if (this.zoomInMode) {
                if (this.zoomValue < 64.0f) {
                    this.zoomValue *= 1.25f;
                }
            } else {
                this.zoomValue /= 1.25f;
            }
            int x = Math.round((float)cx * this.zoomValue - (float)this.getVisibleWidth() / 2.0f);
            int y = Math.round((float)cy * this.zoomValue - (float)this.getVisibleHeight() / 2.0f);
            int width = Math.round((float)this.frame.getWidth() * this.zoomValue);
            int height = Math.round((float)this.frame.getHeight() * this.zoomValue);
            this.resizeContents(width, height);
            this.setContentsPos(x, y);
            this.redraw();
        } else {
            this.dragAndDropEnabled = true;
            if (this.frame != null) {
                int oldSelectedLine = this.frame.getSelectedLine();
                int x = Math.round((float)event.x / this.zoomValue);
                int y = Math.round((float)event.y / this.zoomValue);
                MSCNode node = this.frame.getNodeAt(x, y);
                if (event.button == 1 || node != null) {
                    this.currentGraphNode = node;
                    if (node instanceof LifelineHeader) {
                        this.dragAndDropOffsetX = node.getX() - x;
                    }
                }
                int selectedLine = y / MSCConstants.ROW_HEIGHT - 1;
                this.frame.setSelectedLine(selectedLine);
                if (this.frame.getSelectedLine() != oldSelectedLine) {
                    this.fireSelectionChangeEvent();
                    this.redraw();
                }
            }
        }
        if (this.dragAndDrop == null) {
            super.contentsMouseDownEvent(event);
        }
    }

    @Override
    protected void drawContents(GC gc, int clipx, int clipy, int clipw, int cliph) {
        if (this.frame == null) {
            gc.setBackground(this.getDisplay().getSystemColor(1));
            gc.fillRectangle(0, 0, this.getVisibleWidth(), this.getVisibleHeight());
            gc.dispose();
            return;
        }
        this.update();
        Rectangle area = this.getClientArea();
        Image dbuffer = new Image((Device)this.getDisplay(), area.width, area.height);
        GC gcim = new GC((Drawable)dbuffer);
        NGC context = new NGC(this, gcim);
        MSCConstants.setFontHeight(context.getFontHeight((Font)Activator.getDefault().getCachedResource("FONT_DEFAULT")));
        MSCConstants.setDefaultFontWidth(context.getFontWidth((Font)Activator.getDefault().getCachedResource("FONT_DEFAULT")));
        MSCConstants.setBoldFontWidth(context.getFontWidth((Font)Activator.getDefault().getCachedResource("FONT_BOLD")));
        int width = Math.round((float)this.frame.getWidth() * this.zoomValue);
        int height = Math.round((float)this.frame.getHeight() * this.zoomValue);
        this.resizeContents(width, height);
        context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_WHITE"));
        context.fillRectangle(0, 0, this.frame.getX(), this.getContentsHeight());
        context.fillRectangle(this.frame.getX() + this.frame.getWidth() + 1, 0, this.getContentsWidth() - (this.frame.getX() + this.frame.getWidth() + 1), this.getContentsHeight());
        context.fillRectangle(0, this.frame.getY() + this.frame.getHeight() + 1, this.getContentsWidth(), this.getContentsHeight() - (this.frame.getY() + this.frame.getHeight() + 1));
        gcim.setLineWidth(1);
        this.frame.draw(context);
        if (this.dragAndDrop instanceof LifelineHeader) {
            LifelineHeader node = (LifelineHeader)this.dragAndDrop;
            node.draw(context, this.dragX + this.dragAndDropOffsetX, this.dragY);
        }
        gc.drawImage(dbuffer, 0, 0, area.width, area.height, 0, 0, area.width, area.height);
        gcim.dispose();
        dbuffer.dispose();
        gc.dispose();
        context.dispose();
        this.setHScrollBarIncrement(Math.round((float)MSCConstants.COLUMN_WIDTH * this.zoomValue));
        this.setVScrollBarIncrement(Math.round((float)MSCConstants.ROW_HEIGHT * this.zoomValue));
        int xRatio = this.getContentsWidth() / this.getVisibleWidth();
        int yRatio = this.getContentsHeight() / this.getVisibleHeight();
        if (yRatio > xRatio) {
            this.overview.setOverviewSize((int)((double)this.getVisibleHeight() * 0.75));
        } else {
            this.overview.setOverviewSize((int)((double)this.getVisibleWidth() * 0.75));
        }
    }

    public MSCNode getMouseOverNode() {
        return this.currentGraphNode;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        this.redraw();
    }

    public void setZoomInMode(boolean value) {
        if (value) {
            this.setZoomOutMode(false);
        }
        this.zoomInMode = value;
    }

    public void setZoomOutMode(boolean value) {
        if (value) {
            this.setZoomInMode(false);
        }
        this.zoomOutMode = value;
    }

    public float getZoomFactor() {
        return this.zoomValue;
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.overView != null) {
            this.overView.dispose();
        }
        super.removeDisposeListener((DisposeListener)this);
    }

    @Override
    protected void drawOverview(GC gc, Rectangle r) {
        float oldZoom = this.zoomValue;
        this.zoomValue = this.getContentsWidth() > this.getContentsHeight() ? (float)r.width / (float)this.getContentsWidth() * oldZoom : (float)r.height / (float)this.getContentsHeight() * oldZoom;
        if (this.overView != null && (r.width != this.overView.getBounds().width || r.height != this.overView.getBounds().height)) {
            this.overView.dispose();
            this.overView = null;
        }
        if (this.overView == null) {
            int backX = this.getContentsX();
            int backY = this.getContentsY();
            this.setContentsPos(0, 0);
            this.overView = new Image((Device)this.getDisplay(), r.width, r.height);
            GC gcim = new GC((Drawable)this.overView);
            NGC context = new NGC(this, gcim);
            context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_WHITE"));
            this.frame.draw(context);
            this.setContentsPos(backX, backY);
            gcim.dispose();
            context.dispose();
        }
        if (this.overView != null && r.width == this.overView.getBounds().width && r.height == this.overView.getBounds().height) {
            gc.drawImage(this.overView, 0, 0, r.width, r.height, 0, 0, r.width, r.height);
        }
        this.zoomValue = oldZoom;
        super.drawOverview(gc, r);
    }

    public void resetZoomFactor() {
        int currentX = Math.round((float)this.getContentsX() / this.zoomValue);
        int currentY = Math.round((float)this.getContentsY() / this.zoomValue);
        this.zoomValue = 1.0f;
        this.redraw();
        this.update();
        this.setContentsPos(currentX, currentY);
    }

    @Override
    protected void upArrowPressed() {
        int newSelection;
        int oldSelection = this.frame.getSelectedLine();
        int currSelectionY = oldSelection * MSCConstants.ROW_HEIGHT;
        int visibleY = this.frame.getVisibleAreaY();
        int visibleHeight = this.frame.getVisibleAreaHeight();
        if (currSelectionY >= visibleY && currSelectionY <= visibleY + visibleHeight) {
            newSelection = oldSelection - 1;
            if (newSelection * MSCConstants.ROW_HEIGHT < this.frame.getVisibleAreaY()) {
                this.scrollBy(0, -MSCConstants.ROW_HEIGHT);
            }
        } else {
            newSelection = visibleY / MSCConstants.ROW_HEIGHT + 1;
        }
        this.frame.setSelectedLine(newSelection);
        if (this.frame.getSelectedLine() != oldSelection) {
            this.fireSelectionChangeEvent();
            this.redraw();
        }
    }

    @Override
    protected void downArrowPressed() {
        int newSelection;
        int oldSelection = this.frame.getSelectedLine();
        int currSelectionY = oldSelection * MSCConstants.ROW_HEIGHT;
        int visibleY = this.frame.getVisibleAreaY();
        int visibleHeight = this.frame.getVisibleAreaHeight();
        if (currSelectionY >= visibleY && currSelectionY <= visibleY + visibleHeight) {
            newSelection = oldSelection + 1;
            if (newSelection * MSCConstants.ROW_HEIGHT >= this.frame.getVisibleAreaY() + this.frame.getVisibleAreaHeight() - 2 * MSCConstants.ROW_HEIGHT) {
                this.scrollBy(0, MSCConstants.ROW_HEIGHT);
            }
        } else {
            newSelection = (visibleY + visibleHeight) / MSCConstants.ROW_HEIGHT - 2;
        }
        this.frame.setSelectedLine(newSelection);
        if (this.frame.getSelectedLine() != oldSelection) {
            this.fireSelectionChangeEvent();
            this.redraw();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.registeredListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.registeredListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        int oldSelectedLine = this.frame.getSelectedLine();
        int selectedLine = (Integer)((StructuredSelection)selection).getFirstElement();
        this.frame.setSelectedLine(selectedLine);
        int y = selectedLine * MSCConstants.ROW_HEIGHT + MSCConstants.ROW_HEIGHT;
        int visY = this.frame.getVisibleAreaY();
        int visHeight = this.frame.getVisibleAreaHeight();
        int scroll = 0;
        if (this.frame.getVisibleAreaHeight() == 0 && selectedLine == 0) {
            scroll = 0;
        } else if (y >= visY + visHeight) {
            scroll = visHeight == 0 ? y - 2 * MSCConstants.ROW_HEIGHT : y - (visY + visHeight) + 2 * MSCConstants.ROW_HEIGHT;
        } else if (y <= this.frame.getVisibleAreaY()) {
            scroll = y - visY - 2 * MSCConstants.ROW_HEIGHT;
        }
        this.scrollBy(0, scroll);
        if (this.frame.getSelectedLine() != oldSelectedLine) {
            this.fireSelectionChangeEvent();
            this.redraw();
        }
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.frame.getSelectedLine());
    }

    private void fireSelectionChangeEvent() {
        ArrayList<ISelectionChangedListener> savedListeners = new ArrayList<ISelectionChangedListener>(this.registeredListeners);
        for (ISelectionChangedListener listener : savedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    @Override
    protected void keyPressedEvent(KeyEvent e) {
        this.toolTip.hideToolTip();
        super.keyPressedEvent(e);
    }

    @Override
    protected void verticalScrollBarEvent(SelectionEvent e) {
        this.toolTip.hideToolTip();
    }
}

