/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.navigator;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class FileSizeDecorator
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        if (!(element instanceof IFile)) {
            return;
        }
        IFile aFile = (IFile)element;
        String extension = aFile.getFileExtension();
        if (extension == null || !extension.contentEquals("log")) {
            return;
        }
        try {
            if (!aFile.getProject().hasNature("org.eclipse.titan.log.viewer.TitanLogProject")) {
                return;
            }
        }
        catch (CoreException e) {
            return;
        }
        String formattedSize = this.getFormattedSize(aFile);
        decoration.addSuffix(" [" + formattedSize + ']');
    }

    private String getFormattedSize(IFile aFile) {
        long size = this.getSize(aFile);
        return this.getFormat(size);
    }

    private long getSize(IFile file) {
        IPath location = file.getLocation();
        if (location == null) {
            return -1L;
        }
        File localFile = location.toFile();
        return localFile.length();
    }

    private String getFormat(long size) {
        String format = "";
        if (size == -1L) {
            format = "unknown size";
        } else if (size >= 0x40000000L) {
            long result = (size + 0x20000000L) / 0x40000000L;
            format = result + " GB";
        } else if (size >= 0x100000L) {
            long result = (size + 524288L) / 0x100000L;
            format = result + " MB";
        } else if (size >= 1024L) {
            long result = (size + 512L) / 1024L;
            format = result + " KB";
        } else {
            format = size + " B";
        }
        return format;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }
}

