/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.utils.Constants;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LogFileLabelProvider
extends LabelProvider {
    public String getText(Object element) {
        String defaultText = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider().getText(element);
        if (!(element instanceof IFile)) {
            return defaultText;
        }
        if (this.isExtractionRunningOn((IFile)element)) {
            return "[Extracting testcases] " + defaultText;
        }
        return defaultText;
    }

    public Image getImage(Object element) {
        Image defaultImage = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider().getImage(element);
        if (!(element instanceof IFile)) {
            return defaultImage;
        }
        if (this.isExtractionRunningOn((IFile)element)) {
            return Activator.getDefault().getIcon("icons/hourGlass.gif");
        }
        return defaultImage;
    }

    private boolean isExtractionRunningOn(IFile file) {
        try {
            Object temp = file.getSessionProperty(Constants.EXTRACTION_RUNNING);
            return temp != null && (Boolean)temp != false;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
    }
}

