/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.actions;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.Activator;
import org.eclipse.titan.common.graphics.ImageCache;
import org.eclipse.titan.common.log.merge.LogMerger;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.FileUtils;
import org.eclipse.titan.common.utils.ResourceUtils;
import org.eclipse.titan.common.utils.SelectionUtils;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public final class MergeLog
extends AbstractHandler
implements IWorkbenchWindowActionDelegate {
    private static final String MERGED_FILENAME_SUFFIX = "_merged_";
    public static final QualifiedName MERGED_FILE_PROPERTY = new QualifiedName("org.eclipse.titan.common", "mergedFile");
    private static final String LOG_FILE_EXTENSION = ".log";
    private ISelection selection;
    private static File staticOutput;
    private File outputFile;
    private boolean showDialog = true;

    public void init(IWorkbenchWindow window) {
    }

    public void dispose() {
    }

    private void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
        staticOutput = outputFile;
    }

    public void run(List<IFile> filesToMerge, boolean sync) {
        this.doMerge(filesToMerge, sync);
    }

    public void run(IAction action) {
        List<IFile> files = SelectionUtils.getAccessibleFilesFromSelection(this.selection);
        this.doMerge(files, false);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setShowDialog(boolean isEnabled) {
        this.showDialog = isEnabled;
    }

    private void displayOutputSelectionDialog() {
        String outFile;
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dialog = new FileDialog(parent, 8192);
        if (staticOutput != null) {
            dialog.setFileName(staticOutput.getName());
            dialog.setFilterPath(staticOutput.getParent());
        }
        if ((outFile = dialog.open()) == null) {
            this.setOutputFile(null);
            return;
        }
        if ((outFile = outFile.trim()).length() > 0) {
            this.setOutputFile(new File(outFile));
        }
    }

    private void initializeOutputFile(IFile originalFile) {
        if (staticOutput == null) {
            staticOutput = this.createMergedFileName(originalFile).toFile();
        }
        if (this.showDialog) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MergeLog.this.displayOutputSelectionDialog();
                }
            });
            return;
        }
        this.setOutputFile(staticOutput);
        if (!staticOutput.exists()) {
            return;
        }
        this.handleFileExists(originalFile);
    }

    private IPath createMergedFileName(IFile originalFile) {
        IPath temp = originalFile.getLocation();
        String extension = temp.getFileExtension();
        temp = temp.removeFileExtension();
        String filename = temp.lastSegment();
        temp = temp.removeLastSegments(1);
        return temp.append(filename + "_merged").addFileExtension(extension);
    }

    private void handleFileExists(final IFile originalFile) {
        final IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        String mergeOption = prefStore.getString("org.eclipse.titan.common.automaticMergeOptions");
        if ("create".equals(mergeOption)) {
            this.setOutputFile(this.createNewFileWithUniqueName(originalFile));
            return;
        }
        if ("overwrite".equals(mergeOption)) {
            FileUtils.deleteQuietly(this.outputFile);
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MergeLog.this.askUserToCreateOrOverwrite(prefStore, originalFile);
            }
        });
    }

    private void askUserToCreateOrOverwrite(IPreferenceStore prefStore, IFile originalFile) {
        String[] buttonLabels = new String[]{"Create a new file", "Overwrite"};
        MessageDialogWithToggle msgDialog = new MessageDialogWithToggle(null, "File already exists", null, "An error occured during log file merging. The file '" + this.outputFile.getName() + "' already exists. " + "Do you want to keep the original file and choose another location/name for the new one?", 0, buttonLabels, -1, "Don't ask again", false);
        msgDialog.setBlockOnOpen(true);
        int result = msgDialog.open() - 256;
        if (result == -1) {
            this.setOutputFile(null);
            return;
        }
        boolean dontAskChecked = msgDialog.getToggleState();
        if (dontAskChecked) {
            if (result == 0) {
                prefStore.setValue("org.eclipse.titan.common.automaticMergeOptions", "create");
            } else if (result == 1) {
                prefStore.setValue("org.eclipse.titan.common.automaticMergeOptions", "overwrite");
            }
        } else {
            prefStore.setValue("org.eclipse.titan.common.automaticMergeOptions", "ask");
        }
        if (result == 0) {
            if (dontAskChecked) {
                this.setOutputFile(this.createNewFileWithUniqueName(originalFile));
                return;
            }
            this.displayOutputSelectionDialog();
        } else {
            FileUtils.deleteQuietly(this.outputFile);
        }
    }

    private File createNewFileWithUniqueName(IFile originalFile) {
        String temp = originalFile.getName().endsWith(LOG_FILE_EXTENSION) ? originalFile.getName().substring(0, originalFile.getName().length() - LOG_FILE_EXTENSION.length()) + MERGED_FILENAME_SUFFIX : originalFile.getName() + MERGED_FILENAME_SUFFIX;
        final String outputFileNamePrefix = temp;
        File[] files = this.outputFile.getParentFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(outputFileNamePrefix);
            }
        });
        int max = 0;
        for (File file : files) {
            String fileName = file.getName();
            String suffix = fileName.substring(outputFileNamePrefix.length());
            suffix = suffix.substring(0, suffix.length() - LOG_FILE_EXTENSION.length());
            try {
                int number = Integer.parseInt(suffix);
                if (number <= max) continue;
                max = number;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String newOutpufFileName = outputFileNamePrefix + (max + 1) + LOG_FILE_EXTENSION;
        return new File(this.outputFile.getParent(), newOutpufFileName);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage iwPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.selection = iwPage.getSelection();
        List<IFile> filesToMerge = SelectionUtils.getAccessibleFilesFromSelection(this.selection);
        this.doMerge(filesToMerge, false);
        return null;
    }

    private void doMerge(final List<IFile> files, boolean sync) {
        if (files.size() < 2) {
            return;
        }
        ResourceUtils.refreshResources(files);
        WorkspaceJob mergeJob = new WorkspaceJob("Merging log files"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                boolean isErroneous;
                MergeLog.this.initializeOutputFile((IFile)files.get(0));
                if (MergeLog.this.outputFile == null) {
                    return Status.CANCEL_STATUS;
                }
                boolean bl = isErroneous = !new LogMerger().merge(files, MergeLog.this.outputFile, monitor);
                if (isErroneous) {
                    ErrorReporter.parallelErrorDisplayInMessageDialog("Merging of log files failed", "There were some errors while merging the selected log files.\nPlease check the error log for more information.");
                }
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile[] outputFiles = root.findFilesForLocationURI(MergeLog.this.outputFile.toURI());
                MergeLog.this.refreshOutputFilesAsync(outputFiles);
                return Status.OK_STATUS;
            }
        };
        mergeJob.setRule(this.createSchedulingRule(files));
        mergeJob.setPriority(30);
        mergeJob.setUser(true);
        mergeJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        mergeJob.schedule();
        if (sync) {
            try {
                mergeJob.join();
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace("Interrupted", e);
            }
        }
    }

    private ISchedulingRule createSchedulingRule(List<IFile> files) {
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule combinedRule = null;
        for (IFile file : files) {
            combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.createRule((IResource)file), combinedRule);
        }
        return combinedRule;
    }

    private void refreshOutputFilesAsync(final IFile[] outputFiles) {
        WorkspaceJob mergeJob = new WorkspaceJob("Refreshing output file information"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                if (outputFiles != null) {
                    ResourceUtils.refreshResources(Arrays.asList(outputFiles));
                    for (IFile file : outputFiles) {
                        ResourceUtils.setPersistentProperty((IResource)file, MERGED_FILE_PROPERTY.getQualifier(), MERGED_FILE_PROPERTY.getLocalName(), true);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule combinedRule = null;
        for (IFile file : outputFiles) {
            combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.createRule((IResource)file), combinedRule);
        }
        mergeJob.setRule(combinedRule);
        mergeJob.setPriority(30);
        mergeJob.setUser(true);
        mergeJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        mergeJob.schedule();
    }
}

