/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.logging;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.osgi.framework.Bundle;

public final class ErrorReporter {
    private static final String EMPTY = "";
    private static final String INTERNAL_ERROR_PREFIX = "INTERNAL_ERROR: ";
    private static ILog log;

    private ErrorReporter() {
    }

    public static void logExceptionStackTrace(Exception e) {
        String message = e.getMessage();
        ErrorReporter.getMyLog().log((IStatus)new Status(4, "org.eclipse.titan.common", 0, message != null ? message : EMPTY, (Throwable)e));
    }

    public static void logExceptionStackTrace(String context, Throwable e) {
        ErrorReporter.getMyLog().log((IStatus)new Status(4, "org.eclipse.titan.common", 0, context, e));
    }

    public static void INTERNAL_ERROR(String description) {
        Exception e = new Exception(description);
        ErrorReporter.getMyLog().log((IStatus)new Status(4, "org.eclipse.titan.common", 0, INTERNAL_ERROR_PREFIX + description, (Throwable)e));
    }

    public static void INTERNAL_ERROR() {
        Exception e = new Exception("An INTERNAL ERROR has occured");
        ErrorReporter.getMyLog().log((IStatus)new Status(4, "org.eclipse.titan.common", 0, "An INTERNAL ERROR has occured", (Throwable)e));
    }

    public static void logError(String description) {
        ErrorReporter.getMyLog().log((IStatus)new Status(4, "org.eclipse.titan.common", 0, description, null));
    }

    public static void logWarning(String description) {
        ErrorReporter.getMyLog().log((IStatus)new Status(2, "org.eclipse.titan.common", 0, description, null));
    }

    public static void logWarningExceptionStackTrace(String context, Exception e) {
        ErrorReporter.getMyLog().log((IStatus)new Status(2, "org.eclipse.titan.common", 0, context, (Throwable)e));
    }

    public static void logWarningExceptionStackTrace(Exception e) {
        String message = e.getMessage();
        ErrorReporter.getMyLog().log((IStatus)new Status(2, "org.eclipse.titan.common", 0, message != null ? message : EMPTY, (Throwable)e));
    }

    public static String stackTraceToString(StackTraceElement[] elements) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement element : elements) {
            builder.append(element).append("\n");
        }
        return builder.toString();
    }

    private static ILog getMyLog() {
        if (log == null) {
            log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.titan.common"));
        }
        return log;
    }

    public static void setLog(ILog newLog) {
        log = newLog;
    }

    public static void parallelDisplayInStatusLine(final IEditorPart targetEditor, final String errorMessage) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (targetEditor != null) {
                    targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(errorMessage);
                }
            }
        });
    }

    public static void parallelErrorDisplayInMessageDialog(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError(null, (String)title, (String)message);
            }
        });
    }

    public static void parallelWarningDisplayInMessageDialog(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning(null, (String)title, (String)message);
            }
        });
    }
}

